/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class DetermineNovelty {
    public static final String UsageInfo = "proteogenomicUtils.DetermineNovelty, version 2011.11.17\nThis program takes a file of Inspect results and determines which peptides are derived from novel proteins\nand which are derived from known proteins(specified with the -t option).  If a filtered set is specified (-x) then \npeptide is searched in this database before the other database.  The output format is still Inspect Results format.\n[REQUIRED]\n -r [FILE] An Inspect results file (pre PValue.py)\n -t [FILE] A .trie file of known protein sequences\n -w [FILE] An output file name for the 'known' peptides\n -n [FILE] An output file name for the 'novel' peptides\n[OPTIONAL]\n -x [FILE] A .trie file of filtered protein sequences\n -d Run in debug mode\n";
    private String InputFileName = null;
    private TrieDB TrieFile = null;
    private TrieDB FilteredSetTrieFile = null;
    private String OutputFileKnown = null;
    private String OutputFileNovel = null;
    public boolean Debug = false;

    public DetermineNovelty(String InputFileName, String TrieFileName, String FilteredFileName, String OutputFileNameKnown, String OutputFileNameNovel) {
        this.InputFileName = InputFileName;
        this.TrieFile = new TrieDB(TrieFileName);
        this.OutputFileKnown = OutputFileNameKnown;
        this.OutputFileNovel = OutputFileNameNovel;
        if (FilteredFileName != null) {
            this.FilteredSetTrieFile = new TrieDB(FilteredFileName);
        }
    }

    public DetermineNovelty(String InputFileName, String TrieFileName, String FilteredFileName, String OutputFileNameKnown, String OutputFileNameNovel, boolean MSGFDBFlag) {
        if (MSGFDBFlag) {
            this.InputFileName = InputFileName;
            this.OutputFileKnown = OutputFileNameKnown;
            this.OutputFileNovel = OutputFileNameNovel;
            if (FilteredFileName != null) {
                this.FilteredSetTrieFile = new TrieDB(FilteredFileName);
            }
        }
    }

    public void Run() {
        if (this.Debug) {
            System.out.println("--DetermineNovelty---");
            System.out.println("InputFile: " + this.InputFileName);
            System.out.println("TrieDB: " + this.TrieFile.GetDBFileName());
            if (this.FilteredSetTrieFile != null) {
                System.out.println("FilteredSet: " + this.FilteredSetTrieFile.GetDBFileName());
            }
            System.out.println("OutputKnown: " + this.OutputFileKnown);
            System.out.println("OutputNovel: " + this.OutputFileNovel);
            Utils.WaitForEnter();
        }
        Hashtable<String, ArrayList> CurrPeptides = new Hashtable<String, ArrayList>();
        Hashtable<String, Boolean> SeenPeptides = new Hashtable<String, Boolean>();
        int NovelCount = 0;
        int KnownCount = 0;
        boolean wroteNovelHeader = false;
        boolean wroteKnownHeader = false;
        BufferedReader InFile = null;
        String Line = null;
        FileWriter OutFileKnown = null;
        FileWriter OutFileNovel = null;
        try {
            InFile = new BufferedReader(new FileReader(this.InputFileName));
            Line = InFile.readLine();
            OutFileKnown = new FileWriter(this.OutputFileKnown);
            OutFileNovel = new FileWriter(this.OutputFileNovel);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        String[] columnHeaders = null;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                }
                try {
                    Line = InFile.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            InspectAnnotation NewAnn = new InspectAnnotation(Line, columnHeaders);
            if (NewAnn.columnHeaders == null || Utils.FindStringInArray(NewAnn.columnHeaders, "IsNovel") < 0) {
                NewAnn.columnHeaders = Utils.appendToArray(NewAnn.columnHeaders, "IsNovel");
            }
            String UnModded = Utils.GetUnModded(NewAnn.Annotation);
            if (this.Debug) {
                System.out.println("Next Peptide: " + UnModded);
            }
            if (SeenPeptides.containsKey(UnModded)) {
                if (this.Debug) {
                    System.out.println("We've seen it before!");
                }
                Boolean Value = (Boolean)SeenPeptides.get(UnModded);
                NewAnn.IsNovel = Value;
                try {
                    if (NewAnn.IsNovel) {
                        if (!wroteNovelHeader) {
                            OutFileNovel.write("#" + Utils.JoinStringArray(NewAnn.columnHeaders, "\t") + "\n");
                            wroteNovelHeader = true;
                        }
                        OutFileNovel.write(String.valueOf(NewAnn.toString()) + "\n");
                    }
                    if (!wroteKnownHeader) {
                        OutFileKnown.write("#" + Utils.JoinStringArray(NewAnn.columnHeaders, "\t") + "\n");
                        wroteKnownHeader = true;
                    }
                    OutFileKnown.write(String.valueOf(NewAnn.toString()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            } else {
                if (this.Debug) {
                    System.out.println("We've not searched it before");
                }
                ArrayList Temp = null;
                if (CurrPeptides.containsKey(UnModded)) {
                    Temp = (ArrayList)CurrPeptides.get(UnModded);
                    if (this.Debug) {
                        System.out.println("but we've seen it before");
                    }
                } else {
                    Temp = new ArrayList();
                    if (this.Debug) {
                        System.out.println("but we've never seen it before");
                    }
                }
                Temp.add(Line);
                CurrPeptides.put(UnModded, Temp);
                if (CurrPeptides.size() >= 5000) {
                    System.out.println("We've reached " + CurrPeptides.size() + " peptides, so we search...");
                    String[] PeptidesToSearch = Utils.GetHashtableKeysString(CurrPeptides);
                    Hashtable FilteredLocations = new Hashtable();
                    if (this.FilteredSetTrieFile != null) {
                        FilteredLocations = this.FilteredSetTrieFile.GetAllLocations(PeptidesToSearch);
                    }
                    Hashtable Locations = this.TrieFile.GetAllLocations(PeptidesToSearch);
                    int i = 0;
                    while (i < PeptidesToSearch.length) {
                        if (Locations.containsKey(PeptidesToSearch[i]) || FilteredLocations.containsKey(PeptidesToSearch[i])) {
                            Object[] Location;
                            ++KnownCount;
                            ArrayList Locs = new ArrayList();
                            String DBFileName = "";
                            String PeptideWithFlankingAA = "";
                            int ProteinID = -1;
                            String ProteinName = "";
                            int TrieDBPos = -1;
                            if (Locations.containsKey(PeptidesToSearch[i])) {
                                Locs.addAll((ArrayList)Locations.get(PeptidesToSearch[i]));
                                DBFileName = this.TrieFile.GetDBFileName();
                                Location = (Object[])Locs.get(0);
                                PeptideWithFlankingAA = (String)Location[0];
                                ProteinID = (Integer)Location[1];
                                ProteinName = (String)Location[3];
                                TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                            }
                            if (FilteredLocations.containsKey(PeptidesToSearch[i])) {
                                Locs.addAll((ArrayList)FilteredLocations.get(PeptidesToSearch[i]));
                                DBFileName = this.FilteredSetTrieFile.GetDBFileName();
                                Location = (Object[])Locs.get(0);
                                PeptideWithFlankingAA = (String)Location[0];
                                ProteinID = (Integer)Location[1];
                                ProteinName = (String)Location[3];
                                TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                            }
                            if (Locs.size() > 0) {
                                if (this.Debug) {
                                    System.out.println(String.valueOf(PeptidesToSearch[i]) + " - KNOWN:" + DBFileName);
                                }
                                SeenPeptides.put(PeptidesToSearch[i], Boolean.FALSE);
                                ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                                int j = 0;
                                while (j < Lines.size()) {
                                    InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                                    if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                                        Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                                    }
                                    Ann.AnnotationWithFlanking = PeptideWithFlankingAA;
                                    Ann.ProteinID = ProteinID;
                                    Ann.ProteinName = ProteinName;
                                    Ann.TrieDBPos = TrieDBPos;
                                    Ann.SearchDB = DBFileName;
                                    Ann.IsNovel = false;
                                    try {
                                        if (!wroteKnownHeader) {
                                            OutFileKnown.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                            wroteKnownHeader = true;
                                        }
                                        OutFileKnown.write(String.valueOf(Ann.toString()) + "\n");
                                    }
                                    catch (IOException E) {
                                        E.printStackTrace();
                                        return;
                                    }
                                    ++j;
                                }
                            }
                        } else {
                            if (this.Debug) {
                                System.out.println(String.valueOf(PeptidesToSearch[i]) + " - NOVEL");
                            }
                            ++NovelCount;
                            SeenPeptides.put(PeptidesToSearch[i], Boolean.TRUE);
                            ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                            int j = 0;
                            while (j < Lines.size()) {
                                InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                                if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                                    Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                                }
                                Ann.IsNovel = true;
                                try {
                                    if (!wroteNovelHeader) {
                                        OutFileNovel.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                        wroteNovelHeader = true;
                                    }
                                    OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    return;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    CurrPeptides.clear();
                    if (SeenPeptides.size() > Utils.MAX_STORED_PEPTIDES) {
                        System.out.println("Reached the max stored peptides, clearing the list");
                        SeenPeptides.clear();
                    }
                }
            }
            try {
                Line = InFile.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            if (!this.Debug) continue;
            Utils.WaitForEnter();
        }
        if (CurrPeptides.size() > 0) {
            System.out.println("We have " + CurrPeptides.size() + " leftover peptides to search...");
            String[] PeptidesToSearch = Utils.GetHashtableKeysString(CurrPeptides);
            Hashtable FilteredLocations = new Hashtable();
            if (this.FilteredSetTrieFile != null) {
                FilteredLocations = this.FilteredSetTrieFile.GetAllLocations(PeptidesToSearch);
            }
            Hashtable Locations = this.TrieFile.GetAllLocations(PeptidesToSearch);
            int i = 0;
            while (i < PeptidesToSearch.length) {
                if (Locations.containsKey(PeptidesToSearch[i]) || FilteredLocations.containsKey(PeptidesToSearch[i])) {
                    Object[] Location;
                    ArrayList Locs = new ArrayList();
                    ++KnownCount;
                    String DBFileName = "";
                    String PeptideWithFlankingAA = "";
                    int ProteinID = -1;
                    String ProteinName = "";
                    int TrieDBPos = -1;
                    if (Locations.containsKey(PeptidesToSearch[i])) {
                        Locs.addAll((ArrayList)Locations.get(PeptidesToSearch[i]));
                        DBFileName = this.TrieFile.GetDBFileName();
                        Location = (Object[])Locs.get(0);
                        PeptideWithFlankingAA = (String)Location[0];
                        ProteinID = (Integer)Location[1];
                        ProteinName = (String)Location[3];
                        TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                    }
                    if (FilteredLocations.containsKey(PeptidesToSearch[i])) {
                        Locs.addAll((ArrayList)FilteredLocations.get(PeptidesToSearch[i]));
                        DBFileName = this.FilteredSetTrieFile.GetDBFileName();
                        Location = (Object[])Locs.get(0);
                        PeptideWithFlankingAA = (String)Location[0];
                        ProteinID = (Integer)Location[1];
                        ProteinName = (String)Location[3];
                        TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                    }
                    if (Locs.size() > 0) {
                        if (this.Debug) {
                            System.out.println(String.valueOf(PeptidesToSearch[i]) + " - KNOWN:" + DBFileName);
                        }
                        SeenPeptides.put(PeptidesToSearch[i], Boolean.FALSE);
                        ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                        int j = 0;
                        while (j < Lines.size()) {
                            InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                            if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                                Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                            }
                            Ann.AnnotationWithFlanking = PeptideWithFlankingAA;
                            Ann.ProteinID = ProteinID;
                            Ann.ProteinName = ProteinName;
                            Ann.TrieDBPos = TrieDBPos;
                            Ann.SearchDB = DBFileName;
                            Ann.IsNovel = false;
                            try {
                                if (!wroteKnownHeader) {
                                    OutFileKnown.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                    wroteKnownHeader = true;
                                }
                                OutFileKnown.write(String.valueOf(Ann.toString()) + "\n");
                            }
                            catch (IOException E) {
                                E.printStackTrace();
                                return;
                            }
                            ++j;
                        }
                    }
                } else {
                    if (this.Debug) {
                        System.out.println(String.valueOf(PeptidesToSearch[i]) + " - NOVEL");
                    }
                    ++NovelCount;
                    SeenPeptides.put(PeptidesToSearch[i], Boolean.TRUE);
                    ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                    int j = 0;
                    while (j < Lines.size()) {
                        InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), columnHeaders);
                        if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                            Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                        }
                        Ann.IsNovel = true;
                        try {
                            if (!wroteNovelHeader) {
                                OutFileNovel.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                wroteNovelHeader = true;
                            }
                            OutFileNovel.write(String.valueOf(Ann.toString()) + "\n");
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            CurrPeptides.clear();
        }
        try {
            InFile.close();
            OutFileKnown.close();
            OutFileNovel.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        System.out.println("Total peptides searched: " + SeenPeptides.size());
        System.out.println("Novel Peptides: " + NovelCount);
        System.out.println("Known Peptides: " + KnownCount);
    }

    public void RunMSGFDBFormat() {
        if (this.Debug) {
            System.out.println("--DetermineNovelty---");
            System.out.println("InputFile: " + this.InputFileName);
            System.out.println("TrieDB: " + this.TrieFile.GetDBFileName());
            if (this.FilteredSetTrieFile != null) {
                System.out.println("FilteredSet: " + this.FilteredSetTrieFile.GetDBFileName());
            }
            System.out.println("OutputKnown: " + this.OutputFileKnown);
            System.out.println("OutputNovel: " + this.OutputFileNovel);
            Utils.WaitForEnter();
        }
        Hashtable<String, ArrayList> CurrPeptides = new Hashtable<String, ArrayList>();
        Hashtable<String, Boolean> SeenPeptides = new Hashtable<String, Boolean>();
        int NovelCount = 0;
        int KnownCount = 0;
        boolean wroteNovelHeader = false;
        boolean wroteKnownHeader = false;
        BufferedReader InFile = null;
        String Line = null;
        FileWriter OutFileKnown = null;
        FileWriter OutFileNovel = null;
        try {
            InFile = new BufferedReader(new FileReader(this.InputFileName));
            Line = InFile.readLine();
            OutFileKnown = new FileWriter(this.OutputFileKnown);
            OutFileNovel = new FileWriter(this.OutputFileNovel);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        String[] columnHeaders = null;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                }
                try {
                    Line = InFile.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            if (Line.split("\t").length != columnHeaders.length) {
                System.out.println(Line);
                continue;
            }
            InspectAnnotation NewAnn = new InspectAnnotation(Line, true, columnHeaders);
            if (NewAnn.columnHeaders == null || Utils.FindStringInArray(NewAnn.columnHeaders, "IsNovel") < 0) {
                NewAnn.columnHeaders = Utils.appendToArray(NewAnn.columnHeaders, "IsNovel");
            }
            String UnModded = Utils.GetUnModded(NewAnn.Annotation);
            if (this.Debug) {
                System.out.println("Next Peptide: " + UnModded);
            }
            if (SeenPeptides.containsKey(UnModded)) {
                if (this.Debug) {
                    System.out.println("We've seen it before!");
                }
                Boolean Value = (Boolean)SeenPeptides.get(UnModded);
                NewAnn.IsNovel = Value;
                try {
                    if (NewAnn.IsNovel) {
                        if (!wroteNovelHeader) {
                            OutFileNovel.write("#" + Utils.JoinStringArray(NewAnn.columnHeaders, "\t") + "\n");
                            wroteNovelHeader = true;
                        }
                        OutFileNovel.write(String.valueOf(NewAnn.toStringMSGFDBFormat()) + "\n");
                    }
                    if (!wroteKnownHeader) {
                        OutFileKnown.write("#" + Utils.JoinStringArray(NewAnn.columnHeaders, "\t") + "\n");
                        wroteKnownHeader = true;
                    }
                    OutFileKnown.write(String.valueOf(NewAnn.toStringMSGFDBFormat()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            } else {
                if (this.Debug) {
                    System.out.println("We've not searched it before");
                }
                ArrayList Temp = null;
                if (CurrPeptides.containsKey(UnModded)) {
                    Temp = (ArrayList)CurrPeptides.get(UnModded);
                    if (this.Debug) {
                        System.out.println("but we've seen it before");
                    }
                } else {
                    Temp = new ArrayList();
                    if (this.Debug) {
                        System.out.println("but we've never seen it before");
                    }
                }
                Temp.add(Line);
                CurrPeptides.put(UnModded, Temp);
                if (CurrPeptides.size() >= 5000) {
                    System.out.println("We've reached " + CurrPeptides.size() + " peptides, so we search...");
                    String[] PeptidesToSearch = Utils.GetHashtableKeysString(CurrPeptides);
                    Hashtable FilteredLocations = new Hashtable();
                    if (this.TrieFile != null) {
                        FilteredLocations = this.TrieFile.GetAllLocations(PeptidesToSearch);
                    }
                    Hashtable Locations = this.TrieFile.GetAllLocations(PeptidesToSearch);
                    int i = 0;
                    while (i < PeptidesToSearch.length) {
                        if (Locations.containsKey(PeptidesToSearch[i]) || FilteredLocations.containsKey(PeptidesToSearch[i])) {
                            Object[] Location;
                            ++KnownCount;
                            ArrayList Locs = new ArrayList();
                            String DBFileName = "";
                            String PeptideWithFlankingAA = "";
                            int ProteinID = -1;
                            String ProteinName = "";
                            int TrieDBPos = -1;
                            if (Locations.containsKey(PeptidesToSearch[i])) {
                                Locs.addAll((ArrayList)Locations.get(PeptidesToSearch[i]));
                                DBFileName = this.TrieFile.GetDBFileName();
                                Location = (Object[])Locs.get(0);
                                PeptideWithFlankingAA = (String)Location[0];
                                ProteinID = (Integer)Location[1];
                                ProteinName = (String)Location[3];
                                TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                            }
                            if (FilteredLocations.containsKey(PeptidesToSearch[i])) {
                                Locs.addAll((ArrayList)FilteredLocations.get(PeptidesToSearch[i]));
                                DBFileName = this.TrieFile.GetDBFileName();
                                Location = (Object[])Locs.get(0);
                                PeptideWithFlankingAA = (String)Location[0];
                                ProteinID = (Integer)Location[1];
                                ProteinName = (String)Location[3];
                                TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                            }
                            if (Locs.size() > 0) {
                                if (this.Debug) {
                                    System.out.println(String.valueOf(PeptidesToSearch[i]) + " - KNOWN:" + DBFileName);
                                }
                                SeenPeptides.put(PeptidesToSearch[i], Boolean.FALSE);
                                ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                                int j = 0;
                                while (j < Lines.size()) {
                                    InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), true, columnHeaders);
                                    if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                                        Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                                    }
                                    Ann.AnnotationWithFlanking = PeptideWithFlankingAA;
                                    Ann.ProteinID = ProteinID;
                                    Ann.ProteinName = ProteinName;
                                    Ann.TrieDBPos = TrieDBPos;
                                    Ann.SearchDB = DBFileName;
                                    Ann.IsNovel = false;
                                    try {
                                        if (!wroteKnownHeader) {
                                            OutFileKnown.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                            wroteKnownHeader = true;
                                        }
                                        OutFileKnown.write(String.valueOf(Ann.toStringMSGFDBFormat()) + "\n");
                                    }
                                    catch (IOException E) {
                                        E.printStackTrace();
                                        return;
                                    }
                                    ++j;
                                }
                            }
                        } else {
                            if (this.Debug) {
                                System.out.println(String.valueOf(PeptidesToSearch[i]) + " - NOVEL");
                            }
                            ++NovelCount;
                            SeenPeptides.put(PeptidesToSearch[i], Boolean.TRUE);
                            ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                            int j = 0;
                            while (j < Lines.size()) {
                                InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), true, columnHeaders);
                                if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                                    Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                                }
                                Ann.IsNovel = true;
                                try {
                                    if (!wroteNovelHeader) {
                                        OutFileNovel.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                        wroteNovelHeader = true;
                                    }
                                    OutFileNovel.write(String.valueOf(Ann.toStringMSGFDBFormat()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                    return;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    CurrPeptides.clear();
                    if (SeenPeptides.size() > Utils.MAX_STORED_PEPTIDES) {
                        System.out.println("Reached the max stored peptides, clearing the list");
                        SeenPeptides.clear();
                    }
                }
            }
            try {
                Line = InFile.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            if (!this.Debug) continue;
            Utils.WaitForEnter();
        }
        if (CurrPeptides.size() > 0) {
            System.out.println("We have " + CurrPeptides.size() + " leftover peptides to search...");
            String[] PeptidesToSearch = Utils.GetHashtableKeysString(CurrPeptides);
            Hashtable FilteredLocations = new Hashtable();
            if (this.FilteredSetTrieFile != null) {
                FilteredLocations = this.FilteredSetTrieFile.GetAllLocations(PeptidesToSearch);
            }
            Hashtable Locations = this.TrieFile.GetAllLocations(PeptidesToSearch);
            int i = 0;
            while (i < PeptidesToSearch.length) {
                if (Locations.containsKey(PeptidesToSearch[i]) || FilteredLocations.containsKey(PeptidesToSearch[i])) {
                    Object[] Location;
                    ArrayList Locs = new ArrayList();
                    ++KnownCount;
                    String DBFileName = "";
                    String PeptideWithFlankingAA = "";
                    int ProteinID = -1;
                    String ProteinName = "";
                    int TrieDBPos = -1;
                    if (Locations.containsKey(PeptidesToSearch[i])) {
                        Locs.addAll((ArrayList)Locations.get(PeptidesToSearch[i]));
                        DBFileName = this.TrieFile.GetDBFileName();
                        Location = (Object[])Locs.get(0);
                        PeptideWithFlankingAA = (String)Location[0];
                        ProteinID = (Integer)Location[1];
                        ProteinName = (String)Location[3];
                        TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                    }
                    if (FilteredLocations.containsKey(PeptidesToSearch[i])) {
                        Locs.addAll((ArrayList)FilteredLocations.get(PeptidesToSearch[i]));
                        DBFileName = this.FilteredSetTrieFile.GetDBFileName();
                        Location = (Object[])Locs.get(0);
                        PeptideWithFlankingAA = (String)Location[0];
                        ProteinID = (Integer)Location[1];
                        ProteinName = (String)Location[3];
                        TrieDBPos = this.TrieFile.GetTriePos(ProteinID) + (Integer)Location[2];
                    }
                    if (Locs.size() > 0) {
                        if (this.Debug) {
                            System.out.println(String.valueOf(PeptidesToSearch[i]) + " - KNOWN:" + DBFileName);
                        }
                        SeenPeptides.put(PeptidesToSearch[i], Boolean.FALSE);
                        ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                        int j = 0;
                        while (j < Lines.size()) {
                            InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), true, columnHeaders);
                            if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                                Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                            }
                            Ann.AnnotationWithFlanking = PeptideWithFlankingAA;
                            Ann.ProteinID = ProteinID;
                            Ann.ProteinName = ProteinName;
                            Ann.TrieDBPos = TrieDBPos;
                            Ann.SearchDB = DBFileName;
                            Ann.IsNovel = false;
                            try {
                                if (!wroteKnownHeader) {
                                    OutFileKnown.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                    wroteKnownHeader = true;
                                }
                                OutFileKnown.write(String.valueOf(Ann.toStringMSGFDBFormat()) + "\n");
                            }
                            catch (IOException E) {
                                E.printStackTrace();
                                return;
                            }
                            ++j;
                        }
                    }
                } else {
                    if (this.Debug) {
                        System.out.println(String.valueOf(PeptidesToSearch[i]) + " - NOVEL");
                    }
                    ++NovelCount;
                    SeenPeptides.put(PeptidesToSearch[i], Boolean.TRUE);
                    ArrayList Lines = (ArrayList)CurrPeptides.get(PeptidesToSearch[i]);
                    int j = 0;
                    while (j < Lines.size()) {
                        InspectAnnotation Ann = new InspectAnnotation((String)Lines.get(j), true, columnHeaders);
                        if (Ann.columnHeaders == null || Utils.FindStringInArray(Ann.columnHeaders, "IsNovel") < 0) {
                            Ann.columnHeaders = Utils.appendToArray(Ann.columnHeaders, "IsNovel");
                        }
                        Ann.IsNovel = true;
                        try {
                            if (!wroteNovelHeader) {
                                OutFileNovel.write("#" + Utils.JoinStringArray(Ann.columnHeaders, "\t") + "\n");
                                wroteNovelHeader = true;
                            }
                            OutFileNovel.write(String.valueOf(Ann.toStringMSGFDBFormat()) + "\n");
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            CurrPeptides.clear();
        }
        try {
            InFile.close();
            OutFileKnown.close();
            OutFileNovel.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        System.out.println("Total peptides searched: " + SeenPeptides.size());
        System.out.println("Novel Peptides: " + NovelCount);
        System.out.println("Known Peptides: " + KnownCount);
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-t", "-d", "-x", "-n", "-m"};
        boolean[] blArray = new boolean[7];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLineMulti(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: You must specify an input file");
            System.out.println(UsageInfo);
            return;
        }
        ArrayList Temp = (ArrayList)CommandLineArgs.get("-r");
        String InputFile = (String)Temp.get(0);
        if (!CommandLineArgs.containsKey("-t")) {
            System.err.println("ERROR: You must specify a database of known proteins");
            System.out.println(UsageInfo);
            return;
        }
        Temp = (ArrayList)CommandLineArgs.get("-t");
        String KnownFile = (String)Temp.get(0);
        String FilteredFile = null;
        if (CommandLineArgs.containsKey("-x")) {
            Temp = (ArrayList)CommandLineArgs.get("-x");
            FilteredFile = (String)Temp.get(0);
        }
        if (!CommandLineArgs.containsKey("-w") || !CommandLineArgs.containsKey("-n")) {
            System.err.println("ERROR: You must specify an output file for known and novel peptides");
            System.out.println(UsageInfo);
            return;
        }
        Temp = (ArrayList)CommandLineArgs.get("-w");
        String OutputFileKnown = (String)Temp.get(0);
        Temp = (ArrayList)CommandLineArgs.get("-n");
        String OutputFileNovel = (String)Temp.get(0);
        DetermineNovelty Dummy = new DetermineNovelty(InputFile, KnownFile, FilteredFile, OutputFileKnown, OutputFileNovel);
        if (CommandLineArgs.containsKey("-d")) {
            Dummy.Debug = true;
        }
        if (!CommandLineArgs.containsKey("-m")) {
            Dummy.Run();
        } else {
            Dummy.RunMSGFDBFormat();
        }
    }
}

