/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import proteogenomicUtils.GenomeClusterer;
import proteogenomicUtils.SearchLocation;

public class EventFinder {
    public static final String UsageInfo = "proteogenomicUtils.EventFinder\nInterprets a cluster file as specific events.  The hierarchy of events and definitions is the following:\n  Consistent : Peptide is consistent with the current annotation\n  FrameShift : Peptide overlaps an exon in a different frame, or overlaps a peptide which is in a frameshift with an exon\n  TranslatedUTR : Peptide overlaps the UTR, or overlaps a peptide which is in a TranslatedUTR\n  ExonBoundary : Peptide overlaps an exon (in the correct frame), or overlap a peptide which is a ExonBoundary\n  NovelSplice : Peptide supports a novel splice site (not a new exon boundary)\n  NovelExon:  Peptide supports a novel exon (intronic exon)\n  GeneBoundary: Peptide is beyond UTR but within cluster size of gene\n  ReverseStrand: Peptide is on opposite strand\n  NovelGene: Peptide is far from any known gene\n[REQUIRED]\n -r [FILE/DIR] containing cluster files.  If directory, then all files are intepreted separately\n -w [FILE] Output file to write events to\n -k [FILE] Working set gff file\n[OPTIONAL]\n -f [FILE] Filtered set .trie file\n -x [NUM] Minimum event probability\n -d Run in debug mode\n";
    private String[] InputFiles = null;
    private String OutputFile = null;
    private String ProteinGFFFile = null;
    private String FilteredProteinSeqFile = null;
    private double MinEventProb = 0.0;
    private Hashtable KnownGeneModels;
    private Hashtable GeneCoordsHash;
    public static boolean Debug = false;
    public static boolean N_TERM = false;
    public static boolean C_TERM = !N_TERM;
    private Hashtable CodingRegions = null;

    public static int GetEventNum(EventType Type) {
        if (Type == EventType.Consistent) {
            return 0;
        }
        if (Type == EventType.FrameShift) {
            return 1;
        }
        if (Type == EventType.TranslatedUTR) {
            return 2;
        }
        if (Type == EventType.ExonBoundary) {
            return 3;
        }
        if (Type == EventType.NovelSplice) {
            return 4;
        }
        if (Type == EventType.NovelExon) {
            return 5;
        }
        if (Type == EventType.GeneBoundary) {
            return 6;
        }
        if (Type == EventType.ReverseStrand) {
            return 7;
        }
        if (Type == EventType.NovelGene) {
            return 8;
        }
        return -1;
    }

    public static EventType GetEventName(int Num) {
        if (Num < 0 || Num > 8) {
            System.err.println("ERROR: Cannot get event name for event with index " + Num);
            return null;
        }
        if (Num == 0) {
            return EventType.Consistent;
        }
        if (Num == 1) {
            return EventType.FrameShift;
        }
        if (Num == 2) {
            return EventType.TranslatedUTR;
        }
        if (Num == 3) {
            return EventType.ExonBoundary;
        }
        if (Num == 4) {
            return EventType.NovelSplice;
        }
        if (Num == 5) {
            return EventType.NovelExon;
        }
        if (Num == 6) {
            return EventType.GeneBoundary;
        }
        if (Num == 7) {
            return EventType.ReverseStrand;
        }
        if (Num == 8) {
            return EventType.NovelGene;
        }
        return null;
    }

    public static EventType GetEventNameFromString(String name) {
        if (name.equalsIgnoreCase("FrameShift")) {
            return EventType.FrameShift;
        }
        if (name.equalsIgnoreCase("Consistent")) {
            return EventType.Consistent;
        }
        if (name.equalsIgnoreCase("TranslatedUTR")) {
            return EventType.TranslatedUTR;
        }
        if (name.equalsIgnoreCase("ExonBoundary")) {
            return EventType.ExonBoundary;
        }
        if (name.equalsIgnoreCase("NovelSplice")) {
            return EventType.NovelSplice;
        }
        if (name.equalsIgnoreCase("NovelExon")) {
            return EventType.NovelExon;
        }
        if (name.equalsIgnoreCase("GeneBoundary")) {
            return EventType.GeneBoundary;
        }
        if (name.equalsIgnoreCase("ReverseStrand")) {
            return EventType.ReverseStrand;
        }
        if (name.equalsIgnoreCase("NovelGene")) {
            return EventType.NovelGene;
        }
        ErrorThrower.ThrowWarningCustom(101, "Invalid event type '" + name + "'!");
        return EventType.Consistent;
    }

    public EventFinder(String[] GFFFileNames, String SeqName, String geneFeatureName) {
        System.out.println("Loading known genes/exons for " + SeqName);
        if (geneFeatureName == null) {
            this.LoadKnownModelsIntoHash(GFFFileNames, SeqName, "mrna");
        } else {
            this.LoadKnownModelsIntoHash(GFFFileNames, SeqName, geneFeatureName);
        }
        System.out.println("Loaded " + this.KnownGeneModels.size() + " genes");
        if (this.KnownGeneModels.size() == 0) {
            System.err.println("WARNING: Unable to load any genes!!");
        }
    }

    private void LoadKnownModelsIntoHash(String[] GFFFileNames, String DesiredSeqName, String geneBoundaryFeatureName) {
        this.KnownGeneModels = new Hashtable();
        this.GeneCoordsHash = new Hashtable();
        int i = 0;
        while (i < GFFFileNames.length) {
            BufferedReader buf = null;
            String Line = null;
            try {
                buf = new BufferedReader(new FileReader(GFFFileNames[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, GFFFileNames[i]);
            }
            while (Line != null) {
                ArrayList Exons;
                String[] Bits2;
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, GFFFileNames[i]);
                    }
                    continue;
                }
                String GeneName = null;
                String[] Bits = Line.split("\t");
                String SeqName = Bits[GFFFile.GFFColumns.SequenceName];
                if (Utils.IsInteger(SeqName) || SeqName.toLowerCase().compareTo("unknown") == 0 || SeqName.toLowerCase().compareTo("c") == 0 || SeqName.toLowerCase().compareTo("m") == 0) {
                    SeqName = "chr" + SeqName;
                }
                if (SeqName.toLowerCase().compareTo("pt") == 0) {
                    SeqName = "chrC";
                } else if (SeqName.toLowerCase().compareTo("mt") == 0) {
                    SeqName = "chrM";
                }
                if (DesiredSeqName != null && DesiredSeqName.toLowerCase().compareTo(SeqName.toLowerCase()) != 0) {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, GFFFileNames[i]);
                    }
                    continue;
                }
                if (Bits[GFFFile.GFFColumns.FeatureType].toLowerCase().compareTo("cds") != 0 && Bits[GFFFile.GFFColumns.FeatureType].toLowerCase().compareTo(geneBoundaryFeatureName) != 0) {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, GFFFileNames[i]);
                    }
                    continue;
                }
                String Notes = Bits[GFFFile.GFFColumns.Attributes];
                String[] NoteElements = Notes.split(";");
                int j = 0;
                while (j < NoteElements.length) {
                    Bits2 = NoteElements[j].split("=");
                    if (Bits2[0].toLowerCase().indexOf("parent") >= 0) {
                        GeneName = Bits2[1].replaceAll("\"", "");
                        break;
                    }
                    ++j;
                }
                if (GeneName == null) {
                    j = 0;
                    while (j < NoteElements.length) {
                        Bits2 = NoteElements[j].split("=");
                        if (Bits2[0].toLowerCase().indexOf("name") >= 0) {
                            GeneName = Bits2[1].replaceAll("\"", "");
                            break;
                        }
                        ++j;
                    }
                }
                if (GeneName == null) {
                    j = 0;
                    while (j < NoteElements.length) {
                        Bits2 = NoteElements[j].split("=");
                        if (Bits2[0].toLowerCase().indexOf("id") >= 0) {
                            GeneName = Bits2[1].replaceAll("\"", "");
                            break;
                        }
                        ++j;
                    }
                }
                if (GeneName == null) {
                    System.out.println("NO GENE NAME!!");
                    System.out.println(Line);
                    System.out.println(Notes);
                    Utils.WaitForEnter();
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, GFFFileNames[i]);
                    }
                    continue;
                }
                int Start = Integer.parseInt(Bits[GFFFile.GFFColumns.Start]) - 1;
                int End = Integer.parseInt(Bits[GFFFile.GFFColumns.End]);
                if (Bits[GFFFile.GFFColumns.FeatureType].toLowerCase().compareTo(geneBoundaryFeatureName) == 0) {
                    GeneName = null;
                    int j2 = 0;
                    while (j2 < NoteElements.length) {
                        String[] Bits22 = NoteElements[j2].split("=");
                        if (Bits22[0].toLowerCase().indexOf("id") >= 0) {
                            GeneName = Bits22[1].replaceAll("\"", "");
                            break;
                        }
                        ++j2;
                    }
                    if (GeneName == null) {
                        System.out.println("NO GENE NAME for mrna!!!");
                        System.out.println(Line);
                        System.out.println(Notes);
                        Utils.WaitForEnter();
                        try {
                            Line = buf.readLine();
                        }
                        catch (IOException E) {
                            ErrorThrower.ThrowError(6, GFFFileNames[i]);
                        }
                    }
                    int[] coords = new int[]{Start, End};
                    this.GeneCoordsHash.put(GeneName, coords);
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, GFFFileNames[i]);
                    }
                    continue;
                }
                int ReadingFrame = -1;
                try {
                    ReadingFrame = Integer.parseInt(Bits[GFFFile.GFFColumns.Frame]);
                }
                catch (Exception E) {
                    ReadingFrame = 0;
                }
                String DatabaseName = Bits[GFFFile.GFFColumns.Source];
                int Strand = GFFFile.ParseStrand(Bits[GFFFile.GFFColumns.Strand]);
                if (DatabaseName.compareTo("ensembl") == 0) {
                    if (Strand == 1) {
                        ReadingFrame = (3 - ReadingFrame) % 3;
                    } else {
                        int MySuffix = (3 - ReadingFrame) % 3;
                        ReadingFrame = (End - Start - MySuffix) % 3;
                    }
                }
                ReadingFrame = Strand == 1 ? (Start + ReadingFrame) % 3 : (End - 1 - ReadingFrame) % 3;
                SimpleExon e = new SimpleExon(Start, End, ReadingFrame, Strand);
                if (this.KnownGeneModels.containsKey(GeneName)) {
                    Exons = (ArrayList)this.KnownGeneModels.get(GeneName);
                    Exons.add(e);
                    this.KnownGeneModels.put(GeneName, Exons);
                } else {
                    Exons = new ArrayList();
                    Exons.add(e);
                    this.KnownGeneModels.put(GeneName, Exons);
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, GFFFileNames[i]);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, GFFFileNames[i]);
            }
            ++i;
        }
    }

    public Event[] CreateEvents(Object[] Location, String ClusterHeader) {
        String[] ProximalGenes = GenomeClusterer.GetClusterProteins(ClusterHeader);
        if (Debug) {
            System.out.println("Considering new location:\n" + SearchLocation.GenomicColumns.toString(Location, " "));
        }
        if (ProximalGenes == null) {
            Event[] Ret = new Event[]{new Event(EventType.NovelGene)};
            Ret[0].AddMoreSupportNoDoubles(Location, (Integer)Location[SearchLocation.GenomicColumns.Start], (Integer)Location[SearchLocation.GenomicColumns.End]);
            if (Debug) {
                System.out.println("No proximal gene, this must be a novel gene!");
                Ret[0].DebugPrint();
                Utils.WaitForEnter();
            }
            return Ret;
        }
        int[][] SpliceBits = Utils.GetSpliceInfo((String)Location[SearchLocation.GenomicColumns.Splices], (Integer)Location[SearchLocation.GenomicColumns.Strand], (Integer)Location[SearchLocation.GenomicColumns.Start], (Integer)Location[SearchLocation.GenomicColumns.End]);
        if (Debug) {
            int i = 0;
            while (i < SpliceBits.length) {
                System.out.println("Splice Segment[" + i + "]: (" + SpliceBits[i][0] + "-" + SpliceBits[i][1] + "), frame: " + SpliceBits[i][2]);
                ++i;
            }
        }
        Event[][] Ret = new Event[SpliceBits.length][ProximalGenes.length];
        int j = 0;
        while (j < ProximalGenes.length) {
            block79: {
                ArrayList Exons;
                block78: {
                    if (Debug) {
                        System.out.println("Comparing to proximal gene " + ProximalGenes[j]);
                    }
                    if ((Exons = (ArrayList)this.KnownGeneModels.get(ProximalGenes[j])) != null && Exons.size() != 0) break block78;
                    System.out.println("WARNGING: THis gene has no exons: " + ProximalGenes[j]);
                    System.out.println("Considering new location:\n" + SearchLocation.GenomicColumns.toString(Location, " "));
                    int k = 0;
                    while (k < ProximalGenes.length) {
                        System.out.println("Proximal Gene [" + k + " ]: " + ProximalGenes[k]);
                        ++k;
                    }
                    Utils.WaitForEnter();
                    break block79;
                }
                int[] geneCoords = (int[])this.GeneCoordsHash.get(ProximalGenes[j]);
                if (geneCoords == null) {
                    System.out.println("ERROR: Unable to load gene coords for " + ProximalGenes[j]);
                    Utils.WaitForEnter();
                }
                int GeneStart = geneCoords[0];
                int GeneEnd = geneCoords[1];
                int GeneStrand = ((SimpleExon)Exons.get((int)0)).Strand;
                int i = 0;
                while (i < SpliceBits.length) {
                    block81: {
                        boolean OverlapsAnExon;
                        int CodingEnd;
                        int CodingStart;
                        block83: {
                            block84: {
                                SimpleExon CurrExon;
                                block82: {
                                    block80: {
                                        if (Debug) {
                                            System.out.println("Comparing splice segment (" + SpliceBits[i][0] + "-" + SpliceBits[i][1] + ")");
                                        }
                                        if ((Integer)Location[SearchLocation.GenomicColumns.Strand] == GeneStrand) break block80;
                                        if (Ret[i][j] != null) {
                                            System.out.println("This splice and gene already have an event!");
                                            Ret[i][j].DebugPrint();
                                            Utils.WaitForEnter();
                                        }
                                        Ret[i][j] = new Event(EventType.ReverseStrand);
                                        Ret[i][j].AddMoreSupportNoDoubles(Location, (Integer)Location[SearchLocation.GenomicColumns.Start], (Integer)Location[SearchLocation.GenomicColumns.End]);
                                        Ret[i][j].RefinedFeature = ProximalGenes[j];
                                        Ret[i][j].FeatureStrand = GeneStrand;
                                        if (Debug) {
                                            System.out.println("On opposite strand from proximal gene, this must be a wrong strand");
                                            Ret[i][j].DebugPrint();
                                            Utils.WaitForEnter();
                                        }
                                        break block81;
                                    }
                                    if (Utils.HasOverlap(SpliceBits[i][0], SpliceBits[i][1], GeneStart, GeneEnd)) break block82;
                                    if (Ret[i][j] != null) {
                                        System.out.println("This splice and gene already have an event!");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                    Ret[i][j] = new Event(EventType.GeneBoundary);
                                    if (SpliceBits[i][0] >= GeneEnd) {
                                        Ret[i][j].ExonIndex = Exons.size() - 1;
                                        Ret[i][j].term = C_TERM;
                                    }
                                    if (SpliceBits[i][1] <= GeneStart) {
                                        Ret[i][j].ExonIndex = 0;
                                        Ret[i][j].term = N_TERM;
                                    }
                                    Ret[i][j].AddMoreSupport(Location, SpliceBits[i][0], SpliceBits[i][1]);
                                    Ret[i][j].RefinedFeature = ProximalGenes[j];
                                    Ret[i][j].FeatureStrand = GeneStrand;
                                    Ret[i][j].SuggestedFrame = SpliceBits[i][2];
                                    if (Debug) {
                                        System.out.println("Not overlapping proximal gene, this must be a gene extension");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                    break block81;
                                }
                                CodingStart = Integer.MAX_VALUE;
                                CodingEnd = -1;
                                OverlapsAnExon = false;
                                int k = 0;
                                while (k < Exons.size()) {
                                    CurrExon = (SimpleExon)Exons.get(k);
                                    if (Debug) {
                                        System.out.println("Considering Exon " + k);
                                        System.out.println("Start: " + CurrExon.Start);
                                        System.out.println("End: " + CurrExon.End);
                                        System.out.println("Frame: " + CurrExon.ReadingFrame);
                                    }
                                    if (CurrExon.Start < CodingStart) {
                                        CodingStart = CurrExon.Start;
                                    }
                                    if (CurrExon.End > CodingEnd) {
                                        CodingEnd = CurrExon.End;
                                    }
                                    if (Utils.HasOverlap(SpliceBits[i][0], SpliceBits[i][1], CurrExon.Start, CurrExon.End)) {
                                        OverlapsAnExon = true;
                                        if (CurrExon.ReadingFrame != SpliceBits[i][2]) {
                                            if (Ret[i][j] != null) {
                                                if (Debug) {
                                                    System.out.println("This splice and gene already have an event!");
                                                    Ret[i][j].DebugPrint();
                                                    Utils.WaitForEnter();
                                                }
                                            } else {
                                                Ret[i][j] = new Event(EventType.FrameShift);
                                                Ret[i][j].AddMoreSupport(Location, SpliceBits[i][0], SpliceBits[i][1]);
                                                Ret[i][j].RefinedFeature = ProximalGenes[j];
                                                Ret[i][j].FeatureStrand = GeneStrand;
                                                Ret[i][j].ExonIndex = k;
                                                Ret[i][j].ExonFrame = CurrExon.ReadingFrame;
                                                Ret[i][j].ExonStart = CurrExon.Start;
                                                Ret[i][j].ExonEnd = CurrExon.End;
                                                Ret[i][j].SuggestedFrame = SpliceBits[i][2];
                                                if (Debug) {
                                                    System.out.println("In different frame from proximal gene, this must be a frameshift");
                                                    Ret[i][j].DebugPrint();
                                                    Utils.WaitForEnter();
                                                }
                                            }
                                        } else if (CurrExon.Start > SpliceBits[i][0] || CurrExon.End < SpliceBits[i][1]) {
                                            if (Ret[i][j] != null) {
                                                if (Debug) {
                                                    System.out.println("This splice and gene already have an event!");
                                                    Ret[i][j].DebugPrint();
                                                    Utils.WaitForEnter();
                                                }
                                            } else {
                                                Ret[i][j] = new Event(EventType.ExonBoundary);
                                                Ret[i][j].AddMoreSupport(Location, SpliceBits[i][0], SpliceBits[i][1]);
                                                Ret[i][j].RefinedFeature = ProximalGenes[j];
                                                Ret[i][j].FeatureStrand = GeneStrand;
                                                Ret[i][j].ExonIndex = k;
                                                Ret[i][j].ExonFrame = CurrExon.ReadingFrame;
                                                Ret[i][j].ExonStart = CurrExon.Start;
                                                Ret[i][j].ExonEnd = CurrExon.End;
                                                Ret[i][j].SuggestedFrame = SpliceBits[i][2];
                                                if (Debug) {
                                                    System.out.println("Exon extension");
                                                    Ret[i][j].DebugPrint();
                                                    Utils.WaitForEnter();
                                                }
                                            }
                                        } else if (Ret[i][j] != null) {
                                            if (Debug) {
                                                System.out.println("This splice and gene already have an event!");
                                                Ret[i][j].DebugPrint();
                                                Utils.WaitForEnter();
                                            }
                                        } else {
                                            Ret[i][j] = new Event(EventType.Consistent);
                                            Ret[i][j].AddMoreSupport(Location, SpliceBits[i][0], SpliceBits[i][1]);
                                            Ret[i][j].RefinedFeature = ProximalGenes[j];
                                            Ret[i][j].FeatureStrand = GeneStrand;
                                            Ret[i][j].ExonIndex = k;
                                            Ret[i][j].ExonFrame = CurrExon.ReadingFrame;
                                            Ret[i][j].ExonStart = CurrExon.Start;
                                            Ret[i][j].ExonEnd = CurrExon.End;
                                            Ret[i][j].SuggestedFrame = SpliceBits[i][2];
                                            if (Debug) {
                                                System.out.println("Consistent!!!");
                                                Ret[i][j].DebugPrint();
                                                Utils.WaitForEnter();
                                            }
                                        }
                                    }
                                    ++k;
                                }
                                if (Ret[i][j] == null || Ret[i][j].Type != EventType.Consistent || i <= 0) break block83;
                                if (Debug) {
                                    System.out.println("THIS COULD BE A NOVEL SPLICE!!");
                                }
                                if (Ret[i - 1][j].Type != EventType.Consistent) break block84;
                                SimpleExon PrevExon = (SimpleExon)Exons.get(Ret[i - 1][j].ExonIndex);
                                CurrExon = (SimpleExon)Exons.get(Ret[i][j].ExonIndex);
                                int CurrExonIndex = Ret[i][j].ExonIndex;
                                int PrevExonIndex = Ret[i - 1][j].ExonIndex;
                                boolean IntronFound = false;
                                if (GeneStrand == 1) {
                                    if (PrevExonIndex == CurrExonIndex - 1 && SpliceBits[i - 1][1] == PrevExon.End && SpliceBits[i][0] == CurrExon.Start) {
                                        IntronFound = true;
                                    }
                                } else if (PrevExonIndex == CurrExonIndex + 1 && SpliceBits[i - 1][0] == PrevExon.Start && SpliceBits[i][1] == CurrExon.End) {
                                    IntronFound = true;
                                }
                                if (IntronFound) break block83;
                                if (Debug) {
                                    System.out.println("NO INTRON FOUND BETWEEN THESE TWO SEGMENTS!");
                                }
                                if (Ret[i][j] != null && Ret[i][j].Type != EventType.Consistent) {
                                    if (Debug) {
                                        System.out.println("This splice and gene already have an event!");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                } else {
                                    int CurrSpliceFrame = Ret[i][j].ExonFrame;
                                    int SpliceEnd = SpliceBits[i][0];
                                    Ret[i][j] = new Event(EventType.NovelSplice);
                                    Ret[i][j].AddMoreSupport(Location, SpliceBits[i][0], SpliceBits[i][1]);
                                    Ret[i][j].RefinedFeature = ProximalGenes[j];
                                    Ret[i][j].FeatureStrand = GeneStrand;
                                    Ret[i][j].ExonIndex2 = CurrExonIndex;
                                    Ret[i][j].ExonStart2 = CurrExon.Start;
                                    Ret[i][j].ExonEnd2 = CurrExon.End;
                                    Ret[i][j].ExonFrame2 = CurrSpliceFrame;
                                    Ret[i][j].ExonIndex = PrevExonIndex;
                                    Ret[i][j].ExonStart = PrevExon.Start;
                                    Ret[i][j].ExonEnd = PrevExon.End;
                                    Ret[i][j].ExonFrame = Ret[i - 1][j].ExonFrame;
                                    Ret[i][j].SpliceStart = SpliceBits[i - 1][1];
                                    Ret[i][j].SpliceEnd = SpliceEnd;
                                    Ret[i - 1][j] = null;
                                    if (Debug) {
                                        System.out.println("NovelSplice");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                }
                                break block81;
                            }
                            if (Debug) {
                                System.out.println("BUT PREVIOUS GUY IS OF TYPE: " + (Object)((Object)Ret[i - 1][j].Type));
                            }
                        }
                        if (Ret[i][j] == null) {
                            if (SpliceBits[i][0] >= CodingEnd || SpliceBits[i][1] <= CodingStart) {
                                if (Ret[i][j] != null) {
                                    if (Debug) {
                                        System.out.println("This splice and gene already have an event!");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                } else {
                                    Ret[i][j] = new Event(EventType.TranslatedUTR);
                                    if (SpliceBits[i][0] >= CodingEnd) {
                                        Ret[i][j].ExonIndex = Exons.size() - 1;
                                        Ret[i][j].term = C_TERM;
                                    }
                                    if (SpliceBits[i][1] <= CodingStart) {
                                        Ret[i][j].ExonIndex = 0;
                                        Ret[i][j].term = N_TERM;
                                    }
                                    Ret[i][j].AddMoreSupport(Location, SpliceBits[i][0], SpliceBits[i][1]);
                                    Ret[i][j].RefinedFeature = ProximalGenes[j];
                                    Ret[i][j].FeatureStrand = GeneStrand;
                                    Ret[i][j].SuggestedFrame = SpliceBits[i][2];
                                    if (Debug) {
                                        System.out.println("Translated UTR!");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                }
                            } else if (!OverlapsAnExon) {
                                if (Ret[i][j] != null) {
                                    if (Debug) {
                                        System.out.println("This splice and gene already have an event!");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                } else {
                                    Ret[i][j] = new Event(EventType.NovelExon);
                                    Ret[i][j].AddMoreSupport(Location, SpliceBits[i][0], SpliceBits[i][1]);
                                    Ret[i][j].RefinedFeature = ProximalGenes[j];
                                    Ret[i][j].FeatureStrand = GeneStrand;
                                    Ret[i][j].SuggestedFrame = SpliceBits[i][2];
                                    if (Debug) {
                                        System.out.println("Exon extension");
                                        Ret[i][j].DebugPrint();
                                        Utils.WaitForEnter();
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        ArrayList<Event> FinalEvents = new ArrayList<Event>();
        int j2 = 0;
        while (j2 < ProximalGenes.length) {
            Event e = null;
            int i = 0;
            while (i < SpliceBits.length) {
                if (Ret[i][j2] != null && Ret[i][j2].Type != EventType.Consistent) {
                    if (e == null) {
                        e = Ret[i][j2];
                    } else if (e.Type == Ret[i][j2].Type) {
                        if (e.Type == EventType.FrameShift && e.ExonIndex == Ret[i][j2].ExonIndex) {
                            e = Event.MergeEvents(e, Ret[i][j2]);
                        } else if ((e.Type == EventType.TranslatedUTR || e.Type == EventType.GeneBoundary) && e.term == Ret[i][j2].term) {
                            e = Event.MergeEvents(e, Ret[i][j2]);
                        } else if (e.Type == EventType.ReverseStrand || e.Type == EventType.NovelGene) {
                            e = Event.MergeEvents(e, Ret[i][j2]);
                        }
                    } else if (Ret[i][j2].Type != EventType.Consistent) {
                        FinalEvents.add(e);
                        e = Ret[i][j2];
                    }
                }
                ++i;
            }
            if (e != null) {
                FinalEvents.add(e);
            }
            ++j2;
        }
        Event[] RetList = new Event[FinalEvents.size()];
        int i = 0;
        while (i < RetList.length) {
            RetList[i] = (Event)FinalEvents.get(i);
            ++i;
        }
        return RetList;
    }

    public Event[] CreateAllEvents(ArrayList ClusterLocations, String ClusterHeader) {
        Object[] CurrLocation;
        int i;
        ArrayList AllEvents = new ArrayList();
        if (Debug) {
            System.out.println("Creating all events for " + ClusterHeader);
            i = 0;
            while (i < ClusterLocations.size()) {
                CurrLocation = (Object[])ClusterLocations.get(i);
                System.out.println("[" + i + "]: " + SearchLocation.GenomicColumns.toString(CurrLocation, " "));
                ++i;
            }
            Utils.WaitForEnter();
        }
        i = 0;
        while (i < ClusterLocations.size()) {
            CurrLocation = (Object[])ClusterLocations.get(i);
            Event[] CurrEvents = this.CreateEvents(CurrLocation, ClusterHeader);
            if (Debug) {
                System.out.println("FINISHED CREATING EVENTS FROM LOCATION[" + i + "]");
            }
            int j = 0;
            while (j < CurrEvents.length) {
                AllEvents = Event.AddEventToList(CurrEvents[j], AllEvents);
                ++j;
            }
            ++i;
        }
        Event[] Ret = new Event[AllEvents.size()];
        int i2 = 0;
        while (i2 < Ret.length) {
            int[] coords;
            Ret[i2] = (Event)AllEvents.get(i2);
            if (Ret[i2].Type != EventType.NovelGene && Utils.HasOverlap((coords = (int[])this.GeneCoordsHash.get(Ret[i2].RefinedFeature))[0], coords[1], Ret[i2].Start, Ret[i2].End)) {
                Ret[i2].hasOverlap = true;
            }
            ++i2;
        }
        return Ret;
    }

    public void DebugPrintParams() {
        System.out.println("INPUT FILES: ");
        int i = 0;
        while (i < this.InputFiles.length) {
            System.out.println(" " + this.InputFiles[i]);
            ++i;
        }
        System.out.println("OUTPUT FILE: " + this.OutputFile);
        System.out.println("KNOWN GFF FILE: " + this.ProteinGFFFile);
        if (this.FilteredProteinSeqFile != null) {
            System.out.println("FILTERED PROTEIN FILE: " + this.FilteredProteinSeqFile);
        }
        System.out.println("MIN EVENT PROB: " + this.MinEventProb);
    }

    public static Hashtable loadEventGFF(String eventGFF, Hashtable gFFToGeneMap, boolean verbose, String[] types) {
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(eventGFF));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, eventGFF);
        }
        ArrayList currEventLines = new ArrayList();
        Object currEventParent = null;
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, eventGFF);
                }
                continue;
            }
            Hashtable atts = GFFFile.getAttributes(line);
            if (!atts.containsKey("parent")) {
                ErrorThrower.ThrowError(12, "Line does not contain 'Parent' attribute: " + line);
            }
            String eventParent = (String)atts.get("parent");
            String[] parentBits = eventParent.split("[.]");
            if (types == null || Utils.FindStringInArrayCaseInsensitive(types, parentBits[1]) >= 0) {
                String gffGene;
                if (parentBits.length < 4) {
                    if (!parentBits[1].equalsIgnoreCase("NovelGene")) {
                        ErrorThrower.ThrowError(12, "Ill-formed parent attribute does not contain gene name:" + line);
                    }
                    String[] bits = line.split("\t");
                    gffGene = String.valueOf(bits[GFFFile.GFFColumns.SequenceName]) + "." + bits[GFFFile.GFFColumns.Strand] + "." + parentBits[2];
                } else {
                    gffGene = parentBits[3];
                }
                String gene = gffGene;
                if (gFFToGeneMap != null && !gFFToGeneMap.containsKey(gffGene)) {
                    if (verbose) {
                        ErrorThrower.ThrowWarning(13, "No entry for '" + gffGene + "'.  Using key as value");
                    }
                } else if (gFFToGeneMap != null && gFFToGeneMap.containsKey(gffGene)) {
                    gene = (String)gFFToGeneMap.get(gffGene);
                }
                ArrayList eventLines = null;
                eventLines = ret.containsKey(gene) ? (ArrayList)ret.get(gene) : new ArrayList();
                eventLines.add(line);
                ret.put(gene, eventLines);
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, eventGFF);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, eventGFF);
        }
        return ret;
    }

    public static Hashtable loadEventsByFeatureName(String tableFile, boolean uniqueOnly, boolean arePLGs) {
        BufferedReader buf = Utils.openBufferedReader(tableFile);
        String line = Utils.readNextLine(buf, tableFile);
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = Utils.readNextLine(buf, tableFile);
                continue;
            }
            String[] bits = line.split("\t");
            if (arePLGs) {
                String[] temp = new String[bits.length - 2];
                int k = 2;
                while (k < bits.length) {
                    temp[k - 2] = bits[k];
                    ++k;
                }
                bits = temp;
            }
            String eventType = "";
            if (Utils.StringIsNum(bits[1])) {
                String strand = "-1";
                eventType = "NovelGene";
                String[] peptideBits = bits[3].split(",");
                HashSet<String> peptides = new HashSet<String>();
                int i = 0;
                while (i < peptideBits.length) {
                    String[] pepInfo = peptideBits[i].split(":");
                    if (pepInfo[3].equals("true") || !uniqueOnly) {
                        peptides.add(Utils.RemoveFlankingAAs(pepInfo[0]));
                    }
                    strand = pepInfo[2];
                    ++i;
                }
                String locusName = (String.valueOf(bits[0]) + "." + strand + ".(" + (Integer.parseInt(bits[1]) + 1) + "-" + bits[2] + ")").toLowerCase();
                ArrayList locusDeets = null;
                locusDeets = ret.containsKey(locusName) ? (ArrayList)ret.get(locusName) : new ArrayList();
                Object[] deets = new Object[]{eventType, Utils.ConvertHashSetToStringArray(peptides)};
                locusDeets.add(deets);
                ret.put(locusName, locusDeets);
            } else {
                eventType = bits[1];
                String[] peptideBits = bits[2].split(",");
                HashSet<String> peptides = new HashSet<String>();
                int i = 0;
                while (i < peptideBits.length) {
                    String[] pepInfo = peptideBits[i].split(":");
                    if (pepInfo[3].equals("true") || !uniqueOnly) {
                        peptides.add(Utils.RemoveFlankingAAs(pepInfo[0]));
                    }
                    ++i;
                }
                String locusName = bits[0].toLowerCase();
                ArrayList locusDeets = null;
                locusDeets = ret.containsKey(locusName) ? (ArrayList)ret.get(locusName) : new ArrayList();
                Object[] deets = new Object[]{eventType, Utils.ConvertHashSetToStringArray(peptides)};
                locusDeets.add(deets);
                ret.put(locusName, locusDeets);
            }
            line = Utils.readNextLine(buf, tableFile);
        }
        Utils.closeBufferedReader(buf, tableFile);
        return ret;
    }

    public static Hashtable loadEventPeptidesFromTableFile(String tableFile, boolean uniqueOnly, boolean arePLGs) {
        BufferedReader buf = Utils.openBufferedReader(tableFile);
        String line = Utils.readNextLine(buf, tableFile);
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = Utils.readNextLine(buf, tableFile);
                continue;
            }
            String[] bits = line.split("\t");
            if (arePLGs) {
                String[] temp = new String[bits.length - 2];
                int k = 2;
                while (k < bits.length) {
                    temp[k - 2] = bits[k];
                    ++k;
                }
                bits = temp;
            }
            if (Utils.StringIsNum(bits[1])) {
                String strand = "-1";
                String[] peptideBits = bits[3].split(",");
                HashSet<String> peptides = new HashSet<String>();
                int i = 0;
                while (i < peptideBits.length) {
                    String[] pepInfo = peptideBits[i].split(":");
                    if (pepInfo[3].equals("true") || !uniqueOnly) {
                        peptides.add(Utils.RemoveFlankingAAs(pepInfo[0]));
                    }
                    strand = pepInfo[2];
                    ++i;
                }
                String locusName = (String.valueOf(bits[0]) + "." + strand + ".(" + (Integer.parseInt(bits[1]) + 1) + "-" + bits[2] + ")").toLowerCase();
                if (ret.containsKey(locusName)) {
                    String[] oldPeps = (String[])ret.get(locusName);
                    int p = 0;
                    while (p < oldPeps.length) {
                        peptides.add(oldPeps[p]);
                        ++p;
                    }
                }
                ret.put(locusName, Utils.ConvertHashSetToStringArray(peptides));
            } else {
                String[] peptideBits = bits[2].split(",");
                HashSet<String> peptides = new HashSet<String>();
                int i = 0;
                while (i < peptideBits.length) {
                    String[] pepInfo = peptideBits[i].split(":");
                    if (pepInfo[3].equals("true") || !uniqueOnly) {
                        peptides.add(Utils.RemoveFlankingAAs(pepInfo[0]));
                    }
                    ++i;
                }
                String locusName = bits[0].toLowerCase();
                if (ret.containsKey(locusName)) {
                    String[] oldPeps = (String[])ret.get(locusName);
                    int p = 0;
                    while (p < oldPeps.length) {
                        peptides.add(oldPeps[p]);
                        ++p;
                    }
                }
                ret.put(locusName, Utils.ConvertHashSetToStringArray(peptides));
            }
            line = Utils.readNextLine(buf, tableFile);
        }
        Utils.closeBufferedReader(buf, tableFile);
        return ret;
    }

    public static class Event {
        public EventType Type;
        public String RefinedFeature = null;
        public int ExonIndex = -1;
        public int ExonFrame = -1;
        public int SuggestedFrame = -1;
        public int ExonStart = -1;
        public int ExonEnd = -1;
        public boolean term = N_TERM;
        public int ExonIndex2 = -1;
        public int ExonFrame2 = -1;
        public int SuggestedFrame2 = -1;
        public int ExonStart2 = -1;
        public int ExonEnd2 = -1;
        public int SpliceStart = -1;
        public int SpliceEnd = -1;
        public int FeatureStrand = -1;
        public int Start = -1;
        public int End = -1;
        public double Prob = 0.0;
        private ArrayList SupportingLocations = null;
        public boolean hasOverlap;

        public Event(EventType Type) {
            this.Type = Type;
            this.setSupportingLocations(new ArrayList());
        }

        public static ArrayList SortEvents(ArrayList a) {
            int i = 0;
            while (i < a.size()) {
                int MinIndex = i;
                Event MinEvent = (Event)a.get(i);
                int j = i + 1;
                while (j < a.size()) {
                    Event NextEvent = (Event)a.get(j);
                    if (NextEvent.Start < MinEvent.Start || NextEvent.Start == MinEvent.Start && NextEvent.End < MinEvent.End) {
                        MinEvent = NextEvent;
                        MinIndex = j;
                    }
                    ++j;
                }
                if (MinIndex != i) {
                    Event Temp = (Event)a.remove(i);
                    a.add(i, MinEvent);
                    a.remove(MinIndex);
                    a.add(MinIndex, Temp);
                }
                ++i;
            }
            return a;
        }

        public String CreateOneLineString() {
            String Ret = String.valueOf(this.RefinedFeature) + "\t" + (Object)((Object)this.Type) + "\t";
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] CurrLoc = (Object[])this.getSupportingLocations().get(i);
                if (i > 0) {
                    Ret = String.valueOf(Ret) + ",";
                }
                Ret = String.valueOf(Ret) + CurrLoc[SearchLocation.GenomicColumns.Peptide] + ":" + (Integer)CurrLoc[SearchLocation.GenomicColumns.Start] + "-" + (Integer)CurrLoc[SearchLocation.GenomicColumns.End] + ":" + (Integer)CurrLoc[SearchLocation.GenomicColumns.Strand] + ":" + (Boolean)CurrLoc[SearchLocation.GenomicColumns.IsUnique];
                ++i;
            }
            Ret = String.valueOf(Ret) + "\t" + this.Prob + "\n";
            return Ret;
        }

        public String CreateFileString() {
            String Ret = "";
            Ret = String.valueOf(Ret) + this.Start + "-" + this.End + "\n";
            Ret = String.valueOf(Ret) + (Object)((Object)this.Type) + "\n";
            Ret = String.valueOf(Ret) + this.RefinedFeature + "\n";
            Ret = String.valueOf(Ret) + this.FeatureStrand + "\n";
            Ret = String.valueOf(Ret) + this.ExonIndex + "\n";
            Ret = String.valueOf(Ret) + this.ExonStart + "\n";
            Ret = String.valueOf(Ret) + this.ExonEnd + "\n";
            Ret = String.valueOf(Ret) + this.ExonFrame + "\n";
            Ret = String.valueOf(Ret) + this.SuggestedFrame + "\n";
            Ret = String.valueOf(Ret) + this.ExonIndex2 + "\n";
            Ret = String.valueOf(Ret) + this.ExonStart2 + "\n";
            Ret = String.valueOf(Ret) + this.ExonEnd2 + "\n";
            Ret = String.valueOf(Ret) + this.ExonFrame2 + "\n";
            Ret = String.valueOf(Ret) + this.SuggestedFrame2 + "\n";
            Ret = String.valueOf(Ret) + this.Prob + "\n";
            Ret = String.valueOf(Ret) + this.getSupportingLocations().size() + "\n";
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] CurrLoc = (Object[])this.getSupportingLocations().get(i);
                Ret = String.valueOf(Ret) + SearchLocation.GenomicColumns.toString(CurrLoc, "\t") + "\n";
                ++i;
            }
            return Ret;
        }

        public String CreateGFFFileString() {
            String Ret = "";
            String Header = "Event." + (Object)((Object)this.Type) + ".(" + (this.Start + 1) + "-" + this.End + ")";
            if (this.RefinedFeature != null) {
                Header = String.valueOf(Header) + "." + this.RefinedFeature;
            }
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] Loc = (Object[])this.getSupportingLocations().get(i);
                Loc[SearchLocation.GenomicColumns.BestLocalFDR] = new Double(1.0 - this.Prob);
                Ret = String.valueOf(Ret) + SearchLocation.GenomicColumns.toGFFFileLine(Loc, Header);
                ++i;
            }
            return Ret;
        }

        public String CreateGFFFileString(String species) {
            String Ret = "";
            String Header = "Event." + (Object)((Object)this.Type) + ".(" + (this.Start + 1) + "-" + this.End + ")";
            if (this.RefinedFeature != null) {
                Header = String.valueOf(Header) + "." + this.RefinedFeature;
            }
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] Loc = (Object[])this.getSupportingLocations().get(i);
                Loc[SearchLocation.GenomicColumns.BestLocalFDR] = new Double(1.0 - this.Prob);
                Ret = String.valueOf(Ret) + SearchLocation.GenomicColumns.toGFFFileLine(Loc, Header, species);
                ++i;
            }
            return Ret;
        }

        public static EventType GetEventTypeFromString(String Line) {
            if (Line.compareTo("Consistent") == 0) {
                return EventType.Consistent;
            }
            if (Line.compareTo("FrameShift") == 0) {
                return EventType.FrameShift;
            }
            if (Line.compareTo("TranslatedUTR") == 0) {
                return EventType.TranslatedUTR;
            }
            if (Line.compareTo("ExonBoundary") == 0) {
                return EventType.ExonBoundary;
            }
            if (Line.compareTo("NovelSplice") == 0) {
                return EventType.NovelSplice;
            }
            if (Line.compareTo("NovelExon") == 0) {
                return EventType.NovelExon;
            }
            if (Line.compareTo("GeneBoundary") == 0) {
                return EventType.GeneBoundary;
            }
            if (Line.compareTo("ReverseStrand") == 0) {
                return EventType.ReverseStrand;
            }
            if (Line.compareTo("NovelGene") == 0) {
                return EventType.NovelGene;
            }
            return null;
        }

        public static Event[] LoadEventsFromFile(String FileName) {
            ArrayList<Event> Temp = new ArrayList<Event>();
            BufferedReader Buf = null;
            String Line = null;
            try {
                Buf = new BufferedReader(new FileReader(FileName));
                Line = Buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, FileName);
            }
            int LineNumber = 0;
            int Start = -1;
            int End = -1;
            int TotalLocations = 0;
            Event CurrEvent = null;
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = Buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, FileName);
                    }
                    continue;
                }
                switch (LineNumber) {
                    case 0: {
                        if (CurrEvent != null) {
                            Temp.add(CurrEvent);
                        }
                        String[] Bits = Line.split("-");
                        Start = Integer.parseInt(Bits[0]);
                        End = Integer.parseInt(Bits[1]);
                        break;
                    }
                    case 1: {
                        EventType t = Event.GetEventTypeFromString(Line);
                        CurrEvent = new Event(t);
                        CurrEvent.Start = Start;
                        CurrEvent.End = End;
                        break;
                    }
                    case 2: {
                        CurrEvent.RefinedFeature = Line;
                        break;
                    }
                    case 3: {
                        CurrEvent.FeatureStrand = Integer.parseInt(Line);
                        break;
                    }
                    case 4: {
                        CurrEvent.ExonIndex = Integer.parseInt(Line);
                        break;
                    }
                    case 5: {
                        CurrEvent.ExonStart = Integer.parseInt(Line);
                        break;
                    }
                    case 6: {
                        CurrEvent.ExonEnd = Integer.parseInt(Line);
                        break;
                    }
                    case 7: {
                        CurrEvent.ExonFrame = Integer.parseInt(Line);
                        break;
                    }
                    case 8: {
                        CurrEvent.SuggestedFrame = Integer.parseInt(Line);
                        break;
                    }
                    case 9: {
                        CurrEvent.ExonIndex2 = Integer.parseInt(Line);
                        break;
                    }
                    case 10: {
                        CurrEvent.ExonStart2 = Integer.parseInt(Line);
                        break;
                    }
                    case 11: {
                        CurrEvent.ExonEnd2 = Integer.parseInt(Line);
                        break;
                    }
                    case 12: {
                        CurrEvent.ExonFrame2 = Integer.parseInt(Line);
                        break;
                    }
                    case 13: {
                        CurrEvent.SuggestedFrame2 = Integer.parseInt(Line);
                        break;
                    }
                    case 14: {
                        CurrEvent.Prob = Double.parseDouble(Line);
                        break;
                    }
                    case 15: {
                        TotalLocations = Integer.parseInt(Line);
                        break;
                    }
                    default: {
                        if (LineNumber < 16 + TotalLocations) {
                            Object[] NewLoc = SearchLocation.GenomicColumns.LoadFromString(Line);
                            CurrEvent.getSupportingLocations().add(NewLoc);
                        }
                        if (LineNumber != 16 + TotalLocations - 1) break;
                        LineNumber = -1;
                    }
                }
                try {
                    Line = Buf.readLine();
                    ++LineNumber;
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, FileName);
                }
            }
            if (CurrEvent != null) {
                Temp.add(CurrEvent);
            }
            try {
                Buf.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, FileName);
            }
            Event[] Ret = new Event[Temp.size()];
            int i = 0;
            while (i < Ret.length) {
                Ret[i] = (Event)Temp.get(i);
                ++i;
            }
            return Ret;
        }

        public void AddMoreSupport(Object[] Location, int RegionStart, int RegionEnd) {
            this.getSupportingLocations().add(Location);
            this.UpdateSpan(RegionStart, RegionEnd);
        }

        public void AddMoreSupportNoDoubles(Object[] Location, int RegionStart, int RegionEnd) {
            if (Debug) {
                System.out.println("Adding support of : " + SearchLocation.GenomicColumns.toString(Location, " "));
            }
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] CurrLocation = (Object[])this.getSupportingLocations().get(i);
                if (SearchLocation.GenomicColumns.IsSameLocation(CurrLocation, Location)) {
                    if (Debug) {
                        System.out.println("NOT ADDED DUPLICATION!!");
                    }
                    return;
                }
                ++i;
            }
            this.getSupportingLocations().add(Location);
            this.UpdateSpan(RegionStart, RegionEnd);
        }

        private void UpdateSpan(int RegionStart, int RegionEnd) {
            this.Start = Math.min(this.Start, RegionStart);
            if (this.Start == -1) {
                this.Start = RegionStart;
            }
            this.End = Math.max(this.End, RegionEnd);
        }

        public void DebugPrint() {
            System.out.println("EVENT: " + this.Start + "-" + this.End);
            if (this.Type == EventType.Consistent) {
                System.out.println("TYPE: Consistent");
            } else if (this.Type == EventType.ExonBoundary) {
                System.out.println("TYPE: ExonBoundary");
            } else if (this.Type == EventType.FrameShift) {
                System.out.println("TYPE: FrameShift");
            } else if (this.Type == EventType.GeneBoundary) {
                System.out.println("TYPE: GeneBoundary");
            } else if (this.Type == EventType.NovelExon) {
                System.out.println("TYPE: NovelExon");
            } else if (this.Type == EventType.NovelGene) {
                System.out.println("TYPE: NovelGene");
            } else if (this.Type == EventType.NovelSplice) {
                System.out.println("TYPE: NovelSplice");
            } else if (this.Type == EventType.ReverseStrand) {
                System.out.println("TYPE: ReverseStrand");
            } else if (this.Type == EventType.TranslatedUTR) {
                System.out.println("TYPE: TranslatedUTR");
            }
            System.out.println("FEATURE NAME: " + this.RefinedFeature);
            System.out.println("FEATURE STRAND: " + this.FeatureStrand);
            System.out.println("AFFECTED EXON: " + this.ExonIndex + " (" + this.ExonStart + "-" + this.ExonEnd + "), Frame: " + this.ExonFrame);
            if (this.Type == EventType.FrameShift || this.Type == EventType.NovelExon || this.Type == EventType.ExonBoundary) {
                System.out.println("SUGGESTED NEW FRAME: " + this.SuggestedFrame);
            }
            if (this.Type == EventType.NovelSplice) {
                System.out.println("AFFECTED EXON2: " + this.ExonIndex2 + " (" + this.ExonStart2 + "-" + this.ExonEnd2 + "), Frame: " + this.ExonFrame2);
                System.out.println("SPLICE: " + this.SpliceStart + "-" + this.SpliceEnd);
            }
            System.out.println("Prob: " + this.Prob);
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                System.out.println("[" + i + "]:" + SearchLocation.GenomicColumns.toString((Object[])this.getSupportingLocations().get(i), " "));
                ++i;
            }
        }

        public static ArrayList AddEventToList(Event event, ArrayList finalEvents) {
            if (Debug) {
                System.out.println("Adding a new event to the list:");
                event.DebugPrint();
            }
            if (finalEvents == null) {
                finalEvents = new ArrayList<Event>();
            }
            if (finalEvents.size() == 0) {
                if (Debug) {
                    System.out.println("First event to be added!");
                    Utils.WaitForEnter();
                }
                finalEvents.add(event);
                return finalEvents;
            }
            int i = 0;
            Event Result = event;
            boolean Merged = false;
            while (i < finalEvents.size()) {
                Event OldEvent = (Event)finalEvents.remove(i);
                Event NewResult = Event.MergeEvents(Result, OldEvent);
                if (NewResult != null) {
                    i = 0;
                    Merged = true;
                    if (Debug) {
                        System.out.println("MERGED TWO EVENTS:");
                        NewResult.DebugPrint();
                        Utils.WaitForEnter();
                    }
                    Result = NewResult;
                    continue;
                }
                finalEvents.add(i, OldEvent);
                ++i;
            }
            if (!Merged) {
                finalEvents.add(event);
            } else {
                finalEvents.add(Result);
            }
            if (Debug) {
                System.out.println("Finished adding event:");
                int j = 0;
                while (j < finalEvents.size()) {
                    Event E = (Event)finalEvents.get(j);
                    System.out.print("[" + j + "]:");
                    E.DebugPrint();
                    ++j;
                }
                Utils.WaitForEnter();
            }
            return finalEvents;
        }

        private static Event MergeEvents(Event event, Event oldEvent) {
            if (Debug) {
                System.out.println("Attempting to merge:");
                System.out.println("-event-");
                event.DebugPrint();
                System.out.println("-oldEvent-");
                oldEvent.DebugPrint();
            }
            if (event.Type == EventType.NovelGene && oldEvent.Type == EventType.NovelGene) {
                int i = 0;
                while (i < oldEvent.getSupportingLocations().size()) {
                    event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                    ++i;
                }
                return event;
            }
            if (event.RefinedFeature.compareTo(oldEvent.RefinedFeature) != 0) {
                if (Debug) {
                    System.out.println("WARNING: Events are not on the same feature, cannot be merged");
                    event.DebugPrint();
                    oldEvent.DebugPrint();
                }
                return null;
            }
            boolean HasOverlap = Utils.HasOverlap(event.Start, event.End, oldEvent.Start, oldEvent.End);
            if (event.Type == EventType.ReverseStrand) {
                if (oldEvent.Type == EventType.ReverseStrand) {
                    int i = 0;
                    while (i < oldEvent.getSupportingLocations().size()) {
                        event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                        ++i;
                    }
                    return event;
                }
                return null;
            }
            if (event.Type == EventType.NovelSplice) {
                if (oldEvent.Type == EventType.NovelSplice && event.ExonIndex == oldEvent.ExonIndex && event.ExonIndex2 == oldEvent.ExonIndex2 && event.SpliceStart == oldEvent.SpliceStart && event.SpliceEnd == oldEvent.SpliceEnd) {
                    int i = 0;
                    while (i < oldEvent.getSupportingLocations().size()) {
                        event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                        ++i;
                    }
                    return event;
                }
                return null;
            }
            if (event.Type == EventType.FrameShift) {
                if (HasOverlap) {
                    if ((oldEvent.Type == EventType.FrameShift || oldEvent.Type == EventType.ExonBoundary || oldEvent.Type == EventType.NovelExon || oldEvent.Type == EventType.TranslatedUTR || oldEvent.Type == EventType.GeneBoundary) && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                        int i = 0;
                        while (i < oldEvent.getSupportingLocations().size()) {
                            event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                            ++i;
                        }
                        return event;
                    }
                    return null;
                }
                if (oldEvent.Type == EventType.FrameShift && event.ExonIndex == oldEvent.ExonIndex && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                    int i = 0;
                    while (i < oldEvent.getSupportingLocations().size()) {
                        event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                        ++i;
                    }
                    return event;
                }
                return null;
            }
            if (event.Type == EventType.ExonBoundary && HasOverlap) {
                if (oldEvent.Type == EventType.FrameShift) {
                    if (event.SuggestedFrame == oldEvent.SuggestedFrame) {
                        int i = 0;
                        while (i < event.getSupportingLocations().size()) {
                            oldEvent.AddMoreSupportNoDoubles((Object[])event.getSupportingLocations().get(i), event.Start, event.End);
                            ++i;
                        }
                        return oldEvent;
                    }
                } else if ((oldEvent.Type == EventType.ExonBoundary || oldEvent.Type == EventType.NovelExon || oldEvent.Type == EventType.GeneBoundary || oldEvent.Type == EventType.TranslatedUTR) && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                    int i = 0;
                    while (i < oldEvent.getSupportingLocations().size()) {
                        event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                        ++i;
                    }
                    return event;
                }
                return null;
            }
            if (event.Type == EventType.NovelExon && HasOverlap) {
                if (oldEvent.Type == EventType.FrameShift || oldEvent.Type == EventType.ExonBoundary) {
                    if (event.SuggestedFrame == oldEvent.SuggestedFrame) {
                        int i = 0;
                        while (i < event.getSupportingLocations().size()) {
                            oldEvent.AddMoreSupportNoDoubles((Object[])event.getSupportingLocations().get(i), event.Start, event.End);
                            ++i;
                        }
                        return oldEvent;
                    }
                } else if (oldEvent.Type == EventType.NovelExon && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                    int i = 0;
                    while (i < oldEvent.getSupportingLocations().size()) {
                        event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                        ++i;
                    }
                    return event;
                }
                return null;
            }
            if (event.Type == EventType.TranslatedUTR) {
                if (HasOverlap) {
                    if ((oldEvent.Type == EventType.FrameShift || oldEvent.Type == EventType.ExonBoundary) && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                        int i = 0;
                        while (i < event.getSupportingLocations().size()) {
                            oldEvent.AddMoreSupportNoDoubles((Object[])event.getSupportingLocations().get(i), event.Start, event.End);
                            ++i;
                        }
                        return oldEvent;
                    }
                    if ((oldEvent.Type == EventType.TranslatedUTR || oldEvent.Type == EventType.GeneBoundary) && event.term == oldEvent.term && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                        int i = 0;
                        while (i < oldEvent.getSupportingLocations().size()) {
                            event.AddMoreSupportNoDoubles((Object[])oldEvent.getSupportingLocations().get(i), oldEvent.Start, oldEvent.End);
                            ++i;
                        }
                        return event;
                    }
                } else if (oldEvent.Type == EventType.TranslatedUTR && oldEvent.term == event.term) {
                    int i = 0;
                    while (i < event.getSupportingLocations().size()) {
                        oldEvent.AddMoreSupportNoDoubles((Object[])event.getSupportingLocations().get(i), event.Start, event.End);
                        ++i;
                    }
                    return oldEvent;
                }
            }
            if (event.Type == EventType.GeneBoundary) {
                if (HasOverlap) {
                    if ((oldEvent.Type == EventType.FrameShift || oldEvent.Type == EventType.ExonBoundary || oldEvent.Type == EventType.TranslatedUTR) && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                        int i = 0;
                        while (i < event.getSupportingLocations().size()) {
                            oldEvent.AddMoreSupportNoDoubles((Object[])event.getSupportingLocations().get(i), event.Start, event.End);
                            ++i;
                        }
                        return oldEvent;
                    }
                    if ((oldEvent.Type == EventType.TranslatedUTR || oldEvent.Type == EventType.GeneBoundary) && event.term == oldEvent.term && event.SuggestedFrame == oldEvent.SuggestedFrame) {
                        int i = 0;
                        while (i < event.getSupportingLocations().size()) {
                            oldEvent.AddMoreSupportNoDoubles((Object[])event.getSupportingLocations().get(i), event.Start, event.End);
                            ++i;
                        }
                        return oldEvent;
                    }
                } else if (oldEvent.Type == EventType.GeneBoundary && oldEvent.term == event.term) {
                    int i = 0;
                    while (i < event.getSupportingLocations().size()) {
                        oldEvent.AddMoreSupportNoDoubles((Object[])event.getSupportingLocations().get(i), event.Start, event.End);
                        ++i;
                    }
                    return oldEvent;
                }
            }
            return null;
        }

        public String CreateOneLineStringNovelGene() {
            String Sequence = (String)((Object[])this.getSupportingLocations().get(0))[SearchLocation.GenomicColumns.SequenceName];
            String Ret = String.valueOf(Sequence) + "\t" + this.Start + "\t" + this.End + "\t";
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] CurrLoc = (Object[])this.getSupportingLocations().get(i);
                if (i > 0) {
                    Ret = String.valueOf(Ret) + ",";
                }
                Ret = String.valueOf(Ret) + CurrLoc[SearchLocation.GenomicColumns.Peptide] + ":" + (Integer)CurrLoc[SearchLocation.GenomicColumns.Start] + "-" + (Integer)CurrLoc[SearchLocation.GenomicColumns.End] + ":" + (Integer)CurrLoc[SearchLocation.GenomicColumns.Strand] + ":" + (Boolean)CurrLoc[SearchLocation.GenomicColumns.IsUnique];
                ++i;
            }
            return String.valueOf(Ret) + "\t" + this.Prob + "\n";
        }

        public String CreateOneLineString(String[] knownPeptideInfo) {
            String Ret = String.valueOf(this.RefinedFeature) + "\t" + (Object)((Object)this.Type) + "\t";
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] CurrLoc = (Object[])this.getSupportingLocations().get(i);
                if (i > 0) {
                    Ret = String.valueOf(Ret) + ",";
                }
                Ret = String.valueOf(Ret) + CurrLoc[SearchLocation.GenomicColumns.Peptide] + ":" + (Integer)CurrLoc[SearchLocation.GenomicColumns.Start] + "-" + (Integer)CurrLoc[SearchLocation.GenomicColumns.End] + ":" + (Integer)CurrLoc[SearchLocation.GenomicColumns.Strand] + ":" + (Boolean)CurrLoc[SearchLocation.GenomicColumns.IsUnique];
                ++i;
            }
            Ret = String.valueOf(Ret) + "\t" + this.Prob + "\t" + this.getSupportingLocations().size() + "\t" + this.hasOverlap;
            if (knownPeptideInfo == null) {
                return String.valueOf(Ret) + "\t \t \t \n";
            }
            Ret = String.valueOf(Ret) + "\t" + knownPeptideInfo[0];
            Ret = String.valueOf(Ret) + "\t" + knownPeptideInfo[1];
            Ret = String.valueOf(Ret) + "\t" + knownPeptideInfo[2];
            return String.valueOf(Ret) + "\n";
        }

        public void setSupportingLocations(ArrayList supportingLocations) {
            this.SupportingLocations = supportingLocations;
        }

        public ArrayList getSupportingLocations() {
            return this.SupportingLocations;
        }

        public int getNumUniquePeptides() {
            int ret = 0;
            int i = 0;
            while (i < this.getSupportingLocations().size()) {
                Object[] CurrLoc = (Object[])this.getSupportingLocations().get(i);
                if (((Boolean)CurrLoc[SearchLocation.GenomicColumns.IsUnique]).booleanValue()) {
                    ++ret;
                }
                ++i;
            }
            return ret;
        }
    }

    public static enum EventType {
        Consistent,
        FrameShift,
        TranslatedUTR,
        ExonBoundary,
        NovelSplice,
        NovelExon,
        GeneBoundary,
        ReverseStrand,
        NovelGene;

    }

    public static class SimpleExon {
        public int Start;
        public int End;
        public int ReadingFrame;
        public int Strand;

        public SimpleExon(int Start, int End, int ReadingFrame, int Strand) {
            this.Start = Start;
            this.End = End;
            this.ReadingFrame = ReadingFrame;
            this.Strand = Strand;
        }
    }
}

