/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import proteogenomicUtils.GenomicLocator;
import sixFrameUtils.SixFrameBuilder;

public class FixDecoyORFStrand {
    public static String UsageInfo = "proteogenomicUtils.FixDecoyORFStrand version 09.23.2010\nThe decoy genome switches the strand directionality, and flips each codon.  For example, if the target genome is:\n5' ATG GGG GTA CGT TGC CGT 3' so the protein will read 'Met Gly Val Arg Cys Arg'\n3' TAC CCC CAT GCA ACG GCA 5' so the protein will read 'Thr Ala Thr Tyr Pro His'\n\nThe decoy genome will look like\n5' CAT CCC TAC ACG GCA ACG 3' so the protein will read 'His Pro Tyr Thr Ala Thr'\n3' GTA GGG GTA TGC CGT TGC 5' so the protein will read 'Arg Cys Arg Val Gly Met'\n\nIn this way, the decoy of a protein is simply the reverse of the protein, but the coordinates are preserved.  \nHowever, when we constructed the six frame translation, we merely reversed the protein without changing \nthe strand. (For the splice graph we changed both the coordinates and the strand).  This script simply changes \nthe strand of the matched ORF\n[REQUIRED]:\n -r [FILE] Locations file\n -w [FILE] Output file with updated decoy ORF strands\n[OPTIONAL]:\n -d Run in debug mode\n";
    private String InputFile;
    private String OutputFile;
    private boolean Debug = false;

    public FixDecoyORFStrand(String inputFile2, String outputFile2) {
        if (!Utils.IsFile(inputFile2)) {
            System.err.println("ERROR: Input file is not valid: " + inputFile2);
            System.exit(-1);
        }
        this.InputFile = inputFile2;
        this.OutputFile = outputFile2;
    }

    private void RunFixer() {
        BufferedReader buf = null;
        OutputStreamWriter fWriter = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(this.InputFile));
            fWriter = new FileWriter(this.OutputFile);
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    fWriter.write(String.valueOf(Line) + "\n");
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            Object[] CurrLoc = GenomicLocator.GenomicColumns.LoadFromString(Line);
            if (SixFrameBuilder.IsSixFrameFASTAHeader((String)CurrLoc[GenomicLocator.GenomicColumns.ProteinName]) && Utils.IsDecoyProtein((String)CurrLoc[GenomicLocator.GenomicColumns.ProteinName])) {
                if (this.Debug) {
                    System.out.println("Found a decoy ORF!");
                    System.out.println(Line);
                }
                int Strand = (Integer)CurrLoc[GenomicLocator.GenomicColumns.Strand];
                Strand = 1 - Strand;
                CurrLoc[GenomicLocator.GenomicColumns.Strand] = new Integer(Strand);
                String[] HeaderBits = SixFrameBuilder.ParseSixFrameHeader((String)CurrLoc[GenomicLocator.GenomicColumns.ProteinName]);
                CurrLoc[GenomicLocator.GenomicColumns.ProteinName] = SixFrameBuilder.CreateSixFrameFASTAHeader(HeaderBits[0], Integer.parseInt(HeaderBits[1]), Integer.parseInt(HeaderBits[2]), Strand);
                if (this.Debug) {
                    System.out.println(GenomicLocator.GenomicColumns.toString(CurrLoc, " "));
                    Utils.WaitForEnter();
                }
            }
            try {
                fWriter.write(String.valueOf(GenomicLocator.GenomicColumns.toString(CurrLoc, "\t")) + "\n");
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
            fWriter.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-d"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Missing required arguments!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String InputFile = (String)CommandLineArgs.get("-r");
        String OutputFile = (String)CommandLineArgs.get("-w");
        FixDecoyORFStrand f = new FixDecoyORFStrand(InputFile, OutputFile);
        if (CommandLineArgs.containsKey("-d")) {
            f.Debug = true;
        }
        f.RunFixer();
    }
}

