/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class KnownProteinChooser {
    public static String UsageInfo = "basicUtils.KnownProteinChooser version 1.31.2011\nCounts peptides and reports protein counts in one of several ways:\n 0. Parsimony : Greedily chooses proteins based on peptide count, each peptide only counts towards one protein\n 1. Maximony : Chooses all proteins with more than 2 peptides, each peptide counts towards all proteins\n 2. Score : Computes a probability of the protein being selected using lFDR\n 3. Unique : Only reports proteins/locii which have at least one unique peptide\n[REQUIRED]:\n -r [FILE/DIR] File or directory containing files of Inspect results\n -t [NUM] this specifies the proteome trie file\n -c [NUM] 0: Parsimony, 1: Maximony, 2: Score, 3: Unique\n -m [NUM] if Maximony is used, this specifies the min number of peptides per protein\n -s [NUM] if Score is used, this specificies the min probability of the protein\n[OPTIONAL]:\n -w [FILE] File to write tabulated results to\n -f [FILE] Write selected proteins to FASTA file \n -p [FILE] Draw the discovery curve of peptides and proteins\n -d Run in debug mode\n -g [FILE] Report number of genes also\n -q [FILE] Write cluster groups\n -y [NUM] Remove all peptides with more than NUM locations\n -u [NUM] Fraction of peptides shared for clusters to be sisters\n -a [FILE] File with conversions between GFF transcript name to FASTA protein name\n -j [NUM] Column containing the FASTA protein name in the conversion file (default:3)\n -n [NUM] Column containing the gene name in the conversion file (default: 1)\n";
    private ChooseScheme Scheme = ChooseScheme.Unique;
    private String[] InputFiles = null;
    public TrieDB Proteome = null;
    private String OutputFile = null;
    private String OutputGeneFile = null;
    private int MinPep = -1;
    private double MinProb = -1.0;
    private boolean Debug = false;
    private String PlotFile = null;
    private Hashtable Protein2Peptide;
    private Hashtable Protein2Name;
    private Hashtable Peptide2Protein;
    private Hashtable Peptide2Type;
    public ArrayList FinalProteinList;
    public Hashtable FinalPeptide2Protein;
    public Hashtable FinalCoverage;
    private Hashtable Peptide2BestLFDR;
    public Hashtable FinalProtein2Peptides;
    private int[] DiscoveryCurveCounts;
    private int[] specCounts;
    private int[] ProteinCounts;
    private boolean reportGenes = false;
    private String fastaFileName = null;
    private ArrayList FinalLocusList;
    private Hashtable FinalPeptide2Locus;
    private Hashtable FinalLocus2Peptides;
    private int[] LocusCounts;
    private String proteinGroupFile = null;
    private static int MinClusterGroupSize = 2;
    private static int MinPeptidesPerGroup = 1;
    private int MaxPeptideLocs = Integer.MAX_VALUE;
    private double SisterFrac = 1.0;
    private String conversionFileName = null;
    private int protColNum = 3;
    private int geneColNum = 1;
    private Hashtable Protein2GeneMap = null;

    public KnownProteinChooser(String[] InputFiles, TrieDB Proteome) {
        this.InputFiles = InputFiles;
        this.Proteome = Proteome;
    }

    public KnownProteinChooser(String InputDir, String OutputFile, ChooseScheme Scheme, String PlotFile, String Proteome, int MinPep, double MinProb, String reportGenesFile, String fastaFile, String proteinGroupFile) {
        if (Utils.IsDir(InputDir)) {
            this.InputFiles = Utils.ListDir(InputDir);
            this.OutputFile = OutputFile;
        } else {
            this.InputFiles = new String[1];
            this.InputFiles[0] = InputDir;
            this.OutputFile = OutputFile;
        }
        this.Scheme = Scheme;
        this.Proteome = new TrieDB(Proteome);
        this.PlotFile = PlotFile;
        this.OutputGeneFile = reportGenesFile;
        if (this.OutputGeneFile != null) {
            this.reportGenes = true;
        }
        if (this.Scheme == ChooseScheme.Maximony) {
            this.MinPep = MinPep;
        } else if (this.Scheme == ChooseScheme.Score) {
            this.MinProb = MinProb;
        }
        this.fastaFileName = fastaFile;
        this.proteinGroupFile = proteinGroupFile;
        if (this.proteinGroupFile != null && this.Scheme != ChooseScheme.Unique) {
            System.err.println("WARNING: Unable to report protein groups except in unique mode!!");
            this.proteinGroupFile = null;
        }
    }

    public void PrintParameters() {
        System.out.println("**Maize Choose Protein's Wisely**");
        System.out.println(" total input files: " + this.InputFiles.length);
        System.out.println(" output file: " + this.OutputFile);
        System.out.println(" proteome file: " + this.Proteome.GetDBFileName());
        if (this.Scheme == ChooseScheme.Parsimony) {
            System.out.println(" choose scheme: Parsimony");
        } else if (this.Scheme == ChooseScheme.Maximony) {
            System.out.println(" choose scheme: Maximony");
            System.out.println("   - min peptides: " + this.MinPep);
        } else if (this.Scheme == ChooseScheme.Score) {
            System.out.println(" choose scheme: Score");
            System.out.println("   - eProb cutOff: " + this.MinProb);
        } else {
            System.out.println(" choose scheme: Unique");
        }
        if (this.PlotFile != null) {
            System.out.println(" discovery curve plot: " + this.PlotFile);
        }
        if (this.proteinGroupFile != null) {
            System.out.println(" protein group file: " + this.proteinGroupFile);
            System.out.println("   - min protein group size: " + MinClusterGroupSize);
            System.out.println("   - min peptides per group: " + MinPeptidesPerGroup);
        }
        if (this.fastaFileName != null) {
            System.out.println(" protein fasta file: " + this.fastaFileName);
        }
        if (this.conversionFileName != null) {
            System.out.println(" gene conversion file: " + this.conversionFileName);
            System.out.println("   - protein column: " + this.protColNum);
            System.out.println("   - gene column: " + this.geneColNum);
        }
    }

    public void ChooseWisely() {
        this.PrintParameters();
        if (this.conversionFileName != null) {
            this.Protein2GeneMap = ProteogenomicUtils.loadTranslationFile(this.conversionFileName, this.protColNum, this.geneColNum);
            System.out.println("Loaded protein to gene map for " + this.Protein2GeneMap.size() + " proteins");
        }
        this.PopulateHashes();
        System.out.println("Total Peptides loaded: " + this.Peptide2Protein.size());
        System.out.println("Total Proteins to consider: " + this.Protein2Name.size());
        if (this.Scheme == ChooseScheme.Parsimony) {
            this.ChooseProteinsParsimony();
        } else if (this.Scheme == ChooseScheme.Maximony) {
            this.ChooseProteinsMaximony();
        } else if (this.Scheme == ChooseScheme.Score) {
            this.ChooseProteinsScore();
        } else if (this.Scheme == ChooseScheme.Unique) {
            this.ChooseProteinsUniquely();
        } else {
            System.err.println("ERROR: Invalid choosing scheme");
            System.exit(-1);
        }
        System.out.println("Total proteins accepted: " + this.FinalProteinList.size());
        if (this.OutputFile != null) {
            System.out.println("Writing final protein list to " + this.OutputFile);
            this.WriteOutput();
        }
        if (this.PlotFile != null) {
            this.PlotDiscoveryCurve();
        }
        Enumeration peps = this.Peptide2Type.keys();
        int sharedPeptides = 0;
        int uniquePeptides = 0;
        int locusUniquePeptides = 0;
        while (peps.hasMoreElements()) {
            String currPep = (String)peps.nextElement();
            ProteogenomicUtils.uniqueType t = (ProteogenomicUtils.uniqueType)((Object)this.Peptide2Type.get(currPep));
            if (t == ProteogenomicUtils.uniqueType.SHARED) {
                ++sharedPeptides;
                continue;
            }
            if (t == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                ++locusUniquePeptides;
                continue;
            }
            if (t != ProteogenomicUtils.uniqueType.PROT_UNIQUE) continue;
            ++uniquePeptides;
        }
        System.out.println("Shared peptides: " + sharedPeptides);
        System.out.println("Locus-unique peptides: " + locusUniquePeptides);
        System.out.println("Unique peptides: " + uniquePeptides);
        System.out.println("Total peptides: " + (sharedPeptides + locusUniquePeptides + uniquePeptides));
        if (this.fastaFileName != null) {
            this.writeFASTAFile();
        }
        if (this.proteinGroupFile != null) {
            this.findClusterGroups(this.MaxPeptideLocs);
        }
    }

    public static boolean proteinsAreSisters(ArrayList cluster1, ArrayList cluster2) {
        if (cluster1.size() != cluster2.size()) {
            return false;
        }
        HashSet<String> peps = new HashSet<String>();
        int i = 0;
        while (i < cluster1.size()) {
            String pepSeq = (String)cluster1.get(i);
            peps.add(pepSeq);
            ++i;
        }
        HashSet<String> peps2 = new HashSet<String>();
        int i2 = 0;
        while (i2 < cluster2.size()) {
            String pepSeq = (String)cluster2.get(i2);
            if (!peps.contains(pepSeq)) {
                return false;
            }
            peps2.add(pepSeq);
            ++i2;
        }
        return peps.size() == peps2.size();
    }

    public static boolean proteinsAreSisters(ArrayList cluster1, ArrayList cluster2, double frac) {
        if (cluster1.size() != cluster2.size()) {
            return false;
        }
        HashSet peps = new HashSet();
        double oneOnly = 0.0;
        double twoOnly = 0.0;
        double shared = 0.0;
        int i = 0;
        while (i < cluster1.size()) {
            String pepSeq = (String)cluster1.get(i);
            if (cluster2.contains(pepSeq)) {
                shared += 1.0;
            } else {
                oneOnly += 1.0;
            }
            ++i;
        }
        twoOnly = (double)cluster2.size() - shared;
        return shared / (oneOnly + shared) >= frac && shared / (twoOnly + shared) >= frac;
    }

    private void removeHighlyDegeneratePeptides(int maxLocs) {
        int removedCount = 0;
        Enumeration peps = this.Peptide2Protein.keys();
        while (peps.hasMoreElements()) {
            ArrayList locs;
            String currPep = (String)peps.nextElement();
            if (!this.Peptide2Protein.containsKey(currPep) || (locs = (ArrayList)this.Peptide2Protein.get(currPep)).size() <= maxLocs) continue;
            this.Peptide2Protein.remove(currPep);
            int j = 0;
            while (j < locs.size()) {
                Integer currProtein = (Integer)locs.get(j);
                ArrayList proteinPeptides = (ArrayList)this.Protein2Peptide.get(currProtein);
                proteinPeptides.remove(currPep);
                this.Protein2Peptide.put(currProtein, proteinPeptides);
                ++j;
            }
            ++removedCount;
        }
        System.out.println("Removed " + removedCount + " peptides with location counts greater than " + maxLocs);
    }

    private void removePeptidesFromFinalProteinList() {
        int removedCount = 0;
        int i = 0;
        while (i < this.FinalProteinList.size()) {
            Integer currProtID = (Integer)this.FinalProteinList.get(i);
            ArrayList peps = (ArrayList)this.Protein2Peptide.get(currProtID);
            int j = 0;
            while (j < peps.size()) {
                String currPep = (String)peps.get(j);
                if (this.Peptide2Protein.containsKey(currPep)) {
                    ArrayList locs = (ArrayList)this.Peptide2Protein.get(currPep);
                    int k = 0;
                    while (k < locs.size()) {
                        Integer currProtein = (Integer)locs.get(k);
                        ArrayList proteinPeptides = (ArrayList)this.Protein2Peptide.get(currProtein);
                        proteinPeptides.remove(currPep);
                        this.Protein2Peptide.put(currProtein, proteinPeptides);
                        ++k;
                    }
                    this.Peptide2Protein.remove(currPep);
                    ++removedCount;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Removed " + removedCount + " peptides that matched a selected protein");
    }

    /*
     * Unable to fully structure code
     */
    private void findClusterGroups(int maxLocs) {
        this.removeHighlyDegeneratePeptides(maxLocs);
        this.removePeptidesFromFinalProteinList();
        localDebug = false;
        E = this.Protein2Peptide.keys();
        sharedProteinIDs = new ArrayList<E>();
        totalSisterClusterGroups = 0;
        totalClusterGroupProteins = 0;
        f = null;
        try {
            f = new FileWriter(this.proteinGroupFile, false);
            if (true) ** GOTO lbl25
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        do {
            if (this.FinalProteinList.contains(new Integer(currProteinID = ((Integer)E.nextElement()).intValue()))) continue;
            locusName = proteinName = ProteogenomicUtils.CleanUpProteinName(this.Proteome.getProteinName(currProteinID));
            if (this.Protein2GeneMap != null && this.Protein2GeneMap.containsKey(proteinName.toLowerCase())) {
                locusName = (String)this.Protein2GeneMap.get(proteinName.toLowerCase());
            } else {
                System.err.println("WARNING: Unable to find locus for " + proteinName.toLowerCase());
            }
            if (this.FinalLocusList.contains(locusName)) continue;
            Utils.InsertInAscendingOrder(sharedProteinIDs, currProteinID);
lbl25:
            // 4 sources

        } while (E.hasMoreElements());
        System.out.println("Total proteins shared: " + sharedProteinIDs.size());
        currClusterGroup = new ArrayList<Integer>();
        i = 0;
        while (i < sharedProteinIDs.size()) {
            currID = (Integer)sharedProteinIDs.get(i);
            proteinName = ProteogenomicUtils.CleanUpProteinName(this.Proteome.getProteinName(currID));
            currPeps = (ArrayList)this.Protein2Peptide.get(currID);
            currClusterGroup.clear();
            j = i + 1;
            while (j < sharedProteinIDs.size()) {
                nextID = (Integer)sharedProteinIDs.get(j);
                nextPeps = (ArrayList)this.Protein2Peptide.get(nextID);
                if (KnownProteinChooser.proteinsAreSisters(currPeps, nextPeps, this.SisterFrac)) {
                    currClusterGroup.add(nextID);
                }
                ++j;
            }
            if (currClusterGroup.size() + 1 >= KnownProteinChooser.MinClusterGroupSize) {
                if (localDebug) {
                    System.out.println("DEBUG: Found a cluster group of size: " + (currClusterGroup.size() + 1));
                }
                k = 0;
                while (k < currPeps.size()) {
                    prots = (ArrayList)this.Peptide2Protein.get((String)currPeps.get(k));
                    if (prots.size() == currClusterGroup.size() + 1) {
                        if (localDebug) {
                            System.out.println("DEBUG: Found a peptide unique to the group: " + (String)currPeps.get(k));
                        }
                        totalClusterGroupProteins += currClusterGroup.size();
                        try {
                            if (localDebug) {
                                System.out.println("SisterGroup:" + totalSisterClusterGroups + ",size: " + (currClusterGroup.size() + 1) + ",peptides:" + currPeps.size());
                            }
                            f.write("SisterGroup:" + totalSisterClusterGroups + ",size: " + (currClusterGroup.size() + 1) + ",peptides:" + currPeps.size() + "\n");
                            groupIndex = 0;
                            j = 0;
                            while (j < currPeps.size()) {
                                prots = (ArrayList)this.Peptide2Protein.get((String)currPeps.get(j));
                                if (localDebug) {
                                    System.out.println(String.valueOf(groupIndex) + "\t" + currID + "\t" + proteinName + "\t" + (String)currPeps.get(j) + "\t" + prots.size());
                                }
                                f.write(String.valueOf(groupIndex) + "\t" + proteinName + "\t" + (String)currPeps.get(j) + "\t" + prots.size() + "\n");
                                ++j;
                            }
                            groupIndex = 0;
                            while (groupIndex < currClusterGroup.size()) {
                                idx = (Integer)currClusterGroup.get(groupIndex);
                                proteinName = this.Proteome.getProteinName(idx);
                                nextPeps = (ArrayList)this.Protein2Peptide.get(idx);
                                j = 0;
                                while (j < nextPeps.size()) {
                                    prots = (ArrayList)this.Peptide2Protein.get((String)nextPeps.get(j));
                                    if (localDebug) {
                                        System.out.println(String.valueOf(groupIndex + 1) + "\t" + idx + "\t" + proteinName + "\t" + (String)nextPeps.get(j) + "\t" + prots.size());
                                    }
                                    f.write(String.valueOf(groupIndex + 1) + "\t" + proteinName + "\t" + (String)nextPeps.get(j) + "\t" + prots.size() + "\n");
                                    ++j;
                                }
                                ++groupIndex;
                            }
                            f.write("\n");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.exit(-1);
                        }
                        ++totalSisterClusterGroups;
                        g = currClusterGroup.size() - 1;
                        while (g >= 0) {
                            idx = (Integer)currClusterGroup.get(g);
                            if (localDebug) {
                                System.out.println("DEBUG: Removing protein ID: " + idx);
                            }
                            sharedProteinIDs.remove(idx);
                            --g;
                        }
                        if (!localDebug) break;
                        Utils.WaitForEnter();
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        System.out.println("Total cluster groups: " + totalSisterClusterGroups);
        System.out.println("Total proteins in clusterGroups: " + totalClusterGroupProteins);
        System.out.println("Min similarity to center cluster: " + this.SisterFrac);
        try {
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void writeFASTAFile() {
        System.out.println("Writing protein sequences to " + this.fastaFileName);
        FileWriter f = null;
        try {
            f = new FileWriter(this.fastaFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        int i = 0;
        while (i < this.FinalProteinList.size()) {
            int currProt = (Integer)this.FinalProteinList.get(i);
            String protName = ProteogenomicUtils.CleanUpProteinName(this.Proteome.getProteinName(currProt));
            String protSeq = this.Proteome.getProteinSequence(currProt);
            try {
                f.write(">" + protName + "\n" + protSeq + "\n");
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            ++i;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    private ArrayList getGroupProteins(int protID) {
        ArrayList<Integer> group = new ArrayList<Integer>();
        group.add(new Integer(protID));
        ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(protID);
        Enumeration E = this.Protein2Peptide.keys();
        while (E.hasMoreElements()) {
            Integer otherProtID = (int)((Integer)E.nextElement());
            ArrayList otherPeptides = (ArrayList)this.Protein2Peptide.get(otherProtID);
            if (!KnownProteinChooser.proteinsAreSisters(Peptides, otherPeptides)) continue;
            group.add(otherProtID);
        }
        return group;
    }

    private int countUnique(int protID) {
        int uniqueCount = 0;
        ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(protID);
        int i = 0;
        while (i < Peptides.size()) {
            String currPep = (String)Peptides.get(i);
            if (!this.Peptide2Protein.containsKey(currPep)) {
                System.out.println("EEK! We have no record of proteins from " + currPep + ", but we know it matches to " + protID);
                Utils.WaitForEnter();
            } else {
                ArrayList protList = (ArrayList)this.Peptide2Protein.get(currPep);
                if (protList == null || protList.size() == 0) {
                    System.out.println("EEK! Protein list is empty/null from " + currPep + ", but we know it matches to " + protID);
                    Utils.WaitForEnter();
                } else if (protList.size() == 1) {
                    ++uniqueCount;
                }
            }
            ++i;
        }
        return uniqueCount;
    }

    private boolean isSubSetProtein(int protID) {
        ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(protID);
        Enumeration E = this.Protein2Peptide.keys();
        HashSet currPeps = new HashSet(Peptides);
        while (E.hasMoreElements()) {
            ArrayList otherPeps;
            HashSet otherPepSet;
            int otherProteinID = (Integer)E.nextElement();
            if (otherProteinID == protID || !(otherPepSet = new HashSet(otherPeps = (ArrayList)this.Protein2Peptide.get(otherProteinID))).containsAll(currPeps) || currPeps.size() >= otherPepSet.size()) continue;
            return true;
        }
        return false;
    }

    private void ChooseProteinsUniquely() {
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        this.FinalLocusList = new ArrayList();
        this.FinalPeptide2Locus = new Hashtable();
        this.FinalLocus2Peptides = new Hashtable();
        Enumeration E = this.Protein2Peptide.keys();
        boolean MaxPeptides = false;
        int ProteinID = -1;
        while (E.hasMoreElements()) {
            String ProteinName;
            int CurrProteinID = (Integer)E.nextElement();
            int uniqueCount = 0;
            int locUniqueCount = 0;
            ArrayList<String> locUniquePeptides = new ArrayList<String>();
            ArrayList<String> uniquePeptides = new ArrayList<String>();
            ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
            int pep = 0;
            while (pep < Peptides.size()) {
                String currPep = (String)Peptides.get(pep);
                if (!this.Peptide2Protein.containsKey(currPep)) {
                    System.out.println("EEK! We have no record of proteins from " + currPep + ", but we know it matches to " + CurrProteinID);
                    Utils.WaitForEnter();
                } else {
                    ArrayList protList = (ArrayList)this.Peptide2Protein.get(currPep);
                    if (protList == null || protList.size() == 0) {
                        System.out.println("EEK! Protein list is empty/null from " + currPep + ", but we know it matches to " + CurrProteinID);
                        Utils.WaitForEnter();
                    } else {
                        ProteogenomicUtils.uniqueType t = (ProteogenomicUtils.uniqueType)((Object)this.Peptide2Type.get(currPep));
                        if (protList.size() == 1) {
                            ++uniqueCount;
                            uniquePeptides.add(currPep);
                        } else if (t == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                            ++locUniqueCount;
                            locUniquePeptides.add(currPep);
                        }
                    }
                }
                ++pep;
            }
            if (uniqueCount > 0) {
                this.FinalProteinList.add(new Integer(CurrProteinID));
                this.FinalProtein2Peptides.put(new Integer(CurrProteinID), uniquePeptides);
                this.FinalCoverage.put(new Integer(CurrProteinID), this.ComputeProteinCoverage(CurrProteinID, uniquePeptides));
                int i = 0;
                while (i < uniquePeptides.size()) {
                    ArrayList<Integer> ProtList = new ArrayList<Integer>();
                    ProtList.add(new Integer(CurrProteinID));
                    this.FinalPeptide2Protein.put((String)uniquePeptides.get(i), ProtList);
                    ++i;
                }
            }
            if (uniqueCount <= 0 && locUniqueCount <= 0) continue;
            String locusName = ProteinName = ProteogenomicUtils.CleanUpProteinName(this.Proteome.getProteinName(CurrProteinID));
            if (this.Protein2GeneMap != null && this.Protein2GeneMap.containsKey(ProteinName.toLowerCase())) {
                locusName = (String)this.Protein2GeneMap.get(ProteinName.toLowerCase());
            } else {
                System.err.println("WARNING: Unable to find locus for " + ProteinName.toLowerCase());
            }
            if (this.FinalLocusList.contains(locusName)) continue;
            this.FinalLocusList.add(locusName);
            locUniquePeptides.addAll(uniquePeptides);
            this.FinalLocus2Peptides.put(locusName, locUniquePeptides);
            int i = 0;
            while (i < locUniquePeptides.size()) {
                ArrayList<Integer> ProtList = new ArrayList<Integer>();
                ProtList.add(new Integer(CurrProteinID));
                this.FinalPeptide2Locus.put((String)locUniquePeptides.get(i), ProtList);
                ++i;
            }
        }
        System.out.println("Peptides: " + this.FinalPeptide2Locus.size());
        HashSet<String> lociiWithUniquePeptides = new HashSet<String>();
        int i = 0;
        while (i < this.FinalProteinList.size()) {
            String ProteinName;
            int protID = (Integer)this.FinalProteinList.get(i);
            String locusName = ProteinName = ProteogenomicUtils.CleanUpProteinName(this.Proteome.getProteinName(protID));
            if (this.Protein2GeneMap != null && this.Protein2GeneMap.containsKey(ProteinName.toLowerCase())) {
                locusName = (String)this.Protein2GeneMap.get(ProteinName.toLowerCase());
            } else {
                System.err.println("WARNING: Unable to find locus for " + ProteinName.toLowerCase());
            }
            lociiWithUniquePeptides.add(locusName);
            ++i;
        }
        System.out.println("Proteins: " + this.FinalProteinList.size() + " in " + lociiWithUniquePeptides.size() + " loci");
        System.out.println("Total Locii: " + this.FinalLocusList.size());
    }

    private void PlotDiscoveryCurve() {
        String title = "Peptide and ProteinDiscoveryCurve (" + Utils.GetVersion() + ")";
        ApplicationFrame F = new ApplicationFrame(title);
        XYSeries series1 = new XYSeries((Comparable)((Object)"Peptides"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Proteins"));
        XYSeries series3 = new XYSeries((Comparable)((Object)"Locii"));
        int cumCount = 0;
        int i = 0;
        while (i < this.DiscoveryCurveCounts.length) {
            series1.add((double)(cumCount += this.specCounts[i]), (double)this.DiscoveryCurveCounts[i]);
            series2.add((double)cumCount, (double)this.ProteinCounts[i]);
            if (this.Scheme == ChooseScheme.Unique) {
                series3.add((double)cumCount, (double)this.LocusCounts[i]);
            }
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        if (this.Scheme == ChooseScheme.Unique) {
            dataset.addSeries(series3);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)"Spectra", (String)"Counts", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(1, false);
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BufferedImage Image2 = chart.createBufferedImage(1000, 1000);
        String ScoreFileName = this.PlotFile;
        System.out.println("Created discovery curve..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
    }

    private void WriteOutput() {
        FileWriter f = null;
        FileWriter gF = null;
        try {
            f = new FileWriter(this.OutputFile);
            f.write("#ProteinName\tCoverage\tNumPeptides\tUniquePeptides\tSharedPeptides\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        ArrayList<String> Uniques = new ArrayList<String>();
        ArrayList<String> Nots = new ArrayList<String>();
        int i = 0;
        while (i < this.FinalProteinList.size()) {
            Integer ProteinID = (Integer)this.FinalProteinList.get(i);
            String ProteinName = ProteogenomicUtils.CleanUpProteinName(this.Proteome.getProteinName(ProteinID));
            Uniques.clear();
            Nots.clear();
            ArrayList Peps = (ArrayList)this.FinalProtein2Peptides.get(ProteinID);
            int k = 0;
            while (k < Peps.size()) {
                String CurrPep = (String)Peps.get(k);
                if (((ArrayList)this.FinalPeptide2Protein.get(CurrPep)).size() > 1) {
                    Nots.add(CurrPep);
                } else {
                    Uniques.add(CurrPep);
                }
                ++k;
            }
            try {
                f.write(String.valueOf(ProteinName) + "\t" + (Double)this.FinalCoverage.get(ProteinID) + "\t" + ((ArrayList)this.FinalProtein2Peptides.get(ProteinID)).size() + "\t" + Utils.JoinStringArray(Utils.ConvertArraylistToStringArray(Uniques), ",") + "\t" + Utils.JoinStringArray(Utils.ConvertArraylistToStringArray(Nots), ",") + "\n");
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        if (this.reportGenes) {
            try {
                gF = new FileWriter(this.OutputGeneFile);
                gF.write("#GeneName\tNumPeptides\tGeneUniquePeptides\tSharedPeptides\n");
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, this.OutputGeneFile);
            }
            i = 0;
            while (i < this.FinalLocusList.size()) {
                String geneName = (String)this.FinalLocusList.get(i);
                Uniques.clear();
                Nots.clear();
                ArrayList Peps = (ArrayList)this.FinalLocus2Peptides.get(geneName);
                int k = 0;
                while (k < Peps.size()) {
                    String CurrPep = (String)Peps.get(k);
                    if (((ArrayList)this.FinalPeptide2Locus.get(CurrPep)).size() > 1) {
                        Nots.add(CurrPep);
                    } else {
                        Uniques.add(CurrPep);
                    }
                    ++k;
                }
                try {
                    gF.write(String.valueOf(geneName) + "\t" + ((ArrayList)this.FinalLocus2Peptides.get(geneName)).size() + "\t" + Utils.JoinStringArray(Utils.ConvertArraylistToStringArray(Uniques), ",") + "\t" + Utils.JoinStringArray(Utils.ConvertArraylistToStringArray(Nots), ",") + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++i;
            }
            try {
                gF.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private void ChooseProteinsParsimony() {
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        while (this.Protein2Peptide.size() > 0) {
            Enumeration E = this.Protein2Peptide.keys();
            int MaxPeptides = 0;
            int ProteinID = -1;
            while (E.hasMoreElements()) {
                int CurrProteinID = (Integer)E.nextElement();
                ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
                if (Peptides.size() <= MaxPeptides) continue;
                MaxPeptides = Peptides.size();
                ProteinID = CurrProteinID;
            }
            if (MaxPeptides == 0) break;
            if (this.Debug) {
                System.out.println("Chose protein " + ProteinID + " with " + MaxPeptides + " peptides");
                System.out.println((String)this.Protein2Name.get(new Integer(ProteinID)));
            }
            ArrayList protGroup = this.getGroupProteins(ProteinID);
            protGroup.size();
            ArrayList ChosenPeps = (ArrayList)this.Protein2Peptide.remove(new Integer(ProteinID));
            this.FinalProtein2Peptides.put(new Integer(ProteinID), ChosenPeps);
            this.FinalProteinList.add(new Integer(ProteinID));
            this.FinalCoverage.put(new Integer(ProteinID), this.ComputeProteinCoverage(ProteinID, ChosenPeps));
            ArrayList<Integer> ProtList = new ArrayList<Integer>();
            ProtList.add(new Integer(ProteinID));
            int i = 0;
            while (i < ChosenPeps.size()) {
                this.FinalPeptide2Protein.put((String)ChosenPeps.get(i), ProtList);
                ArrayList OtherProteins = (ArrayList)this.Peptide2Protein.get((String)ChosenPeps.get(i));
                int j = 0;
                while (j < OtherProteins.size()) {
                    Integer OtherProteinID = (Integer)OtherProteins.get(j);
                    if (!this.FinalProteinList.contains(OtherProteinID)) {
                        ArrayList OtherProteinPeps = (ArrayList)this.Protein2Peptide.get(OtherProteinID);
                        OtherProteinPeps.remove((String)ChosenPeps.get(i));
                        this.Protein2Peptide.put(OtherProteinID, OtherProteinPeps);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void ChooseProteinsScore() {
        boolean LocalDebug = false;
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        Enumeration E = this.Protein2Peptide.keys();
        boolean MaxPeptides = false;
        while (E.hasMoreElements()) {
            int CurrProteinID = (Integer)E.nextElement();
            ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
            double Prob = this.ComputeProb(Peptides);
            if (LocalDebug) {
                String Name = (String)this.Protein2Name.get(new Integer(CurrProteinID));
                System.out.println("Considering protein " + Name + " : " + Prob);
            }
            if (!(Prob >= this.MinProb)) continue;
            this.FinalProteinList.add(new Integer(CurrProteinID));
            this.FinalProtein2Peptides.put(new Integer(CurrProteinID), Peptides);
            this.FinalCoverage.put(new Integer(CurrProteinID), this.ComputeProteinCoverage(CurrProteinID, Peptides));
            int i = 0;
            while (i < Peptides.size()) {
                ArrayList ProtList = this.FinalPeptide2Protein.containsKey((String)Peptides.get(i)) ? (ArrayList)this.FinalPeptide2Protein.get((String)Peptides.get(i)) : new ArrayList();
                ProtList.add(new Integer(CurrProteinID));
                this.FinalPeptide2Protein.put((String)Peptides.get(i), ProtList);
                ++i;
            }
        }
    }

    private double ComputeProb(ArrayList Peptides) {
        double Ret = 1.0;
        int i = 0;
        while (i < Peptides.size()) {
            double LocationCount = ((ArrayList)this.Peptide2Protein.get((String)Peptides.get(i))).size();
            double LocalFDR = (Double)this.Peptide2BestLFDR.get((String)Peptides.get(i));
            Ret *= 1.0 - (1.0 - LocalFDR) / LocationCount;
            ++i;
        }
        return 1.0 - Ret;
    }

    public void ChooseProteinsMaximony() {
        this.FinalProteinList = new ArrayList();
        this.FinalPeptide2Protein = new Hashtable();
        this.FinalProtein2Peptides = new Hashtable();
        this.FinalCoverage = new Hashtable();
        Enumeration E = this.Protein2Peptide.keys();
        while (E.hasMoreElements()) {
            int CurrProteinID = (Integer)E.nextElement();
            ArrayList Peptides = (ArrayList)this.Protein2Peptide.get(CurrProteinID);
            if (Peptides.size() < this.MinPep) continue;
            if (this.Debug) {
                System.out.println("Chose protein " + CurrProteinID + " with " + Peptides.size() + " peptides");
                System.out.println((String)this.Protein2Name.get(new Integer(CurrProteinID)));
            }
            this.FinalProtein2Peptides.put(new Integer(CurrProteinID), Peptides);
            this.FinalProteinList.add(new Integer(CurrProteinID));
            this.FinalProtein2Peptides.put(new Integer(CurrProteinID), Peptides);
            this.FinalCoverage.put(new Integer(CurrProteinID), new Double(this.ComputeProteinCoverage(CurrProteinID, Peptides)));
            int i = 0;
            while (i < Peptides.size()) {
                ArrayList ProtList = this.FinalPeptide2Protein.containsKey((String)Peptides.get(i)) ? (ArrayList)this.FinalPeptide2Protein.get((String)Peptides.get(i)) : new ArrayList();
                ProtList.add(new Integer(CurrProteinID));
                this.FinalPeptide2Protein.put((String)Peptides.get(i), ProtList);
                ++i;
            }
        }
    }

    private double ComputeProteinCoverage(int ProteinID, ArrayList Peptides) {
        String CurrProtein = this.Proteome.getProteinSequence(ProteinID);
        boolean[] Covered = new boolean[CurrProtein.length()];
        double CoveredCount = 0.0;
        int i = 0;
        while (i < Peptides.size()) {
            int Index;
            String CurrPeptide = (String)Peptides.get(i);
            int j = Index = CurrProtein.indexOf(CurrPeptide);
            while (j < Index + CurrPeptide.length()) {
                if (!Covered[j]) {
                    CoveredCount += 1.0;
                }
                Covered[j] = true;
                ++j;
            }
            ++i;
        }
        return CoveredCount / (double)Covered.length;
    }

    public void PopulateHashes() {
        this.Protein2Name = new Hashtable();
        this.Protein2Peptide = new Hashtable();
        this.Peptide2Protein = new Hashtable();
        this.Peptide2Type = new Hashtable();
        if (this.PlotFile != null) {
            if (this.Scheme == ChooseScheme.Parsimony) {
                System.out.println("WARNING: Unable to draw protein discovery curve in Parsimony mode, drawing in Maximony mode instead");
                this.Scheme = ChooseScheme.Maximony;
            }
            this.DiscoveryCurveCounts = new int[this.InputFiles.length];
            this.specCounts = new int[this.InputFiles.length];
            this.ProteinCounts = new int[this.InputFiles.length];
            this.LocusCounts = new int[this.InputFiles.length];
        }
        ArrayList<String> CurrPeptides = new ArrayList<String>();
        if (this.Scheme == ChooseScheme.Unique) {
            this.Peptide2BestLFDR = new Hashtable();
        }
        this.InputFiles = (String[])Utils.SortIncreasingOrder((Comparable[])this.InputFiles);
        int i = 0;
        while (i < this.InputFiles.length) {
            String CurrPeptide;
            if (this.PlotFile != null) {
                this.specCounts[i] = this.InputFiles[i].indexOf("Maize-Endosperm-10DAP_Clustered.20.fil") >= 0 ? 20826 : (this.InputFiles[i].indexOf("Maize-Endosperm-10DAP") >= 0 || this.InputFiles[i].indexOf("Maize-Endosperm-12DAP") >= 0 ? 40000 : 20000);
                System.out.println("Loading peptides from " + this.InputFiles[i] + ", " + this.specCounts[i] + " spectra");
            } else {
                System.out.println("Loading peptides from " + this.InputFiles[i]);
            }
            InspectAnnotation[] Anns = InspectAnnotation.LoadInspectResultsFile(this.InputFiles[i]);
            int j = 0;
            while (j < Anns.length) {
                CurrPeptide = Utils.GetUnModded(Anns[j].Annotation);
                if (this.Peptide2BestLFDR != null) {
                    if (!this.Peptide2BestLFDR.containsKey(CurrPeptide)) {
                        this.Peptide2BestLFDR.put(CurrPeptide, new Double(Anns[j].LocalFDR));
                    } else {
                        double OldVal = (Double)this.Peptide2BestLFDR.get(CurrPeptide);
                        if (Anns[j].LocalFDR < OldVal) {
                            this.Peptide2BestLFDR.put(CurrPeptide, new Double(Anns[j].LocalFDR));
                        }
                    }
                }
                if (!this.Peptide2Protein.containsKey(CurrPeptide) && !CurrPeptides.contains(CurrPeptide)) {
                    CurrPeptides.add(CurrPeptide);
                    if (CurrPeptides.size() >= 5000) {
                        if (this.Debug) {
                            System.out.println("Loaded " + CurrPeptides.size() + " peptides 2 search");
                        }
                        Hashtable AllLocations = this.Proteome.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
                        int p = 0;
                        while (p < CurrPeptides.size()) {
                            CurrPeptide = (String)CurrPeptides.get(p);
                            ArrayList<Integer> P = new ArrayList<Integer>();
                            ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                            ProteogenomicUtils.uniqueType t = ProteogenomicUtils.getUniquenessType(Locations, this.Protein2GeneMap);
                            if (Locations == null || Locations.size() == 0) {
                                System.out.println("WARNING: Peptide '" + CurrPeptide + "' does not have any locations!");
                            } else {
                                int k = 0;
                                while (k < Locations.size()) {
                                    Object[] Loc = (Object[])Locations.get(k);
                                    Integer ProteinID = (Integer)Loc[1];
                                    String pName = ProteogenomicUtils.CleanUpProteinName((String)Loc[3]);
                                    if (!this.Protein2Name.containsKey(ProteinID)) {
                                        this.Protein2Name.put(ProteinID, pName);
                                    }
                                    ArrayList L = null;
                                    L = this.Protein2Peptide.containsKey(ProteinID) ? (ArrayList)this.Protein2Peptide.get(ProteinID) : new ArrayList();
                                    L.add(CurrPeptide);
                                    this.Protein2Peptide.put(ProteinID, L);
                                    P.add(ProteinID);
                                    ++k;
                                }
                                this.Peptide2Protein.put(CurrPeptide, P);
                                this.Peptide2Type.put(CurrPeptide, t);
                            }
                            ++p;
                        }
                        CurrPeptides.clear();
                    }
                }
                ++j;
            }
            if (this.PlotFile != null && CurrPeptides.size() > 0) {
                if (this.Debug) {
                    System.out.println("Loaded " + CurrPeptides.size() + " peptides 2 search");
                }
                Hashtable AllLocations = this.Proteome.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
                int p = 0;
                while (p < CurrPeptides.size()) {
                    CurrPeptide = (String)CurrPeptides.get(p);
                    ArrayList<Integer> P = new ArrayList<Integer>();
                    ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                    ProteogenomicUtils.uniqueType t = ProteogenomicUtils.getUniquenessType(Locations, this.Protein2GeneMap);
                    int k = 0;
                    while (k < Locations.size()) {
                        Object[] Loc = (Object[])Locations.get(k);
                        Integer ProteinID = (Integer)Loc[1];
                        if (!this.Protein2Name.containsKey(ProteinID)) {
                            this.Protein2Name.put(ProteinID, (String)Loc[3]);
                        }
                        ArrayList L = null;
                        L = this.Protein2Peptide.containsKey(ProteinID) ? (ArrayList)this.Protein2Peptide.get(ProteinID) : new ArrayList();
                        L.add(CurrPeptide);
                        this.Protein2Peptide.put(ProteinID, L);
                        P.add(ProteinID);
                        ++k;
                    }
                    this.Peptide2Protein.put(CurrPeptide, P);
                    this.Peptide2Type.put(CurrPeptide, t);
                    ++p;
                }
                CurrPeptides.clear();
                System.out.println("Choosing proteins from " + this.Peptide2Protein.size() + " peptides");
                this.DiscoveryCurveCounts[i] = this.Peptide2Protein.size();
                if (this.Scheme == ChooseScheme.Unique) {
                    this.ChooseProteinsUniquely();
                } else if (this.Scheme == ChooseScheme.Maximony) {
                    this.ChooseProteinsMaximony();
                } else if (this.Scheme == ChooseScheme.Score) {
                    this.ChooseProteinsScore();
                } else {
                    System.err.println("ERROR: Unable to plot discovery curve in Parsimony  mode!!");
                    System.exit(-1);
                }
                this.ProteinCounts[i] = this.FinalProteinList.size();
                if (this.Scheme == ChooseScheme.Unique) {
                    this.LocusCounts[i] = this.FinalLocusList.size();
                }
                System.out.println(String.valueOf(this.DiscoveryCurveCounts[i]) + " " + this.ProteinCounts[i]);
            } else if (this.PlotFile != null) {
                System.out.println("Choosing proteins from " + this.Peptide2Protein.size() + " peptides");
                this.DiscoveryCurveCounts[i] = this.Peptide2Protein.size();
                this.ProteinCounts[i] = this.FinalProteinList.size();
                if (this.Scheme == ChooseScheme.Unique) {
                    this.LocusCounts[i] = this.FinalLocusList.size();
                    System.out.println(String.valueOf(this.DiscoveryCurveCounts[i]) + " " + this.ProteinCounts[i] + " " + this.LocusCounts[i]);
                } else {
                    System.out.println(String.valueOf(this.DiscoveryCurveCounts[i]) + " " + this.ProteinCounts[i]);
                }
            }
            ++i;
        }
        if (CurrPeptides.size() > 0) {
            if (this.Debug) {
                System.out.println("Have " + CurrPeptides.size() + " left over peptides to search!!");
            }
            Hashtable AllLocations = this.Proteome.GetAllLocations(Utils.ConvertArraylistToStringArray(CurrPeptides));
            int p = 0;
            while (p < CurrPeptides.size()) {
                String CurrPeptide = (String)CurrPeptides.get(p);
                ArrayList<Integer> P = new ArrayList<Integer>();
                ArrayList Locations = (ArrayList)AllLocations.get(CurrPeptide);
                ProteogenomicUtils.uniqueType t = ProteogenomicUtils.getUniquenessType(Locations, this.Protein2GeneMap);
                if (Locations == null || Locations.size() == 0) {
                    System.out.println("WARNING: Peptide '" + CurrPeptide + "' does not have any locations!");
                } else {
                    int k = 0;
                    while (k < Locations.size()) {
                        Object[] Loc = (Object[])Locations.get(k);
                        Integer ProteinID = (Integer)Loc[1];
                        if (!this.Protein2Name.containsKey(ProteinID)) {
                            this.Protein2Name.put(ProteinID, (String)Loc[3]);
                        }
                        ArrayList L = null;
                        L = this.Protein2Peptide.containsKey(ProteinID) ? (ArrayList)this.Protein2Peptide.get(ProteinID) : new ArrayList();
                        L.add(CurrPeptide);
                        this.Protein2Peptide.put(ProteinID, L);
                        P.add(ProteinID);
                        ++k;
                    }
                    this.Peptide2Protein.put(CurrPeptide, P);
                    this.Peptide2Type.put(CurrPeptide, t);
                }
                ++p;
            }
            CurrPeptides.clear();
        }
        Enumeration e = this.Peptide2Protein.keys();
        int[] counts = new int[100];
        counts = Utils.initializeIntArray(counts, 0);
        while (e.hasMoreElements()) {
            String peptide = (String)e.nextElement();
            ArrayList locs = (ArrayList)this.Peptide2Protein.get(peptide);
            if (locs.size() >= counts.length) {
                int n = counts.length - 1;
                counts[n] = counts[n] + 1;
                System.out.println("Found peptide " + peptide + " with " + locs.size() + " locations!!");
                continue;
            }
            int n = locs.size();
            counts[n] = counts[n] + 1;
        }
        int i2 = 0;
        while (i2 < counts.length - 1) {
            System.out.println("Peptides with " + i2 + " locations: " + counts[i2]);
            ++i2;
        }
        System.out.println("Peptides with " + (counts.length - 1) + "+ locations: " + counts[counts.length - 1]);
    }

    public static Hashtable[] ChooseProteinsParsimonyExternal(String[] inputFiles, TrieDB proteome) {
        KnownProteinChooser chooser = new KnownProteinChooser(inputFiles, proteome);
        chooser.PopulateHashes();
        chooser.ChooseProteinsParsimony();
        Hashtable[] ret = new Hashtable[]{chooser.FinalPeptide2Protein, chooser.FinalProtein2Peptides};
        return ret;
    }

    public static void main(String[] args) {
        String Proteome;
        String InputDir;
        String[] options = new String[]{"-r", "-w", "-c", "-m", "-s", "-d", "-t", "-p", "-g", "-f", "-q", "-y", "-u", "-i", "-a", "-j", "-n"};
        boolean[] blArray = new boolean[17];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-c") && CommandLineArgs.containsKey("-t"))) {
            System.err.println("ERROR: Must specify an input file/directory, a proteome file, and a choosing scheme!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        if (!Utils.IsFile(InputDir = (String)CommandLineArgs.get("-r")) && !Utils.IsDir(InputDir)) {
            System.err.println("ERROR: Invalid file/directory path '" + InputDir + "'!");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        String OutputDir = null;
        if (CommandLineArgs.containsKey("-w")) {
            OutputDir = (String)CommandLineArgs.get("-w");
        }
        String PlotFile = null;
        if (CommandLineArgs.containsKey("-p")) {
            PlotFile = (String)CommandLineArgs.get("-p");
        }
        if (!Utils.IsFile(Proteome = (String)CommandLineArgs.get("-t"))) {
            System.err.println("ERROR: Invalid proteome file '" + Proteome + "'\n");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        String reportGenesFile = null;
        if (CommandLineArgs.containsKey("-g")) {
            reportGenesFile = (String)CommandLineArgs.get("-g");
        }
        int Scheme = Integer.parseInt((String)CommandLineArgs.get("-c"));
        String fastaFile = null;
        if (CommandLineArgs.containsKey("-f")) {
            fastaFile = (String)CommandLineArgs.get("-f");
        }
        String proteinGroupFile = null;
        if (CommandLineArgs.containsKey("-q")) {
            proteinGroupFile = (String)CommandLineArgs.get("-q");
        }
        KnownProteinChooser chooser = null;
        if (Scheme == 0) {
            chooser = new KnownProteinChooser(InputDir, OutputDir, ChooseScheme.Parsimony, PlotFile, Proteome, 0, 0.0, reportGenesFile, fastaFile, proteinGroupFile);
        } else if (Scheme == 1) {
            int PepCount;
            if (!CommandLineArgs.containsKey("-m") || !CommandLineArgs.containsKey("-t")) {
                System.err.println("ERROR: Must specify peptide/protein with -m option and proteome file with -t option to use Maximony scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            if ((PepCount = Integer.parseInt((String)CommandLineArgs.get("-m"))) <= 0) {
                System.err.println("ERROR: Must specify peptide/protein > 0 with -m option to use Maximony scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            chooser = new KnownProteinChooser(InputDir, OutputDir, ChooseScheme.Maximony, PlotFile, Proteome, PepCount, 0.0, reportGenesFile, fastaFile, proteinGroupFile);
        } else if (Scheme == 2) {
            double MinProb;
            if (!CommandLineArgs.containsKey("-s")) {
                System.err.println("ERROR: Must specify protein probability with -s option to use Score-based scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            if ((MinProb = Double.parseDouble((String)CommandLineArgs.get("-s"))) < 0.0 || MinProb > 1.0) {
                System.err.println("ERROR: Must specify valid protein probability  with -s option to use MScore-based scheme\n");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            chooser = new KnownProteinChooser(InputDir, OutputDir, ChooseScheme.Score, PlotFile, Proteome, 0, MinProb, reportGenesFile, fastaFile, proteinGroupFile);
        } else if (Scheme == 3) {
            chooser = new KnownProteinChooser(InputDir, OutputDir, ChooseScheme.Unique, PlotFile, Proteome, 0, 0.0, reportGenesFile, fastaFile, proteinGroupFile);
        }
        if (CommandLineArgs.containsKey("-d")) {
            chooser.Debug = true;
        }
        if (CommandLineArgs.containsKey("-y")) {
            int maxLocs = Integer.parseInt((String)CommandLineArgs.get("-y"));
            if (maxLocs <= 0) {
                System.err.println("ERROR: Invalid max number of peptide locations '" + maxLocs + "'.  Please choose a number larger than 1");
                System.exit(-1);
            }
            chooser.MaxPeptideLocs = maxLocs;
        }
        if (CommandLineArgs.containsKey("-u")) {
            double frac = Double.parseDouble((String)CommandLineArgs.get("-u"));
            if (frac <= 0.0 || frac > 1.0) {
                System.err.println("ERROR: Invalid fraction '" + frac + "'.  Please choose a number between 0 and 1");
                System.exit(-1);
            }
            chooser.SisterFrac = frac;
        }
        if (CommandLineArgs.containsKey("-a")) {
            chooser.conversionFileName = (String)CommandLineArgs.get("-a");
        }
        if (CommandLineArgs.containsKey("-j")) {
            chooser.protColNum = Integer.parseInt((String)CommandLineArgs.get("-j"));
        }
        if (CommandLineArgs.containsKey("-n")) {
            chooser.geneColNum = Integer.parseInt((String)CommandLineArgs.get("-n"));
        }
        chooser.ChooseWisely();
    }

    public static enum ChooseScheme {
        Parsimony,
        Maximony,
        Score,
        Unique;

    }
}

