/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class MutationSearchAnalyzer {
    public static String UsageInfo = "proteogenomicUtils.MutationSearchAnalyzer version 08.10.2010\nAggregates information from MSAlignment searches against a related organism database, the Blast\nresults of the related organism to the target organism, and their sequences\nREQUIRED:\n-r [FILE/DIR] File or directory containing MSAlignment search results (after PValue.py)\n-b [FILE] File containing blastp and tblastn results for each related protein searched\n-d [FILE] Database file (.trie) file searched (without shuffled proteins)\n-t [FILE] Database file (.trie) of target proteome\nOPTIONAL:\n-v Run in verbose mode\n";
    private String[] InputFiles = null;
    private String BlastFile = null;
    private TrieDB TargetProteome = null;
    private TrieDB OtherProteome = null;
    public boolean Debug = false;
    private Hashtable OtherProteinResults = null;
    private Hashtable OtherToTargetProtein = null;

    public MutationSearchAnalyzer(String InputInfo, String BlastFile, String TargetProteome, String OtherProteome) {
        if (Utils.IsDir(InputInfo)) {
            this.InputFiles = Utils.ListDir(InputInfo);
        } else {
            this.InputFiles = new String[1];
            this.InputFiles[0] = InputInfo;
        }
        this.BlastFile = BlastFile;
        this.TargetProteome = new TrieDB(TargetProteome);
        this.OtherProteome = new TrieDB(OtherProteome);
    }

    private void Run() {
        this.LoadAllInspectResults();
        this.LoadOther2TargetProteins();
        Enumeration proteinNames = this.OtherProteinResults.keys();
        while (proteinNames.hasMoreElements()) {
            String CurrProtein = (String)proteinNames.nextElement();
            Object[] InspectVals = (Object[])this.OtherProteinResults.get(CurrProtein);
            Object[] BlastVals = (Object[])this.OtherToTargetProtein.get(CurrProtein);
            System.out.println("**Considering protein " + CurrProtein);
            System.out.println("Total Peptides: " + ((ArrayList)InspectVals[0]).size() + ", Total Spectra: " + (Integer)InspectVals[1]);
            int i = 0;
            while (i < ((ArrayList)InspectVals[0]).size()) {
                System.out.println("[" + i + "]: " + ((ArrayList)InspectVals[0]).get(i));
                ++i;
            }
            int CurrProteinID = this.OtherProteome.getProteinIDFromPartial(CurrProtein);
            System.out.println(this.OtherProteome.getProteinSequence(CurrProteinID));
            System.out.println("*Best genome match %ID=" + BlastVals[3] + ", Coverage=" + BlastVals[4]);
            System.out.println("*Best protein match: " + BlastVals[0] + ", %ID=" + BlastVals[1] + ", Coverage=" + BlastVals[2]);
            int TargetProteinID = this.TargetProteome.getProteinIDFromPartial((String)BlastVals[0]);
            System.out.println(this.TargetProteome.getProteinSequence(TargetProteinID));
            if (!this.Debug) continue;
            Utils.WaitForEnter();
        }
    }

    private void LoadAllInspectResults() {
        this.OtherProteinResults = new Hashtable();
        int i = 0;
        while (i < this.InputFiles.length) {
            Hashtable CurrAnns = InspectAnnotation.LoadIntoProteinHashtable(this.InputFiles[i]);
            if (this.Debug) {
                System.out.println("Loaded info for " + CurrAnns.size() + " proteins from " + this.InputFiles[i]);
            }
            Enumeration e = CurrAnns.keys();
            while (e.hasMoreElements()) {
                String CurrProtein = (String)e.nextElement();
                if (!this.OtherProteinResults.containsKey(CurrProtein)) {
                    this.OtherProteinResults.put(CurrProtein, (Object[])CurrAnns.get(CurrProtein));
                    continue;
                }
                Object[] OldResults = (Object[])this.OtherProteinResults.get(CurrProtein);
                Object[] NewResults = (Object[])CurrAnns.get(CurrProtein);
                int j = 0;
                while (j < ((ArrayList)NewResults[0]).size()) {
                    String CurrPeptide = (String)((ArrayList)NewResults[0]).get(j);
                    if (!((ArrayList)OldResults[0]).contains(CurrPeptide)) {
                        ((ArrayList)OldResults[0]).add(CurrPeptide);
                    }
                    ++j;
                }
                int NewSpecCount = (Integer)OldResults[1] + (Integer)NewResults[1];
                OldResults[1] = new Integer(NewSpecCount);
                this.OtherProteinResults.put(CurrProtein, OldResults);
            }
            ++i;
        }
        if (this.Debug) {
            System.out.println("Loaded info for " + this.OtherProteinResults.size() + " proteins total");
        }
    }

    private void LoadOther2TargetProteins() {
        this.OtherToTargetProtein = new Hashtable();
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(this.BlastFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            if (this.OtherToTargetProtein.containsKey(Bits[0])) {
                System.out.println("ERROR: We already saw an entry for this protein '" + Bits[0] + "'!!!");
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            Object[] Value = new Object[]{Bits[2], Bits[3], Bits[4], Bits[5], Bits[6]};
            this.OtherToTargetProtein.put(Bits[0], Value);
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-b", "-d", "-t", "-v"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-b") && CommandLineArgs.containsKey("-d") && CommandLineArgs.containsKey("-t"))) {
            System.err.println("ERROR: Missing arguments!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        String InputInfo = (String)CommandLineArgs.get("-r");
        String BlastFile = (String)CommandLineArgs.get("-b");
        String OtherProteinFile = (String)CommandLineArgs.get("-d");
        String TargetProteinFile = (String)CommandLineArgs.get("-t");
        if (!Utils.IsFile(InputInfo) && !Utils.IsDir(InputInfo)) {
            System.err.println("ERROR: Invalid input file or directory name '" + InputInfo + "'!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        if (!Utils.IsFile(TargetProteinFile)) {
            System.err.println("ERROR: Invalid target protein file name '" + TargetProteinFile + "'!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        if (!Utils.IsFile(OtherProteinFile)) {
            System.err.println("ERROR: Invalid related organism protein file name '" + OtherProteinFile + "'!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        if (!Utils.IsFile(BlastFile)) {
            System.err.println("ERROR: Invalid blast file name '" + BlastFile + "'!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        MutationSearchAnalyzer a = new MutationSearchAnalyzer(InputInfo, BlastFile, TargetProteinFile, OtherProteinFile);
        if (CommandLineArgs.containsKey("-v")) {
            a.Debug = true;
        }
        a.Run();
    }
}

