/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import proteogenomicUtils.GenomicLocator;
import trieUtils.TrieDB;

public class NovelPeptideVerifier {
    public static String usageInfo = "proteogenomicUtils.NovelPeptideVerifier version 2011.11.14\nThis class is used to verify that peptides are novel.  In looks for mutations or modifications\nwhich would cause the peptide to no longer be novel (e.g. I->L, N->D for deamidation, and Q->K)\nUsage: java -jar NovelPeptideVerifier \n -r [DIR/FILE] File or directory containing novel peptides or locations\n -w [DIR/FILE] File or directory to write novel peptides to\n -t [FILE] Trie file containing known proteome\n(-p [0/1] The type of file containing novel peptides (0: inspect results (default), 1: locations))\n(-q            Run in a loose mode (also include W->AD))\n(-d            Run in debug mode\n";
    private boolean debugFlag = false;
    private boolean looseFlag = false;
    private boolean isLocationFormat = false;
    private String[] inputFiles;
    private String[] outputFiles;
    private TrieDB proteomeFile;

    public NovelPeptideVerifier(String inputDir, String outputDir, String proteomeFile) {
        if (Utils.IsFile(inputDir)) {
            this.inputFiles = new String[1];
            this.inputFiles[0] = inputDir;
            if (Utils.IsFile(outputDir)) {
                this.outputFiles = new String[1];
                this.outputFiles[0] = outputDir;
            } else if (Utils.IsDir(outputDir)) {
                this.outputFiles = new String[1];
                this.outputFiles[0] = String.valueOf(outputDir) + File.separator + Utils.GetBaseName(this.inputFiles[0]);
            } else {
                Utils.MakeDir(outputDir);
                this.outputFiles = new String[1];
                this.outputFiles[0] = String.valueOf(outputDir) + File.separator + Utils.GetBaseName(this.inputFiles[0]);
            }
        } else if (Utils.IsDir(inputDir)) {
            this.inputFiles = Utils.ListDir(inputDir);
            if (Utils.IsFile(outputDir)) {
                System.err.println("ERROR: Cannot write results from many files to one file.  Please specify an output directory");
                System.exit(-1);
            } else if (Utils.IsDir(outputDir)) {
                this.outputFiles = new String[this.inputFiles.length];
                int i = 0;
                while (i < this.outputFiles.length) {
                    this.outputFiles[i] = String.valueOf(outputDir) + File.separator + Utils.GetBaseName(this.inputFiles[i]);
                    ++i;
                }
            } else {
                Utils.MakeDir(outputDir);
                this.outputFiles = new String[this.inputFiles.length];
                int i = 0;
                while (i < this.outputFiles.length) {
                    this.outputFiles[i] = String.valueOf(outputDir) + File.separator + Utils.GetBaseName(this.inputFiles[i]);
                    ++i;
                }
            }
        } else {
            System.err.println("ERROR: Cannot find file or directory '" + inputDir + "'!");
            System.exit(-1);
        }
        if (!Utils.IsFile(proteomeFile)) {
            System.err.println("ERROR: Cannot find proteome file '" + proteomeFile + "'!");
            System.exit(-1);
        }
        this.proteomeFile = new TrieDB(proteomeFile);
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-q", "-d", "-t", "-p"};
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[4] = true;
        blArray[5] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-t"))) {
            System.err.println("ERROR: Must specify an input file/directory, a proteome file, and an output file/directory");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputDir = (String)CommandLineArgs.get("-r");
        String outputDir = (String)CommandLineArgs.get("-w");
        String proteomeFile = (String)CommandLineArgs.get("-t");
        NovelPeptideVerifier v = new NovelPeptideVerifier(inputDir, outputDir, proteomeFile);
        if (CommandLineArgs.containsKey("-d")) {
            v.debugFlag = true;
        }
        if (CommandLineArgs.containsKey("-q")) {
            v.looseFlag = true;
        }
        if (CommandLineArgs.containsKey("-p")) {
            int val = Integer.parseInt((String)CommandLineArgs.get("-p"));
            if (val == 0) {
                v.isLocationFormat = false;
            } else if (val == 1) {
                v.isLocationFormat = true;
            } else {
                System.err.println("ERROR: Invalid file format type '" + val + "'.  Must be 0 or 1\n");
                System.exit(-1);
            }
        }
        v.verify();
    }

    private String[] generatePeptideMods(String origPeptide) {
        ArrayList<String> candidates = new ArrayList<String>();
        String cleanPep = Utils.GetUnModded(origPeptide).toUpperCase();
        int i = 0;
        while (i < cleanPep.length()) {
            String newString;
            if (cleanPep.charAt(i) == 'I') {
                newString = String.valueOf(cleanPep.substring(0, i)) + "L" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
            } else if (cleanPep.charAt(i) == 'L') {
                newString = String.valueOf(cleanPep.substring(0, i)) + "I" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
            } else if (cleanPep.charAt(i) == 'Q') {
                newString = String.valueOf(cleanPep.substring(0, i)) + "K" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
            } else if (cleanPep.charAt(i) == 'K') {
                newString = String.valueOf(cleanPep.substring(0, i)) + "Q" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
            } else if (cleanPep.charAt(i) == 'N') {
                newString = String.valueOf(cleanPep.substring(0, i)) + "D" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
            } else if (cleanPep.charAt(i) == 'D') {
                newString = String.valueOf(cleanPep.substring(0, i)) + "N" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
            } else if (cleanPep.charAt(i) == 'W' && this.looseFlag) {
                newString = String.valueOf(cleanPep.substring(0, i)) + "AD" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
                newString = String.valueOf(cleanPep.substring(0, i)) + "DA" + cleanPep.substring(i + 1);
                if (this.debugFlag) {
                    System.out.println(newString);
                }
                candidates.add(newString);
            }
            ++i;
        }
        if (this.debugFlag) {
            System.out.println("Generated " + candidates.size() + " candidates from '" + origPeptide + "'");
        }
        return Utils.ConvertArraylistToStringArray(candidates);
    }

    private boolean hasKnownProteinCandidate(String origPeptide) {
        String[] pepCandidates = this.generatePeptideMods(origPeptide);
        Hashtable locs = this.proteomeFile.GetAllLocations(pepCandidates);
        int i = 0;
        while (i < pepCandidates.length) {
            ArrayList currLocs;
            if (locs.containsKey(pepCandidates[i]) && (currLocs = (ArrayList)locs.get(pepCandidates[i])).size() > 0) {
                if (this.debugFlag) {
                    System.out.println("Found match from '" + origPeptide + "->" + pepCandidates[i] + " in a protein!");
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private void verify() {
        int peptidesKnown = 0;
        int peptidesNovel = 0;
        int locsKnown = 0;
        int locsNovel = 0;
        FileWriter f = null;
        int i = 0;
        while (i < this.inputFiles.length) {
            block26: {
                if (!Utils.IsFile(this.outputFiles[i])) {
                    int j;
                    InspectAnnotation[] els;
                    System.out.println("Verifying file: " + this.inputFiles[i]);
                    try {
                        f = new FileWriter(this.outputFiles[i]);
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        break block26;
                    }
                    Hashtable<String, Integer> pepsSeen = new Hashtable<String, Integer>();
                    if (this.isLocationFormat) {
                        els = GenomicLocator.GenomicColumns.LoadFromFile(this.inputFiles[i]);
                        j = 0;
                        while (j < els.size()) {
                            int val;
                            Object[] currLoc = (Object[])els.get(j);
                            String peptide = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                            if (!pepsSeen.containsKey(peptide)) {
                                if (this.hasKnownProteinCandidate(peptide)) {
                                    pepsSeen.put(peptide, new Integer(1));
                                    ++peptidesKnown;
                                } else {
                                    pepsSeen.put(peptide, new Integer(0));
                                    ++peptidesNovel;
                                }
                            }
                            if ((val = ((Integer)pepsSeen.get(peptide)).intValue()) == 0) {
                                ++locsNovel;
                                try {
                                    f.write(String.valueOf(GenomicLocator.GenomicColumns.toString(currLoc, "\t")) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                }
                            } else {
                                ++locsKnown;
                            }
                            ++j;
                        }
                    } else {
                        els = InspectAnnotation.LoadInspectResultsFile(this.inputFiles[i]);
                        j = 0;
                        while (j < els.length) {
                            int val;
                            String peptide = els[j].Annotation;
                            if (!pepsSeen.containsKey(peptide)) {
                                if (this.hasKnownProteinCandidate(peptide)) {
                                    pepsSeen.put(peptide, new Integer(1));
                                    ++peptidesKnown;
                                } else {
                                    pepsSeen.put(peptide, new Integer(0));
                                    ++peptidesNovel;
                                }
                            }
                            if ((val = ((Integer)pepsSeen.get(peptide)).intValue()) == 0) {
                                try {
                                    f.write(String.valueOf(els[j].toString()) + "\n");
                                }
                                catch (IOException E) {
                                    E.printStackTrace();
                                }
                            }
                            ++j;
                        }
                    }
                    try {
                        f.close();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        break block26;
                    }
                    if (this.debugFlag) {
                        System.out.println("Finished file '" + this.inputFiles[i] + "'");
                        System.out.println("Total peptides novel: " + peptidesNovel);
                        System.out.println("Total peptides known: " + peptidesKnown);
                        if (this.isLocationFormat) {
                            System.out.println("Total locations novel: " + locsNovel);
                            System.out.println("Total locations known: " + locsKnown);
                        }
                    }
                }
            }
            ++i;
        }
        System.out.println("Total peptides novel: " + peptidesNovel);
        System.out.println("Total peptides known: " + peptidesKnown);
        if (this.isLocationFormat) {
            System.out.println("Total locations novel: " + locsNovel);
            System.out.println("Total locations known: " + locsKnown);
        }
    }
}

