/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.ui.ApplicationFrame;

public class PlotPeptideFDRs {
    public static String UsageInfo = "proteogenomicUtils.PlotPeptideFDRs version 09132010\nCreates a png file of the derived peptideFDR versus the empirical peptide FDR.\n[REQUIRED]\n -r [FILE] File containing Inspect results after peptideFDR is computed\n -w [FILE] Output file to write image to\n[Optional]\n -p [NUM] Empirical FDR cutoff\n";
    private String inputFile;
    private String outputFile;
    private float[][] dataPoints;
    private double[] EmpiricalFDR;
    private double[] DerivedFDR;
    private double CutOff = 1.0;

    public PlotPeptideFDRs(String inputFile, String outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    private void GeneratePlot() {
        this.populateData();
        String title = "Empirical versus derived local peptideFDR (" + this.dataPoints[0].length + " peptides)";
        System.out.println(title);
        PlotPeptideFDRs.plotDotGraph(this.outputFile, title, "EmpiricalFDR", "DerivedFDR", this.dataPoints);
    }

    public static boolean plotDotGraph(String OutputFile, String title, String xAxisName, String yAxisName, float[][] dataPoints) {
        ApplicationFrame f = new ApplicationFrame(title);
        NumberAxis domainAxis = new NumberAxis(xAxisName);
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis(yAxisName);
        rangeAxis.setAutoRangeIncludesZero(false);
        FastScatterPlot plot = new FastScatterPlot(dataPoints, (ValueAxis)domainAxis, (ValueAxis)rangeAxis);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartPanel panel = new ChartPanel(chart, true);
        panel.setPreferredSize(new Dimension(500, 270));
        panel.setMinimumDrawHeight(10);
        panel.setMaximumDrawHeight(2000);
        panel.setMinimumDrawWidth(20);
        panel.setMaximumDrawWidth(2000);
        f.setContentPane((Container)panel);
        f.pack();
        BufferedImage Image2 = chart.createBufferedImage(1000, 1000);
        String ScoreFileName = OutputFile;
        System.out.println("Created dot plot..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return false;
        }
        return true;
    }

    private void populateData() {
        ArrayList<Double> tempDataX = new ArrayList<Double>();
        ArrayList<Double> tempDataY = new ArrayList<Double>();
        BufferedReader buf = null;
        String Line = null;
        int LineCount = 0;
        try {
            buf = new BufferedReader(new FileReader(this.inputFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        System.out.println("#SpectrumFile ScanNumber Peptide E.pepFDR D.pepFDR localFDR SpecProb");
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            ++LineCount;
            String[] Bits = Line.split("\t");
            double derivedFDR = Double.parseDouble(Bits[InspectAnnotation.InspectColumns.LocalFDR]);
            double empiricalFDR = Double.parseDouble(Bits[InspectAnnotation.InspectColumns.FDR]);
            if (empiricalFDR <= this.CutOff) {
                tempDataX.add(new Double(empiricalFDR));
                tempDataY.add(new Double(derivedFDR));
                System.out.println(String.valueOf(Bits[InspectAnnotation.InspectColumns.SpectrumFile]) + " " + Bits[InspectAnnotation.InspectColumns.ScanNumber] + " " + Bits[InspectAnnotation.InspectColumns.Annotation] + " " + empiricalFDR + " " + derivedFDR + " " + Bits[InspectAnnotation.InspectColumns.LocalFDR] + " " + Bits[InspectAnnotation.InspectColumns.SpecProb]);
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        this.EmpiricalFDR = Utils.ConvertArraylistToDoubleArray(tempDataX);
        this.DerivedFDR = Utils.ConvertArraylistToDoubleArray(tempDataY);
        this.dataPoints = new float[2][tempDataX.size()];
        int i = 0;
        while (i < this.dataPoints[0].length) {
            this.dataPoints[0][i] = (float)((Double)tempDataX.get(i)).doubleValue();
            this.dataPoints[1][i] = (float)((Double)tempDataY.get(i)).doubleValue();
            ++i;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-p"};
        boolean[] values = new boolean[]{true, true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input file and output file!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String InputFile = (String)CommandLineArgs.get("-r");
        String OutputFile = (String)CommandLineArgs.get("-w");
        PlotPeptideFDRs p = new PlotPeptideFDRs(InputFile, OutputFile);
        if (CommandLineArgs.containsKey("-p")) {
            p.CutOff = Double.parseDouble((String)CommandLineArgs.get("-p"));
        }
        p.GeneratePlot();
    }
}

