/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import proteogenomicUtils.GenomicLocator;

public class ResultValidator {
    public static final String UsageInfo = "proteogenomicUtils.ResultValidator\nThis class is designed to compare two workflow runs on the same spectrum file.\nThe files may be Inspect results or locations\n.[Required]\n -a [FILE] One file to compare\n -b [FILE] Other file to compare\n -t [TYPE] 0: Inspect results, 1: Locations\n[Optional]\n -d Run in debug mode\n";
    public static final int INSPECT_TYPE = 0;
    public static final int LOC_TYPE = 1;
    private String FileName1 = null;
    private String FileName2 = null;
    private int FileTypes = -1;
    public boolean Debug = false;

    public ResultValidator(String File1, String File2, int Type) {
        this.FileName1 = File1;
        this.FileName2 = File2;
        this.FileTypes = Type;
    }

    public boolean Validate() {
        if (this.FileTypes == 0) {
            return this.ValidateInspect();
        }
        if (this.FileTypes == 1) {
            return this.ValidateLocations();
        }
        return false;
    }

    public boolean ValidateInspect() {
        InspectAnnotation[] Results = InspectAnnotation.LoadInspectResultsFile(this.FileName1);
        if (this.Debug) {
            System.out.println("Loaded " + Results.length + " Results from " + this.FileName1);
        }
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(this.FileName2));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        String[] columnHeaders = null;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                }
                try {
                    Line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return false;
                }
            }
            InspectAnnotation newAnn = new InspectAnnotation(Line, columnHeaders);
            int index = InspectAnnotation.indexOfNoSpecFile(Results, newAnn);
            if (index < 0) {
                System.out.println("Missing Location: " + newAnn.toString());
                System.out.println("Present in " + this.FileName2 + " but missing in " + this.FileName1);
                return false;
            }
            Results[index] = null;
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return false;
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        int i = 0;
        while (i < Results.length) {
            if (Results[i] != null) {
                System.out.println("Missing Location: " + Results[i].toString());
                System.out.println("Present in " + this.FileName1 + " but missing in " + this.FileName2);
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean ValidateLocations() {
        Results = GenomicLocator.GenomicColumns.LoadFromFile(this.FileName1);
        if (this.Debug) {
            System.out.println("Loaded " + Results.size() + " Results from " + this.FileName1);
        }
        buf = null;
        Line = null;
        try {
            buf = new BufferedReader(new FileReader(this.FileName2));
            Line = buf.readLine();
            if (true) ** GOTO lbl70
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        do {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return false;
                }
            } else {
                Loc = GenomicLocator.GenomicColumns.LoadFromString(Line);
                index = GenomicLocator.GenomicColumns.indexOf(Results, Loc);
                if (index < 0) {
                    System.out.println("Missing Location: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
                    System.out.println("Present in " + this.FileName2 + " but missing in " + this.FileName1);
                    return false;
                }
                OtherLoc = (Object[])Results.remove(index);
                if (((Integer)Loc[GenomicLocator.GenomicColumns.BestSpectrumScanNum]).intValue() != ((Integer)OtherLoc[GenomicLocator.GenomicColumns.BestSpectrumScanNum]).intValue()) {
                    if (this.Debug) {
                        System.out.println("A: " + GenomicLocator.GenomicColumns.toString(OtherLoc, " "));
                        System.out.println("B: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
                        System.out.println("ScanNumbers don't match!");
                    }
                    return false;
                }
                if (((String)Loc[GenomicLocator.GenomicColumns.BestSpectrumScanNum]).compareTo((String)OtherLoc[GenomicLocator.GenomicColumns.BestSpectrumScanNum]) != 0) {
                    if (this.Debug) {
                        System.out.println("A: " + GenomicLocator.GenomicColumns.toString(OtherLoc, " "));
                        System.out.println("B: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
                        System.out.println("Proteins don't match!");
                    }
                    return false;
                }
                if (((Integer)Loc[GenomicLocator.GenomicColumns.SpectrumCount]).intValue() != ((Integer)OtherLoc[GenomicLocator.GenomicColumns.SpectrumCount]).intValue()) {
                    if (this.Debug) {
                        System.out.println("A: " + GenomicLocator.GenomicColumns.toString(OtherLoc, " "));
                        System.out.println("B: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
                        System.out.println("SpectrumCounts don't match!");
                    }
                    return false;
                }
                if (((Boolean)Loc[GenomicLocator.GenomicColumns.IsUnique]).booleanValue() != ((Boolean)OtherLoc[GenomicLocator.GenomicColumns.IsUnique]).booleanValue()) {
                    if (this.Debug) {
                        System.out.println("A: " + GenomicLocator.GenomicColumns.toString(OtherLoc, " "));
                        System.out.println("B: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
                        System.out.println("IsUnique don't match!");
                    }
                    return false;
                }
                if (((Boolean)Loc[GenomicLocator.GenomicColumns.IsNovel]).booleanValue() != ((Boolean)OtherLoc[GenomicLocator.GenomicColumns.IsNovel]).booleanValue()) {
                    if (this.Debug) {
                        System.out.println("A: " + GenomicLocator.GenomicColumns.toString(OtherLoc, " "));
                        System.out.println("B: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
                        System.out.println("isNovel don't match!");
                    }
                    return false;
                }
                if (Loc[GenomicLocator.GenomicColumns.BestSpecProb] != null && OtherLoc[GenomicLocator.GenomicColumns.BestSpecProb] != null && ((Double)Loc[GenomicLocator.GenomicColumns.BestSpecProb]).doubleValue() != ((Double)OtherLoc[GenomicLocator.GenomicColumns.BestSpecProb]).doubleValue()) {
                    if (this.Debug) {
                        System.out.println("A: " + GenomicLocator.GenomicColumns.toString(OtherLoc, " "));
                        System.out.println("B: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
                        System.out.println("SpecProb don't match!");
                    }
                    return false;
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return false;
                }
            }
lbl70:
            // 3 sources

        } while (Line != null);
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        if (Results.size() > 0 && (i = 0) < Results.size()) {
            Loc = (Object[])Results.get(i);
            System.out.println("Missing Location: " + GenomicLocator.GenomicColumns.toString(Loc, " "));
            System.out.println("Present in " + this.FileName1 + " but missing in " + this.FileName2);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-a", "-b", "-t", "-d"};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        boolean[] values = blArray;
        Hashtable Options = Utils.ParseCommandLine(args, options, values);
        if (!Options.containsKey("-a")) {
            System.err.println("ERROR: Must specify a file to compare (-a)");
            System.out.println(UsageInfo);
            return;
        }
        if (!Options.containsKey("-b")) {
            System.err.println("ERROR: Must specify a file to compare (-b)");
            System.out.println(UsageInfo);
            return;
        }
        if (!Options.containsKey("-t")) {
            System.err.println("ERROR: Must specify a file type (0 or 1)");
            System.out.println(UsageInfo);
            return;
        }
        String File1 = (String)Options.get("-a");
        String File2 = (String)Options.get("-b");
        int Type = Integer.parseInt((String)Options.get("-t"));
        if (Type != 0 && Type != 1) {
            System.err.println("ERROR: Invalid file type '" + Type + "'");
            System.out.println(UsageInfo);
            return;
        }
        ResultValidator V = new ResultValidator(File1, File2, Type);
        if (Options.containsKey("-d")) {
            V.Debug = true;
        }
        V.Validate();
    }
}

