/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.GFFFile;
import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import proteogenomicUtils.FASTAParser;
import sixFrameUtils.SixFrameBuilder;

public class SearchLocation {
    public static final String UsageInfo = "proteogenomicUtils.SearchLocation, version 2012.05.10\nConverts Inspect results to genomic coordinate format (not GFF).  Each line is a location on the genome\nOptions:\n -r [FILE] Inspect result file to analyize\n -t [FILE] May be .trie or .ms2db and produced by SixFrameBuilder or BuildMS2DB\n -w [FILE] File to write converted results\n";
    private FASTAParser[] SixframeFiles = null;
    private FASTAParser[] SpliceFastaFiles = null;
    private String[] InputFiles = null;
    private String OutputFile = null;
    private FileWriter OutputFileWriter = null;
    public boolean Debug = false;

    public SearchLocation(String InputFile, String[] SixframeDBs, String[] SpliceDBs, String OutputFile) {
        File Test = new File(InputFile);
        this.InputFiles = null;
        if (Test.isDirectory()) {
            String[] Names = Test.list();
            this.InputFiles = new String[Names.length];
            int i = 0;
            while (i < Names.length) {
                this.InputFiles[i] = String.valueOf(InputFile) + File.separator + Names[i];
                System.out.println(this.InputFiles[i]);
                ++i;
            }
        } else {
            this.InputFiles = new String[1];
            this.InputFiles[0] = InputFile;
        }
        this.OutputFile = OutputFile;
        int SixframeFastaCount = 0;
        int SpliceFastaCount = 0;
        int i = 0;
        while (i < SixframeDBs.length) {
            ++SixframeFastaCount;
            ++i;
        }
        i = 0;
        while (i < SpliceDBs.length) {
            ++SpliceFastaCount;
            ++i;
        }
        this.SixframeFiles = new FASTAParser[SixframeFastaCount];
        this.SpliceFastaFiles = new FASTAParser[SpliceFastaCount];
        i = 0;
        while (i < SixframeDBs.length) {
            this.SixframeFiles[i] = new FASTAParser(SixframeDBs[i]);
            this.SixframeFiles[i].LoadFASTAFile();
            ++i;
        }
        i = 0;
        while (i < SpliceDBs.length) {
            this.SpliceFastaFiles[i] = new FASTAParser(SpliceDBs[i]);
            this.SpliceFastaFiles[i].LoadFASTAFile();
            ++i;
        }
    }

    public static Hashtable GetAllLocations(Hashtable CurrPeptides, ArrayList PeptidesToSearch, FASTAParser[] SixframeFiles, FASTAParser[] SpliceFastaFiles) {
        Hashtable CurrLocs;
        String[] Peptides = Utils.ConvertArraylistToStringArray(PeptidesToSearch);
        Hashtable AllLocations = new Hashtable();
        int i = 0;
        while (i < SixframeFiles.length) {
            if (SixframeFiles[i] != null) {
                CurrLocs = SixframeFiles[i].GetAllLocations(Peptides);
                AllLocations = SearchLocation.AddSixframeLocations(CurrLocs, AllLocations, SixframeFiles[i], CurrPeptides);
            }
            ++i;
        }
        System.out.println("Sixframe Location added");
        i = 0;
        while (i < SpliceFastaFiles.length) {
            if (SpliceFastaFiles[i] != null) {
                CurrLocs = SpliceFastaFiles[i].GetAllLocations(Peptides);
                AllLocations = SearchLocation.AddSpliceLocations(CurrLocs, AllLocations, SpliceFastaFiles[i], CurrPeptides);
            }
            ++i;
        }
        System.out.println("Splice Location added");
        Enumeration P = AllLocations.keys();
        while (P.hasMoreElements()) {
            String CurrPeptide = (String)P.nextElement();
            ArrayList Locs = (ArrayList)AllLocations.get(CurrPeptide);
            int L = 0;
            while (L < Locs.size()) {
                Object[] Loc = (Object[])Locs.get(L);
                Loc[GenomicColumns.LocationCount] = new Integer(Locs.size());
                ++L;
            }
            AllLocations.put(CurrPeptide, Locs);
        }
        System.out.println("Get all location finished");
        return AllLocations;
    }

    private static Hashtable AddSixframeLocations(Hashtable TrieLocations, Hashtable AllLocations, FASTAParser DB, Hashtable PeptideInfo) {
        Enumeration FoundPeptides = TrieLocations.keys();
        while (FoundPeptides.hasMoreElements()) {
            String Peptide2 = (String)FoundPeptides.nextElement();
            ArrayList NewLocs = (ArrayList)TrieLocations.get(Peptide2);
            Object[] Info2 = null;
            Info2 = PeptideInfo != null && PeptideInfo.containsKey(Peptide2) ? (Object[])PeptideInfo.get(Peptide2) : new Object[]{"FakeFile", new Integer(-1), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.01), new Integer(0), new Integer(0), new Double(0.0), new Integer(-1)};
            ArrayList OldLocs = null;
            OldLocs = AllLocations.containsKey(Peptide2) ? (ArrayList)AllLocations.get(Peptide2) : new ArrayList();
            int L = 0;
            while (L < NewLocs.size()) {
                Object[] TrieLoc = (Object[])NewLocs.get(L);
                Object[] FormattedLoc = new Object[GenomicColumns.NUM_COLUMNS];
                FormattedLoc[GenomicColumns.BestSpectrumFile] = (String)Info2[0];
                FormattedLoc[GenomicColumns.BestSpectrumScanNum] = (Integer)Info2[1];
                FormattedLoc[GenomicColumns.BestMQScore] = (Double)Info2[2];
                FormattedLoc[GenomicColumns.BestFDR] = (Double)Info2[5];
                FormattedLoc[GenomicColumns.SpectrumCount] = (Integer)Info2[7];
                FormattedLoc[GenomicColumns.Peptide] = (String)TrieLoc[0];
                FormattedLoc[GenomicColumns.ProteinName] = (String)TrieLoc[2];
                FormattedLoc[GenomicColumns.DBFileName] = DB.GetDBFileName();
                FormattedLoc[GenomicColumns.SpectrumFilePos] = (Integer)Info2[6];
                FormattedLoc[GenomicColumns.BestFScore] = (Double)Info2[3];
                String[] HeaderBits = SixFrameBuilder.ParseSixFrameHeader((String)FormattedLoc[GenomicColumns.ProteinName]);
                FormattedLoc[GenomicColumns.SequenceName] = HeaderBits[0];
                FormattedLoc[GenomicColumns.Strand] = GFFFile.ParseStrand(HeaderBits[3]);
                if (Info2[4] != null) {
                    FormattedLoc[GenomicColumns.BestSpecProb] = (Double)Info2[4];
                }
                if (HeaderBits[3].compareTo("1") == 0) {
                    if (Peptide2.indexOf(95) >= 0) {
                        FormattedLoc[GenomicColumns.Start] = new Integer((Integer)TrieLoc[1] * 3 + Integer.parseInt(HeaderBits[1]));
                        FormattedLoc[GenomicColumns.End] = new Integer((Integer)TrieLoc[1] * 3 + Integer.parseInt(HeaderBits[1]) + (Peptide2.length() - 1) * 3);
                    } else {
                        FormattedLoc[GenomicColumns.Start] = new Integer((Integer)TrieLoc[1] * 3 + Integer.parseInt(HeaderBits[1]));
                        FormattedLoc[GenomicColumns.End] = new Integer((Integer)TrieLoc[1] * 3 + Integer.parseInt(HeaderBits[1]) + Peptide2.length() * 3);
                    }
                } else if (Peptide2.indexOf(95) >= 0) {
                    FormattedLoc[GenomicColumns.End] = new Integer(Integer.parseInt(HeaderBits[2]) - (Integer)TrieLoc[1] * 3);
                    FormattedLoc[GenomicColumns.Start] = new Integer(Integer.parseInt(HeaderBits[2]) - (Integer)TrieLoc[1] * 3 - (Peptide2.length() - 1) * 3);
                } else {
                    FormattedLoc[GenomicColumns.End] = new Integer(Integer.parseInt(HeaderBits[2]) - (Integer)TrieLoc[1] * 3);
                    FormattedLoc[GenomicColumns.Start] = new Integer(Integer.parseInt(HeaderBits[2]) - (Integer)TrieLoc[1] * 3 - Peptide2.length() * 3);
                }
                FormattedLoc[GenomicColumns.SplicedSequence] = Peptide2;
                FormattedLoc[GenomicColumns.Splices] = "";
                FormattedLoc[GenomicColumns.IsUnique] = new Boolean(NewLocs.size() == 1);
                FormattedLoc[GenomicColumns.IsNovel] = Boolean.TRUE;
                FormattedLoc[GenomicColumns.BestLocalFDR] = (Double)Info2[8];
                FormattedLoc[GenomicColumns.Charge] = (Integer)Info2[9];
                OldLocs = SearchLocation.AddLocation(OldLocs, FormattedLoc);
                ++L;
            }
            AllLocations.put(Peptide2, OldLocs);
        }
        return AllLocations;
    }

    private static Hashtable AddSpliceLocations(Hashtable TrieLocations, Hashtable AllLocations, FASTAParser DB, Hashtable PeptideInfo) {
        Enumeration FoundPeptides = TrieLocations.keys();
        while (FoundPeptides.hasMoreElements()) {
            String Peptide2 = (String)FoundPeptides.nextElement();
            ArrayList NewLocs = (ArrayList)TrieLocations.get(Peptide2);
            Object[] Info2 = null;
            Info2 = PeptideInfo != null && PeptideInfo.containsKey(Peptide2) ? (Object[])PeptideInfo.get(Peptide2) : new Object[]{"FakeFile", new Integer(-1), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.01), new Integer(0), new Integer(0), new Double(0.0), new Integer(-1)};
            ArrayList OldLocs = null;
            OldLocs = AllLocations.containsKey(Peptide2) ? (ArrayList)AllLocations.get(Peptide2) : new ArrayList();
            int L = 0;
            while (L < NewLocs.size()) {
                Object[] TrieLoc = (Object[])NewLocs.get(L);
                Object[] FormattedLoc = new Object[GenomicColumns.NUM_COLUMNS];
                FormattedLoc[GenomicColumns.BestSpectrumFile] = (String)Info2[0];
                FormattedLoc[GenomicColumns.BestSpectrumScanNum] = (Integer)Info2[1];
                FormattedLoc[GenomicColumns.BestMQScore] = (Double)Info2[2];
                FormattedLoc[GenomicColumns.BestFDR] = (Double)Info2[5];
                FormattedLoc[GenomicColumns.SpectrumCount] = (Integer)Info2[7];
                FormattedLoc[GenomicColumns.Peptide] = (String)TrieLoc[0];
                FormattedLoc[GenomicColumns.ProteinName] = (String)TrieLoc[2];
                FormattedLoc[GenomicColumns.DBFileName] = DB.GetDBFileName();
                FormattedLoc[GenomicColumns.SpectrumFilePos] = (Integer)Info2[6];
                FormattedLoc[GenomicColumns.BestFScore] = (Double)Info2[3];
                String tmpProteinSequence = (String)TrieLoc[3];
                String tmpPeptide = (String)FormattedLoc[GenomicColumns.Peptide];
                tmpPeptide = String.valueOf(tmpPeptide.charAt(0)) + tmpPeptide.substring(2, tmpPeptide.length() - 2) + tmpPeptide.charAt(tmpPeptide.length() - 1);
                tmpPeptide = tmpPeptide.replace("_", "");
                int IndexAA = tmpProteinSequence.indexOf(tmpPeptide);
                int SubSeqStartBasepair = IndexAA * 3;
                int SubSeqEndBasepair = SubSeqStartBasepair + tmpPeptide.length() * 3;
                String[] tmpGeneName = FormattedLoc[GenomicColumns.ProteinName].toString().split(";");
                String[] tmpGeneInfo = tmpGeneName[0].split("@");
                FormattedLoc[GenomicColumns.SequenceName] = tmpGeneInfo[1];
                FormattedLoc[GenomicColumns.Strand] = Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]);
                FormattedLoc[GenomicColumns.Strand] = 1;
                String tmpSplicedSequence = "";
                String tmpSplices = "";
                String tmpSplicedSequenceString = "";
                boolean tmpSplitPeptideIndex = false;
                if (tmpGeneName.length > 2) {
                    int tmp_end;
                    int tmp_start;
                    ArrayList<Integer> start = new ArrayList<Integer>();
                    ArrayList<Integer> end = new ArrayList<Integer>();
                    ArrayList<Integer> len = new ArrayList<Integer>();
                    int m = 1;
                    while (m < tmpGeneName.length) {
                        String[] tmp = tmpGeneName[m].split("-");
                        start.add(Integer.parseInt(tmp[0]));
                        end.add(Integer.parseInt(tmp[1]));
                        len.add(Integer.parseInt(tmp[1]) - Integer.parseInt(tmp[0]));
                        ++m;
                    }
                    int i = -1;
                    int j = -1;
                    if (SubSeqStartBasepair < 0) {
                        System.out.println("SubSeqStartBasepair " + SubSeqStartBasepair + " tmpPeptide" + tmpPeptide);
                    }
                    while (SubSeqStartBasepair >= 0) {
                        SubSeqStartBasepair -= Integer.parseInt(len.get(++i).toString());
                    }
                    while (SubSeqEndBasepair > 0) {
                        SubSeqEndBasepair -= Integer.parseInt(len.get(++j).toString());
                    }
                    if (tmpGeneInfo == null || tmpGeneInfo.length == 0 || tmpGeneInfo.length == 1 || tmpGeneInfo.length == 2) {
                        System.out.println(" tmpGeneInfo " + tmpGeneInfo);
                    }
                    if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                        tmp_start = Integer.parseInt(start.get(i).toString()) - SubSeqStartBasepair;
                        tmp_end = Integer.parseInt(start.get(j).toString()) - SubSeqEndBasepair;
                    } else {
                        tmp_start = Integer.parseInt(end.get(i).toString()) + SubSeqStartBasepair;
                        tmp_end = Integer.parseInt(end.get(j).toString()) + SubSeqEndBasepair;
                    }
                    ArrayList<Integer> location_start = new ArrayList<Integer>();
                    ArrayList<Integer> location_end = new ArrayList<Integer>();
                    ArrayList<Integer> location_len = new ArrayList<Integer>();
                    if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                        FormattedLoc[GenomicColumns.Start] = tmp_end;
                        FormattedLoc[GenomicColumns.End] = tmp_start;
                        if (j - i <= 0) {
                            location_start.add(tmp_end);
                            location_end.add(tmp_start);
                            location_len.add(tmp_start - tmp_end);
                        } else {
                            location_start.add(Integer.parseInt(start.get(i).toString()));
                            location_end.add(tmp_start);
                            location_len.add(tmp_start - Integer.parseInt(start.get(i).toString()));
                            int k = 0;
                            while (k < j - i - 1) {
                                location_start.add(Integer.parseInt(start.get(k + i + 1).toString()));
                                location_end.add(Integer.parseInt(end.get(k + i + 1).toString()));
                                location_len.add(Integer.parseInt(end.get(k + i + 1).toString()) - Integer.parseInt(start.get(k + i + 1).toString()));
                                ++k;
                            }
                            location_start.add(tmp_end);
                            location_end.add(Integer.parseInt(end.get(j).toString()));
                            location_len.add(Integer.parseInt(end.get(j).toString()) - tmp_end);
                        }
                    } else {
                        FormattedLoc[GenomicColumns.Start] = tmp_start;
                        FormattedLoc[GenomicColumns.End] = tmp_end;
                        if (j - i <= 0) {
                            location_start.add(tmp_start);
                            location_end.add(tmp_end);
                            location_len.add(tmp_end - tmp_start);
                        } else {
                            location_start.add(tmp_start);
                            location_end.add(Integer.parseInt(end.get(i).toString()));
                            location_len.add(Integer.parseInt(end.get(i).toString()) - tmp_start);
                            int k = 0;
                            while (k < j - i - 1) {
                                location_start.add(Integer.parseInt(start.get(k + i + 1).toString()));
                                location_end.add(Integer.parseInt(end.get(k + i + 1).toString()));
                                location_len.add(Integer.parseInt(end.get(k + i + 1).toString()) - Integer.parseInt(start.get(k + i + 1).toString()));
                                ++k;
                            }
                            location_start.add(Integer.parseInt(start.get(j).toString()));
                            location_end.add(tmp_end);
                            location_len.add(tmp_end - Integer.parseInt(start.get(j).toString()));
                        }
                    }
                    if (location_start.size() > 1) {
                        String temp = "";
                        int num = 0;
                        String splice_tmp = "";
                        i = 0;
                        while (i < location_len.size()) {
                            if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                                if (i == location_len.size() - 1) {
                                    temp = String.valueOf(temp) + tmpPeptide.substring(num);
                                } else {
                                    temp = String.valueOf(temp) + tmpPeptide.substring(num, num + Integer.parseInt(location_len.get(i).toString()) / 3);
                                    temp = String.valueOf(temp) + ":";
                                    num += Integer.parseInt(location_len.get(i).toString()) / 3;
                                    splice_tmp = String.valueOf(splice_tmp) + location_end.get(location_len.size() - 1 - i) + "-" + location_start.get(location_len.size() - 2 - i);
                                    if (i != location_len.size() - 2) {
                                        splice_tmp = String.valueOf(splice_tmp) + ',';
                                    }
                                }
                            } else if (i == location_len.size() - 1) {
                                temp = String.valueOf(temp) + tmpPeptide.substring(num);
                            } else {
                                temp = String.valueOf(temp) + tmpPeptide.substring(num, num + Integer.parseInt(location_len.get(i).toString()) / 3);
                                temp = String.valueOf(temp) + ":";
                                num += Integer.parseInt(location_len.get(i).toString()) / 3;
                                splice_tmp = String.valueOf(splice_tmp) + location_end.get(i).toString() + "-" + location_start.get(i + 1).toString();
                                if (i != location_len.size() - 2) {
                                    splice_tmp = String.valueOf(splice_tmp) + ',';
                                }
                            }
                            FormattedLoc[GenomicColumns.SplicedSequence] = temp;
                            FormattedLoc[GenomicColumns.Splices] = splice_tmp;
                            ++i;
                        }
                    } else {
                        FormattedLoc[GenomicColumns.SplicedSequence] = tmpPeptide;
                        FormattedLoc[GenomicColumns.Splices] = "";
                    }
                } else {
                    FormattedLoc[GenomicColumns.SplicedSequence] = tmpPeptide;
                    FormattedLoc[GenomicColumns.Splices] = "";
                    String[] tmp = tmpGeneName[1].split("-");
                    if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                        FormattedLoc[GenomicColumns.End] = Integer.parseInt(tmp[1]) - SubSeqStartBasepair;
                        FormattedLoc[GenomicColumns.Start] = Integer.parseInt(tmp[1]) - SubSeqEndBasepair;
                    } else {
                        FormattedLoc[GenomicColumns.Start] = Integer.parseInt(tmp[0]) + SubSeqStartBasepair;
                        FormattedLoc[GenomicColumns.End] = Integer.parseInt(tmp[0]) + SubSeqEndBasepair;
                    }
                }
                if (Info2[4] != null) {
                    FormattedLoc[GenomicColumns.BestSpecProb] = (Double)Info2[4];
                }
                FormattedLoc[GenomicColumns.IsUnique] = new Boolean(NewLocs.size() == 1);
                FormattedLoc[GenomicColumns.IsNovel] = Boolean.TRUE;
                FormattedLoc[GenomicColumns.BestLocalFDR] = (Double)Info2[8];
                FormattedLoc[GenomicColumns.Charge] = (Integer)Info2[9];
                OldLocs = SearchLocation.AddLocation(OldLocs, FormattedLoc);
                ++L;
            }
            AllLocations.put(Peptide2, OldLocs);
        }
        return AllLocations;
    }

    private static Hashtable AddSpliceLocationsOld1(Hashtable TrieLocations, Hashtable AllLocations, FASTAParser DB, Hashtable PeptideInfo) {
        Enumeration FoundPeptides = TrieLocations.keys();
        while (FoundPeptides.hasMoreElements()) {
            String Peptide2 = (String)FoundPeptides.nextElement();
            ArrayList NewLocs = (ArrayList)TrieLocations.get(Peptide2);
            Object[] Info2 = null;
            Info2 = PeptideInfo != null && PeptideInfo.containsKey(Peptide2) ? (Object[])PeptideInfo.get(Peptide2) : new Object[]{"FakeFile", new Integer(-1), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.01), new Integer(0), new Integer(0), new Double(0.0), new Integer(-1)};
            ArrayList OldLocs = null;
            OldLocs = AllLocations.containsKey(Peptide2) ? (ArrayList)AllLocations.get(Peptide2) : new ArrayList();
            int L = 0;
            while (L < NewLocs.size()) {
                Object[] TrieLoc = (Object[])NewLocs.get(L);
                Object[] FormattedLoc = new Object[GenomicColumns.NUM_COLUMNS];
                FormattedLoc[GenomicColumns.BestSpectrumFile] = (String)Info2[0];
                FormattedLoc[GenomicColumns.BestSpectrumScanNum] = (Integer)Info2[1];
                FormattedLoc[GenomicColumns.BestMQScore] = (Double)Info2[2];
                FormattedLoc[GenomicColumns.BestFDR] = (Double)Info2[5];
                FormattedLoc[GenomicColumns.SpectrumCount] = (Integer)Info2[7];
                FormattedLoc[GenomicColumns.Peptide] = (String)TrieLoc[0];
                FormattedLoc[GenomicColumns.ProteinName] = (String)TrieLoc[2];
                FormattedLoc[GenomicColumns.DBFileName] = DB.GetDBFileName();
                FormattedLoc[GenomicColumns.SpectrumFilePos] = (Integer)Info2[6];
                FormattedLoc[GenomicColumns.BestFScore] = (Double)Info2[3];
                String tmpProteinSequence = (String)TrieLoc[3];
                String tmpPeptide = (String)FormattedLoc[GenomicColumns.Peptide];
                tmpPeptide = tmpPeptide.substring(2, tmpPeptide.length() - 2);
                int IndexAA = tmpProteinSequence.indexOf(tmpPeptide);
                int SubSeqStartBasepair = IndexAA * 3;
                int SubSeqEndBasepair = SubSeqStartBasepair + tmpPeptide.length() * 3;
                String[] tmpGeneName = FormattedLoc[GenomicColumns.ProteinName].toString().split(";");
                String[] tmpGeneInfo = tmpGeneName[0].split("@");
                FormattedLoc[GenomicColumns.SequenceName] = tmpGeneInfo[1];
                FormattedLoc[GenomicColumns.Strand] = Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]);
                String tmpSplicedSequence = "";
                String tmpSplices = "";
                String tmpSplicedSequenceString = "";
                boolean tmpSplitPeptideIndex = false;
                if (tmpGeneName.length > 2) {
                    int tmp_end;
                    int tmp_start;
                    ArrayList<Integer> start = new ArrayList<Integer>();
                    ArrayList<Integer> end = new ArrayList<Integer>();
                    ArrayList<Integer> len = new ArrayList<Integer>();
                    int m = 1;
                    while (m < tmpGeneName.length) {
                        String[] tmp = tmpGeneName[m].split("-");
                        start.add(Integer.parseInt(tmp[0]));
                        end.add(Integer.parseInt(tmp[1]));
                        len.add(Integer.parseInt(tmp[1]) - Integer.parseInt(tmp[0]));
                        ++m;
                    }
                    int i = -1;
                    int j = -1;
                    while (SubSeqStartBasepair > 0) {
                        SubSeqStartBasepair -= Integer.parseInt(len.get(++i).toString());
                    }
                    while (SubSeqEndBasepair > 0) {
                        SubSeqEndBasepair -= Integer.parseInt(len.get(++j).toString());
                    }
                    if (i == -1) {
                        i = 0;
                    }
                    if (j == -1) {
                        j = 0;
                    }
                    if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                        tmp_start = Integer.parseInt(start.get(i).toString()) - SubSeqStartBasepair;
                        tmp_end = Integer.parseInt(start.get(j).toString()) - SubSeqEndBasepair;
                    } else {
                        tmp_start = Integer.parseInt(end.get(i).toString()) + SubSeqStartBasepair;
                        tmp_end = Integer.parseInt(end.get(j).toString()) + SubSeqEndBasepair;
                    }
                    ArrayList<Integer> location_start = new ArrayList<Integer>();
                    ArrayList<Integer> location_end = new ArrayList<Integer>();
                    ArrayList<Integer> location_len = new ArrayList<Integer>();
                    if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                        FormattedLoc[GenomicColumns.Start] = tmp_end;
                        FormattedLoc[GenomicColumns.End] = tmp_start;
                        if (j - i <= 0) {
                            location_start.add(tmp_end);
                            location_end.add(tmp_start);
                            location_len.add(tmp_start - tmp_end);
                        } else {
                            location_start.add(Integer.parseInt(start.get(i).toString()));
                            location_end.add(tmp_start);
                            location_len.add(tmp_start - Integer.parseInt(start.get(i).toString()));
                            int k = 0;
                            while (k < j - i - 1) {
                                location_start.add(Integer.parseInt(start.get(k + i).toString()));
                                location_end.add(Integer.parseInt(end.get(k + i).toString()));
                                location_len.add(Integer.parseInt(end.get(k + i).toString()) - Integer.parseInt(start.get(k + i).toString()));
                                ++k;
                            }
                            location_start.add(tmp_end);
                            location_end.add(Integer.parseInt(end.get(j).toString()));
                            location_len.add(Integer.parseInt(end.get(j).toString()) - tmp_end);
                        }
                    } else {
                        FormattedLoc[GenomicColumns.Start] = tmp_start;
                        FormattedLoc[GenomicColumns.End] = tmp_end;
                        if (j - i <= 0) {
                            location_start.add(tmp_start);
                            location_end.add(tmp_end);
                            location_len.add(tmp_end - tmp_start);
                        } else {
                            location_start.add(tmp_start);
                            location_end.add(Integer.parseInt(end.get(i).toString()));
                            location_len.add(Integer.parseInt(end.get(i).toString()) - tmp_start);
                            int k = 0;
                            while (k < j - i - 1) {
                                location_start.add(Integer.parseInt(start.get(k + i).toString()));
                                location_end.add(Integer.parseInt(end.get(k + i).toString()));
                                location_len.add(Integer.parseInt(end.get(k + i).toString()) - Integer.parseInt(start.get(k + i).toString()));
                                ++k;
                            }
                            location_start.add(Integer.parseInt(start.get(j).toString()));
                            location_end.add(tmp_end);
                            location_len.add(tmp_end - Integer.parseInt(start.get(j).toString()));
                        }
                    }
                    if (location_start.size() > 1) {
                        String temp = "";
                        int num = 0;
                        String splice_tmp = "";
                        i = 0;
                        while (i < location_len.size()) {
                            if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                                if (i != location_len.size() - 1) {
                                    num += Integer.parseInt(location_len.get(location_len.size() - 1 - i).toString()) / 3;
                                    splice_tmp = String.valueOf(splice_tmp) + location_end.get(location_len.size() - 1 - i) + "-" + location_start.get(location_len.size() - 2 - i);
                                    if (i != location_len.size() - 2) {
                                        splice_tmp = String.valueOf(splice_tmp) + ',';
                                    }
                                }
                            } else if (i != location_len.size() - 1) {
                                num += Integer.parseInt(location_len.get(i).toString()) / 3;
                                splice_tmp = String.valueOf(splice_tmp) + location_end.get(i).toString() + "-" + location_start.get(i + 1).toString();
                                if (i != location_len.size() - 2) {
                                    splice_tmp = String.valueOf(splice_tmp) + ',';
                                }
                            }
                            FormattedLoc[GenomicColumns.SplicedSequence] = splice_tmp;
                            FormattedLoc[GenomicColumns.Splices] = tmpPeptide;
                            ++i;
                        }
                    } else {
                        FormattedLoc[GenomicColumns.SplicedSequence] = "";
                        FormattedLoc[GenomicColumns.Splices] = "";
                    }
                } else {
                    FormattedLoc[GenomicColumns.SplicedSequence] = "";
                    FormattedLoc[GenomicColumns.Splices] = "";
                    String[] tmp = tmpGeneName[1].split("-");
                    if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                        FormattedLoc[GenomicColumns.End] = Integer.parseInt(tmp[1]) - SubSeqStartBasepair;
                        FormattedLoc[GenomicColumns.Start] = Integer.parseInt(tmp[1]) - SubSeqEndBasepair;
                    } else {
                        FormattedLoc[GenomicColumns.Start] = Integer.parseInt(tmp[0]) + SubSeqStartBasepair;
                        FormattedLoc[GenomicColumns.End] = Integer.parseInt(tmp[0]) + SubSeqEndBasepair;
                    }
                }
                if (Info2[4] != null) {
                    FormattedLoc[GenomicColumns.BestSpecProb] = (Double)Info2[4];
                }
                FormattedLoc[GenomicColumns.IsUnique] = new Boolean(NewLocs.size() == 1);
                FormattedLoc[GenomicColumns.IsNovel] = Boolean.TRUE;
                FormattedLoc[GenomicColumns.BestLocalFDR] = (Double)Info2[8];
                FormattedLoc[GenomicColumns.Charge] = (Integer)Info2[9];
                OldLocs = SearchLocation.AddLocation(OldLocs, FormattedLoc);
                ++L;
            }
            AllLocations.put(Peptide2, OldLocs);
        }
        return AllLocations;
    }

    private static Hashtable AddSpliceLocationsOld(Hashtable TrieLocations, Hashtable AllLocations, FASTAParser DB, Hashtable PeptideInfo) {
        Enumeration FoundPeptides = TrieLocations.keys();
        while (FoundPeptides.hasMoreElements()) {
            String Peptide2 = (String)FoundPeptides.nextElement();
            ArrayList NewLocs = (ArrayList)TrieLocations.get(Peptide2);
            Object[] Info2 = null;
            Info2 = PeptideInfo != null && PeptideInfo.containsKey(Peptide2) ? (Object[])PeptideInfo.get(Peptide2) : new Object[]{"FakeFile", new Integer(-1), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.01), new Integer(0), new Integer(0), new Double(0.0), new Integer(-1)};
            ArrayList OldLocs = null;
            OldLocs = AllLocations.containsKey(Peptide2) ? (ArrayList)AllLocations.get(Peptide2) : new ArrayList();
            int L = 0;
            while (L < NewLocs.size()) {
                Object[] TrieLoc = (Object[])NewLocs.get(L);
                Object[] FormattedLoc = new Object[GenomicColumns.NUM_COLUMNS];
                FormattedLoc[GenomicColumns.BestSpectrumFile] = (String)Info2[0];
                FormattedLoc[GenomicColumns.BestSpectrumScanNum] = (Integer)Info2[1];
                FormattedLoc[GenomicColumns.BestMQScore] = (Double)Info2[2];
                FormattedLoc[GenomicColumns.BestFDR] = (Double)Info2[5];
                FormattedLoc[GenomicColumns.SpectrumCount] = (Integer)Info2[7];
                FormattedLoc[GenomicColumns.Peptide] = (String)TrieLoc[0];
                FormattedLoc[GenomicColumns.ProteinName] = (String)TrieLoc[2];
                FormattedLoc[GenomicColumns.DBFileName] = DB.GetDBFileName();
                FormattedLoc[GenomicColumns.SpectrumFilePos] = (Integer)Info2[6];
                FormattedLoc[GenomicColumns.BestFScore] = (Double)Info2[3];
                String tmpProteinSequence = (String)TrieLoc[3];
                String tmpPeptide = (String)FormattedLoc[GenomicColumns.Peptide];
                tmpPeptide = tmpPeptide.substring(2, tmpPeptide.length() - 2);
                int IndexAA = tmpProteinSequence.indexOf(tmpPeptide);
                int Index = IndexAA * 3;
                String[] tmpGeneName = FormattedLoc[GenomicColumns.ProteinName].toString().split(";");
                String[] tmpGeneInfo = tmpGeneName[0].split("@");
                FormattedLoc[GenomicColumns.SequenceName] = tmpGeneInfo[1];
                FormattedLoc[GenomicColumns.Strand] = Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]);
                String tmpSplicedSequence = "";
                String tmpSplices = "";
                String tmpSplicedSequenceString = "";
                boolean tmpSplitPeptideIndex = false;
                if (tmpGeneName.length > 2) {
                    int i;
                    int tmp_end;
                    int tmp_start;
                    int tmp_end_index;
                    int e;
                    int tmpLeftOver;
                    int s;
                    ArrayList<Integer> start = new ArrayList<Integer>();
                    ArrayList<Integer> end = new ArrayList<Integer>();
                    ArrayList<Integer> len = new ArrayList<Integer>();
                    int i2 = 1;
                    while (i2 < tmpGeneName.length) {
                        String[] tmp = tmpGeneName[i2].split("-");
                        start.add(Integer.parseInt(tmp[0]));
                        end.add(Integer.parseInt(tmp[1]));
                        len.add(Integer.parseInt(tmp[1]) - Integer.parseInt(tmp[0]));
                        ++i2;
                    }
                    if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 1) {
                        s = Index;
                        int tmp_start_index = 0;
                        while (true) {
                            if (tmp_start_index >= start.size()) {
                                tmp_start_index = start.size() - 1;
                                break;
                            }
                            tmpLeftOver = s - Integer.parseInt(len.get(tmp_start_index).toString());
                            if (tmpLeftOver < 0) break;
                            s = tmpLeftOver;
                            ++tmp_start_index;
                        }
                        e = Index + tmpPeptide.length() * 3;
                        tmp_end_index = 0;
                        while (true) {
                            if (tmp_end_index >= end.size()) {
                                tmp_end_index = end.size() - 1;
                                break;
                            }
                            tmpLeftOver = e - Integer.parseInt(len.get(tmp_end_index).toString());
                            if (tmpLeftOver < 0) break;
                            e = tmpLeftOver;
                            ++tmp_end_index;
                        }
                        tmp_start = Integer.parseInt(start.get(tmp_start_index).toString()) + s;
                        tmp_end = Integer.parseInt(start.get(tmp_end_index).toString()) + e;
                        if (tmp_start_index == tmp_end_index) {
                            tmpSplices = "NA";
                            tmpSplicedSequenceString = tmpPeptide;
                        } else {
                            tmpSplices = String.valueOf(Integer.toString(tmp_start)) + "-" + end.get(tmp_start_index).toString();
                            i = tmp_start_index + 1;
                            while (i < tmp_end_index) {
                                tmpSplices = String.valueOf(tmpSplices) + "," + start.get(i).toString() + "-" + end.get(i).toString();
                                ++i;
                            }
                            tmpSplices = String.valueOf(tmpSplices) + "," + start.get(tmp_end_index).toString() + "-" + Integer.toString(tmp_end);
                            tmpSplicedSequenceString = tmpPeptide;
                        }
                        FormattedLoc[GenomicColumns.Start] = new Integer(tmp_start);
                        FormattedLoc[GenomicColumns.End] = new Integer(tmp_end);
                    } else if (Integer.parseInt(tmpGeneInfo[tmpGeneInfo.length - 1]) == 0) {
                        s = Index;
                        int tmp_start_index = start.size() - 1;
                        while (true) {
                            if (tmp_start_index < 0) {
                                tmp_start_index = 0;
                                break;
                            }
                            tmpLeftOver = s - Integer.parseInt(len.get(tmp_start_index).toString());
                            if (tmpLeftOver <= 0) break;
                            s = tmpLeftOver;
                            --tmp_start_index;
                        }
                        e = Index + tmpPeptide.length() * 3;
                        tmp_end_index = end.size() - 1;
                        while (true) {
                            if (tmp_end_index < 0) {
                                tmp_end_index = 0;
                                break;
                            }
                            tmpLeftOver = e - Integer.parseInt(len.get(tmp_end_index).toString());
                            if (tmpLeftOver <= 0) break;
                            e = tmpLeftOver;
                            --tmp_end_index;
                        }
                        tmp_start = Integer.parseInt(end.get(tmp_start_index).toString()) - s;
                        tmp_end = Integer.parseInt(end.get(tmp_end_index).toString()) - e;
                        if (tmp_start_index == tmp_end_index) {
                            tmpSplices = "NA";
                            tmpSplicedSequenceString = tmpPeptide;
                        } else {
                            tmpSplices = String.valueOf(start.get(tmp_start_index).toString()) + "-" + Integer.toString(tmp_start);
                            i = tmp_start_index - 1;
                            while (i > tmp_end_index) {
                                tmpSplices = String.valueOf(tmpSplices) + "," + start.get(i).toString() + "-" + end.get(i).toString();
                                --i;
                            }
                            tmpSplices = String.valueOf(tmpSplices) + "," + Integer.toString(tmp_end) + "-" + end.get(tmp_end_index).toString();
                            tmpSplicedSequenceString = tmpPeptide;
                        }
                        FormattedLoc[GenomicColumns.End] = new Integer(start.get(tmp_end_index).toString());
                        FormattedLoc[GenomicColumns.Start] = new Integer(end.get(tmp_start_index).toString());
                    } else {
                        System.out.println("no strand information");
                    }
                    start = null;
                    end = null;
                    len = null;
                } else {
                    tmpSplices = "NA";
                    tmpSplicedSequenceString = tmpPeptide;
                    String[] tmp = tmpGeneName[1].split("-");
                    FormattedLoc[GenomicColumns.Start] = new Integer(Index + Integer.parseInt(tmp[0]));
                    FormattedLoc[GenomicColumns.End] = new Integer(Index + Integer.parseInt(tmp[0]) + tmpPeptide.length());
                }
                FormattedLoc[GenomicColumns.SplicedSequence] = tmpSplicedSequenceString;
                FormattedLoc[GenomicColumns.Splices] = tmpSplices;
                if (Info2[4] != null) {
                    FormattedLoc[GenomicColumns.BestSpecProb] = (Double)Info2[4];
                }
                FormattedLoc[GenomicColumns.IsUnique] = new Boolean(NewLocs.size() == 1);
                FormattedLoc[GenomicColumns.IsNovel] = Boolean.TRUE;
                FormattedLoc[GenomicColumns.BestLocalFDR] = (Double)Info2[8];
                FormattedLoc[GenomicColumns.Charge] = (Integer)Info2[9];
                OldLocs = SearchLocation.AddLocation(OldLocs, FormattedLoc);
                ++L;
            }
            AllLocations.put(Peptide2, OldLocs);
        }
        return AllLocations;
    }

    private static ArrayList AddLocation(ArrayList CurrLocations, Object[] NewLocation) {
        int i = 0;
        while (i < CurrLocations.size()) {
            Object[] OldLoc = (Object[])CurrLocations.get(i);
            if (GenomicColumns.IsSameLocation(OldLoc, NewLocation)) {
                return CurrLocations;
            }
            ++i;
        }
        CurrLocations.add(NewLocation);
        return CurrLocations;
    }

    public Hashtable LoadPeptidesFromMSGFDB() {
        System.out.println("Loading Peptides...");
        Hashtable<String, Object[]> CurrPeptides = new Hashtable<String, Object[]>();
        BufferedReader InFile = null;
        String Line = null;
        int FileIndex = 0;
        while (FileIndex < this.InputFiles.length) {
            System.out.println(" ..." + this.InputFiles[FileIndex]);
            try {
                InFile = new BufferedReader(new FileReader(this.InputFiles[FileIndex]));
                Line = InFile.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
            String[] columnHeaders = null;
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    if (Line.length() > 0 && Line.charAt(0) == '#') {
                        columnHeaders = Line.substring(1).split("\t");
                    }
                    try {
                        Line = InFile.readLine();
                        continue;
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        return null;
                    }
                }
                InspectAnnotation NewAnn = new InspectAnnotation(Line, true, columnHeaders);
                String UnModded = Utils.GetUnModded(NewAnn.Annotation);
                if (this.Debug) {
                    System.out.println("Next Peptide: " + UnModded);
                }
                Object[] Temp = null;
                if (CurrPeptides.containsKey(UnModded)) {
                    double OldFDR;
                    Temp = (Object[])CurrPeptides.get(UnModded);
                    if (this.Debug) {
                        System.out.println("but we've seen it before");
                    }
                    if ((OldFDR = ((Double)Temp[3]).doubleValue()) > NewAnn.FDR) {
                        Temp[0] = NewAnn.SpectrumFile;
                        Temp[1] = new Integer(NewAnn.ScanNumber);
                        Temp[2] = new Double(NewAnn.MQScore);
                        Temp[3] = new Double(NewAnn.FScore);
                        Temp[4] = NewAnn.SpecProb >= 0.0 ? new Double(NewAnn.SpecProb) : null;
                        Temp[5] = new Double(NewAnn.FDR);
                        Temp[6] = new Integer(NewAnn.SpecFileOffset);
                        Temp[8] = new Double(NewAnn.LocalFDR);
                        Temp[9] = new Integer(NewAnn.Charge);
                    }
                    int OldCount = (Integer)Temp[7];
                    Temp[7] = new Integer(++OldCount);
                } else {
                    Temp = new Object[10];
                    if (this.Debug) {
                        System.out.println("but we've never seen it before");
                    }
                    Temp[0] = NewAnn.SpectrumFile;
                    Temp[1] = new Integer(NewAnn.ScanNumber);
                    Temp[2] = new Double(NewAnn.MQScore);
                    Temp[3] = new Double(NewAnn.FScore);
                    Temp[4] = NewAnn.SpecProb >= 0.0 ? new Double(NewAnn.SpecProb) : null;
                    Temp[5] = new Double(NewAnn.FDR);
                    Temp[6] = new Integer(NewAnn.SpecFileOffset);
                    Temp[7] = new Integer(1);
                    Temp[8] = new Double(NewAnn.LocalFDR);
                    Temp[9] = new Integer(NewAnn.Charge);
                }
                CurrPeptides.put(UnModded, Temp);
                try {
                    Line = InFile.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return null;
                }
            }
            try {
                InFile.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
            ++FileIndex;
        }
        System.out.println("Total peptides to search: " + CurrPeptides.size());
        if (this.Debug) {
            Utils.WaitForEnter();
        }
        return CurrPeptides;
    }

    public void WriteLocations(Hashtable Locations) {
        Enumeration Keys = Locations.keys();
        System.out.println("Total Locations: " + Locations.size());
        while (Keys.hasMoreElements()) {
            String Peptide2 = (String)Keys.nextElement();
            ArrayList Locs = (ArrayList)Locations.get(Peptide2);
            int L = 0;
            while (L < Locs.size()) {
                Object[] CurrLoc = (Object[])Locs.get(L);
                String ToWrite = GenomicColumns.toString(CurrLoc, "\t");
                try {
                    this.OutputFileWriter.write(String.valueOf(ToWrite) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                }
                ++L;
            }
        }
    }

    private Hashtable DetermineUniqueness(Hashtable Locations) {
        Enumeration Peptides = Locations.keys();
        while (Peptides.hasMoreElements()) {
            String CurrPeptide = (String)Peptides.nextElement();
            ArrayList CurrLocs = (ArrayList)Locations.get(CurrPeptide);
            boolean IsUnique = CurrLocs.size() == 1;
            int i = 0;
            while (i < CurrLocs.size()) {
                Object[] CurrLoc = (Object[])CurrLocs.remove(i);
                CurrLoc[GenomicColumns.IsUnique] = IsUnique ? new Boolean(true) : new Boolean(false);
                CurrLocs.add(i, CurrLoc);
                ++i;
            }
            Locations.put(CurrPeptide, CurrLocs);
        }
        return Locations;
    }

    public void RunLocator() {
        Hashtable Locs;
        try {
            this.OutputFileWriter = new FileWriter(this.OutputFile);
            this.OutputFileWriter.write(GenomicColumns.GenomicHeader);
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, this.OutputFile);
        }
        Hashtable CurrPeptides = this.LoadPeptidesFromMSGFDB();
        Enumeration Peptides = CurrPeptides.keys();
        ArrayList<String> PeptidesToSearch = new ArrayList<String>();
        while (Peptides.hasMoreElements()) {
            PeptidesToSearch.add((String)Peptides.nextElement());
            if (PeptidesToSearch.size() < 5000) continue;
            Locs = SearchLocation.GetAllLocations(CurrPeptides, PeptidesToSearch, this.SixframeFiles, this.SpliceFastaFiles);
            Locs = this.DetermineUniqueness(Locs);
            this.WriteLocations(Locs);
            PeptidesToSearch.clear();
        }
        if (PeptidesToSearch.size() > 0) {
            Locs = SearchLocation.GetAllLocations(CurrPeptides, PeptidesToSearch, this.SixframeFiles, this.SpliceFastaFiles);
            Locs = this.DetermineUniqueness(Locs);
            this.WriteLocations(Locs);
        }
        try {
            this.OutputFileWriter.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, this.OutputFile);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-t", "-d", "-s"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLineMulti(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.out.println(UsageInfo);
            ErrorThrower.ThrowError(2, "You must specify an input file");
        }
        ArrayList Temp = (ArrayList)CommandLineArgs.get("-r");
        String InputFile = (String)Temp.get(0);
        if (!CommandLineArgs.containsKey("-t")) {
            System.out.println(UsageInfo);
            ErrorThrower.ThrowError(2, "You must specify at least one genomic database of known proteins");
        }
        Temp = (ArrayList)CommandLineArgs.get("-t");
        String[] SearchSixframeDBs = Utils.ConvertArraylistToStringArray(Temp);
        if (!CommandLineArgs.containsKey("-s")) {
            System.out.println(UsageInfo);
            ErrorThrower.ThrowError(2, "You must specify at least one genomic database of known proteins");
        }
        Temp = (ArrayList)CommandLineArgs.get("-s");
        String[] SearchSpliceGraphDBs = Utils.ConvertArraylistToStringArray(Temp);
        if (!CommandLineArgs.containsKey("-w")) {
            System.out.println(UsageInfo);
            ErrorThrower.ThrowError(2, "You must specify at an output file");
        }
        Temp = (ArrayList)CommandLineArgs.get("-w");
        String OutputFile = (String)Temp.get(0);
        SearchLocation Dummy = new SearchLocation(InputFile, SearchSixframeDBs, SearchSpliceGraphDBs, OutputFile);
        if (CommandLineArgs.containsKey("-d")) {
            Dummy.Debug = true;
        }
        Dummy.RunLocator();
    }

    public static class GenomicColumns {
        public static int NUM_COLUMNS = 22;
        public static int BestSpectrumFile = 0;
        public static int BestSpectrumScanNum = 1;
        public static int Peptide = 2;
        public static int SpectrumFilePos = 3;
        public static int BestMQScore = 4;
        public static int BestFScore = 5;
        public static int BestSpecProb = 6;
        public static int BestFDR = 7;
        public static int ProteinName = 8;
        public static int DBFileName = 9;
        public static int SequenceName = 10;
        public static int Start = 11;
        public static int End = 12;
        public static int Strand = 13;
        public static int SplicedSequence = 14;
        public static int Splices = 15;
        public static int SpectrumCount = 16;
        public static int IsUnique = 17;
        public static int IsNovel = 18;
        public static int Charge = 19;
        public static int LocationCount = 20;
        public static int BestLocalFDR = 21;
        public static String GenomicHeader = "#SpectrumFile\tScan#\tAnnotation\tSpecFilePos\tMQScore\tF-Score\tSpecProb\tp-value\tProtein\tDBFileName\tSequenceName\tStart\tEnd\tStrand\tSplicedSequence\tSplices\tSpectrumCount\tIsUnique\tIsNovel\tCharge\tLocationCount\tBestLocalFDR\n";

        public static Object[] LoadFromString(String Line) {
            Object[] Ret = new Object[NUM_COLUMNS];
            String[] Bits = Line.split("\t");
            if (Bits.length < Ret.length) {
                System.err.println("ERROR: Improper number of elements in location line: " + Line);
                System.err.println("FOUND: " + Bits.length + ", NEED: " + Ret.length);
                return null;
            }
            Ret[GenomicColumns.BestSpectrumFile] = Bits[BestSpectrumFile];
            Ret[GenomicColumns.BestSpectrumScanNum] = new Integer(Bits[BestSpectrumScanNum]);
            Ret[GenomicColumns.Peptide] = Bits[Peptide];
            Ret[GenomicColumns.SpectrumFilePos] = new Integer(Bits[SpectrumFilePos]);
            Ret[GenomicColumns.BestMQScore] = new Double(Bits[BestMQScore]);
            Ret[GenomicColumns.BestFScore] = new Double(Bits[BestFScore]);
            try {
                Ret[GenomicColumns.BestFDR] = new Double(Bits[BestFDR]);
                Ret[GenomicColumns.BestSpecProb] = new Double(Bits[BestSpecProb]);
            }
            catch (Exception E) {
                Ret[GenomicColumns.BestFDR] = 1.0;
                Ret[GenomicColumns.BestSpecProb] = null;
            }
            Ret[GenomicColumns.ProteinName] = Bits[ProteinName];
            Ret[GenomicColumns.DBFileName] = Bits[DBFileName];
            Ret[GenomicColumns.SequenceName] = Bits[SequenceName];
            Ret[GenomicColumns.Start] = new Integer(Bits[Start]);
            Ret[GenomicColumns.End] = new Integer(Bits[End]);
            Ret[GenomicColumns.Strand] = new Integer(GFFFile.ParseStrand(Bits[Strand]));
            Ret[GenomicColumns.SplicedSequence] = Bits[SplicedSequence];
            Ret[GenomicColumns.Splices] = Bits[Splices];
            Ret[GenomicColumns.SpectrumCount] = new Integer(Bits[SpectrumCount]);
            Ret[GenomicColumns.IsUnique] = new Boolean(Bits[IsUnique]);
            Ret[GenomicColumns.IsNovel] = new Boolean(Bits[IsNovel]);
            Ret[GenomicColumns.Charge] = new Integer(Bits[Charge]);
            Ret[GenomicColumns.LocationCount] = new Integer(Bits[LocationCount]);
            Ret[GenomicColumns.BestLocalFDR] = new Double(Bits[BestFDR]);
            return Ret;
        }

        public static Object[] LoadFromGFFLine(String Line, String DBFile) {
            String[] B3;
            Object[] Ret = new Object[NUM_COLUMNS];
            String[] Bits = Line.split("\t");
            String[] B2 = Bits[GFFFile.GFFColumns.Attributes].split(";");
            Ret[GenomicColumns.ProteinName] = null;
            int j = 0;
            while (j < B2.length) {
                B3 = B2[j].split("=");
                if (B3[0].toLowerCase().compareTo("id") == 0) {
                    Ret[GenomicColumns.ProteinName] = B3[1].replaceAll("\"", "");
                    break;
                }
                ++j;
            }
            if (Ret[ProteinName] == null) {
                j = 0;
                while (j < B2.length) {
                    B3 = B2[j].split("=");
                    if (B3[0].toLowerCase().compareTo("name") == 0) {
                        Ret[GenomicColumns.ProteinName] = B3[1].replaceAll("\"", "");
                        break;
                    }
                    ++j;
                }
            }
            if (Ret[ProteinName] == null) {
                System.out.println("ERROR: Unable to parse gene name from " + Line);
                Utils.WaitForEnter();
            }
            Ret[GenomicColumns.DBFileName] = DBFile;
            Ret[GenomicColumns.SequenceName] = Bits[GFFFile.GFFColumns.SequenceName].toLowerCase();
            Ret[GenomicColumns.Start] = new Integer(Bits[GFFFile.GFFColumns.Start]);
            Ret[GenomicColumns.End] = new Integer(Bits[GFFFile.GFFColumns.End]);
            Ret[GenomicColumns.Strand] = new Integer(GFFFile.ParseStrand(Bits[GFFFile.GFFColumns.Strand]));
            Ret[GenomicColumns.SplicedSequence] = "";
            Ret[GenomicColumns.Splices] = "";
            Ret[GenomicColumns.SpectrumCount] = -1;
            return Ret;
        }

        public static String toGFFFileLine(Object[] Location, String Header) {
            int[][] SplicedInfo = Utils.GetSpliceInfo((String)Location[Splices], (Integer)Location[Strand], (Integer)Location[Start], (Integer)Location[End]);
            int NumLocations = (Integer)Location[LocationCount];
            double LocalFDR = (Double)Location[BestLocalFDR];
            String Ret = "";
            int i = 0;
            while (i < SplicedInfo.length) {
                Ret = String.valueOf(Ret) + (String)Location[SequenceName] + "\t";
                Ret = String.valueOf(Ret) + "Proteogenomics\t";
                Ret = String.valueOf(Ret) + "CDSpart\t";
                Ret = String.valueOf(Ret) + (SplicedInfo[i][0] + 1) + "\t";
                Ret = String.valueOf(Ret) + SplicedInfo[i][1] + "\t";
                Ret = String.valueOf(Ret) + 1.0 / (double)NumLocations * (1.0 - LocalFDR) + "\t";
                Ret = (Integer)Location[Strand] == 1 ? String.valueOf(Ret) + "+\t" : String.valueOf(Ret) + "-\t";
                Ret = (Integer)Location[Strand] == 1 ? (SplicedInfo[i][0] % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "0\t" : ((SplicedInfo[i][0] + 1) % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "1\t" : String.valueOf(Ret) + "2\t")) : ((SplicedInfo[i][1] - 1) % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "0\t" : ((SplicedInfo[i][1] - 2) % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "1\t" : String.valueOf(Ret) + "2\t"));
                Ret = String.valueOf(Ret) + "Name=" + (String)Location[Peptide];
                if (Header != null) {
                    Ret = String.valueOf(Ret) + ";Parent=" + Header;
                }
                Ret = String.valueOf(Ret) + "\n";
                ++i;
            }
            return Ret;
        }

        public static String toGFFFileLine(Object[] Location, String Header, String species) {
            int[][] SplicedInfo = Utils.GetSpliceInfo((String)Location[Splices], (Integer)Location[Strand], (Integer)Location[Start], (Integer)Location[End]);
            int NumLocations = (Integer)Location[LocationCount];
            double LocalFDR = (Double)Location[BestLocalFDR];
            String Ret = "";
            int i = 0;
            while (i < SplicedInfo.length) {
                if (species.toLowerCase().compareTo("celegans") == 0) {
                    String tmpChrString = (String)Location[SequenceName];
                    String NewChrString = "";
                    if (tmpChrString.toLowerCase().compareTo("chr1") == 0) {
                        NewChrString = "chrI";
                    } else if (tmpChrString.toLowerCase().compareTo("chr2") == 0) {
                        NewChrString = "chrII";
                    } else if (tmpChrString.toLowerCase().compareTo("chr3") == 0) {
                        NewChrString = "chrIII";
                    } else if (tmpChrString.toLowerCase().compareTo("chr4") == 0) {
                        NewChrString = "chrIV";
                    } else if (tmpChrString.toLowerCase().compareTo("chr5") == 0) {
                        NewChrString = "chrV";
                    } else if (tmpChrString.toLowerCase().compareTo("chrx") == 0) {
                        NewChrString = "chrX";
                    } else {
                        System.out.println("Unknown chr name for C.elegans " + tmpChrString);
                        NewChrString = tmpChrString;
                    }
                    Ret = String.valueOf(Ret) + NewChrString + "\t";
                } else {
                    Ret = String.valueOf(Ret) + (String)Location[SequenceName] + "\t";
                }
                Ret = String.valueOf(Ret) + "Proteogenomics\t";
                Ret = String.valueOf(Ret) + "CDSpart\t";
                Ret = String.valueOf(Ret) + (SplicedInfo[i][0] + 1) + "\t";
                Ret = String.valueOf(Ret) + SplicedInfo[i][1] + "\t";
                Ret = String.valueOf(Ret) + 1.0 / (double)NumLocations * (1.0 - LocalFDR) + "\t";
                Ret = (Integer)Location[Strand] == 1 ? String.valueOf(Ret) + "+\t" : String.valueOf(Ret) + "-\t";
                Ret = (Integer)Location[Strand] == 1 ? (SplicedInfo[i][0] % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "0\t" : ((SplicedInfo[i][0] + 1) % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "1\t" : String.valueOf(Ret) + "2\t")) : ((SplicedInfo[i][1] - 1) % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "0\t" : ((SplicedInfo[i][1] - 2) % 3 == SplicedInfo[i][2] ? String.valueOf(Ret) + "1\t" : String.valueOf(Ret) + "2\t"));
                Ret = Location[SplicedSequence] != null && (String)Location[SplicedSequence] != "" ? String.valueOf(Ret) + "Name=" + (String)Location[SplicedSequence] : String.valueOf(Ret) + "Name=" + (String)Location[Peptide];
                if (Header != null) {
                    Ret = String.valueOf(Ret) + ";Parent=" + Header;
                }
                Ret = String.valueOf(Ret) + "\n";
                ++i;
            }
            return Ret;
        }

        public static boolean IsSameLocation(Object[] Loc1, Object[] Loc2) {
            if (((String)Loc1[SequenceName]).toLowerCase().compareTo(((String)Loc2[SequenceName]).toLowerCase()) != 0) {
                return false;
            }
            if (((Integer)Loc1[Start]).intValue() != ((Integer)Loc2[Start]).intValue()) {
                return false;
            }
            if (((Integer)Loc1[End]).intValue() != ((Integer)Loc2[End]).intValue()) {
                return false;
            }
            if (((Integer)Loc1[Strand]).intValue() != ((Integer)Loc2[Strand]).intValue()) {
                return false;
            }
            return ((String)Loc1[Splices]).compareTo((String)Loc2[Splices]) == 0;
        }

        public static ArrayList LoadFromFile(String FileName) {
            BufferedReader Reader2 = null;
            String Line = null;
            try {
                Reader2 = new BufferedReader(new FileReader(FileName));
                Line = Reader2.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
            ArrayList<Object[]> Ret = new ArrayList<Object[]>();
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = Reader2.readLine();
                        continue;
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        return null;
                    }
                }
                Object[] Loc = GenomicColumns.LoadFromString(Line);
                if (Loc != null) {
                    Ret.add(Loc);
                }
                try {
                    Line = Reader2.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return null;
                }
            }
            try {
                Reader2.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
            return Ret;
        }

        public static String toString(Object[] Loc, String delim) {
            String Ret = "";
            Ret = String.valueOf(Ret) + (String)Loc[BestSpectrumFile] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[BestSpectrumScanNum] + delim;
            Ret = String.valueOf(Ret) + (String)Loc[Peptide] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[SpectrumFilePos] + delim;
            Ret = String.valueOf(Ret) + (Double)Loc[BestMQScore] + delim;
            Ret = String.valueOf(Ret) + (Double)Loc[BestFScore] + delim;
            Ret = Loc[BestSpecProb] != null ? String.valueOf(Ret) + (Double)Loc[BestSpecProb] + delim : String.valueOf(Ret) + delim;
            Ret = String.valueOf(Ret) + (Double)Loc[BestFDR] + delim;
            Ret = String.valueOf(Ret) + (String)Loc[ProteinName] + delim;
            Ret = String.valueOf(Ret) + (String)Loc[DBFileName] + delim;
            Ret = String.valueOf(Ret) + (String)Loc[SequenceName] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[Start] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[End] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[Strand] + delim;
            Ret = String.valueOf(Ret) + (String)Loc[SplicedSequence] + delim;
            Ret = String.valueOf(Ret) + (String)Loc[Splices] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[SpectrumCount] + delim;
            Ret = String.valueOf(Ret) + (Boolean)Loc[IsUnique] + delim;
            Ret = String.valueOf(Ret) + (Boolean)Loc[IsNovel] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[Charge] + delim;
            Ret = String.valueOf(Ret) + (Integer)Loc[LocationCount] + delim;
            Ret = String.valueOf(Ret) + (Double)Loc[BestLocalFDR];
            return Ret;
        }

        public static int indexOf(ArrayList CurrList, Object[] NewLoc) {
            int i = 0;
            while (i < CurrList.size()) {
                Object[] CurrLoc = (Object[])CurrList.get(i);
                if (GenomicColumns.IsSameLocation(NewLoc, CurrLoc)) {
                    Object[] MergedLoc = GenomicColumns.MergeLocations(NewLoc, CurrLoc);
                    CurrList.remove(i);
                    CurrList.add(i, MergedLoc);
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public static ArrayList InsertInOrder(ArrayList CurrList, Object[] NewLoc) {
            int i = 0;
            while (i < CurrList.size()) {
                Object[] CurrLoc = (Object[])CurrList.get(i);
                if (GenomicColumns.compare(NewLoc, CurrLoc) < 0) {
                    CurrList.add(i, NewLoc);
                    return CurrList;
                }
                if (GenomicColumns.IsSameLocation(NewLoc, CurrLoc)) {
                    Object[] MergedLoc = GenomicColumns.MergeLocations(NewLoc, CurrLoc);
                    CurrList.remove(i);
                    CurrList.add(i, MergedLoc);
                    return CurrList;
                }
                ++i;
            }
            CurrList.add(NewLoc);
            return CurrList;
        }

        public static Object[] MergeLocations(Object[] L1, Object[] L2) {
            Object[] NewLoc = new Object[NUM_COLUMNS];
            int SpecCount1 = 1;
            int SpecCount2 = 1;
            if (L1[SpectrumCount] != null) {
                SpecCount1 = (Integer)L1[SpectrumCount];
            } else {
                System.out.println("WARNING: No spectral counts available for some guys!");
            }
            if (L2[SpectrumCount] != null) {
                SpecCount2 = (Integer)L2[SpectrumCount];
            } else {
                System.out.println("WARNING: No spectral counts available for some guys!");
            }
            NewLoc[GenomicColumns.SpectrumCount] = new Integer(SpecCount1 + SpecCount2);
            if (L1[BestFDR] != null && L2[BestFDR] != null) {
                double FDR2;
                double FDR1 = (Double)L1[BestFDR];
                if (FDR1 <= (FDR2 = ((Double)L2[BestFDR]).doubleValue())) {
                    NewLoc[GenomicColumns.BestSpectrumFile] = L1[BestSpectrumFile];
                    NewLoc[GenomicColumns.BestSpectrumScanNum] = L1[BestSpectrumScanNum];
                    NewLoc[GenomicColumns.Peptide] = L1[Peptide];
                    NewLoc[GenomicColumns.SpectrumFilePos] = L1[SpectrumFilePos];
                    NewLoc[GenomicColumns.BestMQScore] = L1[BestMQScore];
                    NewLoc[GenomicColumns.BestFScore] = L1[BestFScore];
                    NewLoc[GenomicColumns.BestFDR] = L1[BestFDR];
                    NewLoc[GenomicColumns.BestSpecProb] = L1[BestSpecProb];
                    NewLoc[GenomicColumns.ProteinName] = L1[ProteinName];
                    NewLoc[GenomicColumns.DBFileName] = L1[DBFileName];
                    NewLoc[GenomicColumns.SequenceName] = L1[SequenceName];
                    NewLoc[GenomicColumns.Start] = L1[Start];
                    NewLoc[GenomicColumns.End] = L1[End];
                    NewLoc[GenomicColumns.Strand] = L1[Strand];
                    NewLoc[GenomicColumns.SplicedSequence] = L1[SplicedSequence];
                    NewLoc[GenomicColumns.Splices] = L1[Splices];
                    NewLoc[GenomicColumns.IsUnique] = L1[IsUnique];
                    NewLoc[GenomicColumns.IsNovel] = L1[IsNovel];
                    NewLoc[GenomicColumns.Charge] = L1[Charge];
                    NewLoc[GenomicColumns.LocationCount] = L1[LocationCount];
                    NewLoc[GenomicColumns.BestLocalFDR] = L1[BestLocalFDR];
                } else {
                    NewLoc[GenomicColumns.BestSpectrumFile] = L2[BestSpectrumFile];
                    NewLoc[GenomicColumns.BestSpectrumScanNum] = L2[BestSpectrumScanNum];
                    NewLoc[GenomicColumns.Peptide] = L2[Peptide];
                    NewLoc[GenomicColumns.SpectrumFilePos] = L2[SpectrumFilePos];
                    NewLoc[GenomicColumns.BestMQScore] = L2[BestMQScore];
                    NewLoc[GenomicColumns.BestFScore] = L2[BestFScore];
                    NewLoc[GenomicColumns.BestFDR] = L2[BestFDR];
                    NewLoc[GenomicColumns.BestSpecProb] = L2[BestSpecProb];
                    NewLoc[GenomicColumns.ProteinName] = L2[ProteinName];
                    NewLoc[GenomicColumns.DBFileName] = L2[DBFileName];
                    NewLoc[GenomicColumns.SequenceName] = L2[SequenceName];
                    NewLoc[GenomicColumns.Start] = L2[Start];
                    NewLoc[GenomicColumns.End] = L2[End];
                    NewLoc[GenomicColumns.Strand] = L2[Strand];
                    NewLoc[GenomicColumns.SplicedSequence] = L2[SplicedSequence];
                    NewLoc[GenomicColumns.Splices] = L2[Splices];
                    NewLoc[GenomicColumns.IsUnique] = L2[IsUnique];
                    NewLoc[GenomicColumns.IsNovel] = L2[IsNovel];
                    NewLoc[GenomicColumns.Charge] = L2[Charge];
                    NewLoc[GenomicColumns.LocationCount] = L2[LocationCount];
                    NewLoc[GenomicColumns.BestLocalFDR] = L2[BestLocalFDR];
                }
            } else {
                NewLoc[GenomicColumns.BestSpectrumFile] = L1[BestSpectrumFile];
                NewLoc[GenomicColumns.BestSpectrumScanNum] = L1[BestSpectrumScanNum];
                NewLoc[GenomicColumns.Peptide] = L1[Peptide];
                NewLoc[GenomicColumns.SpectrumFilePos] = L1[SpectrumFilePos];
                NewLoc[GenomicColumns.BestMQScore] = L1[BestMQScore];
                NewLoc[GenomicColumns.BestFScore] = L1[BestFScore];
                NewLoc[GenomicColumns.BestFDR] = L1[BestFDR];
                NewLoc[GenomicColumns.BestSpecProb] = L1[BestSpecProb];
                NewLoc[GenomicColumns.ProteinName] = L1[ProteinName];
                NewLoc[GenomicColumns.DBFileName] = L1[DBFileName];
                NewLoc[GenomicColumns.SequenceName] = L1[SequenceName];
                NewLoc[GenomicColumns.Start] = L1[Start];
                NewLoc[GenomicColumns.End] = L1[End];
                NewLoc[GenomicColumns.Strand] = L1[Strand];
                NewLoc[GenomicColumns.SplicedSequence] = L1[SplicedSequence];
                NewLoc[GenomicColumns.Splices] = L1[Splices];
                NewLoc[GenomicColumns.IsUnique] = L1[IsUnique];
                NewLoc[GenomicColumns.IsNovel] = L1[IsNovel];
                NewLoc[GenomicColumns.Charge] = L1[Charge];
                NewLoc[GenomicColumns.LocationCount] = L1[LocationCount];
                NewLoc[GenomicColumns.BestLocalFDR] = L1[BestLocalFDR];
            }
            return NewLoc;
        }

        public static int compare(Object[] L1, Object[] L2) {
            if (GenomicColumns.IsSameLocation(L1, L2)) {
                return 0;
            }
            Integer Str1 = (Integer)L1[Strand];
            Integer Str2 = (Integer)L2[Strand];
            if (Str1 < Str2) {
                return -1;
            }
            if (Str1 > Str2) {
                return 1;
            }
            Integer S1 = (Integer)L1[Start];
            Integer S2 = (Integer)L2[Start];
            if (S1 < S2) {
                return -1;
            }
            if (S1 > S2) {
                return 1;
            }
            Integer E1 = (Integer)L1[End];
            Integer E2 = (Integer)L2[End];
            if (E1 < E2) {
                return -1;
            }
            if (E1 > E2) {
                return 1;
            }
            String Splices1 = (String)L1[SplicedSequence];
            String Splices2 = (String)L2[SplicedSequence];
            if (Splices1.compareTo(Splices2) < 0) {
                return -1;
            }
            if (Splices1.compareTo(Splices2) > 0) {
                return 1;
            }
            Splices1 = (String)L1[Splices];
            Splices2 = (String)L2[Splices];
            if (Splices1.compareTo(Splices2) < 0) {
                return -1;
            }
            if (Splices1.compareTo(Splices2) > 0) {
                return 1;
            }
            System.err.println("WHY ARE THESE NOT THE SAME!!!!");
            System.exit(5);
            return 0;
        }

        public static int GetDistance(Object[] L1, Object[] L2) {
            int E2;
            int S2;
            int E1;
            boolean Debug = false;
            String Seq1 = ((String)L1[SequenceName]).toLowerCase();
            int Strand1 = (Integer)L1[Strand];
            String Seq2 = ((String)L2[SequenceName]).toLowerCase();
            int Strand2 = (Integer)L2[Strand];
            if (Strand1 != Strand2) {
                if (Debug) {
                    System.out.println("Strand: " + Strand1 + "!=" + Strand2);
                }
                return -1;
            }
            if (Seq1.compareTo(Seq2) != 0) {
                if (Debug) {
                    System.out.println("Seq: " + Seq1 + "!=" + Seq2);
                }
                return -1;
            }
            int S1 = (Integer)L1[Start];
            if (Utils.HasOverlap(S1, E1 = ((Integer)L1[End]).intValue(), S2 = ((Integer)L2[Start]).intValue(), E2 = ((Integer)L2[End]).intValue())) {
                return 0;
            }
            if (S2 >= E1) {
                if (Debug) {
                    System.out.println("Greater: " + S2 + ">=" + E1);
                }
                return S2 - E1;
            }
            if (S1 >= E2) {
                if (Debug) {
                    System.out.println("Less: " + S1 + ">=" + E2);
                }
                return S1 - E2;
            }
            System.err.println("WHAT DID WE NOT CONSIDER IN DISTANCE?");
            System.err.println(GenomicColumns.toString(L1, "\t"));
            System.err.println(GenomicColumns.toString(L2, "\t"));
            System.exit(0);
            return -1;
        }

        public static int GetDistanceNoStrand(Object[] L1, Object[] L2) {
            int E2;
            int S2;
            int E1;
            String Seq2;
            boolean Debug = false;
            String Seq1 = ((String)L1[SequenceName]).toLowerCase();
            if (Seq1.compareTo(Seq2 = ((String)L2[SequenceName]).toLowerCase()) != 0) {
                if (Debug) {
                    System.out.println("Seq: " + Seq1 + "!=" + Seq2);
                }
                return -1;
            }
            int S1 = (Integer)L1[Start];
            if (Utils.HasOverlap(S1, E1 = ((Integer)L1[End]).intValue(), S2 = ((Integer)L2[Start]).intValue(), E2 = ((Integer)L2[End]).intValue())) {
                return 0;
            }
            if (S2 >= E1) {
                if (Debug) {
                    System.out.println("Greater: " + S2 + ">=" + E1);
                }
                return S2 - E1;
            }
            if (S1 >= E2) {
                if (Debug) {
                    System.out.println("Less: " + S1 + ">=" + E2);
                }
                return S1 - E2;
            }
            System.err.println("WHAT DID WE NOT CONSIDER IN DISTANCE?");
            System.err.println(GenomicColumns.toString(L1, "\t"));
            System.err.println(GenomicColumns.toString(L2, "\t"));
            System.exit(0);
            return -1;
        }

        public static String[] LoadAllPeptides(String inputDir) {
            String[] inputFiles = null;
            if (Utils.IsFile(inputDir)) {
                inputFiles = new String[]{inputDir};
            } else if (Utils.IsDir(inputDir)) {
                inputFiles = Utils.ListDir(inputDir);
            } else {
                ErrorThrower.ThrowWarning(1, inputDir);
                return null;
            }
            HashSet<String> peptides = new HashSet<String>();
            int f = 0;
            while (f < inputFiles.length) {
                BufferedReader Reader2 = Utils.openBufferedReader(inputFiles[f]);
                String Line = Utils.readNextLine(Reader2, inputFiles[f]);
                while (Line != null) {
                    if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                        Line = Utils.readNextLine(Reader2, inputFiles[f]);
                        continue;
                    }
                    Object[] Loc = GenomicColumns.LoadFromString(Line);
                    String pep = Utils.RemoveFlankingAAs((String)Loc[Peptide]);
                    peptides.add(pep);
                    Line = Utils.readNextLine(Reader2, inputFiles[f]);
                }
                Utils.closeBufferedReader(Reader2, inputFiles[f]);
                ++f;
            }
            return Utils.ConvertHashSetToStringArray(peptides);
        }
    }
}

