/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import org.systemsbiology.jrap.stax.Scan;
import specUtils.SpectrumLoader;
import specUtils.SpectrumWriter;

public class FilterPepNovoSQS {
    public static String usageInfo = "specUtils.FilterPepNovoSQS version 10.11.2010\nUses the PepNovo SQS to filter a directory of MGF files\nThe spectra a reshuffled to a fewer number of files\n[REQUIRED]:\n -r [DIR] Directory containing PepNovo SQS results\n -s [DIR] Spectrum directory\n -w [DIR] Directory to write filtered spectra to\n -q [NUM] Minimum spectrum quality score (0 - 1.0)\n[OPTIONAL]:\n -m [NUM] Max spectra written to a file (default 40,000)\n";
    private int maxSpectraPerFile = 40000;
    private double minSQS;
    private String scoreDir;
    private String spectrumDir;
    private String outputDir;
    private boolean debug = false;

    public FilterPepNovoSQS(String inputDir, String specDir, String outputDir2, double sqs) {
        if (!Utils.IsDir(inputDir)) {
            System.err.println("ERROR: Invalid directory '" + inputDir + "'!");
            System.exit(-1);
        }
        if (!Utils.IsDir(specDir)) {
            System.err.println("ERROR: Invalid directory '" + specDir + "'!");
            System.exit(-1);
        }
        if (!Utils.IsDir(outputDir2)) {
            Utils.MakeDir(outputDir2);
        }
        if (sqs < 0.0 || sqs > 1.0) {
            System.err.println("ERROR: Invalid spectrum quality score '" + sqs + "'! Must be between 0 and 1");
            System.exit(-1);
        }
        this.scoreDir = inputDir;
        this.spectrumDir = specDir;
        this.outputDir = outputDir2;
        this.minSQS = sqs;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-s", "-w", "-q", "-m"};
        boolean[] values = new boolean[]{true, true, true, true, true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(commandLineArgs.containsKey("-r") && commandLineArgs.containsKey("-w") && commandLineArgs.containsKey("-s") && commandLineArgs.containsKey("-q"))) {
            System.err.println("ERROR: Missing arguments!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputDir = (String)commandLineArgs.get("-r");
        String specDir = (String)commandLineArgs.get("-s");
        String outputDir = (String)commandLineArgs.get("-w");
        double SQS = Double.parseDouble((String)commandLineArgs.get("-q"));
        FilterPepNovoSQS f = new FilterPepNovoSQS(inputDir, specDir, outputDir, SQS);
        if (commandLineArgs.containsKey("-m")) {
            int maxSpectra;
            f.maxSpectraPerFile = maxSpectra = Integer.parseInt((String)commandLineArgs.get("-m"));
        }
        f.Filter();
    }

    private String getSpecFileFromScoreFile(String scoreFileName) {
        String baseName = Utils.GetBaseName(scoreFileName);
        int index = baseName.indexOf(".sqs.txt");
        baseName = baseName.substring(0, index);
        String currSpecFileName = String.valueOf(this.spectrumDir) + File.separator + baseName + ".mgf";
        return currSpecFileName;
    }

    private void Filter() {
        OutputStreamWriter currOutputFile = null;
        OutputStreamWriter currMapFile = null;
        String currOutputFileName = null;
        int writtenSpectra = 0;
        int currOutputFileCount = 0;
        int totalSpectrumCount = 0;
        int totalWrittenCount = 0;
        String[] scoreFiles = Utils.ListDir(this.scoreDir);
        scoreFiles = (String[])Utils.SortIncreasingOrder((Comparable[])scoreFiles);
        boolean Write = false;
        int i = 0;
        while (i < scoreFiles.length) {
            String ext = Utils.GetFileExtension(scoreFiles[i]);
            if (ext.compareTo(".txt") == 0) {
                String currSpecFileName = this.getSpecFileFromScoreFile(scoreFiles[i]);
                System.out.println("Spectrum File: " + currSpecFileName);
                System.out.println("Score File: " + scoreFiles[i]);
                BufferedReader scoreReader = null;
                String scoreLine = null;
                try {
                    scoreReader = new BufferedReader(new FileReader(scoreFiles[i]));
                    scoreLine = scoreReader.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                if (currOutputFileName == null) {
                    String baseName = Utils.GetBaseName(currSpecFileName);
                    String[] fileBits = baseName.split("[.]");
                    currOutputFileName = String.valueOf(this.outputDir) + File.separator + fileBits[0] + "." + currOutputFileCount + ".fil.mgf";
                    String currMapFileName = String.valueOf(Utils.GetFileNameNoExtension(currOutputFileName)) + ".map";
                    System.out.println("Starting new output file: " + currOutputFileName + ", " + currMapFileName);
                    ++currOutputFileCount;
                    if (currOutputFileName.compareTo("/Users/Natalie/Documents/UCSD/Maize/FilteredSpectra/SQS02Clusters/Maize-GermKernel_Clustered_Clustered.22.fil.mgf") == 0) {
                        Write = true;
                    }
                    if (!Write) {
                        System.out.println("But not writing!");
                    }
                    writtenSpectra = 0;
                    try {
                        if (Write) {
                            currOutputFile = new FileWriter(currOutputFileName);
                            currMapFile = new FileWriter(currMapFileName);
                            currMapFile.write("#CurrScanNum\tOldScanFile\tOldScanNum\n");
                        }
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                }
                SpectrumLoader specLoader = new SpectrumLoader(currSpecFileName);
                specLoader.openSequential();
                int oldSpecFileScanNum = 0;
                int newSpecFileScanNum = 0;
                Scan currScan = specLoader.getNextScan();
                while (scoreLine != null) {
                    if ((scoreLine = scoreLine.trim()).length() == 0 || this.isPepNovoSQSHeaderLine(scoreLine)) {
                        if (this.debug) {
                            System.out.println("Skipping line '" + scoreLine + "'");
                        }
                        try {
                            scoreLine = scoreReader.readLine();
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                        continue;
                    }
                    String[] headerBits = scoreLine.split(" ");
                    int sqsSpecNum = Integer.parseInt(headerBits[2]);
                    if (this.debug) {
                        System.out.println("headerLine: " + scoreLine);
                        System.out.println("SpecNum: " + sqsSpecNum);
                    }
                    while (oldSpecFileScanNum < sqsSpecNum) {
                        if (this.debug) {
                            System.out.println("MGFSpecNum is only " + oldSpecFileScanNum + ". progressing...");
                        }
                        currScan = specLoader.getNextScan();
                        ++oldSpecFileScanNum;
                        if (currScan != null && currScan.header != null) continue;
                        System.err.println("ERROR: currScan is null for scanNum: " + oldSpecFileScanNum);
                        System.err.println("ERROR: trying to reach " + sqsSpecNum);
                    }
                    try {
                        scoreLine = scoreReader.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    String[] scoreBits = scoreLine.split("\t");
                    String[] sqsBits = scoreBits[0].split(" ");
                    double currScore = Double.parseDouble(sqsBits[1]);
                    if (this.debug) {
                        System.out.println("sqsLine: " + scoreLine);
                        System.out.println("sqs: " + currScore);
                    }
                    try {
                        scoreLine = scoreReader.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    if (currScore >= this.minSQS) {
                        try {
                            if (Write) {
                                currOutputFile.write(SpectrumWriter.WriteScanAsMGF(currScan));
                                currMapFile.write(String.valueOf(newSpecFileScanNum) + "\t" + currSpecFileName + "\t" + oldSpecFileScanNum + "\n");
                            }
                            ++newSpecFileScanNum;
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                        ++writtenSpectra;
                        ++totalWrittenCount;
                        if (this.debug) {
                            System.out.println("Line is good");
                        }
                    } else if (this.debug) {
                        System.out.println("This line is no good: " + scoreLine);
                    }
                    ++totalSpectrumCount;
                    if (this.debug) {
                        System.out.println("Spectra in this file: " + writtenSpectra);
                        System.out.println("Total spectra written: " + totalWrittenCount + "/" + totalSpectrumCount);
                        Utils.WaitForEnter();
                    }
                    if (currOutputFileName == null || writtenSpectra == this.maxSpectraPerFile) {
                        try {
                            if (Write) {
                                currOutputFile.close();
                                currMapFile.close();
                            }
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                        String baseName = Utils.GetBaseName(currSpecFileName);
                        String[] fileBits = baseName.split("[.]");
                        currOutputFileName = String.valueOf(this.outputDir) + File.separator + fileBits[0] + "." + currOutputFileCount + ".fil.mgf";
                        String currMapFileName = String.valueOf(Utils.GetFileNameNoExtension(currOutputFileName)) + ".map";
                        System.out.println("Starting new output file: " + currOutputFileName + ", " + currMapFileName);
                        ++currOutputFileCount;
                        writtenSpectra = 0;
                        newSpecFileScanNum = 0;
                        if (currOutputFileName.compareTo("/Users/Natalie/Documents/UCSD/Maize/FilteredSpectra/SQS02Clusters/Maize-GermKernel_Clustered_Clustered.22.fil.mgf") == 0) {
                            Write = true;
                        }
                        if (!Write) {
                            System.out.println("But not writing!");
                        }
                        try {
                            if (Write) {
                                currOutputFile = new FileWriter(currOutputFileName);
                                currMapFile = new FileWriter(currMapFileName);
                                currMapFile.write("#CurrScanNum\tOldScanFile\tOldScanNum\n");
                            }
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                    }
                    try {
                        scoreLine = scoreReader.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                }
                try {
                    scoreReader.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                specLoader.closeSequential();
            }
            ++i;
        }
        try {
            if (Write) {
                currOutputFile.close();
                currMapFile.close();
            }
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Wrote " + totalWrittenCount + " of " + totalSpectrumCount + " spectra");
    }

    private boolean isPepNovoSQSHeaderLine(String scoreLine) {
        if (scoreLine == null || scoreLine.length() == 0) {
            return false;
        }
        if (scoreLine.indexOf("PepNovo+") >= 0) {
            return true;
        }
        if (scoreLine.indexOf("Copyright") >= 0) {
            return true;
        }
        if (scoreLine.indexOf("Created by") >= 0) {
            return true;
        }
        if (scoreLine.indexOf("Initializing models") >= 0) {
            return true;
        }
        if (scoreLine.indexOf("Fragment tolerance") >= 0) {
            return true;
        }
        if (scoreLine.indexOf("PM tolernace") >= 0 || scoreLine.indexOf("PM Tolerance") >= 0) {
            return true;
        }
        return scoreLine.indexOf("PTMs considered") >= 0;
    }
}

