/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.systemsbiology.jrap.stax.Scan;
import specUtils.MGFExtractor;
import specUtils.SpectrumLoader;

public class GetUnannotatedSpectra {
    public static String usageInfo = "specUtils.GetUnannotatedSpectra\nUsage: java -jar GetUnannotatedSpectra.jar\n -r [FILE/DIR] File or directory containing PValued results\n -s [FILE/DIR] File or directory containing spectra\n -w [FILE/DIR] File or directory to write spectra to\n";
    private String[] inputFiles = null;
    private String[] specFiles = null;
    private String[] outputFiles = null;

    public GetUnannotatedSpectra(String inputDir, String outputDir, String specDir) {
        if (Utils.IsDir(inputDir)) {
            this.inputFiles = Utils.ListDir(inputDir);
        } else if (Utils.IsFile(inputDir)) {
            this.inputFiles = new String[1];
            this.inputFiles[0] = inputDir;
        } else {
            System.err.println("ERROR: Input file/dir is invalid '" + inputDir + "'");
            System.exit(-1);
        }
        if (Utils.IsDir(specDir)) {
            this.specFiles = Utils.ListDir(specDir);
        } else if (Utils.IsFile(specDir)) {
            this.specFiles = new String[1];
            this.specFiles[0] = specDir;
        } else {
            System.err.println("ERROR: Spectrum file/dir is invalid '" + specDir + "'");
            System.exit(-1);
        }
        if (Utils.IsDir(outputDir)) {
            this.outputFiles = new String[this.specFiles.length];
            int i = 0;
            while (i < this.outputFiles.length) {
                this.outputFiles[i] = String.valueOf(outputDir) + File.separator + Utils.GetBaseName(this.specFiles[i]);
                ++i;
            }
        } else {
            this.outputFiles = new String[1];
            this.outputFiles[0] = outputDir;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-s"};
        boolean[] values = new boolean[]{true, true, true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(commandLineArgs.containsKey("-r") && commandLineArgs.containsKey("-s") && commandLineArgs.containsKey("-w"))) {
            System.err.println("ERROR: Must specify an input, spectrum, and output file/dir!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputDir = (String)commandLineArgs.get("-r");
        String outputDir = (String)commandLineArgs.get("-w");
        String specDir = (String)commandLineArgs.get("-s");
        GetUnannotatedSpectra getter = new GetUnannotatedSpectra(inputDir, outputDir, specDir);
        getter.getSpectra();
    }

    private void getSpectra() {
        Hashtable acceptedScans = InspectAnnotation.LoadInspectAnnotationsIntoSpecHash(this.inputFiles);
        FileWriter f = null;
        int i = 0;
        while (i < this.specFiles.length) {
            SpectrumLoader l = new SpectrumLoader(this.specFiles[i]);
            String fileName = Utils.GetBaseName(this.specFiles[i]);
            System.out.println("Loading spectra from " + fileName + "...");
            if (this.outputFiles.length > i) {
                System.out.println(" Writing filtered spectra to " + this.outputFiles[i]);
                try {
                    f = new FileWriter(this.outputFiles[i]);
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            } else {
                System.out.println(" Writing filtered spectra to " + this.outputFiles[0]);
                try {
                    f = new FileWriter(this.outputFiles[0], true);
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            int scanNum = 0;
            l.openSequential();
            Scan s = l.getNextScan();
            int keptScans = 0;
            while (s != null) {
                String hashKey = String.valueOf(fileName) + "_" + scanNum;
                if (!acceptedScans.containsKey(hashKey)) {
                    String scanStr = MGFExtractor.getMGFString(s);
                    ++keptScans;
                    try {
                        f.write(scanStr);
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                }
                s = l.getNextScan();
                ++scanNum;
            }
            try {
                f = new FileWriter(this.outputFiles[0], true);
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            System.out.println(" Kept " + keptScans);
            ++i;
        }
    }
}

