/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import basicUtils.Utils;
import java.util.Hashtable;
import org.systemsbiology.jrap.stax.Scan;
import specUtils.SpectrumLoader;

public class SpectrumAnalyzer {
    public static String UsageInfo = "specUtils.SpectrumAnalyzer version 2010.10.05\n -r [FILE] Spectrum file to analyze\n -w [FILE] Output file\n";
    private String inputFile;
    private String outputFile;

    public SpectrumAnalyzer(String inFile, String outFile) {
        if (!Utils.IsFile(inFile)) {
            System.err.println("ERROR: Invalide input file name '" + inFile + "'!");
            System.exit(-1);
        }
        this.inputFile = inFile;
        this.outputFile = outFile;
    }

    public void analyze() {
        int TotalSpectra = 0;
        int MaxPeaks = 0;
        int MaxPeaksScanNum = 0;
        int MinPeaks = Integer.MAX_VALUE;
        int MinPeaksScanNum = 0;
        double MaxPeakVal = 0.0;
        int MaxPeakValScanNum = 0;
        double MinPeakVal = Double.MAX_VALUE;
        int MinPeakValScanNum = 0;
        SpectrumLoader l = new SpectrumLoader(this.inputFile);
        l.openSequential();
        Scan s = l.getNextScan();
        while (s != null) {
            double[][] peaks;
            if (++TotalSpectra % 1000 == 0) {
                System.out.println(TotalSpectra);
            }
            if ((peaks = s.getMassIntensityList())[0].length > MaxPeaks) {
                MaxPeaks = peaks[0].length;
                MaxPeaksScanNum = s.getHeader().getNum();
            }
            if (peaks[0].length < MinPeaks) {
                MinPeaks = peaks[0].length;
                MinPeaksScanNum = s.getHeader().getNum();
            }
            int i = 0;
            while (i < peaks[0].length) {
                if (peaks[1][i] > MaxPeakVal) {
                    MaxPeakVal = peaks[1][i];
                    MaxPeakValScanNum = s.getHeader().getNum();
                }
                if (peaks[1][i] < MinPeakVal) {
                    MinPeakVal = peaks[1][i];
                    MinPeakValScanNum = s.getHeader().getNum();
                }
                ++i;
            }
            s = l.getNextScan();
        }
        l.closeSequential();
        System.out.println("Total Scans: " + TotalSpectra);
        System.out.println("Max peak num of " + MaxPeaks + " from scan " + MaxPeaksScanNum);
        System.out.println("Min peak num of " + MinPeaks + " from scan " + MinPeaksScanNum);
        System.out.println("Max peak val of " + MaxPeakVal + " from scan " + MaxPeakValScanNum);
        System.out.println("Min peak val of " + MinPeakVal + " from scan " + MinPeakValScanNum);
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input file or directory and  output file");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String inputFile = (String)CommandLineArgs.get("-r");
        String outputFile = (String)CommandLineArgs.get("-w");
        SpectrumAnalyzer a = new SpectrumAnalyzer(inputFile, outputFile);
        a.analyze();
    }
}

