/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import basicUtils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;
import org.systemsbiology.jrap.stax.MSXMLParser;
import org.systemsbiology.jrap.stax.MSXMLSequentialParser;
import org.systemsbiology.jrap.stax.Scan;
import org.systemsbiology.jrap.stax.ScanHeader;

public class SpectrumLoader {
    public static final String UsageInfo = "basicUtils.SpectrumLoader\nTesting platform for parsing files\n[REQUIRED]\n-d [DIR] directory containing spectrum files to test (e.g. Inspect/SystemTest/)\n";
    private String fileName = null;
    private RandomAccessFile r = null;
    int ScanNumber = 0;
    private MSXMLSequentialParser p = null;
    private MSXMLParser pRand = null;
    private ParseMode mode = ParseMode.NONE;
    private FileType t;
    private boolean Debug = true;

    public SpectrumLoader(String fileName) {
        this.fileName = fileName;
        String extension = Utils.GetFileExtension(this.fileName);
        if (extension.toLowerCase().compareTo(".mzxml") == 0) {
            this.t = FileType.MZXML;
        } else if (extension.toLowerCase().compareTo(".mgf") == 0) {
            this.t = FileType.MGF;
        } else if (extension.toLowerCase().compareTo(".pkl") == 0) {
            this.t = FileType.PKL;
        } else if (extension.toLowerCase().compareTo(".dta") == 0) {
            this.t = FileType.DTA;
        } else if (extension.toLowerCase().compareTo(".ms2") == 0) {
            this.t = FileType.MS2;
        } else if (extension.toLowerCase().compareTo(".txt") == 0 && this.fileName.indexOf("_dta.txt") >= 0) {
            this.t = FileType.CDTA;
        } else {
            System.err.println("ERROR: Unable to identify format of '" + this.fileName + "'");
            System.exit(-1);
        }
    }

    public Scan getNextScan() {
        if (this.mode != ParseMode.SEQ) {
            System.err.println("ERROR: Cannot get next scan for non-sequential parse!");
            return null;
        }
        if (this.t == FileType.MZXML) {
            if (!this.p.hasNextScan()) {
                return null;
            }
            Scan r = null;
            try {
                r = this.p.getNextScan();
            }
            catch (Exception E) {
                E.printStackTrace();
                return null;
            }
            return r;
        }
        if (this.r == null) {
            System.err.println("ERROR: Spectrum file has not been opened!");
            return null;
        }
        return this.loadNextNonMZXMLScan();
    }

    private Scan loadNextNonMZXMLScan() {
        if (this.t == FileType.MGF) {
            return this.loadNextMGFScan();
        }
        if (this.t == FileType.MS2) {
            return this.loadNextMS2();
        }
        if (this.t == FileType.PKL) {
            return this.loadNextPKL();
        }
        if (this.t == FileType.DTA) {
            return this.loadNextDTA();
        }
        if (this.t == FileType.CDTA) {
            return this.loadNextCDTA();
        }
        return null;
    }

    private Scan loadNextPKL() {
        double[][] MassIntensityList;
        String Line = null;
        try {
            Line = this.r.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Scan ret = null;
        ArrayList<Double> PeakList = null;
        ArrayList<Double> IntensityList = null;
        boolean HeaderFound = false;
        while (Line != null) {
            String[] Bits;
            if ((Line = Line.trim()).length() == 0) {
                if (ret != null) {
                    MassIntensityList = new double[2][PeakList.size()];
                    int i = 0;
                    while (i < PeakList.size()) {
                        MassIntensityList[0][i] = (Double)PeakList.get(i);
                        MassIntensityList[1][i] = (Double)IntensityList.get(i);
                        ++i;
                    }
                    ret.setMassIntensityList(MassIntensityList);
                    return ret;
                }
                try {
                    Line = this.r.readLine();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!HeaderFound) {
                ret = new Scan();
                ret.header = new ScanHeader();
                PeakList = new ArrayList<Double>();
                IntensityList = new ArrayList<Double>();
                ret.header.setNum(this.ScanNumber);
                ++this.ScanNumber;
                ret.header.setMsLevel(2);
                Bits = Line.split(" ");
                float ParentMass = Float.parseFloat(Bits[0]);
                float ParentIntensity = Float.parseFloat(Bits[1]);
                int Charge = Integer.parseInt(Bits[2]);
                ret.header.setPrecursorCharge(Charge);
                ret.header.setPrecursorIntensity(ParentIntensity);
                ret.header.setPrecursorMz((ParentMass + (float)(Charge - 1) * 1.0078f) / (float)Charge);
                HeaderFound = true;
            } else {
                if (ret == null) {
                    return null;
                }
                Bits = Line.split(" ");
                PeakList.add(new Double(Double.parseDouble(Bits[0])));
                IntensityList.add(new Double(Double.parseDouble(Bits[1])));
            }
            try {
                Line = this.r.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (ret == null) {
            return ret;
        }
        MassIntensityList = new double[2][PeakList.size()];
        int i = 0;
        while (i < PeakList.size()) {
            MassIntensityList[0][i] = (Double)PeakList.get(i);
            MassIntensityList[1][i] = (Double)IntensityList.get(i);
            ++i;
        }
        ret.setMassIntensityList(MassIntensityList);
        return ret;
    }

    private Scan loadNextDTA() {
        String Line = null;
        try {
            Line = this.r.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Scan ret = null;
        ArrayList<Double> PeakList = null;
        ArrayList<Double> IntensityList = null;
        boolean HeaderFound = false;
        while (Line != null) {
            String[] Bits;
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = this.r.readLine();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!HeaderFound) {
                ret = new Scan();
                ret.header = new ScanHeader();
                PeakList = new ArrayList<Double>();
                IntensityList = new ArrayList<Double>();
                ret.header.setNum(this.ScanNumber);
                ++this.ScanNumber;
                ret.header.setMsLevel(2);
                Bits = Line.split(" ");
                float ParentMass = Float.parseFloat(Bits[0]);
                int Charge = Integer.parseInt(Bits[1]);
                ret.header.setPrecursorCharge(Charge);
                ret.header.setPrecursorMz((ParentMass + (float)(Charge - 1) * 1.0078f) / (float)Charge);
                HeaderFound = true;
            } else {
                if (ret == null) {
                    return null;
                }
                Bits = Line.split(" ");
                PeakList.add(new Double(Double.parseDouble(Bits[0])));
                IntensityList.add(new Double(Double.parseDouble(Bits[1])));
            }
            try {
                Line = this.r.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (ret == null) {
            return ret;
        }
        double[][] MassIntensityList = new double[2][PeakList.size()];
        int i = 0;
        while (i < PeakList.size()) {
            MassIntensityList[0][i] = (Double)PeakList.get(i);
            MassIntensityList[1][i] = (Double)IntensityList.get(i);
            ++i;
        }
        ret.setMassIntensityList(MassIntensityList);
        return ret;
    }

    private Scan loadNextMS2() {
        double[][] MassIntensityList;
        String Line = null;
        if (this.Debug) {
            try {
                System.out.println("FilePos: " + this.r.getFilePointer());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String OrigLine = null;
        try {
            OrigLine = this.r.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Scan ret = null;
        ArrayList<Double> PeakList = null;
        ArrayList<Double> IntensityList = null;
        while (OrigLine != null) {
            String[] Bits;
            if (this.Debug) {
                try {
                    System.out.println("FilePos: " + this.r.getFilePointer());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((Line = OrigLine.trim()).length() == 0 || Line.charAt(0) == '#' || Line.charAt(0) == 'H' || Line.charAt(0) == 'I' || Line.charAt(0) == 'D') {
                try {
                    OrigLine = this.r.readLine();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (Line.charAt(0) == 'S') {
                if (ret != null) {
                    if (this.Debug) {
                        System.out.println("Found a new S line!!");
                    }
                    MassIntensityList = new double[2][PeakList.size()];
                    int i = 0;
                    while (i < PeakList.size()) {
                        MassIntensityList[0][i] = (Double)PeakList.get(i);
                        MassIntensityList[1][i] = (Double)IntensityList.get(i);
                        ++i;
                    }
                    ret.setMassIntensityList(MassIntensityList);
                    try {
                        this.r.seek(this.r.getFilePointer() - (long)OrigLine.length() - 2L);
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    return ret;
                }
                ret = new Scan();
                ret.header = new ScanHeader();
                PeakList = new ArrayList<Double>();
                IntensityList = new ArrayList<Double>();
                Bits = Line.split("[ \t]+");
                if (this.Debug) {
                    System.out.println("Line: " + Line);
                    System.out.println("NumBits: " + Bits.length);
                    System.out.println("Bits[1]: " + Bits[1]);
                }
                ret.header.setNum(Integer.parseInt(Bits[1]));
                ret.header.setPrecursorMz(Float.parseFloat(Bits[3]));
                ret.header.setMsLevel(2);
            } else if (Line.charAt(0) == 'Z') {
                if (ret == null) {
                    return null;
                }
                Bits = Line.split("[ \t]+");
                ret.header.setPrecursorCharge(Integer.parseInt(Bits[1]));
            } else {
                if (ret == null) {
                    return null;
                }
                Bits = Line.split("[ \t]+");
                PeakList.add(new Double(Double.parseDouble(Bits[0])));
                IntensityList.add(new Double(Double.parseDouble(Bits[1])));
            }
            try {
                OrigLine = this.r.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (ret == null) {
            return ret;
        }
        MassIntensityList = new double[2][PeakList.size()];
        int i = 0;
        while (i < PeakList.size()) {
            MassIntensityList[0][i] = (Double)PeakList.get(i);
            MassIntensityList[1][i] = (Double)IntensityList.get(i);
            ++i;
        }
        ret.setMassIntensityList(MassIntensityList);
        return ret;
    }

    private Scan loadNextCDTA() {
        double[][] MassIntensityList;
        String Line = null;
        String OrigLine = null;
        try {
            OrigLine = this.r.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Scan ret = null;
        ArrayList<Double> PeakList = null;
        ArrayList<Double> IntensityList = null;
        boolean HeaderLine = false;
        while (OrigLine != null) {
            String[] Bits;
            Line = OrigLine.trim();
            if (Line.length() == 0 || Line.charAt(0) == '#') {
                try {
                    OrigLine = this.r.readLine();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (Line.charAt(0) == '=') {
                if (ret != null) {
                    MassIntensityList = new double[2][PeakList.size()];
                    int i = 0;
                    while (i < PeakList.size()) {
                        MassIntensityList[0][i] = (Double)PeakList.get(i);
                        MassIntensityList[1][i] = (Double)IntensityList.get(i);
                        ++i;
                    }
                    ret.setMassIntensityList(MassIntensityList);
                    try {
                        this.r.seek(this.r.getFilePointer() - (long)OrigLine.length());
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    return ret;
                }
                ret = new Scan();
                ret.header = new ScanHeader();
                PeakList = new ArrayList<Double>();
                IntensityList = new ArrayList<Double>();
                Bits = Line.split("[.]");
                ret.header.setNum(Integer.parseInt(Bits[1]));
                ret.header.setMsLevel(2);
                HeaderLine = true;
            } else {
                if (ret == null) {
                    return null;
                }
                if (HeaderLine) {
                    Bits = Line.split(" ");
                    float ParentMass = Float.parseFloat(Bits[0]);
                    int Charge = Integer.parseInt(Bits[1]);
                    float ParentMZ = (ParentMass + (float)(Charge - 1) * 1.0078f) / (float)Charge;
                    ret.header.setPrecursorMz(ParentMZ);
                    ret.header.setPrecursorCharge(Charge);
                    HeaderLine = false;
                } else {
                    Bits = Line.split(" ");
                    PeakList.add(new Double(Double.parseDouble(Bits[0])));
                    IntensityList.add(new Double(Double.parseDouble(Bits[1])));
                }
            }
            try {
                OrigLine = this.r.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (ret == null) {
            return ret;
        }
        MassIntensityList = new double[2][PeakList.size()];
        int i = 0;
        while (i < PeakList.size()) {
            MassIntensityList[0][i] = (Double)PeakList.get(i);
            MassIntensityList[1][i] = (Double)IntensityList.get(i);
            ++i;
        }
        ret.setMassIntensityList(MassIntensityList);
        return ret;
    }

    private Scan loadNextMGFScan() {
        double[][] MassIntensityList;
        String Line = null;
        try {
            Line = this.r.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Scan ret = null;
        ArrayList<Double> PeakList = null;
        ArrayList<Double> IntensityList = null;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = this.r.readLine();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (Line.compareTo("BEGIN IONS") == 0) {
                ret = new Scan();
                ret.header = new ScanHeader();
                PeakList = new ArrayList<Double>();
                IntensityList = new ArrayList<Double>();
                ret.header.setNum(this.ScanNumber);
                ++this.ScanNumber;
                ret.header.setMsLevel(2);
            } else {
                String[] Bits;
                if (Line.compareTo("END IONS") == 0) {
                    if (ret == null) {
                        return null;
                    }
                    if (PeakList.size() != IntensityList.size()) {
                        System.err.println("ERROR: In Scan " + ret.header.getNum() + ", PeakList size(" + PeakList.size() + ") != IntensityList size (" + IntensityList.size() + ")!");
                        return null;
                    }
                    MassIntensityList = new double[2][PeakList.size()];
                    int i = 0;
                    while (i < PeakList.size()) {
                        MassIntensityList[0][i] = (Double)PeakList.get(i);
                        MassIntensityList[1][i] = (Double)IntensityList.get(i);
                        ++i;
                    }
                    ret.setMassIntensityList(MassIntensityList);
                    return ret;
                }
                if (Line.indexOf("PEPMASS") >= 0) {
                    if (ret == null) {
                        return null;
                    }
                    Bits = Line.split("=");
                    String[] PrecursorStuff = Bits[1].split(" ");
                    ret.header.setPrecursorMz(Float.parseFloat(PrecursorStuff[0]));
                    if (PrecursorStuff.length > 1) {
                        ret.header.setPrecursorIntensity(Float.parseFloat(PrecursorStuff[1]));
                    }
                } else if (Line.indexOf("CHARGE") >= 0) {
                    if (ret == null) {
                        return null;
                    }
                    Bits = Line.split("=");
                    String C = Bits[1].trim();
                    if ((C = C.split(" ")[0]).charAt(C.length() - 1) == '+') {
                        C = C.substring(0, C.length() - 1);
                    }
                    ret.header.setPrecursorCharge(Integer.parseInt(C));
                } else if (Line.indexOf("PRECURSOR_INTENSITY") >= 0) {
                    if (ret == null) {
                        return null;
                    }
                    Bits = Line.split("=");
                    ret.header.setPrecursorIntensity(Float.parseFloat(Bits[1]));
                } else {
                    if (ret == null) {
                        return null;
                    }
                    Bits = Line.split(" ");
                    if (Bits.length == 2) {
                        try {
                            PeakList.add(new Double(Double.parseDouble(Bits[0])));
                            IntensityList.add(new Double(Double.parseDouble(Bits[1])));
                        }
                        catch (Exception E) {
                            E.printStackTrace();
                            return null;
                        }
                    }
                }
            }
            try {
                Line = this.r.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (ret == null) {
            return ret;
        }
        MassIntensityList = new double[2][PeakList.size()];
        int i = 0;
        while (i < PeakList.size()) {
            MassIntensityList[0][i] = (Double)PeakList.get(i);
            MassIntensityList[1][i] = (Double)IntensityList.get(i);
            ++i;
        }
        ret.setMassIntensityList(MassIntensityList);
        return ret;
    }

    public int countScansMGF() {
        int scanCount = 0;
        Scan currScan = this.loadNextMGFScan();
        while (currScan != null) {
            ++scanCount;
            currScan = this.loadNextMGFScan();
        }
        return scanCount;
    }

    public boolean openSequential() {
        if (this.mode != ParseMode.NONE) {
            System.err.println("ERROR: SpectrumLoader is already open in another mode!");
            return false;
        }
        this.mode = ParseMode.SEQ;
        if (this.t == FileType.MZXML) {
            this.p = new MSXMLSequentialParser();
            try {
                this.p.open(this.fileName);
            }
            catch (Exception E) {
                E.printStackTrace();
                return false;
            }
            return true;
        }
        this.ScanNumber = 0;
        try {
            this.r = new RandomAccessFile(this.fileName, "r");
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean closeSequential() {
        if (this.mode != ParseMode.SEQ) {
            System.err.println("ERROR: Cannot close the non-sequential file");
            return false;
        }
        this.mode = ParseMode.NONE;
        if (this.t == FileType.MZXML) {
            this.p.close();
        } else {
            try {
                this.r.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean openRandomAccess() {
        if (this.mode != ParseMode.NONE) {
            System.err.println("ERROR: SpectrumLoader is already open in another mode!");
            return false;
        }
        this.mode = ParseMode.RAND;
        if (this.t == FileType.MZXML) {
            this.pRand = new MSXMLParser(this.fileName);
            return true;
        }
        this.ScanNumber = 0;
        try {
            this.r = new RandomAccessFile(this.fileName, "r");
        }
        catch (IOException E) {
            E.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean closeRandomAcces() {
        if (this.mode != ParseMode.RAND) {
            System.err.println("ERROR: Cannot close the non-sequential file");
            return false;
        }
        this.mode = ParseMode.NONE;
        if (this.t == FileType.MZXML) {
            this.pRand = null;
        } else {
            try {
                this.r.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean RunSanityCheck(String FileName) {
        SpectrumLoader sLoader = new SpectrumLoader(FileName);
        if (!sLoader.openSequential()) {
            System.err.println("ERROR: Cannot open file " + FileName);
            System.exit(-1);
        }
        int ScanCount = 0;
        Scan CurrScan = sLoader.getNextScan();
        while (CurrScan != null) {
            if (CurrScan.getHeader().getPeaksCount() == 0) {
                System.out.println("Scan " + CurrScan.getHeader().getNum() + " has 0 peaks!");
                CurrScan = sLoader.getNextScan();
                continue;
            }
            double[][] Peaks = CurrScan.getMassIntensityList();
            int i = 0;
            while (i < Peaks[0].length) {
                if (Peaks[0][i] < 0.0) {
                    System.err.println("ERROR: Peak mass for scan " + CurrScan.getHeader().getNum() + " is " + Peaks[0][i]);
                    return false;
                }
                if (Peaks[1][i] <= 0.0) {
                    System.err.println("ERROR: Intensity for scan " + CurrScan.getHeader().getNum() + " is " + Peaks[1][i]);
                    return false;
                }
                if (i > 0 && Peaks[0][i] <= Peaks[0][i - 1]) {
                    System.err.println("ERROR: Peak masses for scan " + CurrScan.getHeader().getNum() + " are " + Peaks[0][i - 1] + " and " + Peaks[0][i]);
                    return false;
                }
                ++i;
            }
            CurrScan = sLoader.getNextScan();
            ++ScanCount;
        }
        System.out.println("Checked " + ScanCount + " scans...");
        return true;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-d"};
        boolean[] values = new boolean[]{true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-d")) {
            System.err.println("ERROR: You must specify an input directory");
            System.out.println(UsageInfo);
            return;
        }
        String Dir = (String)CommandLineArgs.get("-d");
        File D = new File(Dir);
        if (D.isFile()) {
            System.out.println("Running sanity check on " + Dir);
            if (!SpectrumLoader.RunSanityCheck(Dir)) {
                System.out.println("FAILED!");
            } else {
                System.out.println("SUCCESS!");
            }
            return;
        }
        if (!D.isDirectory()) {
            System.err.println("ERROR: Input '" + Dir + "' is not a valid directory!");
            System.out.println(UsageInfo);
            return;
        }
        System.out.println("TESTING...");
        String[] TestFiles = D.list();
        int i = 0;
        while (i < TestFiles.length) {
            System.out.println("Test File: " + TestFiles[i]);
            Utils.WaitForEnter();
            String FullName = String.valueOf(D.getAbsolutePath()) + File.separator + TestFiles[i];
            SpectrumLoader S = new SpectrumLoader(FullName);
            S.openSequential();
            Scan sc = S.getNextScan();
            int ScanCount = 0;
            while (sc != null) {
                if (sc.header.getMsLevel() >= 2) {
                    System.out.println(String.valueOf(sc.header.getNum()) + " " + sc.header.getPrecursorMz() + " " + sc.header.getPrecursorCharge());
                    ++ScanCount;
                }
                sc = S.getNextScan();
            }
            System.out.println("Total Scans: " + ScanCount);
            Utils.WaitForEnter();
            S.closeSequential();
            ++i;
        }
    }

    static enum FileType {
        MZXML,
        MGF,
        PKL,
        DTA,
        CDTA,
        MS2;

    }

    static enum ParseMode {
        SEQ,
        RAND,
        NONE;

    }
}

