/*
 * Decompiled with CFR 0.152.
 */
package trieUtils;

import basicUtils.Utils;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class ShuffleDB {
    public static final String usageInfo = "trieUtil.ShuffleDB.java version 2010.12.16\nPrepares a FASTA database for use with InsPecT\nUsage: java -jar PrepDB.jar\n[REQUIRED]:\n-r [FILE] .trie file to be converted \n[OPTIONAL]:\n-w [FILE] File to write formatted (.trie) db.  Default is to write to same location and name (with .RS.trie extension) as input file\n-o [FILE] Index file to write formatted index file to (.index).  Default is to write to same location and name (with .RS.index) extension as input .trie file, or output trie file\n-i [FILE] .index file to be converted Default is to expect a file by the same name as the input trie file (with the .index extension)\n";

    public static void main(String[] args) {
        String[] Commands = new String[]{"-r", "-w", "-o", "-i"};
        boolean[] Values = new boolean[]{true, true, true, true};
        Hashtable Options = Utils.ParseCommandLine(args, Commands, Values);
        if (!Options.containsKey("-r")) {
            System.err.println("ERROR: Must specify an input TRIE file");
            System.out.println(usageInfo);
            return;
        }
        String inputTrieFile = (String)Options.get("-r");
        String outputTrieFile = null;
        String inputIndexFile = null;
        String outputIndexFile = null;
        if (Options.containsKey("-w")) {
            outputTrieFile = (String)Options.get("-w");
        }
        if (Options.containsKey("-o")) {
            outputIndexFile = (String)Options.get("-o");
        }
        if (Options.containsKey("-i")) {
            inputIndexFile = (String)Options.get("-i");
        }
        if (TrieDB.reverseDB(inputTrieFile, inputIndexFile, outputTrieFile, outputIndexFile) == null) {
            System.err.println("ERROR: Unable to prepare TRIE file\n");
            System.exit(-1);
        }
    }
}

