/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import specUtils.SpectrumLoader;
import specUtils.SpectrumWriter;

public class GetAllAnnotatedSpectraMGF {
    public static String usageInfo = "basicUtils.GetAllAnnotatedSpectraMGF.java\nReads the Inspect result file and converts the annotated spectra to MGF\nUsage: java -jar GetAllAnnotatedSpectraMGF.jar\n -r [FILE/DIR] Directory or file containing inspect results\n -s [FILE/DIR] Directory or file containing spectra\n -o [DIR] Directory to write results to.  One file is created per spectrum file\n(-p [FILE] Protein list)\n";
    private Hashtable annotatedSpectra;
    private String[] inputFiles;
    private String[] spectrumFiles;
    private String outputDir;
    private String proteinFileName;
    private ArrayList peptideList;

    public GetAllAnnotatedSpectraMGF(String inputDir, String spectraDir, String outputDir, String proteinFileName) {
        if (Utils.IsDir(inputDir)) {
            this.inputFiles = Utils.ListDir(inputDir);
        } else if (Utils.IsFile(inputDir)) {
            this.inputFiles = new String[1];
            this.inputFiles[0] = inputDir;
        } else {
            System.err.println("ERROR: Invalid input file/directory '" + inputDir + "'!!");
            System.exit(-1);
        }
        if (Utils.IsDir(spectraDir)) {
            this.spectrumFiles = Utils.ListDir(spectraDir);
        } else if (Utils.IsFile(spectraDir)) {
            this.spectrumFiles = new String[1];
            this.spectrumFiles[0] = spectraDir;
        } else {
            System.err.println("ERROR: Invalid spectrum file/directory '" + spectraDir + "'!!");
            System.exit(-1);
        }
        if (!Utils.IsDir(outputDir)) {
            Utils.MakeDir(outputDir);
        }
        this.outputDir = outputDir;
        if (proteinFileName != null && !Utils.IsFile(proteinFileName)) {
            System.err.println("ERROR: Invalid protein file name '" + proteinFileName + "'!!");
            System.exit(-1);
        }
        this.proteinFileName = proteinFileName;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-s", "-o", "-p"};
        boolean[] values = new boolean[]{true, true, true, true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(commandLineArgs.containsKey("-r") && commandLineArgs.containsKey("-s") && commandLineArgs.containsKey("-o"))) {
            System.err.println("ERROR: Must specify an input file/directory, a spectrum file/dir, and an ourput file/dir!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputDir = (String)commandLineArgs.get("-r");
        String spectraDir = (String)commandLineArgs.get("-s");
        String outputDir = (String)commandLineArgs.get("-o");
        String proteinFile = null;
        if (commandLineArgs.containsKey("-p")) {
            proteinFile = (String)commandLineArgs.get("-p");
        }
        GetAllAnnotatedSpectraMGF g = new GetAllAnnotatedSpectraMGF(inputDir, spectraDir, outputDir, proteinFile);
        g.getSpectra();
    }

    /*
     * Unable to fully structure code
     */
    private void getSpectra() {
        if (this.proteinFileName != null) {
            this.loadProteinFile();
        }
        this.loadSpectrumHash();
        System.out.println("Extracting spectra...");
        i = 0;
        while (i < this.spectrumFiles.length) {
            block10: {
                keptSpectra = 0;
                specFileName = Utils.GetBaseName(this.spectrumFiles[i]);
                if (!this.annotatedSpectra.containsKey(specFileName)) break block10;
                sLoader = new SpectrumLoader(this.spectrumFiles[i]);
                sLoader.openSequential();
                s = sLoader.getNextScan();
                outputFilename = String.valueOf(this.outputDir) + File.separator + Utils.GetFileNameNoExtension(specFileName) + ".mgf";
                f = null;
                try {
                    f = new FileWriter(outputFilename);
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                annotatedScans = (int[])this.annotatedSpectra.get(specFileName);
                j = 0;
                ** GOTO lbl37
                {
                    s = sLoader.getNextScan();
                    do {
                        if (s.getHeader().getNum() < annotatedScans[j]) continue block7;
                        MGFScan = SpectrumWriter.WriteScanAsMGF(s);
                        ++keptSpectra;
                        try {
                            f.write(MGFScan);
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            System.exit(-1);
                        }
                        ++j;
lbl37:
                        // 2 sources

                    } while (j < annotatedScans.length);
                }
                System.out.println(" - Kept " + keptSpectra + " spectra from " + specFileName);
                try {
                    f.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                sLoader.closeSequential();
            }
            ++i;
        }
    }

    private void loadProteinFile() {
        BufferedReader buf = null;
        String line = null;
        this.peptideList = new ArrayList();
        try {
            buf = new BufferedReader(new FileReader(this.proteinFileName));
            line = buf.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            String[] uniquePeps = bits[3].split(",");
            int i = 0;
            while (i < uniquePeps.length) {
                if (!this.peptideList.contains(uniquePeps[i])) {
                    this.peptideList.add(uniquePeps[i]);
                }
                ++i;
            }
            String[] sharedPeps = bits[4].split(",");
            int i2 = 0;
            while (i2 < sharedPeps.length) {
                if (!this.peptideList.contains(sharedPeps[i2])) {
                    this.peptideList.add(sharedPeps[i2]);
                }
                ++i2;
            }
            try {
                line = buf.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("From the protein list, loaded " + this.peptideList.size() + " acceptable peptides");
    }

    private void loadSpectrumHash() {
        System.out.println("Loading annotated spectra from input directory...");
        this.annotatedSpectra = new Hashtable();
        int i = 0;
        while (i < this.inputFiles.length) {
            System.out.println(" - " + this.inputFiles[i]);
            Hashtable MappedScans = InspectAnnotation.GetAllAnnotatedScanNumsWithPeptides(this.inputFiles[i], this.peptideList);
            Enumeration E = MappedScans.keys();
            while (E.hasMoreElements()) {
                String f = (String)E.nextElement();
                int[] scans = (int[])MappedScans.get(f);
                if (this.annotatedSpectra.containsKey(f)) {
                    int[] oldScans = (int[])this.annotatedSpectra.get(f);
                    int[] mergedScans = Utils.MergeIntArraysInAscendingOrder(scans, oldScans);
                    this.annotatedSpectra.put(f, mergedScans);
                    continue;
                }
                this.annotatedSpectra.put(f, scans);
            }
            ++i;
        }
    }
}

