/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.InspectAnnotation;
import java.util.ArrayList;

public class Peptide {
    protected ArrayList SupportingSpectra = new ArrayList();
    protected String Sequence;
    protected boolean ModifiedFlag;
    protected Peptide[] RelatedPeptides;
    protected Peptide UnModdedVersion;

    public String GetUnModifiedPeptideString() {
        if (!this.ModifiedFlag) {
            return this.Sequence;
        }
        StringBuffer Buf = new StringBuffer();
        int i = 0;
        while (i < this.Sequence.length()) {
            if (this.Sequence.charAt(i) >= 'A' && this.Sequence.charAt(i) <= 'Z') {
                Buf.append(this.Sequence.charAt(i));
            }
            ++i;
        }
        return Buf.toString();
    }

    public Peptide(InspectAnnotation Ann) {
        this.SupportingSpectra.add(Ann);
        this.Sequence = Ann.Annotation;
        int i = 0;
        while (i < this.Sequence.length()) {
            if (this.Sequence.charAt(i) < 'A' || this.Sequence.charAt(i) > 'Z') {
                this.ModifiedFlag = true;
                break;
            }
            ++i;
        }
        if (!this.ModifiedFlag) {
            this.UnModdedVersion = this;
        }
    }

    public void AddAnnotation(InspectAnnotation Ann) {
        this.SupportingSpectra.add(Ann);
    }

    public void AddRelatedPeptide(Peptide NewPep) {
        Peptide[] NewRelated;
        if (!NewPep.ModifiedFlag) {
            this.UnModdedVersion = NewPep;
        }
        if (this.RelatedPeptides != null) {
            NewRelated = new Peptide[this.RelatedPeptides.length + 1];
            int i = 0;
            while (i < this.RelatedPeptides.length) {
                NewRelated[i] = this.RelatedPeptides[i];
                ++i;
            }
            NewRelated[this.RelatedPeptides.length] = NewPep;
        } else {
            NewRelated = new Peptide[]{NewPep};
        }
        this.RelatedPeptides = NewRelated;
    }

    public String GetSequence() {
        return this.Sequence;
    }

    public int GetNumSupportingSpectra() {
        return this.SupportingSpectra.size();
    }

    public ArrayList GetSupportingSpectra() {
        return this.SupportingSpectra;
    }

    public Peptide[] GetRelatedPeptides() {
        return this.RelatedPeptides;
    }

    public Peptide GetUnModifiedPeptide() {
        return this.UnModdedVersion;
    }
}

