/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import proteogenomicUtils.EventFinder;
import proteogenomicUtils.GenomicLocator;

public class CompareToTransposons {
    public static String UsageInfo = "proteogenomicUtils.CompareToTransposons version 10.18.2010\nCompares a list of novel gene events to the gff file of transposons\nREQUIRED:\n -r [FILE] Event file\n -g [FILE] GFF of transposons\n";
    private String eventFile;
    private String transposonGFF;
    private Hashtable NovelGenesBySeq;
    private boolean Debug = true;

    public CompareToTransposons(String eventFile, String transposonFile) {
        if (!Utils.IsFile(eventFile)) {
            ErrorThrower.ThrowError(1, eventFile);
        }
        if (!Utils.IsFile(transposonFile)) {
            ErrorThrower.ThrowError(1, transposonFile);
        }
        this.eventFile = eventFile;
        this.transposonGFF = transposonFile;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-g"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-g")) {
            System.err.println(UsageInfo);
            ErrorThrower.ThrowError(2);
        }
        String EventFile = (String)CommandLineArgs.get("-r");
        String TransposonFile = (String)CommandLineArgs.get("-g");
        CompareToTransposons c = new CompareToTransposons(EventFile, TransposonFile);
        c.Compare();
    }

    private void Compare() {
        EventFinder.Event[] eList = EventFinder.Event.LoadEventsFromFile(this.eventFile);
        System.out.println("Loaded " + eList.length + " events!!");
        this.NovelGenesBySeq = new Hashtable();
        int i = 0;
        while (i < eList.length) {
            if (eList[i].Type == EventFinder.EventType.NovelGene) {
                String SeqName = (String)((Object[])eList[i].getSupportingLocations().get(0))[GenomicLocator.GenomicColumns.SequenceName];
                SeqName = SeqName.toLowerCase();
                ArrayList currGenes = null;
                currGenes = this.NovelGenesBySeq.containsKey(SeqName) ? (ArrayList)this.NovelGenesBySeq.get(SeqName) : new ArrayList();
                currGenes.add(eList[i]);
                this.NovelGenesBySeq.put(SeqName, currGenes);
            }
            ++i;
        }
        System.out.println("Loaded novel genes for " + this.NovelGenesBySeq.size() + " sequences");
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(this.transposonGFF));
            Line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, this.transposonGFF);
        }
        String CurrSeq = null;
        ArrayList CurrEvents = null;
        int CurrEventIndex = 0;
        int OverlapCount = 0;
        int OverlapDiffStrandCount = 0;
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, this.transposonGFF);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            String RepeatSeqName = Bits[GFFFile.GFFColumns.SequenceName].toLowerCase();
            if (RepeatSeqName.indexOf("chr") < 0) {
                RepeatSeqName = "chr" + RepeatSeqName;
            }
            if (CurrSeq == null || RepeatSeqName.compareTo(CurrSeq) != 0) {
                CurrSeq = RepeatSeqName;
                if (this.NovelGenesBySeq.containsKey(RepeatSeqName)) {
                    CurrEvents = (ArrayList)this.NovelGenesBySeq.get(RepeatSeqName);
                    CurrEvents = EventFinder.Event.SortEvents(CurrEvents);
                } else {
                    CurrEvents = new ArrayList();
                }
                CurrEventIndex = 0;
                if (this.Debug) {
                    System.out.println("Starting a new sequence: " + RepeatSeqName);
                    System.out.println(" - have " + CurrEvents.size() + " events");
                    Utils.WaitForEnter();
                }
            }
            int RepeatStart = Integer.parseInt(Bits[GFFFile.GFFColumns.Start]) - 1;
            int RepeatEnd = Integer.parseInt(Bits[GFFFile.GFFColumns.End]);
            if (this.Debug) {
                System.out.println(Line);
                System.out.println("New repeat: " + RepeatStart + " - " + RepeatEnd);
            }
            if (CurrEventIndex < CurrEvents.size()) {
                EventFinder.Event CurrEvent = (EventFinder.Event)CurrEvents.get(CurrEventIndex);
                if (this.Debug) {
                    System.out.println("Comparing to new event:");
                    CurrEvent.DebugPrint();
                    Utils.WaitForEnter();
                }
                while (CurrEventIndex < CurrEvents.size() && !Utils.HasOverlap(CurrEvent.Start, CurrEvent.End, RepeatStart, RepeatEnd) && (CurrEvent.Start < RepeatStart || CurrEvent.Start == RepeatStart && CurrEvent.End < RepeatEnd)) {
                    if (this.Debug) {
                        System.out.println("Too low!");
                    }
                    CurrEvent = (EventFinder.Event)CurrEvents.get(++CurrEventIndex);
                    if (!this.Debug) continue;
                    System.out.println("Comparing to new event:");
                    CurrEvent.DebugPrint();
                    Utils.WaitForEnter();
                }
                if (Utils.HasOverlap(CurrEvent.Start, CurrEvent.End, RepeatStart, RepeatEnd)) {
                    int RepeatStrand;
                    int EventStrand;
                    if (this.Debug) {
                        System.out.println("OVERLAP!!");
                    }
                    if ((EventStrand = GFFFile.ParseStrand((String)((Object[])CurrEvent.getSupportingLocations().get(0))[GenomicLocator.GenomicColumns.Strand])) == (RepeatStrand = GFFFile.ParseStrand(Bits[GFFFile.GFFColumns.Strand]))) {
                        ++OverlapCount;
                        if (this.Debug) {
                            System.out.println("Same strand!!");
                        }
                    } else {
                        ++OverlapDiffStrandCount;
                        if (this.Debug) {
                            System.out.println("DIFF strand!!");
                        }
                    }
                } else if (this.Debug) {
                    System.out.println("Exceeded repeat!");
                }
                if (this.Debug) {
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, this.transposonGFF);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, this.transposonGFF);
        }
        System.out.println("Novel gene - transposon pairs: " + OverlapCount);
        System.out.println("Novel gene - transposon pairs (diff strand): " + OverlapCount);
    }
}

