/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import maizeUtils.MaizeUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class KnownClusterGroupAnalyzer {
    public static final String UsageInfo = "maizeUtils.KnownClusterGroupAnalyzer\nPlots distribution of shared cluster group sizes, as defined in\nmaizeUtils.MaizeProteinChooser\n[REQURIED]:\n -r [FILE] cluster group file\n -w [FILE] Output file prefix\n";
    private String inputFileName;
    private String outputFilePrefix;

    public KnownClusterGroupAnalyzer(String inputFileName, String outputFileName) {
        if (!Utils.IsFile(inputFileName)) {
            System.err.println("ERROR: Invalid input file name '" + inputFileName + "'!!!");
            System.exit(-1);
        }
        this.inputFileName = inputFileName;
        this.outputFilePrefix = outputFileName;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input file and an output name prefix!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String inputFileName = (String)CommandLineArgs.get("-r");
        String outputFileName = (String)CommandLineArgs.get("-w");
        KnownClusterGroupAnalyzer a = new KnownClusterGroupAnalyzer(inputFileName, outputFileName);
        a.analyzeGroups();
    }

    private void analyzeGroups() {
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.inputFileName));
            line = buf.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        HashSet<String> currLocii = new HashSet<String>();
        ArrayList<Double> peptideCounts = new ArrayList<Double>();
        ArrayList<Double> locusCounts = new ArrayList<Double>();
        ArrayList<Double> proteinCounts = new ArrayList<Double>();
        boolean localDebug = false;
        while (line != null) {
            String[] bits;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            if (line.indexOf("SisterGroup") >= 0) {
                if (currLocii.size() > 0) {
                    int bin = currLocii.size();
                    if (localDebug) {
                        System.out.println("DEBUG: This group has locus counts towards bin " + bin);
                    }
                    locusCounts.add(new Double(bin));
                    if (localDebug) {
                        Utils.WaitForEnter();
                    }
                }
                currLocii.clear();
                if (localDebug) {
                    System.out.println("DEBUG: Found header line '" + line + "'");
                }
                bits = line.split(",");
                int i = 0;
                while (i < bits.length) {
                    int bin;
                    String[] bits2 = bits[i].trim().split(":");
                    if (bits2[0].trim().compareTo("size") == 0) {
                        bin = Integer.parseInt(bits2[1].trim());
                        if (localDebug) {
                            System.out.println("DEBUG: This group has protein counts towards bin " + bin);
                        }
                        proteinCounts.add(new Double(bin));
                    } else if (bits2[0].trim().compareTo("peptides") == 0) {
                        bin = Integer.parseInt(bits2[1].trim());
                        if (localDebug) {
                            System.out.println("DEBUG: This group has peptide counts towards bin " + bin);
                        }
                        peptideCounts.add(new Double(bin));
                    }
                    ++i;
                }
            } else {
                bits = line.split("\t");
                String locusName = MaizeUtils.getMaizeGeneName(bits[1]);
                currLocii.add(locusName);
            }
            try {
                line = buf.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        String peptideHistoName = String.valueOf(this.outputFilePrefix) + ".peptide.png";
        String title = "Histogram of cluster groups by # peptides";
        String xAxis = "Number of peptides in cluster group";
        String yAxis = "Number of cluster groups";
        this.plotHistogram(Utils.ConvertArraylistToDoubleArray(peptideCounts), "Peptide Counts", xAxis, yAxis, title, peptideHistoName);
        String proteinHistoName = String.valueOf(this.outputFilePrefix) + ".proteins.png";
        title = "Histogram of clusters groups by # proteins";
        xAxis = "Number of proteins in cluster group";
        yAxis = "Number of cluster groups";
        this.plotHistogram(Utils.ConvertArraylistToDoubleArray(proteinCounts), "Protein Counts", xAxis, yAxis, title, proteinHistoName);
        String locusHistoName = String.valueOf(this.outputFilePrefix) + ".locii.png";
        title = "Histogram of clusters groups by # locii";
        xAxis = "Number of locii in cluster group";
        yAxis = "Number of cluster groups";
        this.plotHistogram(Utils.ConvertArraylistToDoubleArray(proteinCounts), "Locus Counts", xAxis, yAxis, title, locusHistoName);
    }

    private void plotHistogram(double[] dataPoints, String seriesName, String xAxis, String yAxis, String title, String outputFileName) {
        HistogramDataset ScoreHisto = new HistogramDataset();
        ScoreHisto.addSeries((Comparable)((Object)seriesName), dataPoints, 200);
        JFreeChart Chart = ChartFactory.createHistogram((String)title, (String)xAxis, (String)yAxis, (IntervalXYDataset)ScoreHisto, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        BufferedImage Image2 = Chart.createBufferedImage(1000, 1000);
        System.out.println("Created histo..." + outputFileName);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(outputFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
    }
}

