/*
 * Decompiled with CFR 0.152.
 */
package maizeUtils;

import basicUtils.Utils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import proteogenomicUtils.GenomicLocator;

public class NovelPeptideDiscoveryCurvePlotter {
    private static String UsageInfo = "maizeUtils.NovelPeptideDiscoveryCurvePlotter v2011.07.18\nPlots the discovery curve of novel peptides( and locations)\n[REQUIRED]:\n -r [FILE/DIR] Input file or directory with novel peptide locations\n -w [FILE] Output file (png format)\n[OPTIONAL]:\n -l Also plot locations on same image\n";
    private String PlotFile;
    private String[] InputFiles;
    private int[] DiscoveryCurveCounts;
    private int[] specCounts;
    private int[] LocationCounts;
    private boolean plotLocations = false;

    public NovelPeptideDiscoveryCurvePlotter(String InputDir, String OutputFile, boolean plotLocs) {
        if (Utils.IsDir(InputDir)) {
            this.InputFiles = Utils.ListDir(InputDir);
            this.PlotFile = OutputFile;
        } else {
            this.InputFiles = new String[1];
            this.InputFiles[0] = InputDir;
            this.PlotFile = OutputFile;
        }
        this.plotLocations = plotLocs;
    }

    private void PopulateHashes() {
        this.DiscoveryCurveCounts = new int[this.InputFiles.length];
        this.LocationCounts = new int[this.InputFiles.length];
        this.specCounts = new int[this.InputFiles.length];
        this.InputFiles = (String[])Utils.SortIncreasingOrder((Comparable[])this.InputFiles);
        HashSet<String> CurrPeptides = new HashSet<String>();
        int locCount = 0;
        int i = 0;
        while (i < this.InputFiles.length) {
            this.specCounts[i] = this.InputFiles[i].indexOf("Maize-Endosperm-10DAP_Clustered.20.fil") >= 0 ? 20826 : (this.InputFiles[i].indexOf("Maize-Endosperm-10DAP") >= 0 || this.InputFiles[i].indexOf("Maize-Endosperm-12DAP") >= 0 ? 40000 : 20000);
            System.out.println("Loading peptides from " + this.InputFiles[i] + ", " + this.specCounts[i] + " spectra");
            ArrayList Locations = GenomicLocator.GenomicColumns.LoadFromFile(this.InputFiles[i]);
            int j = 0;
            while (j < Locations.size()) {
                Object[] currLoc = (Object[])Locations.get(j);
                String CurrPeptide = Utils.GetUnModded((String)currLoc[GenomicLocator.GenomicColumns.Peptide]);
                if (!CurrPeptides.contains(CurrPeptide)) {
                    CurrPeptides.add(CurrPeptide);
                    locCount += ((Integer)currLoc[GenomicLocator.GenomicColumns.LocationCount]).intValue();
                }
                ++j;
            }
            this.DiscoveryCurveCounts[i] = CurrPeptides.size();
            System.out.println(String.valueOf(CurrPeptides.size()) + " " + locCount);
            this.LocationCounts[i] = locCount;
            ++i;
        }
    }

    private void PlotDiscoveryCurve() {
        String title = "Novel Peptide DiscoveryCurve (" + Utils.GetVersion() + ")";
        ApplicationFrame F = new ApplicationFrame(title);
        XYSeries series1 = new XYSeries((Comparable)((Object)"Peptides"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Locations"));
        int cumCount = 0;
        int i = 0;
        while (i < this.DiscoveryCurveCounts.length) {
            series1.add((double)(cumCount += this.specCounts[i]), (double)this.DiscoveryCurveCounts[i]);
            if (this.plotLocations) {
                series2.add((double)cumCount, (double)this.LocationCounts[i]);
            }
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        if (this.plotLocations) {
            dataset.addSeries(series2);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)"Spectra", (String)"Counts", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(1, false);
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BufferedImage Image2 = chart.createBufferedImage(1000, 1000);
        String ScoreFileName = this.PlotFile;
        System.out.println("Created discovery curve..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
    }

    public static void main(String[] args) {
        String InputDir;
        String[] options = new String[]{"-r", "-w"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input file/directory and an output file!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        if (!Utils.IsFile(InputDir = (String)CommandLineArgs.get("-r")) && !Utils.IsDir(InputDir)) {
            System.err.println("ERROR: Invalid file/directory path '" + InputDir + "'!");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        String OutputDir = null;
        if (CommandLineArgs.containsKey("-w")) {
            OutputDir = (String)CommandLineArgs.get("-w");
        }
        boolean plotLocs = false;
        if (CommandLineArgs.containsKey("-l")) {
            plotLocs = true;
        }
        NovelPeptideDiscoveryCurvePlotter p = new NovelPeptideDiscoveryCurvePlotter(InputDir, OutputDir, plotLocs);
        p.plot();
    }

    private void plot() {
        this.PopulateHashes();
        this.PlotDiscoveryCurve();
    }
}

