/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import proteogenomicUtils.AUGUSTUSRunner;
import proteogenomicUtils.EventFinder;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class AUGUSTUSOutputAnalyzer {
    public static String usageInfo = "proteogenomicUtils.AUGUSTUSOutputAnalyzer version 2012.04.02\nThis class is used to analyze the output of AUGUSTUSRunner, which creates a summary table.  For each locus,AUGUSTUSOutputAnalyzer determines if \n 1.  The maize annotation is supported by one of the prediction\n 2.  If any novel predictions are supported by unique and/or shared peptides\nUsage:\n -r [FILE] Augustus output summary table\n -e [FILE] The original event table file\n -t [FILE] Trie or Fasta file containing annotated protein sequences\n -w [FILE] Output file name(-c [FILE] Conversion file of genes, transcripts, and proteins.)\n(-n [NUM] Column containing gene name in conversion file (default: 1))\n(-q [NUM] Column containing transcript name in conversion file (default: 2))\n(-m [NUM] Column containing protein name (matched in trie/fasta file) in conversion file (default: 3))\n(-y The event table file is for PLGs)\n";
    private String augustusTableFile;
    private String eventTableFile;
    private TrieDB proteomeDB;
    private String outputFileName;
    private Hashtable gene2TranMap;
    private Hashtable gene2ProtMap;
    private boolean arePLGs = false;

    public AUGUSTUSOutputAnalyzer(String augustusTable, String eventTable, String proteomeFile, String outputFile, String conversionFile, int geneCol, int protCol, int tranCol) {
        if (!Utils.IsFile(augustusTable)) {
            ErrorThrower.ThrowError(1, augustusTable);
        }
        this.augustusTableFile = augustusTable;
        if (!Utils.IsFile(eventTable)) {
            ErrorThrower.ThrowError(1, eventTable);
        }
        this.eventTableFile = eventTable;
        if (!Utils.IsFile(proteomeFile)) {
            ErrorThrower.ThrowError(1, proteomeFile);
        }
        if (Utils.GetFileExtension(proteomeFile).equalsIgnoreCase(".trie")) {
            this.proteomeDB = new TrieDB(proteomeFile);
        } else {
            String[] fNames = TrieDB.prepDB(proteomeFile, null);
            this.proteomeDB = new TrieDB(fNames[0]);
        }
        this.outputFileName = outputFile;
        if (geneCol < 0) {
            ErrorThrower.ThrowError(4, "Gene column (-n) must be non-negative");
        }
        if (protCol < 0) {
            ErrorThrower.ThrowError(4, "Protein column (-m) must be non-negative");
        }
        if (tranCol < 0) {
            ErrorThrower.ThrowError(4, "Transcript column (-q) must be non-negative");
        }
        if (conversionFile != null && !Utils.IsFile(conversionFile)) {
            ErrorThrower.ThrowError(1, conversionFile);
        }
        if (conversionFile == null) {
            this.gene2TranMap = null;
            this.gene2ProtMap = null;
        } else {
            this.gene2TranMap = ProteogenomicUtils.loadTranslationFileMany(conversionFile, geneCol, tranCol);
            this.gene2ProtMap = ProteogenomicUtils.loadTranslationFileMany(conversionFile, geneCol, protCol);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-e", "-t", "-w", "-c", "-n", "-m", "-q", "-y"};
        boolean[] blArray = new boolean[9];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        boolean[] values = blArray;
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(commandLineArgs.containsKey("-r") && commandLineArgs.containsKey("-e") && commandLineArgs.containsKey("-t") && commandLineArgs.containsKey("-w"))) {
            System.out.println(usageInfo);
            ErrorThrower.ThrowError(2, "Must specify an augustus summary file (-r), an event table file (-e), a trie or fasta file containin the proteome (-t), and an output file name (-w)");
        }
        String augustusTable = (String)commandLineArgs.get("-r");
        String eventTable = (String)commandLineArgs.get("-e");
        String proteomeFile = (String)commandLineArgs.get("-t");
        String outputFile = (String)commandLineArgs.get("-w");
        String conversionFile = null;
        int geneCol = 1;
        int tranCol = 2;
        int protCol = 3;
        if (commandLineArgs.containsKey("-c")) {
            conversionFile = (String)commandLineArgs.get("-c");
        }
        if (commandLineArgs.containsKey("-n")) {
            try {
                geneCol = Integer.parseInt((String)commandLineArgs.get("-n"));
            }
            catch (Exception E) {
                ErrorThrower.ThrowError(4, "Gene column (-n) must be an integer");
            }
        }
        if (commandLineArgs.containsKey("-m")) {
            try {
                protCol = Integer.parseInt((String)commandLineArgs.get("-m"));
            }
            catch (Exception E) {
                ErrorThrower.ThrowError(4, "Protein column (-m) must be an integer");
            }
        }
        if (commandLineArgs.containsKey("-q")) {
            try {
                tranCol = Integer.parseInt((String)commandLineArgs.get("-q"));
            }
            catch (Exception E) {
                ErrorThrower.ThrowError(4, "Transcript column (-q) must be an integer");
            }
        }
        AUGUSTUSOutputAnalyzer a = new AUGUSTUSOutputAnalyzer(augustusTable, eventTable, proteomeFile, outputFile, conversionFile, geneCol, protCol, tranCol);
        if (commandLineArgs.containsKey("-y")) {
            a.arePLGs = true;
        }
        a.analyze();
    }

    private void analyze() {
        Hashtable Locus2SeqHash = AUGUSTUSRunner.loadSequenceSummaryTable(this.augustusTableFile);
        System.out.println("Loaded sequences predicted at " + Locus2SeqHash.size() + " loci");
        Hashtable allEvents = EventFinder.loadEventPeptidesFromTableFile(this.eventTableFile, !this.arePLGs, this.arePLGs);
        String[] ks = Utils.GetHashtableKeysString(allEvents);
        FileWriter f = Utils.openFileWriter(this.outputFileName);
        Utils.writeLine(f, this.outputFileName, "#LocusName\tNumPredictedTranscripts\tNumAnnotatedTranscripts\tPredictedKnownTranscripts\tPredictedNovelTranscript\tPredictedNovelTranscriptsWithPeptides\tEventPeptides\tSupportingPeptides\n");
        String[] locusKeys = Utils.GetHashtableKeysString(Locus2SeqHash);
        int i = 0;
        while (i < locusKeys.length) {
            int k;
            String[] peps;
            String tName;
            System.out.println("For locus " + locusKeys[i]);
            String outputFileLine = locusKeys[i];
            ArrayList predictedLines = (ArrayList)Locus2SeqHash.get(locusKeys[i]);
            ArrayList proteinNames = null;
            String[] proteinSeqs = null;
            String[] geneNames = Utils.GetHashtableKeysString(this.gene2ProtMap);
            boolean found = false;
            if (this.gene2ProtMap.containsKey(locusKeys[i])) {
                outputFileLine = locusKeys[i];
                proteinNames = (ArrayList)this.gene2ProtMap.get(locusKeys[i]);
                proteinSeqs = this.proteomeDB.getProteinSequencesFromNames(Utils.ConvertArraylistToStringArray(proteinNames));
                System.out.println(" - loaded " + proteinSeqs.length + " annotated sequences");
            } else {
                int k2 = 0;
                while (!found && k2 < ks.length) {
                    if (ks[k2].toLowerCase().indexOf(locusKeys[i].toLowerCase()) == 0) {
                        String[] temp = Utils.getKeyForValuePrefix(this.gene2TranMap, ks[k2]);
                        if (temp == null || temp.length == 0 || temp.length > 1) break;
                        locusKeys[i] = temp[0];
                        outputFileLine = locusKeys[i];
                        proteinNames = (ArrayList)this.gene2ProtMap.get(locusKeys[i]);
                        proteinSeqs = this.proteomeDB.getProteinSequencesFromNames(Utils.ConvertArraylistToStringArray(proteinNames));
                        System.out.println(" - loaded " + proteinSeqs.length + " annotated sequences");
                        found = true;
                    }
                    ++k2;
                }
                k2 = 0;
                while (!found && k2 < geneNames.length) {
                    if (geneNames[k2].toLowerCase().indexOf(locusKeys[i].toLowerCase()) == 0) {
                        outputFileLine = geneNames[k2];
                        locusKeys[i] = geneNames[k2];
                        proteinNames = (ArrayList)this.gene2ProtMap.get(geneNames[k2]);
                        proteinSeqs = this.proteomeDB.getProteinSequencesFromNames(Utils.ConvertArraylistToStringArray(proteinNames));
                        System.out.println(" - loaded " + proteinSeqs.length + " annotated sequences");
                        found = true;
                    }
                    ++k2;
                }
            }
            outputFileLine = String.valueOf(outputFileLine) + "\t" + predictedLines.size();
            outputFileLine = proteinNames == null ? String.valueOf(outputFileLine) + "\t0" : String.valueOf(outputFileLine) + "\t" + proteinNames.size();
            ArrayList tranNames = null;
            if (this.gene2TranMap.containsKey(locusKeys[i])) {
                tranNames = (ArrayList)this.gene2TranMap.get(locusKeys[i]);
            } else {
                tranNames = new ArrayList();
                int k3 = 0;
                while (k3 < ks.length) {
                    if (ks[k3].indexOf(locusKeys[i]) >= 0) {
                        tranNames.add(ks[k3]);
                    }
                    ++k3;
                }
                if (tranNames.size() == 0) {
                    tranNames.add(locusKeys[i]);
                }
            }
            HashSet<String> novelPeptides = new HashSet<String>();
            int j = 0;
            while (j < tranNames.size()) {
                tName = ((String)tranNames.get(j)).toLowerCase();
                if (allEvents.containsKey(tName)) {
                    peps = (String[])allEvents.get(tName);
                    k = 0;
                    while (k < peps.length) {
                        novelPeptides.add(peps[k]);
                        ++k;
                    }
                }
                ++j;
            }
            if (novelPeptides.size() == 0) {
                j = 0;
                while (j < tranNames.size()) {
                    tName = ((String)tranNames.get(j)).toLowerCase();
                    if (tName.indexOf("chr") >= 0) {
                        String[] lBits = tName.split("[.]");
                        lBits[1] = lBits[1].equals("+") ? "1" : (lBits[1].equals("1") ? "+" : (lBits[1].equals("-") ? "0" : "-"));
                        tName = Utils.JoinStringArray(lBits, ".").toLowerCase();
                        tranNames.remove(j);
                        tranNames.add(j, tName);
                    }
                    if (allEvents.containsKey(tName)) {
                        peps = (String[])allEvents.get(tName);
                        k = 0;
                        while (k < peps.length) {
                            novelPeptides.add(peps[k]);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            if (novelPeptides.size() == 0) {
                ErrorThrower.ThrowErrorCustum(100, "Unable to find events for locus " + locusKeys[i] + "!");
            }
            System.out.println(" - loaded " + novelPeptides.size() + " unique novel peptides for this region");
            String[] novelPeptideList = Utils.ConvertHashSetToStringArray(novelPeptides);
            boolean[] isProteinSeqPredicted = null;
            if (proteinSeqs != null) {
                isProteinSeqPredicted = new boolean[proteinSeqs.length];
                Utils.initializeBooleanArray(isProteinSeqPredicted, false);
            }
            int[] doesPeptideSupport = new int[predictedLines.size()];
            Utils.initializeIntArray(doesPeptideSupport, 0);
            HashSet<String> peptidesUsed = new HashSet<String>();
            int novelTranscriptCount = 0;
            int j2 = 0;
            while (j2 < predictedLines.size()) {
                String currLine = (String)predictedLines.get(j2);
                String[] bits = currLine.split("\t");
                String seq = bits[7];
                boolean matchesKnown = false;
                int k4 = 0;
                while (proteinSeqs != null && k4 < proteinSeqs.length) {
                    if (seq.equalsIgnoreCase(proteinSeqs[k4])) {
                        isProteinSeqPredicted[k4] = true;
                        matchesKnown = true;
                    }
                    ++k4;
                }
                if (!matchesKnown) {
                    ++novelTranscriptCount;
                }
                k4 = 0;
                while (k4 < novelPeptideList.length) {
                    if (seq.indexOf(novelPeptideList[k4]) >= 0) {
                        int n = j2;
                        doesPeptideSupport[n] = doesPeptideSupport[n] + 1;
                        peptidesUsed.add(novelPeptideList[k4]);
                    }
                    ++k4;
                }
                ++j2;
            }
            int count = 0;
            int j3 = 0;
            while (isProteinSeqPredicted != null && j3 < isProteinSeqPredicted.length) {
                if (isProteinSeqPredicted[j3]) {
                    ++count;
                }
                ++j3;
            }
            outputFileLine = String.valueOf(outputFileLine) + "\t" + count;
            outputFileLine = String.valueOf(outputFileLine) + "\t" + novelTranscriptCount;
            count = 0;
            j3 = 0;
            while (j3 < doesPeptideSupport.length) {
                if (doesPeptideSupport[j3] > 0) {
                    ++count;
                }
                ++j3;
            }
            outputFileLine = String.valueOf(outputFileLine) + "\t" + count;
            outputFileLine = String.valueOf(outputFileLine) + "\t" + novelPeptideList.length;
            outputFileLine = String.valueOf(outputFileLine) + "\t" + peptidesUsed.size() + "\n";
            Utils.writeLine(f, this.outputFileName, outputFileLine);
            ++i;
        }
        Utils.closeFileWriter(f, this.outputFileName);
    }
}

