/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import proteogenomicUtils.GenomicLocator;

public class AnalyzeTargetDecoyLocations {
    public static String UsageInfo = "proteogenomicUtils.AnalyzeTargetDecoyLocations version 9.21.2010\nThis program is used to determine the counts of the following categories of peptide locations\n (1) Novel peptides identified against a target DB, having a target location\n (2) Novel peptides identified against a target DB, having a decoy location\n (3) Novel peptides identified against a decoy DB, but appearing in a target location\n (4) Novel peptides identified against a decoy DB, having a decoy location\n[REQUIRED]:\n -r [FILE] File containing Inspect original search results (Novel peptides only)\n -k [FILE] File containing locations found from the Inspect novel peptides file\n[OPTIONAL]:\n -d run in debug mode\n";
    private boolean Debug;
    private String InspectResultFile;
    private String LocationFile;
    private Hashtable PeptideHasTargetAndDecoyMatches;

    public AnalyzeTargetDecoyLocations(String string, String string2) {
        if (!Utils.IsFile(string)) {
            System.err.println("ERROR: Input file '" + string + "' is not a valid input file!");
            System.exit(-1);
        }
        if (!Utils.IsFile(string2)) {
            System.err.println("ERROR: Input file '" + string + "' is not a valid input file!");
            System.exit(-1);
        }
        this.InspectResultFile = string;
        this.LocationFile = string2;
        this.PeptideHasTargetAndDecoyMatches = new Hashtable();
    }

    public void PrintParams() {
        System.out.println("AnalyzeTargetDecoyLocations parameters:");
        System.out.println("Inspect Result File: " + this.InspectResultFile);
        System.out.println("Location File: " + this.LocationFile);
    }

    private void LoadPeptideHash() {
        InspectAnnotation[] Anns = InspectAnnotation.LoadInspectResultsFile(this.InspectResultFile);
        int i = 0;
        while (i < Anns.length) {
            String Peptide2 = Utils.GetUnModded(Anns[i].Annotation);
            boolean[] Test = null;
            Test = this.PeptideHasTargetAndDecoyMatches.containsKey(Peptide2) ? (boolean[])this.PeptideHasTargetAndDecoyMatches.get(Peptide2) : new boolean[2];
            if (Utils.IsDecoyProtein(Anns[i].ProteinName)) {
                Test[1] = true;
            } else {
                Test[0] = true;
            }
            this.PeptideHasTargetAndDecoyMatches.put(Peptide2, Test);
            ++i;
        }
        if (this.Debug) {
            String[] Peptides = Utils.GetHashtableKeysString(this.PeptideHasTargetAndDecoyMatches);
            int[] Counts = new int[3];
            int i2 = 0;
            while (i2 < Peptides.length) {
                boolean[] Test = (boolean[])this.PeptideHasTargetAndDecoyMatches.get(Peptides[i2]);
                if (Test[0] && Test[1]) {
                    Counts[2] = Counts[2] + 1;
                } else if (Test[0]) {
                    Counts[0] = Counts[0] + 1;
                } else if (Test[1]) {
                    Counts[1] = Counts[1] + 1;
                }
                ++i2;
            }
            System.out.println("Total peptides: " + (Counts[0] + Counts[1] + Counts[2]));
            System.out.println("Peptides only ID'd in target: " + Counts[0]);
            System.out.println("Peptides only ID'd in decoy: " + Counts[1]);
            System.out.println("Peptides ID'd in both: " + Counts[2] + ".  In our real experiment these would count as targets");
        }
    }

    private void AnalyzeLocations() {
        int[] Counts = new int[4];
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(this.LocationFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            Object[] Loc = GenomicLocator.GenomicColumns.LoadFromString(Line);
            String Peptide2 = Utils.GetUnModded((String)Loc[GenomicLocator.GenomicColumns.Peptide]);
            boolean[] Test = (boolean[])this.PeptideHasTargetAndDecoyMatches.get(Peptide2);
            if (Utils.IsDecoyProtein((String)Loc[GenomicLocator.GenomicColumns.ProteinName])) {
                if (Test[1]) {
                    Counts[3] = Counts[3] + 1;
                }
                if (Test[0]) {
                    Counts[1] = Counts[1] + 1;
                }
            } else {
                if (Test[0]) {
                    Counts[0] = Counts[0] + 1;
                }
                if (Test[1]) {
                    Counts[2] = Counts[2] + 1;
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Target PSM - Target Loc: " + Counts[0]);
        System.out.println("Target PSM - Decoy Loc: " + Counts[1]);
        System.out.println("Decoy PSM - Target Loc: " + Counts[2]);
        System.out.println("Decoy PSM - Decoy Loc: " + Counts[3]);
    }

    public void Run() {
        if (this.Debug) {
            this.PrintParams();
        }
        this.LoadPeptideHash();
        this.AnalyzeLocations();
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-k", "-d"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-k")) {
            System.err.println("ERROR: Must specify an input file and locations file!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        boolean Debug = CommandLineArgs.containsKey("-d");
        AnalyzeTargetDecoyLocations a = new AnalyzeTargetDecoyLocations((String)CommandLineArgs.get("-r"), (String)CommandLineArgs.get("-k"));
        a.Debug = Debug;
        a.Run();
    }
}

