/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import proteogenomicUtils.GenomicLocator;

public class BipartiteGraphAnalyzer {
    private static String usageInfo = "maizeUtils.BipartiteGraphAnalyzer versions 2011.11.16\nThis class is used to analyze the bipartite graph structer created by clusters formed\nsolely of shared peptides (produced by GenomeClusterer). There are 2 modes that the analyzer can be\nrun in:\n [1] Look for overlap with repeats\n [2] Identify events of cluster groups\nUsage:\n -r [FILE] File containing the cluster group\n -c [NUM] Mode (1 or 2)\n(-t [FILE] The GFF file containing transposons/repeats.  Required for mode 1)\n(-k [FILE] The GFF file containing known genes.  Required for mode 2)\n";
    private static final int MAX_PEPTIDE_DEGREE = Integer.MAX_VALUE;
    double alpha = 1.0;
    double beta = -1.0;
    private static final int MIN_PEPTIDES_PER_COMPONENT = 2;
    private static final int MAX_LOCI_TO_DRAW = Integer.MAX_VALUE;
    private Hashtable transposons;

    public BipartiteGraphAnalyzer() {
    }

    public BipartiteGraphAnalyzer(double minDensity) {
        this.alpha = (1.0 - 1.0 / minDensity) * this.beta;
        this.transposons = null;
    }

    public void loadTransposons(String fileName) {
        this.transposons = GFFFile.loadIntoSequenceNameHashSorted(fileName, "repeat");
    }

    public PeptideBipartiteGraph[] loadGraphsFromFile(String inputClusterFileName, String species) {
        PeptideBipartiteGraph g;
        boolean localDebug = false;
        BufferedReader buf = null;
        String line = null;
        ArrayList<PeptideBipartiteGraph> graphs = new ArrayList<PeptideBipartiteGraph>();
        try {
            buf = new BufferedReader(new FileReader(inputClusterFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        ArrayList currCluster = null;
        ArrayList<Object[]> currLocus = null;
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return null;
                }
            }
            if (localDebug) {
                System.out.println(line);
            }
            if (line.charAt(0) == '#') {
                if (localDebug) {
                    System.out.println("This is a header line!!!");
                }
                if (currCluster != null) {
                    if (currLocus.size() > 0) {
                        currCluster.add(currLocus);
                    }
                    if (localDebug) {
                        System.out.println("Added the most recent locus of size " + currLocus.size());
                    }
                    g = new PeptideBipartiteGraph(currCluster);
                    graphs.add(g);
                } else if (localDebug) {
                    System.out.println("We are refreshing this cluster and curr locus");
                    Utils.WaitForEnter();
                }
                currCluster = new ArrayList();
                currLocus = new ArrayList<Object[]>();
            } else {
                if (localDebug) {
                    System.out.println("this is a data line!!");
                }
                String[] bits = line.split("\t");
                String newString = bits[1];
                int i = 2;
                while (i < bits.length) {
                    newString = String.valueOf(newString) + "\t" + bits[i];
                    ++i;
                }
                int locusNum = Integer.parseInt(bits[0]);
                if (localDebug) {
                    System.out.println("This is locus " + locusNum + " of " + currCluster.size() + " that we've seen");
                }
                if (locusNum <= currCluster.size()) {
                    if (localDebug) {
                        System.out.println("This is the current locus, so we simply add to it");
                    }
                    currLocus.add(GenomicLocator.GenomicColumns.LoadFromString(newString));
                } else {
                    if (localDebug) {
                        System.out.println("This is a new locus!");
                    }
                    if (currLocus.size() > 0) {
                        currCluster.add(currLocus);
                        if (localDebug) {
                            System.out.println("Added the previous locus of size " + currLocus.size());
                        }
                    }
                    currLocus = new ArrayList();
                    currLocus.add(GenomicLocator.GenomicColumns.LoadFromString(newString));
                }
            }
            try {
                line = buf.readLine();
                if (!localDebug) continue;
                Utils.WaitForEnter();
            }
            catch (IOException E) {
                E.printStackTrace();
                return null;
            }
        }
        if (currCluster != null) {
            if (currLocus.size() > 0) {
                currCluster.add(currLocus);
            }
            if (localDebug) {
                System.out.println("Added the final locus of size " + currLocus.size());
                Utils.WaitForEnter();
            }
            g = new PeptideBipartiteGraph(currCluster);
            graphs.add(g);
        }
        PeptideBipartiteGraph[] ret = new PeptideBipartiteGraph[graphs.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (PeptideBipartiteGraph)graphs.get(i);
            ++i;
        }
        return ret;
    }

    public PeptideBipartiteGraph[] loadComponentsFromClusters(ArrayList sharedClusters, String outFileName, HashSet forbiddenPeptides) {
        boolean debug = false;
        Hashtable<String, ArrayList> peptideMap = new Hashtable<String, ArrayList>();
        int clusterIndex = 0;
        while (clusterIndex < sharedClusters.size()) {
            ArrayList currCluster = (ArrayList)sharedClusters.get(clusterIndex);
            int locIndex = 0;
            while (locIndex < currCluster.size()) {
                Object[] currLoc = (Object[])currCluster.get(locIndex);
                String currPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                if (currPep.indexOf(".") >= 0) {
                    currPep = currPep.substring(2, currPep.length() - 2);
                }
                ArrayList peptideLocs = null;
                peptideLocs = peptideMap.containsKey(currPep) ? (ArrayList)peptideMap.get(currPep) : new ArrayList();
                if (!peptideLocs.contains(new Integer(clusterIndex))) {
                    peptideLocs.add(new Integer(clusterIndex));
                }
                peptideMap.put(currPep, peptideLocs);
                ++locIndex;
            }
            ++clusterIndex;
        }
        int removedCountDegree = 0;
        int removedCountSelected = 0;
        int removedCount = 0;
        Enumeration e = peptideMap.keys();
        int[] peptideCounts = new int[50];
        while (e.hasMoreElements()) {
            int bin;
            String currPep = (String)e.nextElement();
            ArrayList peptideLocs = (ArrayList)peptideMap.get(currPep);
            if (peptideLocs.size() > Integer.MAX_VALUE) {
                peptideMap.remove(currPep);
                forbiddenPeptides.add(currPep);
                ++removedCountDegree;
                continue;
            }
            if (forbiddenPeptides.contains(currPep)) {
                peptideMap.remove(currPep);
                ++removedCountSelected;
                continue;
            }
            if (peptideLocs.size() == 1) {
                peptideMap.remove(currPep);
                forbiddenPeptides.add(currPep);
                ++removedCount;
                continue;
            }
            int n = bin = Math.min(peptideLocs.size(), peptideCounts.length - 1);
            peptideCounts[n] = peptideCounts[n] + 1;
        }
        boolean[] considered = new boolean[sharedClusters.size()];
        int removedLociCount = 0;
        ArrayList newList = new ArrayList();
        int i = 0;
        while (i < sharedClusters.size()) {
            ArrayList currCluster = (ArrayList)sharedClusters.get(i);
            HashSet<String> peptides = new HashSet<String>();
            int locIndex = 0;
            while (locIndex < currCluster.size()) {
                Object[] currLoc = (Object[])currCluster.get(locIndex);
                String currPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                if (currPep.indexOf(".") >= 0) {
                    currPep = currPep.substring(2, currPep.length() - 2);
                }
                if (peptideMap.containsKey(currPep)) {
                    peptides.add(currPep);
                }
                ++locIndex;
            }
            if (peptides.size() == 0) {
                considered[i] = true;
                ++removedLociCount;
            }
            ++i;
        }
        System.out.println("We have removed " + removedLociCount + " loci");
        i = 0;
        while (i < peptideCounts.length) {
            System.out.println("Peptides with " + i + " locations:" + peptideCounts[i]);
            ++i;
        }
        System.out.println("Removed " + removedCountDegree + " peptides for being too numerous");
        System.out.println("Removed " + removedCountSelected + " peptides from loci that were already selected");
        System.out.println("Removed " + removedCount + " peptides with only 1 location remaining");
        System.out.println("Remaining peptides: " + peptideMap.size());
        ArrayList<PeptideBipartiteGraph> temp = new ArrayList<PeptideBipartiteGraph>();
        FileWriter f = null;
        try {
            f = new FileWriter(outFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        considered = Utils.initializeBooleanArray(considered, false);
        ArrayList<ArrayList> currComponent = new ArrayList<ArrayList>();
        int totalComponents = 0;
        int totalLargeComponents = 0;
        int clusterIndex2 = 0;
        while (clusterIndex2 < sharedClusters.size()) {
            if (!considered[clusterIndex2]) {
                considered[clusterIndex2] = true;
                ArrayList currCluster = (ArrayList)sharedClusters.get(clusterIndex2);
                ArrayList<String> peptides = new ArrayList<String>();
                int locIndex = 0;
                while (locIndex < currCluster.size()) {
                    Object[] currLoc = (Object[])currCluster.get(locIndex);
                    String currPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                    if (currPep.indexOf(".") >= 0) {
                        currPep = currPep.substring(2, currPep.length() - 2);
                    }
                    if (peptideMap.containsKey(currPep) && !peptides.contains(currPep)) {
                        peptides.add(currPep);
                    }
                    ++locIndex;
                }
                if (peptides.size() != 0) {
                    currComponent.add(currCluster);
                    if (debug) {
                        System.out.println("Starting from locus " + clusterIndex2 + ", with " + peptides.size() + " peptides");
                    }
                    while (peptides.size() > 0) {
                        String currPep = (String)peptides.remove(0);
                        ArrayList otherLocs = (ArrayList)peptideMap.get(currPep);
                        if (debug) {
                            System.out.println("Starting with peptide " + currPep + " with " + otherLocs.size() + " other locs");
                        }
                        int i2 = 0;
                        while (i2 < otherLocs.size()) {
                            int otherIndex = (Integer)otherLocs.get(i2);
                            if (debug) {
                                System.out.println(" - trying to add cluster " + otherIndex);
                            }
                            if (!considered[otherIndex]) {
                                considered[otherIndex] = true;
                                ArrayList otherCluster = (ArrayList)sharedClusters.get(otherIndex);
                                currComponent.add(otherCluster);
                                int locIndex2 = 0;
                                while (locIndex2 < otherCluster.size()) {
                                    Object[] currLoc = (Object[])otherCluster.get(locIndex2);
                                    String otherPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                                    if (otherPep.indexOf(".") >= 0) {
                                        otherPep = otherPep.substring(2, otherPep.length() - 2);
                                    }
                                    if (peptideMap.containsKey(otherPep) && !peptides.contains(otherPep)) {
                                        peptides.add(otherPep);
                                    }
                                    ++locIndex2;
                                }
                                if (debug) {
                                    System.out.println(" added the locus, now have " + peptides.size() + " peptides");
                                }
                            }
                            ++i2;
                        }
                    }
                    ++totalComponents;
                    if (debug) {
                        System.out.println("Found a component with " + currComponent.size() + " locii");
                    }
                    if (debug && currComponent.size() == 1) {
                        Utils.WaitForEnter();
                    }
                    PeptideBipartiteGraph g = new PeptideBipartiteGraph(currComponent, forbiddenPeptides);
                    if (currComponent.size() > 1 && g.getNumCols() >= 2) {
                        temp.add(g);
                        ++totalLargeComponents;
                        HashSet<String> seqs = new HashSet<String>();
                        try {
                            f.write("#Component " + (temp.size() - 1) + "\n");
                            int i3 = 0;
                            while (i3 < currComponent.size()) {
                                ArrayList c = (ArrayList)currComponent.get(i3);
                                int j = 0;
                                while (j < c.size()) {
                                    Object[] l = (Object[])c.get(j);
                                    String seq = ((String)l[GenomicLocator.GenomicColumns.SequenceName]).toLowerCase();
                                    seqs.add(seq);
                                    String line = GenomicLocator.GenomicColumns.toString(l, "\t");
                                    line = String.valueOf(i3) + "\t" + line;
                                    f.write(String.valueOf(line) + "\n");
                                    ++j;
                                }
                                ++i3;
                            }
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return null;
                        }
                    }
                    currComponent = new ArrayList();
                }
            }
            ++clusterIndex2;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return null;
        }
        System.out.println(" - Found " + totalComponents + " components!");
        System.out.println(" - Found " + totalLargeComponents + " components with at least " + 2 + " peptides!");
        PeptideBipartiteGraph[] ret = new PeptideBipartiteGraph[temp.size()];
        int i4 = 0;
        while (i4 < ret.length) {
            ret[i4] = (PeptideBipartiteGraph)temp.get(i4);
            ++i4;
        }
        return ret;
    }

    private void AnalyzeTransposonOverlap(PeptideBipartiteGraph[] graphs) {
        if (this.transposons == null) {
            System.err.println("ERROR: No transposons have been loaded!!!");
            return;
        }
        boolean localDebug = false;
        int allInRepeatCount = 0;
        int allNotInRepeatCount = 0;
        Hashtable<String, int[]> allInType = new Hashtable<String, int[]>();
        int allInTypeCount = 0;
        Hashtable<String, int[]> allInName = new Hashtable<String, int[]>();
        int allInNameCount = 0;
        int i = 0;
        while (i < graphs.length) {
            if (localDebug) {
                graphs[i].DebugPrint();
            }
            String[] types = new String[graphs[i].clusterLoci.length];
            String[] names = new String[graphs[i].clusterLoci.length];
            int j = 0;
            while (j < graphs[i].clusterLoci.length) {
                String seqName = (String)graphs[i].clusterLoci[j][0];
                if ((seqName = seqName.substring(3)).compareTo("c") == 0) {
                    seqName = "chloroplast";
                }
                if (seqName.compareTo("m") == 0) {
                    seqName = "mitochondrion";
                }
                if (this.transposons.containsKey(seqName)) {
                    ArrayList gffLines = (ArrayList)this.transposons.get(seqName);
                    if (localDebug) {
                        System.out.println("There are " + gffLines.size() + " gff lines for this sequence!!");
                    }
                    int lowIndex = 0;
                    int highIndex = gffLines.size();
                    int locusStrand = (Integer)graphs[i].clusterLoci[j][1];
                    int locusStart = (Integer)graphs[i].clusterLoci[j][2];
                    int locusEnd = (Integer)graphs[i].clusterLoci[j][3];
                    if (localDebug) {
                        System.out.println("Curr locus: " + locusStrand + " " + locusStart + " " + locusEnd);
                    }
                    while (lowIndex < highIndex) {
                        int midIndex = (lowIndex + highIndex) / 2;
                        Object[] transposon = (Object[])gffLines.get(midIndex);
                        int strand = (Integer)transposon[0];
                        int[] tRange = new int[]{(Integer)transposon[1], (Integer)transposon[2]};
                        if (localDebug) {
                            System.out.println("Transposon: " + strand + " " + tRange[0] + "-" + tRange[1] + "," + (String)transposon[3]);
                        }
                        if (strand == locusStrand && Utils.HasOverlap(tRange[0] - 1, tRange[1], locusStart, locusEnd)) {
                            String value;
                            Hashtable atts;
                            if (localDebug) {
                                System.out.println("Found an overlap of GFFLine and graph");
                            }
                            if ((atts = GFFFile.getAttributesFromCol((String)transposon[3])) != null && atts.containsKey("type")) {
                                types[j] = value = (String)atts.get("type");
                            }
                            if (atts != null && atts.containsKey("name")) {
                                names[j] = value = (String)atts.get("name");
                            }
                            if (localDebug) {
                                System.out.println("types: " + types[j]);
                                System.out.println("names: " + names[j]);
                                Utils.WaitForEnter();
                            }
                            break;
                        }
                        if (locusStrand > strand || locusStrand == strand && locusStart > tRange[0] || locusStrand == strand && locusStart == tRange[0] && locusEnd > tRange[1]) {
                            if (localDebug) {
                                System.out.println("The locus is later!!");
                                Utils.WaitForEnter();
                            }
                            lowIndex = midIndex + 1;
                            continue;
                        }
                        if (locusStrand >= strand && (locusStrand != strand || locusStart >= tRange[0]) && (locusStrand != strand || locusStart != tRange[0] || locusEnd >= tRange[1])) continue;
                        if (localDebug) {
                            System.out.println("The locus is earlier!!");
                            Utils.WaitForEnter();
                        }
                        highIndex = midIndex;
                    }
                } else if (localDebug) {
                    System.out.println("There are no transposons on sequence: " + seqName);
                }
                ++j;
            }
            HashSet<String> typeSet = new HashSet<String>();
            HashSet<String> nameSet = new HashSet<String>();
            boolean allInRepeat = true;
            int notInRepeatLocalCount = 0;
            graphs[i].repeatType = 4;
            int j2 = 0;
            while (j2 < graphs[i].clusterLoci.length) {
                if (types[j2] == null) {
                    ++notInRepeatLocalCount;
                    allInRepeat = false;
                } else {
                    typeSet.add(types[j2]);
                    nameSet.add(names[j2]);
                }
                ++j2;
            }
            if (notInRepeatLocalCount == graphs[i].clusterLoci.length) {
                graphs[i].repeatType = 0;
                ++allNotInRepeatCount;
            } else if (allInRepeat) {
                ++allInRepeatCount;
                graphs[i].repeatType = 1;
                if (typeSet.size() == 1) {
                    graphs[i].repeatType = 2;
                    ++allInTypeCount;
                    Iterator eC = typeSet.iterator();
                    String c = (String)eC.next();
                    int[] temp = null;
                    temp = allInType.containsKey(c) ? (int[])allInType.get(c) : new int[]{0, 0};
                    temp[0] = temp[0] + 1;
                    temp[1] = temp[1] + graphs[i].clusterLoci.length;
                    allInType.put(c, temp);
                }
                if (nameSet.size() == 1) {
                    graphs[i].repeatType = 3;
                    ++allInNameCount;
                    Iterator eN = nameSet.iterator();
                    String n = (String)eN.next();
                    int[] temp = null;
                    temp = allInName.containsKey(n) ? (int[])allInName.get(n) : new int[]{0, 0};
                    temp[0] = temp[0] + 1;
                    temp[1] = temp[1] + graphs[i].clusterLoci.length;
                    allInName.put(n, temp);
                }
            }
            ++i;
        }
        System.out.println("Analyzed graphs and transposons");
        System.out.println("Total graphs: " + graphs.length);
        System.out.println("Total graphs with no loci in repeats: " + allNotInRepeatCount);
        System.out.println("Total graphs all loci in repeats: " + allInRepeatCount);
        System.out.println("Total graphs in same repeat type: " + allInTypeCount);
        System.out.println("Total graphs in same repeat name: " + allInNameCount);
        Enumeration eC = allInType.keys();
        while (eC.hasMoreElements()) {
            String repeatClass = (String)eC.nextElement();
            int[] temp = (int[])allInType.get(repeatClass);
            if (temp != null) {
                System.out.println("Class " + repeatClass + " " + temp[0] + " " + temp[1]);
                continue;
            }
            System.out.println("Class " + repeatClass + " temp is null =(");
        }
        Enumeration eN = allInName.keys();
        while (eN.hasMoreElements()) {
            String repeatName = (String)eN.nextElement();
            int[] temp = (int[])allInName.get(repeatName);
            if (temp != null) {
                System.out.println("Name " + repeatName + " " + temp[0] + " " + temp[1]);
                continue;
            }
            System.out.println("Name " + repeatName + " temp is null =(");
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-t", "-d", "-s"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLineMulti(args, options, values);
    }

    private void writeCircosLinkFile(PeptideBipartiteGraph[] graphs, String outputFileName, int graphType) {
        FileWriter f = null;
        try {
            f = new FileWriter(outputFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        int graphedCount = 0;
        int skippedCount = 0;
        int groupIndex = 0;
        while (groupIndex < graphs.length) {
            if (graphs[groupIndex].repeatType == graphType) {
                if (graphs[groupIndex].clusterLoci.length > Integer.MAX_VALUE) {
                    ++skippedCount;
                } else {
                    ++graphedCount;
                    int locusIndex = 0;
                    while (locusIndex < graphs[groupIndex].clusterLoci.length) {
                        String locusSeq1 = (String)graphs[groupIndex].clusterLoci[locusIndex][0];
                        locusSeq1 = locusSeq1.substring(3);
                        locusSeq1 = "zm" + locusSeq1;
                        int locusIndex2 = locusIndex + 1;
                        while (locusIndex2 < graphs[groupIndex].clusterLoci.length) {
                            String locusSeq2 = (String)graphs[groupIndex].clusterLoci[locusIndex2][0];
                            locusSeq2 = locusSeq2.substring(3);
                            locusSeq2 = "zm" + locusSeq2;
                            String line = String.valueOf(groupIndex) + "." + locusIndex + "." + locusIndex2 + " " + locusSeq1 + " " + (Integer)graphs[groupIndex].clusterLoci[locusIndex][2] + " " + (Integer)graphs[groupIndex].clusterLoci[locusIndex][3];
                            String line2 = String.valueOf(groupIndex) + "." + locusIndex + "." + locusIndex2 + " " + locusSeq2 + " " + (Integer)graphs[groupIndex].clusterLoci[locusIndex2][2] + " " + (Integer)graphs[groupIndex].clusterLoci[locusIndex2][3];
                            try {
                                f.write(String.valueOf(line) + "\n");
                                f.write(String.valueOf(line2) + "\n");
                            }
                            catch (IOException E) {
                                E.printStackTrace();
                                return;
                            }
                            ++locusIndex2;
                        }
                        ++locusIndex;
                    }
                }
            }
            ++groupIndex;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        System.out.println("Graphed count of type '" + graphType + "': " + graphedCount);
        System.out.println("Skipped " + skippedCount + " for being too large");
    }

    public class PeptideBipartiteGraph {
        private String[] peptides;
        Object[][] clusterLoci;
        public ArrayList clusters;
        private int repeatType = -1;
        private boolean[][] edgeMap;

        public PeptideBipartiteGraph() {
            this.edgeMap = null;
        }

        public int getNumRows() {
            return this.edgeMap.length;
        }

        public int getNumCols() {
            return this.edgeMap[0].length;
        }

        public PeptideBipartiteGraph(ArrayList sharedClusters) {
            ArrayList<String> peptides = new ArrayList<String>();
            int clusterIndex = 0;
            while (clusterIndex < sharedClusters.size()) {
                ArrayList currCluster = (ArrayList)sharedClusters.get(clusterIndex);
                int locIndex = 0;
                while (locIndex < currCluster.size()) {
                    int index;
                    Object[] currLoc = (Object[])currCluster.get(locIndex);
                    String currPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                    if (currPep.indexOf(".") >= 0) {
                        currPep = currPep.substring(2, currPep.length() - 2);
                    }
                    if ((index = peptides.indexOf(currPep)) < 0) {
                        peptides.add(currPep);
                    }
                    ++locIndex;
                }
                ++clusterIndex;
            }
            this.peptides = Utils.ConvertArraylistToStringArray(peptides);
            this.clusterLoci = new Object[sharedClusters.size()][4];
            this.edgeMap = new boolean[sharedClusters.size()][peptides.size()];
            this.edgeMap = Utils.initializeBooleanMatrix(this.edgeMap, false);
            clusterIndex = 0;
            while (clusterIndex < sharedClusters.size()) {
                int strand = -1;
                int start = Integer.MAX_VALUE;
                int end = Integer.MIN_VALUE;
                String chromosome = null;
                ArrayList currCluster = (ArrayList)sharedClusters.get(clusterIndex);
                int locIndex = 0;
                while (locIndex < currCluster.size()) {
                    Object[] currLoc = (Object[])currCluster.get(locIndex);
                    String currPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                    if (currPep.indexOf(".") >= 0) {
                        currPep = currPep.substring(2, currPep.length() - 2);
                    }
                    int index = peptides.indexOf(currPep);
                    this.edgeMap[clusterIndex][index] = true;
                    int currStart = (Integer)currLoc[GenomicLocator.GenomicColumns.Start];
                    int currEnd = (Integer)currLoc[GenomicLocator.GenomicColumns.End];
                    if (currStart < start) {
                        start = currStart;
                    }
                    if (currEnd > end) {
                        end = currEnd;
                    }
                    strand = (Integer)currLoc[GenomicLocator.GenomicColumns.Strand];
                    chromosome = ((String)currLoc[GenomicLocator.GenomicColumns.SequenceName]).toLowerCase();
                    ++locIndex;
                }
                this.clusterLoci[clusterIndex][0] = chromosome;
                this.clusterLoci[clusterIndex][1] = new Integer(strand);
                this.clusterLoci[clusterIndex][2] = new Integer(start);
                this.clusterLoci[clusterIndex][3] = new Integer(end);
                ++clusterIndex;
            }
        }

        public PeptideBipartiteGraph(ArrayList sharedClusters, HashSet forbiddenPeptides) {
            ArrayList<String> peptides = new ArrayList<String>();
            int clusterIndex = 0;
            while (clusterIndex < sharedClusters.size()) {
                ArrayList currCluster = (ArrayList)sharedClusters.get(clusterIndex);
                int locIndex = 0;
                while (locIndex < currCluster.size()) {
                    int index;
                    Object[] currLoc = (Object[])currCluster.get(locIndex);
                    String currPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                    if (currPep.indexOf(".") >= 0) {
                        currPep = currPep.substring(2, currPep.length() - 2);
                    }
                    if (!forbiddenPeptides.contains(currPep) && (index = peptides.indexOf(currPep)) < 0) {
                        peptides.add(currPep);
                    }
                    ++locIndex;
                }
                ++clusterIndex;
            }
            this.clusters = sharedClusters;
            this.peptides = Utils.ConvertArraylistToStringArray(peptides);
            this.clusterLoci = new Object[sharedClusters.size()][4];
            this.edgeMap = new boolean[sharedClusters.size()][peptides.size()];
            this.edgeMap = Utils.initializeBooleanMatrix(this.edgeMap, false);
            clusterIndex = 0;
            while (clusterIndex < sharedClusters.size()) {
                int strand = -1;
                int start = Integer.MAX_VALUE;
                int end = Integer.MIN_VALUE;
                String chromosome = null;
                ArrayList currCluster = (ArrayList)sharedClusters.get(clusterIndex);
                int locIndex = 0;
                while (locIndex < currCluster.size()) {
                    Object[] currLoc = (Object[])currCluster.get(locIndex);
                    String currPep = (String)currLoc[GenomicLocator.GenomicColumns.Peptide];
                    if (currPep.indexOf(".") >= 0) {
                        currPep = currPep.substring(2, currPep.length() - 2);
                    }
                    if (!forbiddenPeptides.contains(currPep)) {
                        int index = peptides.indexOf(currPep);
                        this.edgeMap[clusterIndex][index] = true;
                        int currStart = (Integer)currLoc[GenomicLocator.GenomicColumns.Start];
                        int currEnd = (Integer)currLoc[GenomicLocator.GenomicColumns.End];
                        if (currStart < start) {
                            start = currStart;
                        }
                        if (currEnd > end) {
                            end = currEnd;
                        }
                        strand = (Integer)currLoc[GenomicLocator.GenomicColumns.Strand];
                        chromosome = ((String)currLoc[GenomicLocator.GenomicColumns.SequenceName]).toLowerCase();
                    }
                    ++locIndex;
                }
                this.clusterLoci[clusterIndex][0] = chromosome;
                this.clusterLoci[clusterIndex][1] = new Integer(strand);
                this.clusterLoci[clusterIndex][2] = new Integer(start);
                this.clusterLoci[clusterIndex][3] = new Integer(end);
                ++clusterIndex;
            }
        }

        public void DebugPrint() {
            System.out.println("Graph: |U| = " + this.edgeMap.length + " |V| = " + this.edgeMap[0].length);
            int i = 0;
            while (i < this.edgeMap.length) {
                String s = "";
                int j = 0;
                while (j < this.edgeMap[i].length) {
                    s = this.edgeMap[i][j] ? String.valueOf(s) + "1 " : String.valueOf(s) + "0 ";
                    ++j;
                }
                System.out.println(s);
                ++i;
            }
            i = 0;
            while (i < this.peptides.length) {
                System.out.println("[" + i + "]:" + this.peptides[i]);
                ++i;
            }
            i = 0;
            while (i < this.clusterLoci.length) {
                System.out.println("Locus " + i + " is on chromosome " + this.clusterLoci[i][0] + " strand " + this.clusterLoci[i][1] + " at " + this.clusterLoci[i][2] + "-" + this.clusterLoci[i][3]);
                ++i;
            }
            Utils.WaitForEnter();
        }
    }
}

