/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import sixFrameUtils.SixFrameBuilder;

public class CombineInspectResults {
    private static final int DEFAULT_ANNS_PER_SPECTRUM = 10;
    public static String UsageInfo = "Usage: java sixFrameUtils.CombineInspectResults, version 2011.11.17\nRequired Arguments:\n-r [File] File containing inspect results(this argument can be given multiple times to indicate files that should be combined\n-w [File] File to write combined files to\n-n [NUM] Report the top NUM hits for each spectrum (Optional)\n";
    private static String HashKeySeparator = ":";
    public String[] InputFiles;
    public String OutputFile;
    public Hashtable Entries;
    public Hashtable OldScans;
    private boolean FinishedAllFiles = false;
    private static int MAX_SCANS_IN_HASH = 25000;
    private int ActualNumHitsPerSpectrum = 10;
    private boolean Debug = false;
    private String[] colHeaders;

    public CombineInspectResults(String[] InputFiles, String OutputFile, int NumHits) {
        this.InputFiles = InputFiles;
        this.OutputFile = OutputFile;
        this.Entries = new Hashtable();
        this.OldScans = new Hashtable();
        this.ActualNumHitsPerSpectrum = NumHits;
    }

    public void Combine() {
        File NewFile = new File(this.OutputFile);
        if (NewFile.exists()) {
            NewFile.delete();
        }
        do {
            System.out.println("Skipping " + this.OldScans.size() + " scans from previous loops");
            int i = 0;
            while (i < this.InputFiles.length) {
                File CurrFile = new File(this.InputFiles[i]);
                if (!CurrFile.exists()) {
                    System.out.println("**File Does Not Exist: " + CurrFile.getAbsolutePath());
                } else {
                    this.LoadResults(CurrFile);
                }
                ++i;
            }
            System.out.println("Total Scans: " + this.Entries.size());
            if (this.Entries.size() <= 0) break;
            this.WriteResults(this.OutputFile);
        } while (!this.FinishedAllFiles);
    }

    private void LoadResults(File CurrFile) {
        boolean LocalDebug = false;
        this.FinishedAllFiles = true;
        System.out.println("Loading annotations from " + CurrFile.getAbsolutePath());
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(CurrFile.getAbsoluteFile()));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        this.colHeaders = null;
        String[] columnHeaders = null;
        while (Line != null) {
            ArrayList Temp;
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                if (Line.length() > 0 && Line.charAt(0) == '#') {
                    columnHeaders = Line.substring(1).split("\t");
                    if (this.colHeaders == null) {
                        this.colHeaders = Line.substring(1).split("\t");
                    }
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            InspectAnnotation CurrAnn = new InspectAnnotation(Line, columnHeaders);
            if (CurrAnn.Length <= 0) {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String FileName = Utils.GetBaseName(CurrAnn.SpectrumFile);
            int ScanNumber = CurrAnn.ScanNumber;
            String HashKey = String.valueOf(FileName) + HashKeySeparator + ScanNumber;
            if (this.Debug) {
                System.out.println("HashKey: " + HashKey);
            }
            if (this.OldScans.containsKey(HashKey)) {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            if (this.Entries.containsKey(HashKey)) {
                Temp = (ArrayList)this.Entries.get(HashKey);
                this.Entries.put(HashKey, this.InsertNewAnn(Temp, CurrAnn));
            } else {
                if (this.Entries.size() > MAX_SCANS_IN_HASH) {
                    if (LocalDebug) {
                        System.out.println("Reached " + this.Entries.size() + " scans, skipping the rest!!");
                        LocalDebug = false;
                    }
                    this.FinishedAllFiles = false;
                    break;
                }
                Temp = new ArrayList();
                this.Entries.put(HashKey, this.InsertNewAnn(Temp, CurrAnn));
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    private void WriteResults(String FileName) {
        boolean LocalDebug;
        boolean bl = LocalDebug = this.Debug;
        if (this.colHeaders == null || Utils.FindStringInArray(this.colHeaders, "Chromosome") < 0) {
            this.colHeaders = Utils.appendToArray(this.colHeaders, "Chromosome");
        }
        if (this.colHeaders == null || Utils.FindStringInArray(this.colHeaders, "Strand") < 0) {
            this.colHeaders = Utils.appendToArray(this.colHeaders, "Strand");
        }
        if (this.colHeaders == null || Utils.FindStringInArray(this.colHeaders, "GenomicPos") < 0) {
            this.colHeaders = Utils.appendToArray(this.colHeaders, "GenomicPos");
        }
        if (this.colHeaders == null || Utils.FindStringInArray(this.colHeaders, "SplicedSequence") < 0) {
            this.colHeaders = Utils.appendToArray(this.colHeaders, "SplicedSequence");
        }
        if (this.colHeaders == null || Utils.FindStringInArray(this.colHeaders, "Splices") < 0) {
            this.colHeaders = Utils.appendToArray(this.colHeaders, "Splices");
        }
        FileWriter Writer2 = null;
        File NewFile = new File(FileName);
        boolean wroteHeader = false;
        try {
            Writer2 = new FileWriter(NewFile.getAbsoluteFile(), true);
            System.out.println("  Creating output file: " + FileName);
        }
        catch (IOException E) {
            System.err.println(E);
            Utils.WaitForEnter();
            return;
        }
        Enumeration e = this.Entries.keys();
        String Line = null;
        String[] Peptides = null;
        double[] MQScores = null;
        int WrittenLines = 0;
        if (LocalDebug) {
            System.out.println("Writing " + this.Entries.size() + " scans");
        }
        while (e.hasMoreElements()) {
            InspectAnnotation Ann;
            ArrayList List2;
            String HashKey = (String)e.nextElement();
            this.OldScans.put(HashKey, new Integer(0));
            String[] Els = HashKey.split(HashKeySeparator);
            if (LocalDebug) {
                System.out.println("File: " + Els[0] + " == " + FileName);
            }
            if ((List2 = (ArrayList)this.Entries.get(HashKey)).size() == 1) {
                InspectAnnotation Ann2 = (InspectAnnotation)List2.get(0);
                Ann2.columnHeaders = this.colHeaders;
                Ann2.SpectrumFile = Utils.GetBaseName(Ann2.SpectrumFile);
                Line = String.valueOf(Ann2.toString()) + "\n";
                ++WrittenLines;
                try {
                    if (!wroteHeader) {
                        Writer2.write("#" + Utils.JoinStringArray(this.colHeaders, "\t") + "\n");
                        wroteHeader = true;
                    }
                    Writer2.write(Line);
                    if (!LocalDebug) continue;
                    System.out.println(Line);
                }
                catch (IOException E) {
                    System.err.println(E);
                }
                continue;
            }
            Peptides = new String[List2.size()];
            MQScores = new double[List2.size()];
            if (LocalDebug) {
                System.out.println(" Entries: " + List2.size());
            }
            int i = 0;
            while (i < Peptides.length) {
                Ann = (InspectAnnotation)List2.get(i);
                Peptides[i] = Ann.Annotation;
                MQScores[i] = Ann.MQScore;
                if (i > 0) {
                    Ann.DeltaScoreAny = MQScores[i] - MQScores[0];
                }
                ++i;
            }
            i = 0;
            while (i < Peptides.length) {
                Ann = (InspectAnnotation)List2.get(i);
                Ann.columnHeaders = this.colHeaders;
                if (i == 0) {
                    Ann.DeltaScoreAny = MQScores[0] - MQScores[1];
                }
                int k = 0;
                while (k < Peptides.length && Peptides[k].compareTo(Peptides[i]) == 0) {
                    ++k;
                }
                Ann.DeltaScore = k == Peptides.length ? MQScores[i] : MQScores[i] - MQScores[k];
                if (LocalDebug) {
                    System.out.println(String.valueOf(Peptides[i]) + ":" + MQScores[i] + " delta: " + Ann.DeltaScore + " any: " + Ann.DeltaScoreAny);
                }
                Ann.SpectrumFile = Utils.GetBaseName(Ann.SpectrumFile);
                Line = String.valueOf(Ann.toString()) + "\n";
                ++WrittenLines;
                try {
                    if (!wroteHeader) {
                        Writer2.write("#" + Utils.JoinStringArray(this.colHeaders, "\t") + "\n");
                        wroteHeader = true;
                    }
                    Writer2.write(Line);
                    if (LocalDebug) {
                        System.out.println(Line);
                    }
                }
                catch (IOException E) {
                    System.err.println(E);
                }
                ++i;
            }
            if (!LocalDebug) continue;
            Utils.WaitForEnter();
        }
        this.Entries.clear();
        System.out.println("  Wrote " + WrittenLines + " lines");
        try {
            Writer2.close();
        }
        catch (IOException E) {
            System.err.println(E);
            return;
        }
    }

    public static boolean IsSamePeptide(InspectAnnotation Ann1, InspectAnnotation Ann2) {
        return Ann1.Annotation.compareTo(Ann2.Annotation) == 0;
    }

    public static boolean IsSamePeptide_LocationDependent(InspectAnnotation Ann1, InspectAnnotation Ann2) {
        String[] H;
        boolean IsMS2DBHeader2;
        boolean IsSixFrameHeader1 = SixFrameBuilder.IsSixFrameFASTAHeader(Ann1.ProteinName);
        boolean IsMS2DBHeader1 = Ann1.GenomicPos.compareTo(InspectAnnotation.EMPTY_STRING) != 0;
        boolean IsSixFrameHeader2 = SixFrameBuilder.IsSixFrameFASTAHeader(Ann2.ProteinName);
        boolean bl = IsMS2DBHeader2 = Ann2.GenomicPos.compareTo(InspectAnnotation.EMPTY_STRING) != 0;
        if (!(IsSixFrameHeader1 || IsMS2DBHeader1 || IsSixFrameHeader2 || IsMS2DBHeader2)) {
            if (Ann1.Annotation.compareTo(Ann2.Annotation) == 0) {
                System.out.println("Case 1");
                System.out.println("IsSixFrame: " + IsSixFrameHeader1 + ", IsMS2DB: " + IsMS2DBHeader1);
                System.out.println("IsSixFrame: " + IsSixFrameHeader2 + ", IsMS2DB: " + IsMS2DBHeader2);
                return true;
            }
            return false;
        }
        if (!IsSixFrameHeader1 && !IsMS2DBHeader1) {
            return false;
        }
        if (!IsSixFrameHeader2 && !IsMS2DBHeader2) {
            return false;
        }
        if (Ann1.Annotation.compareTo(Ann2.Annotation) != 0) {
            return false;
        }
        if (Ann1.SplicedSequence.compareTo(Ann2.SplicedSequence) != 0) {
            return false;
        }
        if (Ann1.Splices != null && Ann2.Splices != null && Ann1.Splices.compareTo(Ann2.Splices) != 0) {
            return false;
        }
        String Sequence1 = "";
        String Start1 = null;
        String Start2 = null;
        String End1 = null;
        String End2 = null;
        Object Splices1 = null;
        String Strand1 = "";
        String Sequence2 = "";
        String Strand2 = "";
        Object Splices2 = null;
        if (IsSixFrameHeader1) {
            H = SixFrameBuilder.ParseSixFrameHeader(Ann1.ProteinName);
            Sequence1 = H[0];
            Start1 = H[1];
            End1 = H[2];
            Strand1 = H[3];
            if (Strand1.compareTo("+") == 0) {
                Strand1 = "1";
            }
            if (Strand1.compareTo("-") == 0) {
                Strand1 = "0";
            }
        } else if (IsMS2DBHeader1) {
            H = Ann1.ProteinName.split("@");
            Sequence1 = H[0];
            Start1 = Ann1.GenomicPos.split("-")[0];
            End1 = Ann1.GenomicPos.split("-")[1];
            Strand1 = Integer.toString(Ann1.Strand);
            if (Ann1.Splices != null && Ann1.Splices.compareTo(" ") == 0) {
                Splices1 = null;
            }
        }
        if (IsSixFrameHeader2) {
            H = SixFrameBuilder.ParseSixFrameHeader(Ann2.ProteinName);
            Sequence2 = H[0];
            Start2 = H[1];
            End2 = H[2];
            Strand2 = H[3];
            if (Strand2.compareTo("+") == 0) {
                Strand2 = "1";
            }
            if (Strand2.compareTo("-") == 0) {
                Strand2 = "0";
            }
        } else if (IsMS2DBHeader2) {
            H = Ann2.ProteinName.split("@");
            Sequence2 = H[0];
            Start2 = Ann2.GenomicPos.split("-")[0];
            End2 = Ann2.GenomicPos.split("-")[1];
            Strand2 = Integer.toString(Ann2.Strand);
            if (Ann2.Splices != null && Ann2.Splices.compareTo(" ") == 0) {
                Splices2 = null;
            }
        }
        if (Splices1 == null && Splices2 != null || Splices1 == null && Splices2 != null) {
            return false;
        }
        if (Sequence1.compareTo(Sequence2) != 0) {
            return false;
        }
        if (Strand1.compareTo(Strand2) != 0) {
            return false;
        }
        if (Start1 != null && Start2 != null && Start1.compareTo(Start2) != 0) {
            return false;
        }
        if (End1 != null && End2 != null && End1.compareTo(End2) != 0) {
            return false;
        }
        System.out.println("Case 2");
        return true;
    }

    public ArrayList InsertNewAnn(ArrayList List2, InspectAnnotation Ann) {
        InspectAnnotation CurrAnn;
        boolean LocalDebug = this.Debug;
        if (List2.size() == 0) {
            List2.add(Ann);
            return List2;
        }
        boolean FoundBetter = false;
        int i = 0;
        while (i < List2.size()) {
            CurrAnn = (InspectAnnotation)List2.get(i);
            if (CombineInspectResults.IsSamePeptide(CurrAnn, Ann)) {
                if (LocalDebug) {
                    System.out.println("Found " + Ann.Annotation + " already in the list!!");
                }
                if (Ann.MQScore > CurrAnn.MQScore) {
                    if (LocalDebug) {
                        System.out.println("MQScore " + Ann.MQScore + " > " + CurrAnn.MQScore + ", replacing in list");
                    }
                    List2.remove(i);
                } else if (Ann.MQScore == CurrAnn.MQScore && CurrAnn.ProteinName.substring(0, 3).compareTo("XXX") == 0 && Ann.ProteinName.substring(0, 3).compareTo("XXX") != 0) {
                    if (LocalDebug) {
                        System.out.println("Replacing the bad guy:");
                        System.out.println(CurrAnn.toString());
                        System.out.println("with:");
                        System.out.println(Ann.toString());
                        Utils.WaitForEnter();
                    }
                    List2.remove(i);
                } else if (Ann.MQScore == CurrAnn.MQScore && (Utils.IsDecoyProtein(Ann.ProteinName) && Utils.IsDecoyProtein(CurrAnn.ProteinName) || !Utils.IsDecoyProtein(Ann.ProteinName) && !Utils.IsDecoyProtein(CurrAnn.ProteinName)) && Ann.AnnotationWithFlanking.compareTo(CurrAnn.AnnotationWithFlanking) < 0) {
                    List2.remove(i);
                } else {
                    FoundBetter = true;
                    if (!LocalDebug) break;
                    System.out.println("MQScore " + Ann.MQScore + "<=" + CurrAnn.MQScore + ", not replacing");
                    break;
                }
                if (LocalDebug) {
                    Utils.WaitForEnter();
                }
            }
            ++i;
        }
        i = 0;
        while (!FoundBetter && i < List2.size()) {
            CurrAnn = (InspectAnnotation)List2.get(i);
            if (CurrAnn.MQScore < Ann.MQScore) {
                List2.add(i, Ann);
                FoundBetter = true;
                break;
            }
            if (CurrAnn.MQScore == Ann.MQScore && CurrAnn.Annotation.compareTo(Ann.Annotation) > 0) {
                List2.add(i, Ann);
                FoundBetter = true;
                break;
            }
            ++i;
        }
        if (!FoundBetter) {
            List2.add(Ann);
        }
        if (List2.size() > this.ActualNumHitsPerSpectrum) {
            List2.remove(List2.size() - 1);
        }
        return List2;
    }

    public void DebugPrintAnns(ArrayList List2) {
        int i = 0;
        while (i < List2.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)List2.get(i);
            System.out.println("[" + i + "] " + CurrAnn.SpectrumFile + ":" + CurrAnn.ScanNumber + ":" + CurrAnn.Annotation + " - " + CurrAnn.MQScore);
            ++i;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-d", "-n"};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLineMulti(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: You must specify at least one input file");
            System.out.println(UsageInfo);
            return;
        }
        ArrayList Temp = (ArrayList)CommandLineArgs.get("-r");
        Object[] InputFiles = new String[Temp.size()];
        int i = 0;
        while (i < InputFiles.length) {
            InputFiles[i] = (String)Temp.get(i);
            ++i;
        }
        Arrays.sort(InputFiles);
        if (!CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: You must specify at an output file");
            System.out.println(UsageInfo);
            return;
        }
        Temp = (ArrayList)CommandLineArgs.get("-w");
        String OutputFile = (String)Temp.get(0);
        int NumHits = 10;
        if (CommandLineArgs.containsKey("-n")) {
            Temp = (ArrayList)CommandLineArgs.get("-n");
            NumHits = Integer.parseInt((String)Temp.get(0));
        }
        CombineInspectResults Combiner = new CombineInspectResults((String[])InputFiles, OutputFile, NumHits);
        if (CommandLineArgs.containsKey("-d")) {
            Combiner.Debug = true;
        }
        Combiner.Combine();
    }
}

