/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.GFFFile;
import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import proteogenomicUtils.BipartiteGraphAnalyzer;
import proteogenomicUtils.ClusterRescorer;
import proteogenomicUtils.EventFinder;
import proteogenomicUtils.GenomicLocator;
import proteogenomicUtils.ProteogenomicUtils;
import proteogenomicUtils.SplitLocationsBySequence;
import trieUtils.TrieDB;

public class GenomeClusterer {
    public static final String UsageInfo = "UsageInfo: proteogenomicUtils.GenomeClusterer, Version 2012.03.12\nGroups peptide locations into clusters, classifies them as intragenic or intergenic, writes \nGFF-style hints of clusters for AUGUSUSTUS.  If known peptides are also given, they can be included in \npeptide clusters.  For clusters not meeting the minimum number of unique peptides criteria, cluster groups\ncan be reported.  The script creates intermediate files that separate locations by sequence (i.e. chromosomes).\nIf these intermediate files exist from a previous run, and are in the output directory, the locations will be \nclustered with the previous locations\n[Required]\n-r [DIR] Directory containing peptide locations.  If directory, then all files are loaded.\n-w [DIR] Directory to write cluster files and/or gffs to\n[Optional]\n-g [0/1] Write clusters in GFF format, if 0 then only human-readable format, if 1 then write gff format and human-readable format\n-l [NUM] The distance between two adjacent peptides (default: 1000 bp)\n-c [NUM] Minimum number of locations per cluster (default: 1)\n-m [NUM] Minimum number of uniquely located peptides per cluster (default: 0)\n-k [FILE] Known proteins GFF (Filtered Set)\n-s [FILE] Known proteins GFF (Working Set), if only one set of known proteins, use '-k'\n-x [NUM:NUM:NUM or NUM] Minimum event probability (give the event cutoffs separately for novel genes, distal events, and proximal events, or just give a single cutoff)\n-f [0/1] Human readable format (0:table or 1:full info)\n-e [FILE] Compute events and write them to specified file\n-i [DIR] Directory containing known peptides\n-t [FILE] Trie file of known proteins\n-y [FILE] Write sister cluster!\n-a [FILE] File with conversions between GFF transcript name to FASTA protein name\n-h [NUM] Column containing the GFF Transcript name in the conversion file (default:2)\n-j [NUM] Column containing the FASTA protein name in the conversion file (default:3)\n-n [NUM] Column containing the gene name in the conversion file (default: 1)\n-p [NAME] Case-insensitive feature name which contains the gene boundaries in the GFF files (default: mrna)\n";
    private static final boolean OverwriteOldFiles = true;
    public static int MIN_MATED_CLUSTER_SIZE = 1;
    public static String CLUSTER_HEADER_DELIM = "!";
    private int LinkageDistance = 1000;
    private int MinClusterSize = 1;
    private int MinNumUnique = 0;
    private boolean WriteGFFs = false;
    private boolean WriteClusterGroups = false;
    private String InputDir = null;
    private String OutputDir = null;
    private int OutputFormat = 0;
    private String FilteredSetFile = null;
    private String WorkingSetFile = null;
    private Hashtable KnownLocations = null;
    private ArrayList Events = null;
    private EventFinder F = null;
    private String[] GFFFiles = null;
    private int MaxTempFileSize = 1000000;
    private double[] MinEventProbs05 = new double[]{0.99996, 0.99603, 0.99422};
    private double[] MinEventProbsOldOld = new double[]{0.95, 0.951, 0.788};
    private double[] MinEventProbsOld = new double[]{0.9981, 0.0, 0.0};
    private double[] MinEventProbs = new double[]{0.99828, 0.998, 0.994};
    private boolean defaultScoring = true;
    private String EventOutputFile = null;
    private boolean ComputeEvents = false;
    private boolean Debug = false;
    private String KnownPeptidesDir;
    private TrieDB KnownProteinTrie;
    private ArrayList sharedClusters;
    private Hashtable Protein2KnownPeptideHash;
    private HashSet selectedPeptides;
    private boolean dealWithSharedClusters = false;
    private String sharedClustersFile;
    private String geneConversionFile = null;
    private int transcriptNameCol = 2;
    private int protNameCol = 3;
    private int geneNameCol = 1;
    private Hashtable GFFToFASTAMap = null;
    private Hashtable FASTAToGeneMap = null;
    private int leaveOutCount = 0;
    private String geneBoundaryFeatureName = "mrna";

    public GenomeClusterer(String InputDir, String OutputDir, String species) {
        this.InputDir = InputDir;
        this.OutputDir = OutputDir;
    }

    public void Cluster() {
        System.out.println("PROGRAM PARAMS:");
        System.out.println("Input Directory: " + this.InputDir);
        System.out.println("Output Directory: " + this.OutputDir);
        System.out.println("Compute Events: " + this.ComputeEvents);
        System.out.println("Protein Comparison Group: " + this.FilteredSetFile);
        if (this.WorkingSetFile != null) {
            System.out.println("Working Set Group: " + this.WorkingSetFile);
        }
        System.out.println("CLUSTER PARAMS:");
        System.out.println("Linkage Distance: " + this.LinkageDistance + " bp");
        System.out.println("Min Cluster Size: " + this.MinClusterSize);
        System.out.println("Min Unique Peptides: " + this.MinNumUnique);
        if (this.ComputeEvents) {
            System.out.println("Min Event Probability (novel genes): " + this.MinEventProbs[0]);
            System.out.println("Min Event Probability (gene boundary, reverse strand, Translated UTR): " + this.MinEventProbs[1]);
            System.out.println("Min Event Probability (frame shift, exon boundary, novel splice, novel exon): " + this.MinEventProbs[2]);
            System.out.println("Event file: " + this.EventOutputFile);
            if (this.leaveOutCount != 0) {
                System.out.println("Leaving out this many genes: " + this.leaveOutCount);
            }
        }
        if (this.KnownPeptidesDir != null && this.KnownProteinTrie != null) {
            System.out.println("Known peptides directory: " + this.KnownPeptidesDir);
            System.out.println("Known protein sequence: " + this.KnownProteinTrie.getTrieFileName());
        }
        if (this.dealWithSharedClusters) {
            System.out.println("Shared cluster file: " + this.sharedClustersFile);
        }
        if (this.geneConversionFile != null) {
            System.out.println("Using gene name map file: " + this.geneConversionFile);
        }
        if (this.geneConversionFile != null) {
            this.GFFToFASTAMap = ProteogenomicUtils.loadTranslationFile(this.geneConversionFile, this.transcriptNameCol, this.protNameCol);
            this.FASTAToGeneMap = ProteogenomicUtils.loadTranslationFile(this.geneConversionFile, this.protNameCol, this.geneNameCol);
            System.out.println(" - Loaded " + this.GFFToFASTAMap.size() + " GFF to FASTA elements");
            System.out.println(" - Loaded " + this.FASTAToGeneMap.size() + " FASTA to Gene elements");
        }
        this.sharedClusters = new ArrayList();
        System.out.println("Clearing directory " + this.OutputDir);
        Utils.ClearDir(this.OutputDir);
        if (this.sharedClustersFile != null) {
            Utils.DeleteFile(this.sharedClustersFile);
        }
        if (this.EventOutputFile != null) {
            Utils.DeleteFile(this.EventOutputFile);
        }
        System.out.println("Splitting locations by sequence...");
        String[] LocationsBySequence = SplitLocationsBySequence.SplitBySequence(this.InputDir, this.OutputDir, true);
        System.out.println("Clustering by sequence...");
        if (this.ComputeEvents) {
            this.Events = new ArrayList();
            this.GFFFiles = this.WorkingSetFile == null ? new String[1] : new String[2];
            this.GFFFiles[0] = this.FilteredSetFile;
            if (this.WorkingSetFile != null) {
                this.GFFFiles[1] = this.WorkingSetFile;
            }
        }
        if (this.KnownPeptidesDir != null && this.KnownProteinTrie != null) {
            this.LoadKnownPeptideLocs();
        }
        this.selectedPeptides = new HashSet();
        int i = 0;
        while (i < LocationsBySequence.length) {
            System.out.println("Clustering locations for file: " + LocationsBySequence[i]);
            this.F = null;
            this.ClusterFile(LocationsBySequence[i]);
            ++i;
        }
        if (this.dealWithSharedClusters) {
            this.DealWithSharedClusters();
        }
        if (this.ComputeEvents) {
            this.DealWithEvents();
        }
    }

    public static boolean clustersAreSisters(ArrayList cluster1, ArrayList cluster2) {
        if (cluster1.size() != cluster2.size()) {
            return false;
        }
        HashSet<String> peps = new HashSet<String>();
        int i = 0;
        while (i < cluster1.size()) {
            Object[] loc = (Object[])cluster1.get(i);
            String pepSeq = (String)loc[GenomicLocator.GenomicColumns.Peptide];
            peps.add(pepSeq);
            ++i;
        }
        HashSet<String> peps2 = new HashSet<String>();
        int i2 = 0;
        while (i2 < cluster2.size()) {
            Object[] loc = (Object[])cluster2.get(i2);
            String pepSeq = (String)loc[GenomicLocator.GenomicColumns.Peptide];
            if (!peps.contains(pepSeq)) {
                return false;
            }
            peps2.add(pepSeq);
            ++i2;
        }
        return peps.size() == peps2.size();
    }

    private void DealWithSharedClusters() {
        BipartiteGraphAnalyzer a = new BipartiteGraphAnalyzer(0.8);
        System.out.println("Total shared clusters: " + this.sharedClusters.size());
        BipartiteGraphAnalyzer.PeptideBipartiteGraph[] graphs = a.loadComponentsFromClusters(this.sharedClusters, this.sharedClustersFile, this.selectedPeptides);
        System.out.println("Total components(PLGs): " + graphs.length);
        if (this.ComputeEvents) {
            int sharedEventCount = 0;
            Hashtable<String, ArrayList> clustersBySeq = new Hashtable<String, ArrayList>();
            String clusterEventFileName = String.valueOf(Utils.GetFileNameNoExtension(this.sharedClustersFile)) + ".events.table.txt";
            String clusterEventFullFileName = String.valueOf(Utils.GetFileNameNoExtension(this.sharedClustersFile)) + ".events.expanded.txt";
            String clusterEventGFFFileName = String.valueOf(Utils.GetFileNameNoExtension(this.sharedClustersFile)) + ".events.gff";
            int i = 0;
            while (i < graphs.length) {
                HashSet eventTypes = new HashSet();
                boolean eventTypesMatch = true;
                int j = 0;
                while (j < graphs[i].clusters.size()) {
                    ArrayList currCluster = (ArrayList)graphs[i].clusters.get(j);
                    Object[] loc = (Object[])currCluster.get(0);
                    String CurrSequence = (String)loc[GenomicLocator.GenomicColumns.SequenceName];
                    ArrayList seqClusters = null;
                    seqClusters = clustersBySeq.containsKey(CurrSequence) ? (ArrayList)clustersBySeq.get(CurrSequence) : new ArrayList();
                    Object[] currEntry = new Object[]{new Integer(i), currCluster};
                    seqClusters.add(currEntry);
                    clustersBySeq.put(CurrSequence, seqClusters);
                    ++j;
                }
                ++i;
            }
            int ClusterNum = 0;
            Enumeration seqs = clustersBySeq.keys();
            ArrayList eventAndCompList = new ArrayList();
            while (seqs.hasMoreElements()) {
                String s = (String)seqs.nextElement();
                this.KnownLocations = this.LoadKnownGenes(s);
                this.F = new EventFinder(this.GFFFiles, s, this.geneBoundaryFeatureName);
                ArrayList clusters = (ArrayList)clustersBySeq.get(s);
                int i2 = 0;
                while (i2 < clusters.size()) {
                    Object[] currEntry = (Object[])clusters.get(i2);
                    int compID = (Integer)currEntry[0];
                    ArrayList currCluster = (ArrayList)currEntry[1];
                    String[] Proteins = this.GetOverlapWithKnown(currCluster);
                    String ClusterHeader = this.CreateClusterHeader(s, ClusterNum, 0, currCluster.size(), Proteins);
                    ++ClusterNum;
                    EventFinder.Event[] events = this.F.CreateAllEvents(currCluster, ClusterHeader);
                    currEntry[0] = new Integer(compID);
                    currEntry[1] = events;
                    eventAndCompList = Utils.InsertObjectArrayInOrder(eventAndCompList, currEntry, 0);
                    ++i2;
                }
            }
            int listIndex = 0;
            FileWriter f = null;
            FileWriter fFull = null;
            FileWriter fGFF = null;
            try {
                f = new FileWriter(clusterEventFileName);
                f.write("#ComponentNum\tLocusNum\tOtherEventInfo\n");
                fFull = new FileWriter(clusterEventFullFileName);
                fGFF = new FileWriter(clusterEventGFFFileName);
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(5, clusterEventFileName);
            }
            int i3 = 0;
            while (i3 < graphs.length) {
                int expectedNum = graphs[i3].clusters.size();
                int start = listIndex;
                Object[] currEntry = (Object[])eventAndCompList.get(listIndex);
                int compID = (Integer)currEntry[0];
                while (compID < i3) {
                    currEntry = (Object[])eventAndCompList.get(++listIndex);
                    compID = (Integer)currEntry[0];
                }
                if (compID > i3) {
                    System.out.println("WARNING: We have no events for component " + i3 + " with " + expectedNum + " loci");
                } else {
                    start = listIndex++;
                    while (compID == i3 && listIndex < eventAndCompList.size()) {
                        currEntry = (Object[])eventAndCompList.get(listIndex);
                        compID = (Integer)currEntry[0];
                        ++listIndex;
                    }
                    int end = listIndex;
                    if (expectedNum != end - start) {
                        System.out.println("WARNING: We have found " + (end - start) + " components when we only expect " + expectedNum + " from component " + i3);
                    }
                    HashSet<EventFinder.EventType> eventTypes = new HashSet<EventFinder.EventType>();
                    String[] fileLines = new String[end - start];
                    String[] fullFileLines = new String[end - start];
                    String[] gffFileLines = new String[end - start];
                    boolean eventTypesMatch = true;
                    int j = 0;
                    while (j < end - start) {
                        String l = String.valueOf(i3) + "\t" + j;
                        currEntry = (Object[])eventAndCompList.get(start + j);
                        EventFinder.Event[] events = (EventFinder.Event[])currEntry[1];
                        fullFileLines[j] = "";
                        gffFileLines[j] = "";
                        int h = 0;
                        while (h < events.length) {
                            int n = j;
                            fullFileLines[n] = String.valueOf(fullFileLines[n]) + events[h].CreateFileString();
                            int n2 = j;
                            gffFileLines[n2] = String.valueOf(gffFileLines[n2]) + events[h].CreateGFFFileString();
                            if (events[h].Type == EventFinder.EventType.NovelGene) {
                                l = String.valueOf(l) + "\t" + events[h].CreateOneLineStringNovelGene();
                            } else {
                                String proteinName = events[h].RefinedFeature.toLowerCase();
                                if (this.GFFToFASTAMap == null || !this.GFFToFASTAMap.containsKey(proteinName)) {
                                    System.err.println("WARNING: Unable to find FASTA name for GFF name '" + proteinName + ". Using GFF name");
                                } else {
                                    proteinName = (String)this.GFFToFASTAMap.get(proteinName);
                                }
                                String[] knownPeptideInfo = null;
                                if (this.Protein2KnownPeptideHash != null && this.Protein2KnownPeptideHash.containsKey(proteinName)) {
                                    knownPeptideInfo = (String[])this.Protein2KnownPeptideHash.get(proteinName);
                                }
                                l = String.valueOf(l) + "\t" + events[h].CreateOneLineString(knownPeptideInfo);
                            }
                            ++h;
                        }
                        fileLines[j] = l;
                        if (j == 0) {
                            int e = 0;
                            while (e < events.length) {
                                eventTypes.add(events[e].Type);
                                ++e;
                            }
                        } else {
                            HashSet<EventFinder.EventType> otherTypes = new HashSet<EventFinder.EventType>();
                            int e = 0;
                            while (e < events.length) {
                                otherTypes.add(events[e].Type);
                                ++e;
                            }
                            if (!otherTypes.equals(eventTypes)) {
                                eventTypesMatch = false;
                            }
                        }
                        ++j;
                    }
                    if (eventTypesMatch) {
                        ++sharedEventCount;
                        int k = 0;
                        while (k < fileLines.length) {
                            try {
                                f.write(fileLines[k]);
                                fFull.write(fullFileLines[k]);
                                fGFF.write(gffFileLines[k]);
                            }
                            catch (IOException E) {
                                ErrorThrower.ThrowError(7, clusterEventFileName);
                            }
                            ++k;
                        }
                    }
                }
                ++i3;
            }
            try {
                f.close();
                fFull.close();
                fGFF.close();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(8, clusterEventFileName);
            }
            System.out.println("Found " + sharedEventCount + " components with the same events");
        }
    }

    private void DealWithSharedClustersPerfectBiCliques() {
        boolean localDebug = false;
        int totalSisterClusterGroups = 0;
        int clustersInGroups = 0;
        System.out.println("Found " + this.sharedClusters.size() + " total clusters with no unique peptides");
        FileWriter f = null;
        boolean[] considered = new boolean[this.sharedClusters.size()];
        int i = 0;
        while (i < considered.length) {
            considered[i] = false;
            ++i;
        }
        String GFFFileName = String.valueOf(Utils.GetFileNameNoExtension(this.sharedClustersFile)) + ".gff";
        FileWriter f2 = null;
        try {
            f = new FileWriter(this.sharedClustersFile, false);
            f2 = new FileWriter(GFFFileName, false);
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, String.valueOf(this.sharedClustersFile) + " and " + GFFFileName);
        }
        int clusterIndex = 0;
        while (clusterIndex < this.sharedClusters.size()) {
            if (!considered[clusterIndex]) {
                considered[clusterIndex] = true;
                ArrayList currCluster = (ArrayList)this.sharedClusters.get(clusterIndex);
                ArrayList<Integer> sisterClusters = new ArrayList<Integer>();
                int index2 = clusterIndex + 1;
                while (index2 < this.sharedClusters.size()) {
                    ArrayList sisCluster;
                    if (!considered[index2] && GenomeClusterer.clustersAreSisters(currCluster, sisCluster = (ArrayList)this.sharedClusters.get(index2))) {
                        sisterClusters.add(new Integer(index2));
                    }
                    ++index2;
                }
                if (sisterClusters.size() >= 1) {
                    if (localDebug) {
                        System.out.println("Found a sister groups for this guy of size " + (sisterClusters.size() + 1) + "!!");
                    }
                    int i2 = 0;
                    while (i2 < currCluster.size()) {
                        Object[] loc = (Object[])currCluster.get(i2);
                        int locCount = (Integer)loc[GenomicLocator.GenomicColumns.LocationCount];
                        if (locCount == sisterClusters.size() + 1) {
                            int idx;
                            if (localDebug) {
                                System.out.println("Found a peptide '" + (String)loc[GenomicLocator.GenomicColumns.Peptide] + "' with " + locCount + " locations");
                            }
                            clustersInGroups += sisterClusters.size() + 1;
                            try {
                                f.write("#SisterGroup:" + totalSisterClusterGroups + ",size: " + (sisterClusters.size() + 1) + ",peptides:" + currCluster.size() + "\n");
                                int groupIndex = 0;
                                int j = 0;
                                while (j < currCluster.size()) {
                                    f2.write(GenomicLocator.GenomicColumns.toGFFFileLine((Object[])currCluster.get(j), "SisterGroup" + totalSisterClusterGroups + "." + groupIndex));
                                    f.write(String.valueOf(groupIndex) + "\t" + GenomicLocator.GenomicColumns.toString((Object[])currCluster.get(j), "\t") + "\n");
                                    ++j;
                                }
                                groupIndex = 0;
                                while (groupIndex < sisterClusters.size()) {
                                    idx = (Integer)sisterClusters.get(groupIndex);
                                    ArrayList cluster = (ArrayList)this.sharedClusters.get(idx);
                                    int j2 = 0;
                                    while (j2 < cluster.size()) {
                                        f2.write(GenomicLocator.GenomicColumns.toGFFFileLine((Object[])cluster.get(j2), "SisterGroup" + totalSisterClusterGroups + "." + (groupIndex + 1)));
                                        f.write(String.valueOf(groupIndex + 1) + "\t" + GenomicLocator.GenomicColumns.toString((Object[])cluster.get(j2), "\t") + "\n");
                                        ++j2;
                                    }
                                    ++groupIndex;
                                }
                                f.write("\n");
                            }
                            catch (IOException E) {
                                ErrorThrower.ThrowError(7, String.valueOf(this.sharedClustersFile) + " and " + GFFFileName);
                            }
                            ++totalSisterClusterGroups;
                            int g = sisterClusters.size() - 1;
                            while (g >= 0) {
                                idx = (Integer)sisterClusters.get(g);
                                if (localDebug) {
                                    System.out.println("Removing cluster at " + idx);
                                }
                                considered[idx] = true;
                                --g;
                            }
                            i2 = currCluster.size();
                            break;
                        }
                        ++i2;
                    }
                }
            }
            ++clusterIndex;
        }
        System.out.println("Found " + totalSisterClusterGroups + " cluster groups!!");
        System.out.println("Loci in groups: " + clustersInGroups);
        try {
            f.close();
            f2.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, String.valueOf(this.sharedClustersFile) + " and " + GFFFileName);
        }
    }

    private void LoadKnownPeptideLocs() {
        String[] peptides = InspectAnnotation.LoadPeptidesDir(this.KnownPeptidesDir);
        this.Protein2KnownPeptideHash = new Hashtable();
        int sharedPeptides = 0;
        int locPeptides = 0;
        String[] temp = new String[5000];
        int tempIndex = 0;
        int i = 0;
        while (i < peptides.length) {
            temp[tempIndex] = peptides[i];
            if (++tempIndex == temp.length) {
                Hashtable locations = this.KnownProteinTrie.GetAllLocations(temp);
                int j = 0;
                while (j < temp.length) {
                    ArrayList currLocs = (ArrayList)locations.get(temp[j]);
                    ProteogenomicUtils.uniqueType uniquenessType = ProteogenomicUtils.getUniquenessType(currLocs, this.FASTAToGeneMap);
                    if (uniquenessType == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                        ++locPeptides;
                    }
                    if (uniquenessType == ProteogenomicUtils.uniqueType.SHARED) {
                        ++sharedPeptides;
                    }
                    int k = 0;
                    while (k < currLocs.size()) {
                        String[] temp2;
                        Object[] loc = (Object[])currLocs.get(k);
                        String proteinName = (String)loc[3];
                        if (this.Protein2KnownPeptideHash.containsKey(proteinName = proteinName.split(" ")[0].toLowerCase())) {
                            temp2 = (String[])this.Protein2KnownPeptideHash.get(proteinName);
                        } else {
                            temp2 = new String[3];
                            int t = 0;
                            while (t < temp2.length) {
                                temp2[t] = "";
                                ++t;
                            }
                        }
                        if (uniquenessType == ProteogenomicUtils.uniqueType.PROT_UNIQUE) {
                            if (temp2[0].compareTo("") != 0) {
                                temp2[0] = String.valueOf(temp2[0]) + ",";
                            }
                            temp2[0] = String.valueOf(temp2[0]) + temp[j];
                        } else if (uniquenessType == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                            if (temp2[1].compareTo("") != 0) {
                                temp2[1] = String.valueOf(temp2[1]) + ",";
                            }
                            temp2[1] = String.valueOf(temp2[1]) + temp[j];
                        } else if (uniquenessType == ProteogenomicUtils.uniqueType.SHARED) {
                            if (temp2[2].compareTo("") != 0) {
                                temp2[2] = String.valueOf(temp2[2]) + ",";
                            }
                            temp2[2] = String.valueOf(temp2[2]) + temp[j];
                        } else {
                            System.out.println("WARNING: UNABLE TO DETERMINE UNIQUENESS OF PEPTIDE " + temp[j]);
                        }
                        this.Protein2KnownPeptideHash.put(proteinName, temp2);
                        ++k;
                    }
                    temp[j] = null;
                    ++j;
                }
                tempIndex = 0;
            }
            ++i;
        }
        if (tempIndex > 0) {
            Hashtable locations = this.KnownProteinTrie.GetAllLocations(temp);
            int j = 0;
            while (j < tempIndex) {
                ArrayList currLocs = (ArrayList)locations.get(temp[j]);
                ProteogenomicUtils.uniqueType uniquenessType = ProteogenomicUtils.getUniquenessType(currLocs, this.FASTAToGeneMap);
                if (uniquenessType == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                    ++locPeptides;
                }
                if (uniquenessType == ProteogenomicUtils.uniqueType.SHARED) {
                    ++sharedPeptides;
                }
                int k = 0;
                while (k < currLocs.size()) {
                    String[] temp2;
                    Object[] loc = (Object[])currLocs.get(k);
                    String proteinName = (String)loc[3];
                    if (this.Protein2KnownPeptideHash.containsKey(proteinName = proteinName.split(" ")[0].toLowerCase())) {
                        temp2 = (String[])this.Protein2KnownPeptideHash.get(proteinName);
                    } else {
                        temp2 = new String[3];
                        int t = 0;
                        while (t < temp2.length) {
                            temp2[t] = "";
                            ++t;
                        }
                    }
                    if (uniquenessType == ProteogenomicUtils.uniqueType.PROT_UNIQUE) {
                        if (temp2[0].compareTo("") != 0) {
                            temp2[0] = String.valueOf(temp2[0]) + ",";
                        }
                        temp2[0] = String.valueOf(temp2[0]) + temp[j];
                    } else if (uniquenessType == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                        if (temp2[1].compareTo("") != 0) {
                            temp2[1] = String.valueOf(temp2[1]) + ",";
                        }
                        temp2[1] = String.valueOf(temp2[1]) + temp[j];
                    } else if (uniquenessType == ProteogenomicUtils.uniqueType.SHARED) {
                        if (temp2[2].compareTo("") != 0) {
                            temp2[2] = String.valueOf(temp2[2]) + ",";
                        }
                        temp2[2] = String.valueOf(temp2[2]) + temp[j];
                    }
                    this.Protein2KnownPeptideHash.put(proteinName, temp2);
                    ++k;
                }
                temp[j] = null;
                ++j;
            }
        }
        System.out.println("Loaded " + peptides.length + " peptides into " + this.Protein2KnownPeptideHash.size() + " proteins");
        System.out.println("Shared: " + sharedPeptides);
        System.out.println("Locspecific: " + locPeptides);
    }

    private Hashtable LoadKnownGenes(String SeqName) {
        BufferedReader buf = null;
        int ProteinCount = 0;
        String Line = null;
        Hashtable<String, ArrayList> Ret = new Hashtable<String, ArrayList>();
        try {
            buf = new BufferedReader(new FileReader(this.FilteredSetFile));
            Line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, this.FilteredSetFile);
        }
        SeqName = SeqName.toLowerCase();
        System.out.println("Loading known genes for " + SeqName + "...");
        while (Line != null) {
            String[] Bits;
            if ((Line = Line.trim()).length() > 0 && Line.charAt(0) != '#' && (Bits = Line.split("\t"))[GFFFile.GFFColumns.FeatureType].toLowerCase().compareTo(this.geneBoundaryFeatureName) == 0) {
                ArrayList AllLocs;
                Object[] Location = GenomicLocator.GenomicColumns.LoadFromGFFLine(Line, this.FilteredSetFile);
                String Key2 = ((String)Location[GenomicLocator.GenomicColumns.SequenceName]).toLowerCase();
                if (SeqName.compareTo(Key2) != 0) {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        ErrorThrower.ThrowError(6, this.FilteredSetFile);
                    }
                    continue;
                }
                ++ProteinCount;
                if (Ret.containsKey(Key2)) {
                    AllLocs = (ArrayList)Ret.get(Key2);
                    AllLocs = GenomicLocator.GenomicColumns.InsertInOrder(AllLocs, Location);
                } else {
                    if (this.Debug) {
                        System.out.println("NEW SEQUENCE : " + Key2 + "!!!");
                    }
                    AllLocs = new ArrayList();
                    AllLocs.add(Location);
                }
                Ret.put(Key2, AllLocs);
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, this.FilteredSetFile);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, this.FilteredSetFile);
        }
        System.out.println("Loaded " + Ret.size() + " sequences with " + ProteinCount + " proteins");
        if (ProteinCount == 0) {
            ErrorThrower.ThrowWarningCustom(101, "No proteins were loaded from GFF.  All events will be Novel Genes!");
        }
        return Ret;
    }

    private String CreateClusterHeader(String CurrSequence, int ClusterNum, int NumUnique, int TotalCount, String[] CloseGenes) {
        String ClusterHeader = "#" + CurrSequence + CLUSTER_HEADER_DELIM + ClusterNum + CLUSTER_HEADER_DELIM + NumUnique + CLUSTER_HEADER_DELIM + TotalCount;
        if (CloseGenes == null) {
            return ClusterHeader;
        }
        String Proteins = "";
        int i = 0;
        while (i < CloseGenes.length) {
            Proteins = String.valueOf(Proteins) + CloseGenes[i];
            if (i < CloseGenes.length - 1) {
                Proteins = String.valueOf(Proteins) + ",";
            }
            ++i;
        }
        ClusterHeader = String.valueOf(ClusterHeader) + CLUSTER_HEADER_DELIM + Proteins;
        return ClusterHeader;
    }

    public static Object[] ParseClusterHeader(String Header) {
        String[] Proteins;
        Header = Header.substring(1);
        String[] Bits = Header.split(CLUSTER_HEADER_DELIM);
        Object[] Ret = new Object[5];
        Ret[0] = Bits[0];
        Ret[1] = new Integer(Bits[1]);
        Ret[2] = new Integer(Bits[2]);
        Ret[3] = new Integer(Bits[3]);
        if (Bits.length == 4) {
            Ret[4] = null;
            return Ret;
        }
        Ret[4] = Proteins = Bits[4].split(",");
        return Ret;
    }

    public static String[] GetClusterProteins(String Header) {
        String[] Bits = (Header = Header.substring(1)).split(CLUSTER_HEADER_DELIM);
        if (Bits.length == 4) {
            return null;
        }
        return Bits[4].split(",");
    }

    private void ClusterFile(String LocationsFile) {
        String OutputFileName = String.valueOf(this.OutputDir) + File.separator + Utils.GetBaseNameNoExtension(LocationsFile) + "_Clusters.txt";
        String GFFFileName = String.valueOf(this.OutputDir) + File.separator + Utils.GetBaseNameNoExtension(LocationsFile) + "_Clusters.gff";
        FileWriter Writer2 = null;
        FileWriter GFFWriter = null;
        this.KnownLocations = null;
        int ClusterNum = 0;
        try {
            Writer2 = new FileWriter(OutputFileName, false);
            if (this.WriteGFFs) {
                GFFWriter = new FileWriter(GFFFileName);
            }
        }
        catch (IOException E) {
            String s = OutputFileName;
            if (this.WriteGFFs) {
                s = String.valueOf(s) + " and " + GFFFileName;
            }
            ErrorThrower.ThrowError(5, s);
        }
        ArrayList Locs = GenomicLocator.GenomicColumns.LoadFromFile(LocationsFile);
        if (this.Debug) {
            System.out.println("Total Locs: " + Locs.size());
        }
        ArrayList<Object[]> CurrCluster = new ArrayList<Object[]>();
        int UniqueCount = 0;
        int TotalCount = 0;
        String CurrSequence = null;
        Object[] PrevLoc = null;
        int IntergenicCount = 0;
        int IntragenicCount = 0;
        int i = 0;
        while (i < Locs.size()) {
            Object[] CurrLoc = (Object[])Locs.get(i);
            if (this.ComputeEvents && this.F == null) {
                this.F = new EventFinder(this.GFFFiles, (String)CurrLoc[GenomicLocator.GenomicColumns.SequenceName], this.geneBoundaryFeatureName);
            }
            if (PrevLoc == null) {
                if (this.Debug) {
                    System.out.println("Starting a new cluster!");
                }
                PrevLoc = CurrLoc;
                CurrCluster.add(PrevLoc);
                CurrSequence = (String)PrevLoc[GenomicLocator.GenomicColumns.SequenceName];
                if (((Boolean)PrevLoc[GenomicLocator.GenomicColumns.IsUnique]).booleanValue()) {
                    ++UniqueCount;
                }
                ++TotalCount;
            } else {
                int Distance = GenomicLocator.GenomicColumns.GetDistance(PrevLoc, (Object[])Locs.get(i));
                if (this.Debug) {
                    System.out.println("Prev: " + GenomicLocator.GenomicColumns.toString(PrevLoc, "\t"));
                    System.out.println("Curr: " + GenomicLocator.GenomicColumns.toString((Object[])Locs.get(i), "\t"));
                    System.out.println("Distance: " + Distance);
                    Utils.WaitForEnter();
                }
                if (Distance == -1 || Distance > this.LinkageDistance) {
                    if (this.Debug) {
                        System.out.println("Cannot be joined with cluster" + ClusterNum + ", unique: " + UniqueCount + ", total: " + TotalCount);
                    }
                    if (UniqueCount >= this.MinNumUnique && TotalCount >= this.MinClusterSize) {
                        if (this.Debug) {
                            System.out.println("But prev cluster is good enough!");
                        }
                        String[] Proteins = null;
                        if (this.FilteredSetFile != null) {
                            if (this.KnownLocations == null) {
                                this.KnownLocations = this.LoadKnownGenes(CurrSequence);
                            }
                            if ((Proteins = this.GetOverlapWithKnown(CurrCluster)) == null) {
                                if (this.Debug) {
                                    System.out.println("No overlapping genes!");
                                }
                                ++IntergenicCount;
                            } else {
                                if (this.Debug) {
                                    System.out.println("Found overlapping genes!");
                                }
                                ++IntragenicCount;
                            }
                        }
                        String ClusterHeader = this.CreateClusterHeader(CurrSequence, ClusterNum, UniqueCount, TotalCount, Proteins);
                        if (this.ComputeEvents) {
                            EventFinder.Event[] events = this.F.CreateAllEvents(CurrCluster, ClusterHeader);
                            int k = 0;
                            while (k < events.length) {
                                events[k].Prob = ClusterRescorer.GetEventProb(events[k]);
                                if (events[k].getNumUniquePeptides() >= this.MinNumUnique && events[k].getSupportingLocations().size() >= this.MinClusterSize && this.passesEventScoring(events[k])) {
                                    this.Events.add(events[k]);
                                }
                                ++k;
                            }
                        }
                        try {
                            Writer2.write(String.valueOf(ClusterHeader) + "\n");
                            this.AddPeptidesToSelectedSet(CurrCluster);
                            if (this.Debug) {
                                System.out.println(ClusterHeader);
                            }
                            int j = 0;
                            while (j < CurrCluster.size()) {
                                Writer2.write(String.valueOf(GenomicLocator.GenomicColumns.toString((Object[])CurrCluster.get(j), "\t")) + "\n");
                                if (this.WriteGFFs) {
                                    GFFWriter.write(GenomicLocator.GenomicColumns.toGFFFileLine((Object[])CurrCluster.get(j), ClusterHeader));
                                }
                                ++j;
                            }
                            Writer2.write("\n");
                        }
                        catch (IOException E) {
                            String s = OutputFileName;
                            if (this.WriteGFFs) {
                                s = String.valueOf(s) + " and " + GFFFileName;
                            }
                            ErrorThrower.ThrowError(7, s);
                        }
                        ++ClusterNum;
                    } else if (UniqueCount == 0 && TotalCount >= MIN_MATED_CLUSTER_SIZE) {
                        this.sharedClusters.add(CurrCluster);
                    }
                    CurrCluster = new ArrayList();
                    UniqueCount = 0;
                    TotalCount = 0;
                    PrevLoc = (Object[])Locs.get(i);
                    CurrCluster.add(PrevLoc);
                    CurrSequence = (String)PrevLoc[GenomicLocator.GenomicColumns.SequenceName];
                    if (((Boolean)PrevLoc[GenomicLocator.GenomicColumns.IsUnique]).booleanValue()) {
                        ++UniqueCount;
                    }
                    ++TotalCount;
                } else {
                    if (this.Debug) {
                        System.out.println("Can add to previous cluster!");
                    }
                    PrevLoc = (Object[])Locs.get(i);
                    CurrCluster.add(PrevLoc);
                    CurrSequence = (String)PrevLoc[GenomicLocator.GenomicColumns.SequenceName];
                    if (((Boolean)PrevLoc[GenomicLocator.GenomicColumns.IsUnique]).booleanValue()) {
                        ++UniqueCount;
                    }
                    ++TotalCount;
                }
            }
            if (this.Debug) {
                Utils.WaitForEnter();
            }
            ++i;
        }
        if (this.Debug) {
            System.out.println("Final cluster" + ClusterNum + ", unique: " + UniqueCount + ", total: " + TotalCount);
        }
        if (UniqueCount >= this.MinNumUnique && TotalCount >= this.MinClusterSize) {
            String[] Proteins = null;
            if (this.FilteredSetFile != null) {
                if (this.KnownLocations == null) {
                    this.KnownLocations = this.LoadKnownGenes(CurrSequence);
                }
                if ((Proteins = this.GetOverlapWithKnown(CurrCluster)) == null) {
                    ++IntergenicCount;
                } else {
                    ++IntragenicCount;
                }
            }
            String ClusterHeader = this.CreateClusterHeader(CurrSequence, ClusterNum, UniqueCount, TotalCount, Proteins);
            try {
                Writer2.write(String.valueOf(ClusterHeader) + "\n");
                this.AddPeptidesToSelectedSet(CurrCluster);
                if (this.Debug) {
                    System.out.println(ClusterHeader);
                }
                int j = 0;
                while (j < CurrCluster.size()) {
                    Writer2.write(String.valueOf(GenomicLocator.GenomicColumns.toString((Object[])CurrCluster.get(j), "\t")) + "\n");
                    if (this.Debug) {
                        System.out.println(GenomicLocator.GenomicColumns.toString((Object[])CurrCluster.get(j), "\t"));
                    }
                    if (this.WriteGFFs) {
                        GFFWriter.write(GenomicLocator.GenomicColumns.toGFFFileLine((Object[])CurrCluster.get(j), ClusterHeader));
                    }
                    ++j;
                }
                Writer2.write("\n");
            }
            catch (IOException E) {
                String s = OutputFileName;
                if (this.WriteGFFs) {
                    s = String.valueOf(s) + " and " + GFFFileName;
                }
                ErrorThrower.ThrowError(7, s);
            }
            if (this.ComputeEvents) {
                EventFinder.Event[] events = this.F.CreateAllEvents(CurrCluster, ClusterHeader);
                int k = 0;
                while (k < events.length) {
                    events[k].Prob = ClusterRescorer.GetEventProb(events[k]);
                    if (events[k].getNumUniquePeptides() >= this.MinNumUnique && events[k].getSupportingLocations().size() >= this.MinClusterSize && this.passesEventScoring(events[k])) {
                        this.Events.add(events[k]);
                    }
                    ++k;
                }
            }
        } else if (UniqueCount == 0 && TotalCount >= MIN_MATED_CLUSTER_SIZE) {
            this.sharedClusters.add(CurrCluster);
        }
        try {
            Writer2.close();
            if (this.WriteGFFs) {
                GFFWriter.close();
            }
        }
        catch (IOException E) {
            String s = OutputFileName;
            if (this.WriteGFFs) {
                s = String.valueOf(s) + " and " + GFFFileName;
            }
            ErrorThrower.ThrowError(8, s);
        }
        System.out.println("For file: " + LocationsFile);
        System.out.println("TotalClusters: " + (IntergenicCount + IntragenicCount));
        System.out.println("Intergenic: " + IntergenicCount);
        System.out.println("Intragenic: " + IntragenicCount);
    }

    private boolean passesEventScoring(EventFinder.Event event) {
        if (this.defaultScoring) {
            if (event.Type == EventFinder.EventType.NovelGene && event.getNumUniquePeptides() >= 2) {
                return true;
            }
            if ((event.Type == EventFinder.EventType.GeneBoundary || event.Type == EventFinder.EventType.TranslatedUTR || event.Type == EventFinder.EventType.ReverseStrand) && event.getNumUniquePeptides() >= 2) {
                return true;
            }
            if ((event.Type == EventFinder.EventType.ExonBoundary || event.Type == EventFinder.EventType.FrameShift || event.Type == EventFinder.EventType.NovelExon || event.Type == EventFinder.EventType.NovelSplice) && event.Prob > this.MinEventProbs[2]) {
                return true;
            }
        } else {
            if (event.Type == EventFinder.EventType.NovelGene && event.Prob > this.MinEventProbs[0]) {
                return true;
            }
            if ((event.Type == EventFinder.EventType.GeneBoundary || event.Type == EventFinder.EventType.TranslatedUTR || event.Type == EventFinder.EventType.ReverseStrand) && event.Prob > this.MinEventProbs[1]) {
                return true;
            }
            if ((event.Type == EventFinder.EventType.ExonBoundary || event.Type == EventFinder.EventType.FrameShift || event.Type == EventFinder.EventType.NovelExon || event.Type == EventFinder.EventType.NovelSplice) && event.Prob > this.MinEventProbs[2]) {
                return true;
            }
        }
        return false;
    }

    private void AddPeptidesToSelectedSet(ArrayList currCluster) {
        int j = 0;
        while (j < currCluster.size()) {
            Object[] loc = (Object[])currCluster.get(j);
            String peptide = (String)loc[GenomicLocator.GenomicColumns.Peptide];
            if (peptide.indexOf(".") >= 0) {
                peptide = peptide.substring(2, peptide.length() - 2);
            }
            this.selectedPeptides.add(peptide);
            ++j;
        }
    }

    private void DealWithEvents() {
        System.out.println("Identified " + this.Events.size() + " events!!");
        int[] EventCounts = new int[9];
        FileWriter F = null;
        FileWriter G = null;
        String GFFFileName = Utils.GetFileNameNoExtension(this.EventOutputFile);
        GFFFileName = String.valueOf(GFFFileName) + ".gff";
        try {
            F = new FileWriter(this.EventOutputFile, false);
            if (this.WriteGFFs) {
                G = new FileWriter(GFFFileName, false);
            }
        }
        catch (IOException E) {
            String s = this.EventOutputFile;
            if (this.WriteGFFs) {
                s = String.valueOf(s) + " and " + GFFFileName;
            }
            ErrorThrower.ThrowError(5, s);
        }
        int i = 0;
        while (i < this.Events.size()) {
            try {
                int Index = EventFinder.GetEventNum(((EventFinder.Event)this.Events.get((int)i)).Type);
                if (Index < 0 || Index >= EventCounts.length) {
                    System.err.println("ERROR: Can't count event of type " + (Object)((Object)((EventFinder.Event)this.Events.get((int)i)).Type));
                } else {
                    int n = Index;
                    EventCounts[n] = EventCounts[n] + 1;
                    String eString = null;
                    if (this.OutputFormat == 0) {
                        EventFinder.Event event = (EventFinder.Event)this.Events.get(i);
                        if (event.Type != EventFinder.EventType.NovelGene) {
                            String proteinName = event.RefinedFeature.toLowerCase();
                            if (this.GFFToFASTAMap == null || !this.GFFToFASTAMap.containsKey(proteinName)) {
                                System.err.println("WARNING: Unable to find protein name for '" + proteinName + "'.  Using transcript name instead");
                            } else {
                                proteinName = (String)this.GFFToFASTAMap.get(proteinName);
                            }
                            String[] knownPeptideInfo = null;
                            if (this.Protein2KnownPeptideHash != null && this.Protein2KnownPeptideHash.containsKey(proteinName)) {
                                knownPeptideInfo = (String[])this.Protein2KnownPeptideHash.get(proteinName);
                            } else if (this.Protein2KnownPeptideHash != null && this.Debug) {
                                System.out.println("NO PEPTIDES FOUND FOR " + proteinName);
                            }
                            eString = ((EventFinder.Event)this.Events.get(i)).CreateOneLineString(knownPeptideInfo);
                        } else {
                            eString = ((EventFinder.Event)this.Events.get(i)).CreateOneLineStringNovelGene();
                        }
                    } else {
                        eString = ((EventFinder.Event)this.Events.get(i)).CreateFileString();
                    }
                    int uniquePeptides = ((EventFinder.Event)this.Events.get(i)).getNumUniquePeptides();
                    int totalPeptides = ((EventFinder.Event)this.Events.get(i)).getSupportingLocations().size();
                    eString = eString.substring(0, eString.length() - 1);
                    eString = String.valueOf(eString) + "\t" + uniquePeptides;
                    eString = String.valueOf(eString) + "\t" + (totalPeptides - uniquePeptides);
                    eString = String.valueOf(eString) + "\t" + ClusterRescorer.GetEventProbUnique((EventFinder.Event)this.Events.get(i));
                    eString = String.valueOf(eString) + "\t" + ClusterRescorer.GetEventProbShared((EventFinder.Event)this.Events.get(i));
                    eString = String.valueOf(eString) + "\n";
                    F.write(eString);
                    if (this.WriteGFFs) {
                        G.write(((EventFinder.Event)this.Events.get(i)).CreateGFFFileString());
                    }
                }
            }
            catch (IOException E) {
                String s = this.EventOutputFile;
                if (this.WriteGFFs) {
                    s = String.valueOf(s) + " and " + GFFFileName;
                }
                ErrorThrower.ThrowError(7, s);
            }
            ++i;
        }
        try {
            F.close();
            if (this.WriteGFFs) {
                G.close();
            }
        }
        catch (IOException E) {
            String s = this.EventOutputFile;
            if (this.WriteGFFs) {
                s = String.valueOf(s) + " and " + GFFFileName;
            }
            ErrorThrower.ThrowError(8, s);
        }
        System.out.println("Event Types:");
        i = 0;
        while (i < EventCounts.length) {
            System.out.println((Object)((Object)EventFinder.GetEventName(i)) + ":" + EventCounts[i]);
            ++i;
        }
    }

    private String[] GetOverlapWithKnown(ArrayList Cluster) {
        Object[] GeneLocation;
        boolean LocalDebug = this.Debug;
        Object[] Location = (Object[])Cluster.get(0);
        String SeqName = ((String)Location[GenomicLocator.GenomicColumns.SequenceName]).toLowerCase();
        if (this.KnownLocations == null || !this.KnownLocations.containsKey(SeqName)) {
            System.out.println("NO GENES FOUND ON " + SeqName);
            return null;
        }
        ArrayList KnownGenes = (ArrayList)this.KnownLocations.get(SeqName);
        ArrayList MatchedGenes = new ArrayList();
        if (LocalDebug) {
            System.out.println("Considering overlap with cluster containing: ");
            System.out.println(GenomicLocator.GenomicColumns.toString(Location, " "));
        }
        int i = 0;
        while (i < Cluster.size()) {
            Location = (Object[])Cluster.get(i);
            if (LocalDebug) {
                System.out.println("Considering location " + GenomicLocator.GenomicColumns.toString(Location, " "));
            }
            int j = 0;
            while (j < KnownGenes.size()) {
                GeneLocation = (Object[])KnownGenes.get(j);
                if (LocalDebug) {
                    System.out.println("COMPARING TO: " + (String)GeneLocation[GenomicLocator.GenomicColumns.ProteinName]);
                    System.out.println("Start: " + (Integer)GeneLocation[GenomicLocator.GenomicColumns.Start]);
                    System.out.println("End: " + (Integer)GeneLocation[GenomicLocator.GenomicColumns.End]);
                    System.out.println("Strand: " + (Integer)GeneLocation[GenomicLocator.GenomicColumns.Strand]);
                }
                if (GenomicLocator.GenomicColumns.GetDistanceNoStrand(Location, GeneLocation) < 1000) {
                    if (LocalDebug) {
                        System.out.println("Have overlap!!");
                    }
                    MatchedGenes = GenomicLocator.GenomicColumns.InsertInOrder(MatchedGenes, GeneLocation);
                    if (LocalDebug) {
                        int k = 0;
                        while (k < MatchedGenes.size()) {
                            Object[] L = (Object[])MatchedGenes.get(k);
                            System.out.println("Matched Genes[" + k + "]: " + (String)L[GenomicLocator.GenomicColumns.ProteinName]);
                            ++k;
                        }
                        Utils.WaitForEnter();
                    }
                } else if (LocalDebug) {
                    System.out.println("No overlap!");
                }
                ++j;
            }
            ++i;
        }
        if (MatchedGenes.size() == 0) {
            return null;
        }
        String[] Ret = new String[MatchedGenes.size()];
        int i2 = 0;
        while (i2 < Ret.length) {
            GeneLocation = (Object[])MatchedGenes.get(i2);
            Ret[i2] = (String)GeneLocation[GenomicLocator.GenomicColumns.ProteinName];
            ++i2;
        }
        return Ret;
    }

    public static void main(String[] args) {
        int Val;
        String species;
        int speciesIndex;
        String OutputDir;
        String InputDir;
        File Tester2;
        String[] options = new String[]{"-w", "-g", "-l", "-c", "-m", "-r", "-k", "-s", "-d", "-e", "-x", "-f", "-i", "-t", "-y", "-b", "-a", "-h", "-j", "-n", "-p", "-q"};
        boolean[] blArray = new boolean[22];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        blArray[18] = true;
        blArray[19] = true;
        blArray[20] = true;
        blArray[21] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-b"))) {
            System.err.println(UsageInfo);
            System.err.println("Valid species: " + Utils.JoinStringArray(ProteogenomicUtils.species, ",") + "\n");
            ErrorThrower.ThrowError(2, "Must specify an input directory, output directory, and species!");
        }
        if (!(Tester2 = new File(InputDir = (String)CommandLineArgs.get("-r"))).exists() || !Tester2.isDirectory()) {
            System.err.println("ERROR: Must specify a valid directory for the input: " + InputDir);
            System.err.println(UsageInfo);
            ErrorThrower.ThrowError(1, InputDir);
        }
        if (!(Tester2 = new File(OutputDir = (String)CommandLineArgs.get("-w"))).exists()) {
            Tester2.mkdirs();
        }
        if ((speciesIndex = Utils.FindStringInArray(ProteogenomicUtils.species, species = (String)CommandLineArgs.get("-b"))) < 0) {
            ErrorThrower.ThrowError(4, "Invalid species '" + species + "'");
        }
        GenomeClusterer Driver = new GenomeClusterer(InputDir, OutputDir, species);
        if (CommandLineArgs.containsKey("-d")) {
            Driver.Debug = true;
        }
        if (CommandLineArgs.containsKey("-g")) {
            Val = Integer.parseInt((String)CommandLineArgs.get("-g"));
            if (Val == 0) {
                Driver.WriteGFFs = false;
            } else if (Val == 1) {
                Driver.WriteGFFs = true;
            } else {
                System.err.println(UsageInfo);
                ErrorThrower.ThrowError(4, "Invalid value for argument '-g', should be 0 or 1: " + Val);
            }
        }
        if (CommandLineArgs.containsKey("-e")) {
            Driver.ComputeEvents = true;
            Driver.EventOutputFile = (String)CommandLineArgs.get("-e");
            if (CommandLineArgs.containsKey("-x")) {
                String[] vals = ((String)CommandLineArgs.get("-x")).split(":");
                if (vals.length == 1) {
                    try {
                        Driver.MinEventProbs[0] = Double.parseDouble(vals[0]);
                        Driver.MinEventProbs[1] = Double.parseDouble(vals[0]);
                        Driver.MinEventProbs[2] = Double.parseDouble(vals[0]);
                    }
                    catch (Exception E) {
                        System.out.println(UsageInfo);
                        ErrorThrower.ThrowError(4, "Invalid value for argument '-x'");
                    }
                    Driver.defaultScoring = false;
                } else if (vals.length == 3) {
                    try {
                        Driver.MinEventProbs[0] = Double.parseDouble(vals[0]);
                        Driver.MinEventProbs[1] = Double.parseDouble(vals[1]);
                        Driver.MinEventProbs[2] = Double.parseDouble(vals[2]);
                    }
                    catch (Exception E) {
                        System.out.println(UsageInfo);
                        ErrorThrower.ThrowError(4, "Invalid value for argument '-x'");
                    }
                    Driver.defaultScoring = false;
                } else {
                    System.out.println(UsageInfo);
                    ErrorThrower.ThrowError(4, "Invalid value for argument '-x'");
                }
                int i = 0;
                while (i < Driver.MinEventProbs.length) {
                    if (Driver.MinEventProbs[i] < 0.0 || Driver.MinEventProbs[i] > 1.0) {
                        System.out.println(UsageInfo);
                        ErrorThrower.ThrowError(4, "Invalid value for argument '-x'");
                    }
                    ++i;
                }
            }
        }
        if (CommandLineArgs.containsKey("-l")) {
            Integer Val2 = Integer.parseInt((String)CommandLineArgs.get("-l"));
            if (Val2 <= 0) {
                System.err.println(UsageInfo);
                ErrorThrower.ThrowError(4, "Invalid value for argument '-l', must be greater than 0: " + Val2);
            }
            Driver.LinkageDistance = Val2;
        }
        if (CommandLineArgs.containsKey("-c")) {
            Val = Integer.parseInt((String)CommandLineArgs.get("-c"));
            if (Val <= 0) {
                System.err.println(UsageInfo);
                ErrorThrower.ThrowError(4, "Invalid value for argument '-c', must be greater than 0: " + Val);
            }
            Driver.MinClusterSize = Val;
        }
        if (CommandLineArgs.containsKey("-m")) {
            Val = Integer.parseInt((String)CommandLineArgs.get("-m"));
            if (Val < 0) {
                System.err.println(UsageInfo);
                ErrorThrower.ThrowError(4, "Invalid value for argument '-m', must be non-negative: " + Val);
            }
            Driver.MinNumUnique = Val;
        }
        if (CommandLineArgs.containsKey("-f")) {
            Val = Integer.parseInt((String)CommandLineArgs.get("-f"));
            if (Val != 0 && Val != 1) {
                System.err.println("ERROR: Invalid value for argument '-f', must be 0 or 1: " + Val);
                System.err.println(UsageInfo);
                System.exit(0);
            }
            Driver.OutputFormat = Val;
        }
        if (CommandLineArgs.containsKey("-r")) {
            Driver.WriteClusterGroups = true;
        }
        if (CommandLineArgs.containsKey("-k")) {
            String FilteredSetFile = (String)CommandLineArgs.get("-k");
            Tester2 = new File(FilteredSetFile);
            if (!Tester2.exists()) {
                System.err.println("ERROR: Invalid filtered gene set file name for '-k':" + FilteredSetFile);
                System.err.println(UsageInfo);
                System.exit(0);
            }
            Driver.FilteredSetFile = FilteredSetFile;
        }
        if (CommandLineArgs.containsKey("-y")) {
            Driver.sharedClustersFile = (String)CommandLineArgs.get("-y");
            Driver.dealWithSharedClusters = true;
        }
        if (CommandLineArgs.containsKey("-i")) {
            String KnownPeptidesDir = (String)CommandLineArgs.get("-i");
            Tester2 = new File(KnownPeptidesDir);
            if (!Tester2.exists()) {
                System.err.println("ERROR: Invalid known peptide directory for '-i':" + KnownPeptidesDir);
                System.err.println(UsageInfo);
                System.exit(0);
            }
            Driver.KnownPeptidesDir = KnownPeptidesDir;
        }
        if (CommandLineArgs.containsKey("-t")) {
            String KnownTrieFile = (String)CommandLineArgs.get("-t");
            Tester2 = new File(KnownTrieFile);
            if (!Tester2.exists()) {
                System.err.println("ERROR: Invalid known protein trie file for '-t':" + KnownTrieFile);
                System.err.println(UsageInfo);
                System.exit(0);
            }
            Driver.KnownProteinTrie = new TrieDB(KnownTrieFile);
        }
        if (CommandLineArgs.containsKey("-s")) {
            String WorkingSetFile = (String)CommandLineArgs.get("-s");
            Tester2 = new File(WorkingSetFile);
            if (!Tester2.exists()) {
                System.err.println("ERROR: Invalid working gene set file name for '-s':" + WorkingSetFile);
                System.err.println(UsageInfo);
                System.exit(0);
            }
            if (Driver.FilteredSetFile == null) {
                Driver.FilteredSetFile = WorkingSetFile;
            } else {
                Driver.WorkingSetFile = WorkingSetFile;
            }
        }
        if (CommandLineArgs.containsKey("-a")) {
            String conversionFile = (String)CommandLineArgs.get("-a");
            if (!Utils.IsFile(conversionFile)) {
                ErrorThrower.ThrowError(1, conversionFile);
            }
            Driver.geneConversionFile = conversionFile;
        }
        if (CommandLineArgs.containsKey("-h")) {
            String temp = (String)CommandLineArgs.get("-h");
            try {
                Driver.transcriptNameCol = Integer.parseInt(temp);
            }
            catch (Exception E) {
                ErrorThrower.ThrowError(4, "GFF transcript name column must be an integer");
            }
        }
        if (CommandLineArgs.containsKey("-j")) {
            String temp = (String)CommandLineArgs.get("-j");
            try {
                Driver.protNameCol = Integer.parseInt(temp);
            }
            catch (Exception E) {
                ErrorThrower.ThrowError(4, "FASTA file name column must be an integer");
            }
        }
        if (CommandLineArgs.containsKey("-n")) {
            String temp = (String)CommandLineArgs.get("-n");
            try {
                Driver.geneNameCol = Integer.parseInt(temp);
            }
            catch (Exception E) {
                ErrorThrower.ThrowError(4, "Gene name column must be an integer");
            }
        }
        if (CommandLineArgs.containsKey("-p")) {
            String temp = (String)CommandLineArgs.get("-p");
            Driver.geneBoundaryFeatureName = temp.toLowerCase();
        }
        if (CommandLineArgs.containsKey("-q")) {
            String temp = (String)CommandLineArgs.get("-q");
            try {
                Driver.leaveOutCount = Integer.parseInt(temp);
                if (Driver.leaveOutCount < 0) {
                    ErrorThrower.ThrowError(4, "Leave out count must be non-negative");
                }
            }
            catch (Exception E) {
                ErrorThrower.ThrowError(4, "Leave out count must be an integer");
            }
        }
        Driver.Cluster();
    }
}

