/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.util.ArrayList;
import java.util.Hashtable;
import proteogenomicUtils.ProteogenomicUtils;
import trieUtils.TrieDB;

public class PeptideAnalyzer {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("ERROR: Missing args");
            int i = 0;
            while (i < args.length) {
                System.out.println("args[" + i + "] = " + args[i]);
                ++i;
            }
            System.err.println("Usage: java -jar PeptideAnalyzer.jar (Input File/Dir) (Trie Proteome File) (Translation file)");
            System.exit(0);
        }
        Hashtable ProteinToGeneMap = ProteogenomicUtils.loadTranslationFile(args[2], 3, 1);
        String[] inputFiles = null;
        if (Utils.IsFile(args[0])) {
            inputFiles = new String[]{args[0]};
        } else if (Utils.IsDir(args[0])) {
            inputFiles = Utils.ListDir(args[0]);
        }
        TrieDB t = new TrieDB(args[1]);
        Hashtable<String, ProteogenomicUtils.uniqueType> peptideHash = new Hashtable<String, ProteogenomicUtils.uniqueType>();
        int uniqueCount = 0;
        int locusUniqueCount = 0;
        int sharedCount = 0;
        ArrayList<String> currPeptides = new ArrayList<String>();
        int i = 0;
        while (i < inputFiles.length) {
            System.out.println("Loading " + inputFiles[i]);
            String[] peps = InspectAnnotation.LoadPeptidesFile(inputFiles[i]);
            int j = 0;
            while (j < peps.length) {
                String p = Utils.RemoveFlankingAAs(peps[j]);
                if (!peptideHash.containsKey(p) && !currPeptides.contains(p)) {
                    currPeptides.add(p);
                    if (currPeptides.size() >= 5000) {
                        System.out.println("Reached " + currPeptides.size() + " peptides...");
                        Hashtable locs = t.GetAllLocations(Utils.ConvertArraylistToStringArray(currPeptides));
                        String[] keys = Utils.GetHashtableKeysString(locs);
                        int k = 0;
                        while (k < keys.length) {
                            String foundPep = keys[k];
                            ArrayList pepLocs = (ArrayList)locs.get(foundPep);
                            ProteogenomicUtils.uniqueType u = ProteogenomicUtils.getUniquenessType(pepLocs, ProteinToGeneMap);
                            peptideHash.put(foundPep, u);
                            if (u == ProteogenomicUtils.uniqueType.PROT_UNIQUE) {
                                ++uniqueCount;
                            } else if (u == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                                ++locusUniqueCount;
                            } else if (u == ProteogenomicUtils.uniqueType.SHARED) {
                                ++sharedCount;
                            }
                            ++k;
                        }
                        currPeptides.clear();
                    }
                }
                ++j;
            }
            ++i;
        }
        if (currPeptides.size() > 0) {
            System.out.println("Reached " + currPeptides.size() + " peptides...");
            Hashtable locs = t.GetAllLocations(Utils.ConvertArraylistToStringArray(currPeptides));
            String[] keys = Utils.GetHashtableKeysString(locs);
            int k = 0;
            while (k < keys.length) {
                String foundPep = keys[k];
                ArrayList pepLocs = (ArrayList)locs.get(foundPep);
                ProteogenomicUtils.uniqueType u = ProteogenomicUtils.getUniquenessType(pepLocs, ProteinToGeneMap);
                peptideHash.put(foundPep, u);
                if (u == ProteogenomicUtils.uniqueType.PROT_UNIQUE) {
                    ++uniqueCount;
                } else if (u == ProteogenomicUtils.uniqueType.LOC_UNIQUE) {
                    ++locusUniqueCount;
                } else if (u == ProteogenomicUtils.uniqueType.SHARED) {
                    ++sharedCount;
                }
                ++k;
            }
        }
        System.out.println("Total peptides: " + peptideHash.size());
        System.out.println(" - unique: " + uniqueCount);
        System.out.println(" - locUnique: " + locusUniqueCount);
        System.out.println(" - sharedCount: " + sharedCount);
        System.out.println(" sum: " + (uniqueCount + locusUniqueCount + sharedCount));
    }
}

