/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.Utils;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class PlotFeatureSizeHistogram {
    public static String UsageInfo = "proteogenomicUtils.PlotFeatureSizeHistogram\nPlots a histogram of the sizes of a given feature (e.g. 'CDS' or 'intron') from a\nGFF file.\n[Required]:\n-r [FILE] The GFF file containing the features\n-n [FEATURE] Feature name (case insensitive)\n-o [FILE] Output png file to create image\n[Optional]:\n-c [NUM] The maximum number of bins to plot (default: 5000)\n-x [NUM] The width of each bin (default: 10)\n";
    private static int DEFAULT_NUM_BINS = 5000;
    private static int DEFAULT_BIN_WIDTH = 10;
    private static int FEATURE_COLUMN = 2;
    private static int START_COLUMN = 3;
    private static int END_COLUMN = 4;

    /*
     * Unable to fully structure code
     */
    public static void Plot(String InputGFF, String FeatureName, String OutputFile, int NumBins, int BinWidth) {
        Counts = new double[NumBins];
        System.out.println("Scanning " + InputGFF + " for features of type " + FeatureName);
        MaxBinIndex = 0;
        LocalDebug = false;
        buf = null;
        Line = null;
        try {
            buf = new BufferedReader(new FileReader(InputGFF));
            Line = buf.readLine();
            if (true) ** GOTO lbl33
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        do {
            if ((Line = Line.trim()).length() != 0 && Line.charAt(0) != '#' && (Bits = Line.split("\t"))[PlotFeatureSizeHistogram.FEATURE_COLUMN].toLowerCase().compareTo(FeatureName) == 0) {
                if (LocalDebug) {
                    System.out.println(Line);
                }
                Start = Integer.parseInt(Bits[PlotFeatureSizeHistogram.START_COLUMN]);
                End = Integer.parseInt(Bits[PlotFeatureSizeHistogram.END_COLUMN]);
                Bin = (End - Start) / BinWidth;
                if (Bin >= NumBins) {
                    Bin = NumBins - 1;
                }
                v0 = Bin;
                Counts[v0] = Counts[v0] + 1.0;
                if (Bin > MaxBinIndex) {
                    MaxBinIndex = Bin;
                }
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
lbl33:
            // 2 sources

        } while (Line != null);
        dataset = new DefaultCategoryDataset();
        i = 0;
        while (i <= MaxBinIndex) {
            dataset.addValue(Counts[i], (Comparable)"Lengths", (Comparable)(i * BinWidth + " AAs"));
            System.out.println(String.valueOf(i) + " " + Counts[i]);
            ++i;
        }
        Chart = ChartFactory.createBarChart((String)("Histogram of " + FeatureName + " Sizes"), (String)"Size (AA)", (String)"Counts", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        Image = Chart.createBufferedImage(1000, 1000);
        ScoreFileName = String.valueOf(Utils.GetFileNameNoExtension(OutputFile)) + ".png";
        System.out.println("Created histo..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-n", "-o", "-c", "-x"};
        boolean[] values = new boolean[]{true, true, true, true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: You must specify an input file");
            System.out.println(UsageInfo);
            return;
        }
        if (!CommandLineArgs.containsKey("-n")) {
            System.err.println("ERROR: You must specify a feature type");
            System.out.println(UsageInfo);
            return;
        }
        if (!CommandLineArgs.containsKey("-o")) {
            System.err.println("ERROR: You must specify an output file");
            System.out.println(UsageInfo);
            return;
        }
        String InputFile = (String)CommandLineArgs.get("-r");
        String OutputFile = (String)CommandLineArgs.get("-o");
        String FeatureName = (String)CommandLineArgs.get("-n");
        FeatureName = FeatureName.toLowerCase();
        int NumBins = DEFAULT_NUM_BINS;
        int BinWidth = DEFAULT_BIN_WIDTH;
        if (CommandLineArgs.containsKey("-c")) {
            NumBins = Integer.parseInt((String)CommandLineArgs.get("-c"));
        }
        if (CommandLineArgs.containsKey("-x")) {
            BinWidth = Integer.parseInt((String)CommandLineArgs.get("-x"));
        }
        PlotFeatureSizeHistogram.Plot(InputFile, FeatureName, OutputFile, NumBins, BinWidth);
    }
}

