/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class ProteogenomicUtils {
    public static String[] species = new String[]{"maize", "arabidopsis", "human", "celegans", "zebrafish"};
    public static int[] chrCounts = new int[]{13, 7, 26};
    public static int[] chloroNum = new int[]{11, 6, -1};
    public static int[] mitoNum = new int[]{12, 7, 23};
    public static int[] unkNum = new int[]{13, -1, 24};
    public static int[] xNum = new int[]{-1, -1, 25};
    public static int[] yNum = new int[]{-1, -1, 26};

    public static String getChromosomeName(int chrNum, String species, String[] chrNames) {
        if (chrNames == null) {
            return ProteogenomicUtils.getChromosomeName(chrNum, species);
        }
        return chrNames[chrNum];
    }

    public static int getChromosomeNum(String chrStr, String species, String[] chrNames) {
        if (chrNames == null) {
            return ProteogenomicUtils.getChromosomeNum(chrStr, species);
        }
        return Utils.FindStringInArray(chrNames, chrStr);
    }

    public static int getNumChromosomes(String species, String[] chrNames) {
        if (chrNames == null) {
            return ProteogenomicUtils.getNumChromosomes(species);
        }
        return chrNames.length;
    }

    private static String getChromosomeName(int chrNum, String species) {
        String ret = "chr";
        int speciesIndex = Utils.FindStringInArray(ProteogenomicUtils.species, species.toLowerCase());
        if (speciesIndex < 0) {
            System.err.println("ERROR: ProteogenomicUtils.getChromosomeName: Cannot identify species '" + species + "'");
            return null;
        }
        if (chrNum < 1 || chrNum > chrCounts[speciesIndex]) {
            System.err.println("ERROR: ProteogenomiccUtils.getChromosomeName: Invalid chromosome number '" + chrNum + "' for species '" + species + "'");
            return null;
        }
        ret = chrNum == chloroNum[speciesIndex] ? String.valueOf(ret) + "C" : (chrNum == mitoNum[speciesIndex] ? String.valueOf(ret) + "M" : (chrNum == unkNum[speciesIndex] ? String.valueOf(ret) + "Unknown" : (chrNum == xNum[speciesIndex] ? String.valueOf(ret) + "X" : (chrNum == yNum[speciesIndex] ? String.valueOf(ret) + "Y" : String.valueOf(ret) + chrNum))));
        return ret;
    }

    private static int getChromosomeNum(String chrStr, String species) {
        int speciesIndex;
        boolean isDecoy = false;
        if (chrStr.length() >= 3 && chrStr.substring(0, 3).equals("XXX")) {
            chrStr = chrStr.substring(4);
            isDecoy = true;
        }
        if ((speciesIndex = Utils.FindStringInArray(ProteogenomicUtils.species, species.toLowerCase())) < 0) {
            System.err.println("ERROR: ProteogenomicUtils.getChromosomeNum: Cannot identify species '" + species + "'");
            return -1;
        }
        if (chrStr.length() >= 3 && chrStr.substring(0, 3).equalsIgnoreCase("chr")) {
            chrStr = chrStr.substring(3);
        }
        int chrNum = -1;
        try {
            chrNum = Integer.parseInt(chrStr);
        }
        catch (Exception E) {
            if (chrStr.equalsIgnoreCase("m") || chrStr.equalsIgnoreCase("mt")) {
                chrNum = mitoNum[speciesIndex];
            }
            if (chrStr.equalsIgnoreCase("unknown") || chrStr.equalsIgnoreCase("un")) {
                chrNum = unkNum[speciesIndex];
            }
            if (chrStr.equalsIgnoreCase("c") || chrStr.equalsIgnoreCase("pt")) {
                chrNum = chloroNum[speciesIndex];
            }
            if (chrStr.equalsIgnoreCase("x")) {
                chrNum = xNum[speciesIndex];
            }
            if (chrStr.equalsIgnoreCase("y")) {
                chrNum = yNum[speciesIndex];
            }
            System.err.println("ERROR: ProteogenomicUtils.getChromosomeNum: Cannot identify chromosome name '" + chrStr + "'");
            return -1;
        }
        if (isDecoy) {
            chrNum += chrCounts[speciesIndex];
        }
        return chrNum;
    }

    private static int getNumChromosomes(String species) {
        int speciesIndex = Utils.FindStringInArray(ProteogenomicUtils.species, species.toLowerCase());
        if (speciesIndex < 0) {
            System.err.println("ERROR: ProteogenomicUtils.getNumChromosomes: Cannot identify species '" + species + "'");
            return -1;
        }
        return chrCounts[speciesIndex];
    }

    public static Hashtable loadTranslationFile(String translationFile, int keyCol, int valCol) {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(translationFile));
            line = buf.readLine();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(5, translationFile);
        }
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    ErrorThrower.ThrowError(6, translationFile);
                }
            }
            String[] bits = line.split("\t");
            ret.put(bits[keyCol].toLowerCase(), bits[valCol].toLowerCase());
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                ErrorThrower.ThrowError(6, translationFile);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            ErrorThrower.ThrowError(8, translationFile);
        }
        return ret;
    }

    public static Hashtable loadTranslationFileMany(String infoFile, int i, int j) {
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        BufferedReader buf = Utils.openBufferedReader(infoFile);
        String line = Utils.readNextLine(buf, infoFile);
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = Utils.readNextLine(buf, infoFile);
                continue;
            }
            String[] bits = line.split("\t");
            String key = bits[i].toLowerCase();
            ArrayList vals = null;
            vals = ret.containsKey(key) ? (ArrayList)ret.get(key) : new ArrayList();
            vals.add(bits[j].toLowerCase());
            ret.put(key, vals);
            line = Utils.readNextLine(buf, infoFile);
        }
        Utils.closeBufferedReader(buf, infoFile);
        return ret;
    }

    public static uniqueType getUniquenessType(HashSet pNames, Hashtable ProtToGeneMap) {
        if (pNames.size() == 1) {
            return uniqueType.PROT_UNIQUE;
        }
        HashSet<String> locii = new HashSet<String>();
        for (String protName : pNames) {
            protName = ProteogenomicUtils.CleanUpProteinName(protName);
            String locusName = protName.toLowerCase();
            if (ProtToGeneMap == null || !ProtToGeneMap.containsKey(protName)) {
                System.err.println("WARNING: Cannot determine gene from protein '" + protName + "'.  Using it as gene name");
            } else {
                locusName = (String)ProtToGeneMap.get(protName);
            }
            locii.add(locusName);
        }
        if (locii.size() == 1) {
            return uniqueType.LOC_UNIQUE;
        }
        return uniqueType.SHARED;
    }

    public static uniqueType getUniquenessType(ArrayList currLocs, Hashtable ProtToGeneMap) {
        boolean debug = false;
        if (currLocs.size() == 1) {
            if (debug) {
                System.out.println("This peptide only has 1 locations, so it is prot_unique");
            }
            return uniqueType.PROT_UNIQUE;
        }
        HashSet<String> locii = new HashSet<String>();
        int i = 0;
        while (i < currLocs.size()) {
            String protName;
            Object[] currLoc = (Object[])currLocs.get(i);
            String locusName = protName = ProteogenomicUtils.CleanUpProteinName((String)currLoc[3]).toLowerCase();
            if (ProtToGeneMap == null || !ProtToGeneMap.containsKey(protName)) {
                System.err.println("WARNING:  gene from protein '" + protName + "'.  Using it as gene name");
            } else {
                locusName = (String)ProtToGeneMap.get(protName);
            }
            if (debug) {
                System.out.println("[" + i + "]: " + protName + "-> " + locusName);
            }
            locii.add(locusName);
            ++i;
        }
        if (locii.size() == 1) {
            if (debug) {
                System.out.println("THis peptide only has 1 locus, so it is loc_unique");
            }
            return uniqueType.LOC_UNIQUE;
        }
        if (debug) {
            System.out.println("This peptide is shared between several locii, so it is shared");
        }
        return uniqueType.SHARED;
    }

    public static String getChromosomeName(String string, String species) {
        int chrNum;
        block23: {
            int speciesIndex;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            String origString = string;
                            if (string.length() > 3 && string.substring(0, 3).equalsIgnoreCase("chr")) {
                                string = string.substring(3);
                            }
                            if ((speciesIndex = Utils.FindStringInArray(ProteogenomicUtils.species, species.toLowerCase())) < 0) {
                                System.err.println("ERROR: ProteogenomicUtils.getChromosomeName: Cannot identify species '" + species + "'");
                                return null;
                            }
                            try {
                                chrNum = Integer.parseInt(string);
                                if (chrNum != chloroNum[speciesIndex]) break block19;
                                return "chrC";
                            }
                            catch (NumberFormatException E) {
                                if ((string.equalsIgnoreCase("mt") || string.equalsIgnoreCase("m")) && mitoNum[speciesIndex] > 0) {
                                    return "chrM";
                                }
                                if (string.equalsIgnoreCase("mt") || string.equalsIgnoreCase("m")) {
                                    ErrorThrower.ThrowWarning(4, "There is no mitochondrial chromosome in species '" + species + "'!");
                                    return origString;
                                }
                                if ((string.equalsIgnoreCase("pt") || string.equalsIgnoreCase("c")) && chloroNum[speciesIndex] > 0) {
                                    return "chrC";
                                }
                                if (string.equalsIgnoreCase("pt") || string.equalsIgnoreCase("c")) {
                                    ErrorThrower.ThrowWarning(4, "There is no chloroplast chromosome in species '" + species + "'!");
                                    return origString;
                                }
                                if (string.equalsIgnoreCase("x") && xNum[speciesIndex] > 0) {
                                    return "chrX";
                                }
                                if (string.equalsIgnoreCase("x")) {
                                    ErrorThrower.ThrowWarning(4, "There is no X chromosome in species '" + species + "'!");
                                    return origString;
                                }
                                if (string.equalsIgnoreCase("y") && yNum[speciesIndex] > 0) {
                                    return "chrY";
                                }
                                if (string.equalsIgnoreCase("y")) {
                                    ErrorThrower.ThrowWarning(4, "There is no Y chromosome in species '" + species + "'!");
                                    return origString;
                                }
                                if ((string.equalsIgnoreCase("unknown") || string.equalsIgnoreCase("unk")) && unkNum[speciesIndex] > 0) {
                                    return "chrUnknown";
                                }
                                if (string.equalsIgnoreCase("unknown") || string.equalsIgnoreCase("unk")) {
                                    ErrorThrower.ThrowWarning(4, "There is no unknown chromosome in species '" + species + "'!");
                                    return origString;
                                }
                                ErrorThrower.ThrowWarning(4, "Unable to determine chromosome string from '" + origString + "'");
                                return origString;
                            }
                        }
                        if (chrNum != mitoNum[speciesIndex]) break block20;
                        return "chrM";
                    }
                    if (chrNum != unkNum[speciesIndex]) break block21;
                    return "chrUnknown";
                }
                if (chrNum != xNum[speciesIndex]) break block22;
                return "chrX";
            }
            if (chrNum != yNum[speciesIndex]) break block23;
            return "chrY";
        }
        return "chr" + chrNum;
    }

    public static String CleanUpProteinName(String proteinName) {
        return proteinName.split(" ")[0];
    }

    public static enum uniqueType {
        PROT_UNIQUE,
        LOC_UNIQUE,
        SHARED;

    }
}

