/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.util.Hashtable;

public class RescoreEvents {
    public static String usageInfo = "proteogenomicUtils.RescoreEvents\nRescoreEvents.java rescores events based on several criteria\n[1] Only using uniquely located peptides\n[2] Only using the best shared peptide\n[3] scaling by the ratio of unique/shared peptides\nUsage:\n-r [FILE] Event file (table form)\n-w [FILE] Updated event file with additional columns\n";
    private String inputFile;
    private String outFile;
    private boolean debugFlag;

    public RescoreEvents(String inputFile, String outputFile, boolean debugFlag) {
        if (!Utils.IsFile(inputFile)) {
            ErrorThrower.ThrowError(1, inputFile);
        }
        this.inputFile = inputFile;
        this.outFile = outputFile;
        this.debugFlag = debugFlag;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-d"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println(usageInfo);
            ErrorThrower.ThrowError(2, "Must specify an input file and output file!");
        }
        String inputFile = (String)CommandLineArgs.get("-r");
        String outputFile = (String)CommandLineArgs.get("-w");
        boolean debugFlag = false;
        if (CommandLineArgs.containsKey("-d")) {
            debugFlag = true;
        }
        RescoreEvents e = new RescoreEvents(inputFile, outputFile, debugFlag);
        e.rescore();
    }

    private void rescore() {
        BufferedReader r = Utils.openBufferedReader(this.inputFile);
        FileWriter f = Utils.openFileWriter(this.outFile);
        String line = Utils.readNextLine(r, this.inputFile);
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = Utils.readNextLine(r, this.inputFile);
                continue;
            }
            String[] eventBits = line.split("\t");
            String[] pepList = null;
            pepList = eventBits.length == 5 ? eventBits[3].split(",") : eventBits[2].split(",");
            boolean uniqueCount = false;
            boolean sharedCount = false;
            int i = 0;
            while (i < pepList.length) {
                String[] pepInfo = pepList[i].split(":");
                String string = Utils.GetUnModded(pepInfo[0]);
                ++i;
            }
        }
    }
}

