/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import proteogenomicUtils.GenomicLocator;

public class SplitLocationsBySequence {
    public static final String UsageInfo = "proteogenomicUtils.SplitLocationsBySequence\nSplits a directory of locations into distinct sequence specific files.\n[REQUIRED]:\n-r [DIR] Directory containing locations files\n-w [DIR] Directory to write results of the form 'SEQNAME_Locations.txt'.  If a SEGNAME_Locations already\n         exists in the output directory, then the results are combined\n";
    public static boolean Debug = false;

    public static String[] SplitBySequence(String InputDir, String OutputDir, boolean Overwrite) {
        SplitLocationsBySequence.PrepareOutputDir(OutputDir);
        String[] Ret = SplitLocationsBySequence.LoadAllLocationsBySequence(InputDir, OutputDir, Overwrite);
        return Ret;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] LoadAllLocationsBySequence(String InputDir, String OutputDir, boolean Overwrite) {
        FilesWritten = new ArrayList<String>();
        SequencesSeen = new Hashtable<String, Integer>();
        CurrSequence = null;
        F = new File(InputDir);
        FileNames = F.list();
        Reader = null;
        Locations = new ArrayList();
        Line = null;
        while (true) {
            i = 0;
            while (i < FileNames.length) {
                FullName = String.valueOf(InputDir) + File.separator + FileNames[i];
                try {
                    Reader = new BufferedReader(new FileReader(FullName));
                    Line = Reader.readLine();
                    if (true) ** GOTO lbl49
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return null;
                }
                do {
                    if ((Line = Line.trim()).length() <= 0 || Line.charAt(0) == '#') ** GOTO lbl43
                    Location = GenomicLocator.GenomicColumns.LoadFromString(Line);
                    if (Location == null) {
                        try {
                            Line = Reader.readLine();
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return null;
                        }
                    } else {
                        SeqName = (String)Location[GenomicLocator.GenomicColumns.SequenceName];
                        if (!SequencesSeen.containsKey(SeqName) && CurrSequence == null) {
                            CurrSequence = SeqName;
                            System.out.println("Loading locations from " + SeqName);
                            if (SplitLocationsBySequence.Debug) {
                                System.out.println("Considering next sequence: " + SeqName);
                                Utils.WaitForEnter();
                            }
                            Locations.clear();
                            Locations.add(Location);
                        } else if (CurrSequence != null && CurrSequence.compareTo(SeqName) == 0) {
                            Locations = GenomicLocator.GenomicColumns.InsertInOrder(Locations, Location);
                        }
lbl43:
                        // 5 sources

                        try {
                            Line = Reader.readLine();
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            return null;
                        }
                    }
lbl49:
                    // 3 sources

                } while (Line != null);
                try {
                    Reader.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return null;
                }
                ++i;
            }
            if (CurrSequence == null) break;
            SequencesSeen.put(CurrSequence, new Integer(1));
            OutputFileName = String.valueOf(OutputDir) + File.separatorChar + CurrSequence + "_Locations.txt";
            if (SplitLocationsBySequence.Debug) {
                System.out.println("Loaded " + Locations.size() + " locations from new files");
            }
            System.out.println("Loaded  " + Locations.size() + " locations");
            SplitLocationsBySequence.WriteLocations(OutputFileName, Locations);
            CurrSequence = null;
            FilesWritten.add(OutputFileName);
        }
        return Utils.ConvertArraylistToStringArray(FilesWritten);
    }

    public static void WriteLocations(String OutputFileName, ArrayList Locations) {
        FileWriter Writer2 = null;
        try {
            Writer2 = new FileWriter(OutputFileName);
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
        int i = 0;
        while (i < Locations.size()) {
            Object[] CurrLocation = (Object[])Locations.get(i);
            try {
                Writer2.write(String.valueOf(GenomicLocator.GenomicColumns.toString(CurrLocation, "\t")) + "\n");
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(0);
            }
            ++i;
        }
        try {
            Writer2.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public static ArrayList LoadPrevious(ArrayList CurrLocations, String PrevFile) {
        File T = new File(PrevFile);
        if (!T.exists()) {
            return CurrLocations;
        }
        BufferedReader Reader2 = null;
        String Line = null;
        try {
            Reader2 = new BufferedReader(new FileReader(T));
            Line = Reader2.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() > 0) {
                Object[] Loc = GenomicLocator.GenomicColumns.LoadFromString(Line);
                CurrLocations = GenomicLocator.GenomicColumns.InsertInOrder(CurrLocations, Loc);
            }
            try {
                Line = Reader2.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(0);
            }
        }
        try {
            Reader2.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
        return CurrLocations;
    }

    public static void PrepareOutputDir(String OutputDir) {
        File F = new File(OutputDir);
        if (!F.exists()) {
            F.mkdirs();
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w"};
        boolean[] values = new boolean[]{true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input and output directory!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String[] Files = SplitLocationsBySequence.SplitBySequence((String)CommandLineArgs.get("-r"), (String)CommandLineArgs.get("-w"), false);
        int i = 0;
        while (i < Files.length) {
            System.out.println(Files[i]);
            ++i;
        }
    }
}

