/*
 * Decompiled with CFR 0.152.
 */
package proteogenomicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class SplitNovelPeptides {
    public static final String UsageInfo = "proteogenomicUtils.SplitNovelPeptides, version 2010.08.03\nThis program splits novel and known peptides into to files.  Assumes that DetermineNovelty has already been run so that the IsNovel field is\npopulated\n[REQUIRED]\n -r [FILE] An Inspect results file (post PValue.py)\n -n [FILE] An output file name for the novel peptides\n -k [FILE] An output file name for the known peptides\n[OPTIONAL]\n -d Run in debug mode\n -h [FILE] Create a histogram of known versus novel deltaknown score\n";
    private String InputFileName = null;
    private String KnownOutputFile = null;
    private String NovelOutputFile = null;
    private boolean Debug = false;
    private String HistogramFile = null;

    public SplitNovelPeptides(String InputFile, String KnownFile, String NovelFile) {
        this.InputFileName = InputFile;
        this.KnownOutputFile = KnownFile;
        this.NovelOutputFile = NovelFile;
    }

    public void Run() {
        FileWriter knownFile = null;
        FileWriter novelFile = null;
        try {
            knownFile = new FileWriter(this.KnownOutputFile);
            novelFile = new FileWriter(this.NovelOutputFile);
            knownFile.write(InspectAnnotation.SplicedHeaderLineDefault);
            novelFile.write(InspectAnnotation.SplicedHeaderLineDefault);
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        ArrayList<Double> NovelScores = null;
        ArrayList<Double> KnownScores = null;
        double NovelMean = 0.0;
        double KnownMean = 0.0;
        int NovelInfinityCount = 0;
        int KnownInfinityCount = 0;
        int NovelZeroCount = 0;
        int KnownZeroCount = 0;
        if (this.HistogramFile != null) {
            NovelScores = new ArrayList<Double>();
            KnownScores = new ArrayList<Double>();
        }
        InspectAnnotation[] Anns = InspectAnnotation.LoadInspectResultsFile(this.InputFileName);
        System.out.println("Loaded " + Anns.length + " annotations");
        int i = 0;
        while (i < Anns.length) {
            if (Anns[i].IsNovel) {
                if (this.HistogramFile != null) {
                    if (Anns[i].DeltaKnown < Double.POSITIVE_INFINITY && Anns[i].DeltaKnown != 0.0) {
                        NovelScores.add(new Double(Anns[i].DeltaKnown));
                        NovelMean += Anns[i].DeltaKnown;
                    } else if (Anns[i].DeltaKnown == 0.0) {
                        ++NovelZeroCount;
                    } else {
                        ++NovelInfinityCount;
                    }
                }
                try {
                    novelFile.write(String.valueOf(Anns[i].toString()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            } else {
                if (this.HistogramFile != null) {
                    if (Anns[i].DeltaKnown < Double.POSITIVE_INFINITY && Anns[i].DeltaKnown != 0.0) {
                        KnownScores.add(new Double(Anns[i].DeltaKnown));
                        KnownMean += Anns[i].DeltaKnown;
                    } else if (Anns[i].DeltaKnown == 0.0) {
                        ++KnownZeroCount;
                    } else {
                        ++KnownInfinityCount;
                    }
                }
                try {
                    knownFile.write(String.valueOf(Anns[i].toString()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            ++i;
        }
        try {
            knownFile.close();
            novelFile.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        System.out.println("NovelMean: " + (NovelMean /= (double)NovelScores.size()));
        System.out.println("KnownMean: " + (KnownMean /= (double)KnownScores.size()));
        System.out.println("Total Novel Entries: " + NovelScores.size());
        System.out.println("Total Known Entries: " + KnownScores.size());
        System.out.println("Novels with no DK: " + NovelInfinityCount);
        System.out.println("Knowns with no DK: " + KnownInfinityCount);
        System.out.println("Novels with 0 DK: " + NovelZeroCount);
        System.out.println("Knowns with 0 DK: " + KnownZeroCount);
        if (this.HistogramFile != null) {
            HistogramDataset ScoreHisto = new HistogramDataset();
            if (KnownScores.size() > 0) {
                ScoreHisto.addSeries((Comparable)((Object)"KnownPeptides"), Utils.ConvertArraylistToDoubleArray(KnownScores), 1000);
            }
            NovelScores.size();
            JFreeChart Chart = ChartFactory.createHistogram((String)("Score Histogram(" + KnownScores.size() + " Known, " + NovelScores.size() + " Novel)"), (String)"Score", (String)"Counts", (IntervalXYDataset)ScoreHisto, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            BufferedImage Image2 = Chart.createBufferedImage(1000, 1000);
            System.out.println("Created histo..." + this.HistogramFile);
            try {
                ImageIO.write((RenderedImage)Image2, "png", new File(this.HistogramFile));
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-n", "-k", "-d", "-h"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-n") && CommandLineArgs.containsKey("-k"))) {
            System.err.println("ERROR: Missing arguments!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        String InputFile = (String)CommandLineArgs.get("-r");
        String KnownFile = (String)CommandLineArgs.get("-k");
        String NovelFile = (String)CommandLineArgs.get("-n");
        if (!Utils.IsFile(InputFile)) {
            System.err.println("ERROR: Invalid input file name '" + InputFile + "'!");
            System.out.println(UsageInfo);
            System.exit(-1);
        }
        SplitNovelPeptides c = new SplitNovelPeptides(InputFile, KnownFile, NovelFile);
        if (CommandLineArgs.containsKey("-d")) {
            c.Debug = true;
        }
        if (CommandLineArgs.containsKey("-h")) {
            c.HistogramFile = (String)CommandLineArgs.get("-h");
        }
        c.Run();
    }
}

