/*
 * Decompiled with CFR 0.152.
 */
package quantUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class PeptideSpecCountCreator {
    public static String usageInfo = "quantUtils.PeptideSpecCountCreator\nThis file aggregates a collection of individual peptide spec count files (like from CreateSpecCountFile.py)\nThe format of each input file must be tab-delimitted with the following files\nPeptideSeq Charge CommaDelimittedSpecList\n\nUsage: java -jar PeptideSpecCountCreator.jar\n-r [FILE/DIR] File or directory containing the peptide spec count files\n-w [FILE] Output file to write with aggregated peptide counts\n-t [FILE] Trie file used in the peptide search\n(-m [FILE] File containing the datasets to be separated into.  For example, data sets might be Maize-Endosperm-10DAP and files might be Maize-Endosperm-10DAP-01.mzXML)\n(-p [FILE] Previously computed results from this script)\n(-s [FILE] Info file containing the transposable element info)\n(-g [FILE] Report protein group info)\n";
    private String[] inputFiles;
    private String outputFileName;
    private TrieDB proteinDB;
    private String datasetFileName;
    private Hashtable peptideHash;
    private boolean debug = false;
    private String prevResultFileName;
    private String[] dataSets;
    private Hashtable peptide2ProteinHash;
    private Hashtable protein2PeptideHash;
    private Hashtable geneHash;
    private String infoFileName;
    private String groupOutputFileName;

    public PeptideSpecCountCreator(String inputInfo, String outputFileName, String trieFileName, String datasetFileName, String prevResultFileName, String infoFileName, String groupOutputFileName) {
        if (Utils.IsDir(inputInfo)) {
            this.inputFiles = Utils.ListDir(inputInfo);
        } else if (Utils.IsFile(inputInfo)) {
            this.inputFiles = new String[1];
            this.inputFiles[0] = inputInfo;
        } else {
            System.err.println("ERROR: Invalid input file/directory '" + inputInfo + "'!!");
            System.exit(-1);
        }
        this.outputFileName = outputFileName;
        if (datasetFileName != null && Utils.IsFile(datasetFileName)) {
            this.datasetFileName = datasetFileName;
        } else {
            System.out.println("NOTE: No dataset file was listed, so using each filename as distinct dataset\n");
        }
        if (prevResultFileName != null && Utils.IsFile(prevResultFileName)) {
            this.prevResultFileName = prevResultFileName;
        }
        this.proteinDB = new TrieDB(trieFileName);
        if (infoFileName != null && Utils.IsFile(infoFileName)) {
            this.infoFileName = infoFileName;
        }
        if (groupOutputFileName != null) {
            this.groupOutputFileName = groupOutputFileName;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-t", "-m", "-p", "-s", "-g"};
        boolean[] values = new boolean[]{true, true, true, true, true, true, true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(commandLineArgs.containsKey("-r") && commandLineArgs.containsKey("-w") && commandLineArgs.containsKey("-t"))) {
            System.err.println("ERROR: Must specify an input file/dir, an output file, and a trie file!");
            System.err.println(usageInfo);
            System.exit(0);
        }
        String inputInfo = (String)commandLineArgs.get("-r");
        String outputFileName = (String)commandLineArgs.get("-w");
        String trieFileName = (String)commandLineArgs.get("-t");
        String datasetFileName = null;
        if (commandLineArgs.containsKey("-m")) {
            datasetFileName = (String)commandLineArgs.get("-m");
        }
        String prevResultFileName = null;
        if (commandLineArgs.containsKey("-p")) {
            prevResultFileName = (String)commandLineArgs.get("-p");
        }
        String infoFileName = null;
        if (commandLineArgs.containsKey("-s")) {
            infoFileName = (String)commandLineArgs.get("-s");
        }
        String groupFileName = null;
        if (commandLineArgs.containsKey("-g")) {
            groupFileName = (String)commandLineArgs.get("-g");
        }
        PeptideSpecCountCreator c = new PeptideSpecCountCreator(inputInfo, outputFileName, trieFileName, datasetFileName, prevResultFileName, infoFileName, groupFileName);
        c.aggregate();
    }

    public void aggregate() {
        this.loadDataSetNames();
        if (this.prevResultFileName != null) {
            this.loadPrevResults();
        }
        this.loadPeptideHashNew();
        this.populatePeptide2ProteinHash();
        this.getProteinStats();
        if (this.groupOutputFileName != null) {
            this.findProteinGroups();
        }
        this.writeResults();
    }

    private void findProteinGroups() {
        ArrayList currGroup;
        boolean debug = true;
        System.out.println("** Finding protein groups...");
        Hashtable<String, ArrayList> prot2Peptides = new Hashtable<String, ArrayList>();
        Enumeration pepKeys = this.peptide2ProteinHash.keys();
        while (pepKeys.hasMoreElements()) {
            String hashKey = (String)pepKeys.nextElement();
            String peptide = hashKey.split("_")[0];
            ArrayList proteins = (ArrayList)this.peptide2ProteinHash.get(peptide);
            int i = 0;
            while (i < proteins.size()) {
                String prot = (String)proteins.get(i);
                if (debug) {
                    System.out.println("Considering protein " + prot);
                }
                ArrayList pepList = null;
                pepList = prot2Peptides.containsKey(prot) ? (ArrayList)prot2Peptides.get(prot) : new ArrayList();
                if (!pepList.contains(peptide)) {
                    pepList.add(peptide);
                    if (debug) {
                        System.out.println("Adding peptide " + peptide);
                    }
                }
                prot2Peptides.put(prot, pepList);
                ++i;
            }
        }
        debug = true;
        if (debug) {
            System.out.println("Peptide info for " + prot2Peptides.size() + " should equal " + this.protein2PeptideHash.size());
        }
        Enumeration protKeys = this.protein2PeptideHash.keys();
        Hashtable<String, Integer> groupedProteins = new Hashtable<String, Integer>();
        ArrayList<ArrayList> groups = new ArrayList<ArrayList>();
        while (protKeys.hasMoreElements()) {
            String protName = (String)protKeys.nextElement();
            if (groupedProteins.containsKey(protName)) continue;
            int[] protCounts = (int[])this.protein2PeptideHash.get(protName);
            currGroup = new ArrayList();
            if (protCounts[1] == 0) {
                if (debug) {
                    System.out.println("Case A: " + protName + " has only unique peptides!");
                    System.out.println(String.valueOf(protCounts[0]) + " " + protCounts[1] + " " + protCounts[2] + " " + protCounts[3] + " " + protCounts[4]);
                }
                currGroup.add(protName);
                groups.add(currGroup);
                groupedProteins.put(protName, new Integer(1));
                continue;
            }
            ArrayList<String> prots2Consider = new ArrayList<String>();
            if (debug) {
                System.out.println("Case B: Creating a bigger group starting with " + protName);
                System.out.println(String.valueOf(protCounts[0]) + " " + protCounts[1] + " " + protCounts[2] + " " + protCounts[3] + " " + protCounts[4]);
            }
            prots2Consider.add(protName);
            while (prots2Consider.size() > 0) {
                String currProt = (String)prots2Consider.remove(0);
                currGroup.add(currProt);
                if (debug) {
                    System.out.println("Adding protein " + currProt);
                }
                groupedProteins.put(currProt, new Integer(1));
                ArrayList peptides = (ArrayList)prot2Peptides.get(currProt);
                int i = 0;
                while (i < peptides.size()) {
                    String currPeptide = (String)peptides.get(i);
                    ArrayList proteins = (ArrayList)this.peptide2ProteinHash.get(currPeptide);
                    int j = 0;
                    while (j < proteins.size()) {
                        String prot = (String)proteins.get(j);
                        if (!currGroup.contains(prot) && !prots2Consider.contains(prot)) {
                            prots2Consider.add(prot);
                            if (debug) {
                                System.out.println(" Protin " + prot + " shares " + currPeptide + " with " + currProt);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (debug) {
                System.out.println("New group of size " + currGroup.size());
                Utils.WaitForEnter();
            }
            groups.add(currGroup);
        }
        System.out.println("Total protein groups: " + groups.size());
        FileWriter f = null;
        try {
            f = new FileWriter(this.groupOutputFileName);
        }
        catch (IOException E) {
            System.err.println("ERROR:findProteinGroup:" + E.getLocalizedMessage());
            return;
        }
        int i = 0;
        while (i < groups.size()) {
            currGroup = (ArrayList)groups.get(i);
            String headerline = "Group " + i + "\t" + currGroup.size() + "\t";
            String geneList = "";
            int geneCount = 0;
            String line = "";
            int j = 0;
            while (j < currGroup.size()) {
                String protName = (String)currGroup.get(j);
                int[] protCounts = (int[])this.protein2PeptideHash.get(protName);
                String geneName = protName.split("_")[0];
                line = String.valueOf(line) + protName + "\t" + geneName + "\t" + protCounts[0] + "\t" + protCounts[2] + "\t" + protCounts[1] + "\t" + protCounts[3] + "\t";
                ArrayList peptides = (ArrayList)prot2Peptides.remove(protName);
                int k = 0;
                while (k < peptides.size()) {
                    line = String.valueOf(line) + (String)peptides.get(k) + ",";
                    ++k;
                }
                line = String.valueOf(line) + "\n";
                if (geneList.indexOf(geneName) < 0) {
                    geneList = String.valueOf(geneList) + geneName + ",";
                    ++geneCount;
                }
                ++j;
            }
            headerline = String.valueOf(headerline) + geneCount + "\n";
            try {
                f.write(headerline);
                f.write(line);
            }
            catch (IOException E) {
                System.err.println("ERROR:findProteinGroup:" + E.getLocalizedMessage());
            }
            ++i;
        }
        try {
            f.close();
        }
        catch (IOException E) {
            System.err.println("ERROR:findProteinGroup:" + E.getLocalizedMessage());
            return;
        }
    }

    private void getProteinStats() {
        this.protein2PeptideHash = new Hashtable();
        this.geneHash = new Hashtable();
        Enumeration pepKeys = this.peptideHash.keys();
        int peptideCount = 0;
        Hashtable proteinTypeInfo = null;
        if (this.infoFileName != null) {
            proteinTypeInfo = this.LoadProteinTEInfo();
        }
        while (pepKeys.hasMoreElements()) {
            String hashKey = (String)pepKeys.nextElement();
            String peptide = hashKey.split("_")[0];
            ++peptideCount;
            String charge = hashKey.split("_")[1];
            int[] pepCounts = (int[])this.peptideHash.get(hashKey);
            int totalSpectra = 0;
            int i = 0;
            while (i < pepCounts.length) {
                totalSpectra += pepCounts[i];
                ++i;
            }
            ArrayList proteins = (ArrayList)this.peptide2ProteinHash.get(peptide);
            int i2 = 0;
            while (i2 < proteins.size()) {
                String protName = (String)proteins.get(i2);
                if (protName.indexOf(32) >= 0) {
                    protName = protName.split(" ")[0];
                }
                int[] protCounts = null;
                protCounts = this.protein2PeptideHash.containsKey(protName) ? (int[])this.protein2PeptideHash.get(protName) : new int[5];
                if (proteins.size() == 1) {
                    protCounts[0] = protCounts[0] + 1;
                    protCounts[2] = protCounts[2] + totalSpectra;
                } else {
                    protCounts[1] = protCounts[1] + 1;
                    protCounts[3] = protCounts[3] + totalSpectra;
                }
                if (proteinTypeInfo != null && proteinTypeInfo.containsKey(protName)) {
                    protCounts[4] = 1;
                }
                this.protein2PeptideHash.put(protName, protCounts);
                ++i2;
            }
        }
        System.out.println("Loaded " + peptideCount + " total peptides!");
        int proteinsWithUniquePeptides = 0;
        int transposableElementProteins = 0;
        int totalProteins = 0;
        Enumeration protKeys = this.protein2PeptideHash.keys();
        while (protKeys.hasMoreElements()) {
            String protName = (String)protKeys.nextElement();
            int[] protCounts = (int[])this.protein2PeptideHash.get(protName);
            ++totalProteins;
            Object geneName = null;
            int[] geneCounts = null;
            geneCounts = this.geneHash.containsKey(geneName) ? (int[])this.geneHash.get(geneName) : new int[3];
            if (protCounts[0] > 0) {
                ++proteinsWithUniquePeptides;
                geneCounts[0] = geneCounts[0] + 1;
            } else {
                geneCounts[1] = geneCounts[1] + 1;
            }
            if (protCounts[4] == 1) {
                ++transposableElementProteins;
                geneCounts[2] = geneCounts[2] + 1;
            }
            this.geneHash.put(geneName, geneCounts);
        }
        System.out.println("Total proteins: " + totalProteins);
        System.out.println("Proteins with 1+ unique peptide: " + proteinsWithUniquePeptides);
        System.out.println("Transposable element proteins: " + transposableElementProteins);
        int genesWithAllUniqueProteins = 0;
        int genesWithMultipleUniqueProteins = 0;
        int genesWithSomeUniqueProteins = 0;
        int genesWithNoUniqueProteins = 0;
        int transposableElementGenes = 0;
        int transposableElementGenesWithUnique = 0;
        Enumeration geneKeys = this.geneHash.keys();
        while (geneKeys.hasMoreElements()) {
            String geneName = (String)geneKeys.nextElement();
            int[] geneCounts = (int[])this.geneHash.get(geneName);
            if (geneCounts[0] > 1 && geneCounts[1] == 0) {
                ++genesWithMultipleUniqueProteins;
            }
            if (geneCounts[0] > 0 && geneCounts[1] == 0) {
                ++genesWithAllUniqueProteins;
            } else if (geneCounts[0] > 0) {
                ++genesWithSomeUniqueProteins;
            } else if (geneCounts[1] > 0) {
                ++genesWithNoUniqueProteins;
            } else {
                System.err.println("ERROR: Gene has no protein counts: " + geneName);
                Utils.WaitForEnter();
            }
            if (geneCounts[2] <= 0) continue;
            ++transposableElementGenes;
            if (geneCounts[0] <= 0) continue;
            ++transposableElementGenesWithUnique;
        }
        System.out.println("Total genes: " + (genesWithAllUniqueProteins + genesWithSomeUniqueProteins + genesWithNoUniqueProteins));
        System.out.println("Genes with all unique proteins: " + genesWithAllUniqueProteins);
        System.out.println("Genes with all unique proteins (2+): " + genesWithMultipleUniqueProteins);
        System.out.println("Genes with some unique proteins: " + genesWithSomeUniqueProteins);
        System.out.println("Genes with no unique proteins: " + genesWithNoUniqueProteins);
        System.out.println("Transposable element genes: " + transposableElementGenes);
        System.out.println("Transposable element genes with unique peptides: " + transposableElementGenesWithUnique);
    }

    private Hashtable LoadProteinTEInfo() {
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.infoFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            System.err.println("ERROR:LoadProteinETInfo:" + E.getLocalizedMessage());
            return null;
        }
        Hashtable<String, Integer> ret = new Hashtable<String, Integer>();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    System.err.println("ERROR:LoadProteinETInfo:" + E.getLocalizedMessage());
                    return null;
                }
            }
            String[] bits = line.split("\t");
            String type = bits[12];
            String name = bits[3];
            if (type.toLowerCase().compareTo("transposable_element") == 0) {
                ret.put(name, new Integer(1));
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                System.err.println("ERROR:LoadProteinETInfo:" + E.getLocalizedMessage());
                return null;
            }
        }
        return ret;
    }

    private void writeResults() {
        Enumeration pepKeys = this.peptideHash.keys();
        int writtenLines = 0;
        FileWriter f = null;
        String header = "#Protein\tPeptide\tCharge\tIsUnique\tTotalSpectra\t";
        header = String.valueOf(header) + Utils.JoinStringArray(this.dataSets, "\t") + "\n";
        try {
            f = new FileWriter(this.outputFileName);
            f.write(header);
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (pepKeys.hasMoreElements()) {
            String hashKey = (String)pepKeys.nextElement();
            int[] counts = (int[])this.peptideHash.get(hashKey);
            String peptide = hashKey.split("_")[0];
            String charge = hashKey.split("_")[1];
            String line = String.valueOf(peptide) + "\t" + charge;
            int totalCount = 0;
            String countString = "";
            int i = 0;
            while (i < counts.length) {
                countString = String.valueOf(countString) + "\t" + counts[i];
                totalCount += counts[i];
                ++i;
            }
            ArrayList proteins = (ArrayList)this.peptide2ProteinHash.get(peptide);
            line = proteins.size() == 1 ? String.valueOf(line) + "\t1" : String.valueOf(line) + "\t0";
            line = String.valueOf(line) + "\t" + totalCount + countString;
            line = String.valueOf(line) + "\n";
            int i2 = 0;
            while (i2 < proteins.size()) {
                try {
                    f.write(String.valueOf((String)proteins.get(i2)) + "\t" + line);
                    ++writtenLines;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++i2;
            }
        }
        try {
            f.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Wrote " + writtenLines + " protein lines\n");
    }

    private void populatePeptide2ProteinHash() {
        ArrayList<String> peptide2Search = new ArrayList<String>();
        if (this.peptide2ProteinHash == null) {
            this.peptide2ProteinHash = new Hashtable();
        }
        Enumeration pepKeys = this.peptideHash.keys();
        while (pepKeys.hasMoreElements()) {
            String hashKey = (String)pepKeys.nextElement();
            String peptide = hashKey.split("_")[0];
            if (!this.peptide2ProteinHash.containsKey(peptide) && !peptide2Search.contains(peptide)) {
                peptide2Search.add(peptide);
            }
            if (peptide2Search.size() < 5000) continue;
            Hashtable locations = this.proteinDB.GetAllLocations(Utils.ConvertArraylistToStringArray(peptide2Search));
            int i = 0;
            while (i < peptide2Search.size()) {
                ArrayList locs = (ArrayList)locations.get((String)peptide2Search.get(i));
                if (locs == null || locs.size() == 0) {
                    System.err.println("ERROR: Could not find peptide '" + (String)peptide2Search.get(i) + "' in the DB!");
                    Utils.WaitForEnter();
                } else {
                    ArrayList<String> protList = new ArrayList<String>();
                    int j = 0;
                    while (j < locs.size()) {
                        Object[] currLoc = (Object[])locs.get(j);
                        String protName = (String)currLoc[3];
                        protList.add(protName);
                        ++j;
                    }
                    this.peptide2ProteinHash.put((String)peptide2Search.get(i), protList);
                }
                ++i;
            }
            peptide2Search.clear();
        }
        if (peptide2Search.size() > 0) {
            Hashtable locations = this.proteinDB.GetAllLocations(Utils.ConvertArraylistToStringArray(peptide2Search));
            int i = 0;
            while (i < peptide2Search.size()) {
                ArrayList locs = (ArrayList)locations.get((String)peptide2Search.get(i));
                ArrayList<String> protList = new ArrayList<String>();
                int j = 0;
                while (j < locs.size()) {
                    Object[] currLoc = (Object[])locs.get(j);
                    String protName = (String)currLoc[3];
                    protList.add(protName);
                    ++j;
                }
                this.peptide2ProteinHash.put((String)peptide2Search.get(i), protList);
                ++i;
            }
            peptide2Search.clear();
        }
    }

    private void loadPrevResults() {
        this.peptide2ProteinHash = new Hashtable();
        this.peptideHash = new Hashtable();
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(this.prevResultFileName));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (line != null) {
            ArrayList protList;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] bits = line.split("\t");
            String hashKey = String.valueOf(bits[1]) + "_" + bits[2];
            if (this.peptide2ProteinHash.containsKey(bits[1])) {
                protList = (ArrayList)this.peptide2ProteinHash.get(bits[1]);
                protList.add(bits[0]);
                this.peptide2ProteinHash.put(bits[1], protList);
            } else {
                protList = new ArrayList();
                protList.add(bits[0]);
                this.peptide2ProteinHash.put(bits[1], protList);
            }
            if (!this.peptideHash.containsKey(hashKey)) {
                int[] countArray = new int[this.dataSets.length];
                int i = 0;
                while (i < countArray.length) {
                    countArray[i] = Integer.parseInt(bits[4 + i]);
                    ++i;
                }
                this.peptideHash.put(hashKey, countArray);
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    private void loadDataSetNames() {
        ArrayList<String> temp = new ArrayList<String>();
        this.dataSets = null;
        if (this.datasetFileName != null) {
            try {
                BufferedReader buf = new BufferedReader(new FileReader(this.datasetFileName));
                String Line = buf.readLine();
                while (Line != null) {
                    if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                        Line = buf.readLine();
                        continue;
                    }
                    temp.add(Line);
                    System.out.println(Line);
                    Line = buf.readLine();
                }
                buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            this.dataSets = Utils.ConvertArraylistToStringArray(temp);
        } else {
            System.out.println("ERROR: Currently not supported without a dataset file list!");
            System.exit(-1);
        }
    }

    private void loadPeptideHashNew() {
        if (this.peptideHash == null) {
            this.peptideHash = new Hashtable();
        }
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < this.inputFiles.length) {
            System.out.println("Loading spectral counts from " + this.inputFiles[i]);
            try {
                buf = new BufferedReader(new FileReader(this.inputFiles[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                String[] bits = Line.split("\t");
                String hashKey = String.valueOf(bits[0]) + "_" + bits[1];
                String[] spectraList = bits[2].split(",");
                int[] countArray = null;
                countArray = this.peptideHash.containsKey(hashKey) ? (int[])this.peptideHash.get(hashKey) : new int[this.dataSets.length];
                int j = 0;
                while (j < spectraList.length) {
                    int k = 0;
                    while (k < this.dataSets.length) {
                        if (spectraList[j].indexOf(this.dataSets[k]) >= 0) {
                            int n = k;
                            countArray[n] = countArray[n] + 1;
                            break;
                        }
                        ++k;
                    }
                    ++j;
                }
                this.peptideHash.put(hashKey, countArray);
                if (this.debug) {
                    System.out.println("For peptide " + bits[0] + " z=" + bits[1] + " and specList " + bits[2]);
                    j = 0;
                    while (j < countArray.length) {
                        System.out.println(String.valueOf(this.dataSets[j]) + ":" + countArray[j]);
                        ++j;
                    }
                    Utils.WaitForEnter();
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
    }
}

