/*
 * Decompiled with CFR 0.152.
 */
package sixFrameUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Hashtable;

public class SixFrameBuilder {
    public static boolean Debug = false;
    public static int MIN_ORF_LENGTH = 40;
    public static final int GLOBAL_INTERVALS = 10000000;
    public static final int MAX_DB_SIZE = 100000000;
    private static int ForwardAAs = 0;
    private static int ForwardEntries = 0;
    private static int ReverseAAs = 0;
    private static int ReverseEntries = 0;
    private static int TotalBACs = 0;
    private static int TotalNucs = 0;
    private static boolean PrepAndZipFlag = false;
    private static String InspectPath = "/home/natalie/Projects/MySVNProjects/Inspect/trunk/";
    public static double[] Counter;
    public static boolean RunCounter;
    public static int MaxSize;
    public static int BinWidth;
    public static final String UsageInfo = "sixFrameUtils.SixFrameBuilder version 2012.01.12\nWritten by Natalie Castellana at UCSD\nProduces a FASTA file of the 6-frame translation of the input FASTA sequence file.  Entries are of the\nform SeqName@Start@End@Strand\nREQUIRED:\n -r [FILE] FASTA file containing nucleotide sequence(s) to translate\n -w [FILE] FASTA file as 6-frame translation output\nOPTIONAL:\n -c [NUM] Specifies the genetic code table to use (default: 0)\n -s [NUM] Max size of sequences per file (default: 100MB)\n -t [NUM] Min ORF size (default: 40 AAs\n -z Prep and shuffle each DB (default: do not prep and shuffle)\n";

    static {
        RunCounter = false;
        MaxSize = 0;
        BinWidth = 10;
    }

    public static String CreateSixFrameFASTAHeader(String OrigHeader, int Start, int End, int Strand) {
        String Header = OrigHeader;
        if (Header.indexOf("@") >= 0) {
            System.err.println("Warning: SixFrameBuilder:CreateSixFrameFASTAHeader " + OrigHeader + " contains forbidden char '" + "@" + "' replacing with '+'");
            Header = Header.replace('@', '+');
        }
        Header = String.valueOf(Header) + "@" + Start + "@" + End + "@" + Strand;
        return Header;
    }

    public static boolean IsSixFrameFASTAHeader(String Header) {
        String[] Els;
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("Header: " + Header);
        }
        if ((Els = Header.split("@")).length != 4) {
            if (LocalDebug) {
                System.out.println("CHECK: Els.length should be 4, actually is " + Els.length);
                Utils.WaitForEnter();
            }
            return false;
        }
        if (Els[3].compareTo("0") != 0 && Els[3].compareTo("1") != 0 && Els[3].compareTo("+") != 0 && Els[3].compareTo("-") != 0) {
            if (LocalDebug) {
                System.out.println("CHECK: Els[3] should be +, -, 1, or 0, actually is " + Els[2]);
                Utils.WaitForEnter();
            }
            return false;
        }
        String[] Coords = new String[]{Els[1], Els[2]};
        try {
            int Start = Integer.parseInt(Coords[0]);
            int End = Integer.parseInt(Coords[1]);
        }
        catch (Exception E) {
            if (LocalDebug) {
                System.out.println("CHECK: Number format error on " + Coords[0] + " or " + Coords[1]);
                Utils.WaitForEnter();
            }
            return false;
        }
        if (LocalDebug) {
            System.out.println("THIS IS A HEADER!!!");
            Utils.WaitForEnter();
        }
        return true;
    }

    public static String[] ParseSixFrameHeader(String Header) {
        Header = Header.trim();
        return Header.split("@");
    }

    public static int WriteORF(String ORF, FileWriter Writer2, String Header, int Start, int End, int Strand) {
        if (RunCounter) {
            if (ORF.length() / BinWidth >= Counter.length) {
                int n = Counter.length - 1;
                Counter[n] = Counter[n] + 1.0;
                MaxSize = Counter.length - 1;
            } else {
                int n = ORF.length() / BinWidth;
                Counter[n] = Counter[n] + 1.0;
                if (ORF.length() / BinWidth > MaxSize) {
                    MaxSize = ORF.length() / BinWidth;
                }
            }
            return 0;
        }
        String NewHeader = SixFrameBuilder.CreateSixFrameFASTAHeader(Header, Start, End, Strand);
        int Data = NewHeader.length() + ORF.length();
        try {
            Writer2.write(String.valueOf(NewHeader) + "\n");
            Writer2.write(String.valueOf(ORF) + "\n");
            if (Debug) {
                System.out.println(NewHeader);
                System.out.println(ORF);
            }
        }
        catch (Exception E) {
            System.err.println(E.getLocalizedMessage());
            Data = 0;
        }
        return Data;
    }

    private static void PrepAndShuffleDBPlain(String FastaFile) {
        String IndexFile = String.valueOf(Utils.GetFileNameNoExtension(FastaFile)) + ".index";
        String TrieFile = String.valueOf(Utils.GetFileNameNoExtension(FastaFile)) + ".trie";
        String ShuffledTrie = String.valueOf(Utils.GetFileNameNoExtension(FastaFile)) + "_RS.trie";
        String ShuffledIndex = String.valueOf(Utils.GetFileNameNoExtension(FastaFile)) + "_RS.index";
        String Command = "python " + InspectPath + "PrepDB.py FASTA " + FastaFile + " " + TrieFile + " " + IndexFile;
        try {
            Utils.RunCommand(Command, null, InspectPath);
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            return;
        }
        Command = "python " + InspectPath + "ShuffleDB.py -r " + TrieFile + " -w " + ShuffledTrie;
        try {
            Utils.RunCommand(Command, null, InspectPath);
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            return;
        }
    }

    public static boolean BuildSixFrameChromosome(String FastaFileName, String OutputFastaFile, int codonTable) {
        return SixFrameBuilder.BuildSixFrameChromosome(FastaFileName, OutputFastaFile, 100000000, MIN_ORF_LENGTH, codonTable);
    }

    private static boolean BuildSixFrameChromosome(String FastaFileName, String OutputFastaFile, int dBSize, int ORFSize, int codonTable) {
        char AA;
        String Line;
        BufferedReader Reader2;
        System.out.println("**Building Six Frame Translation**");
        System.out.println(" - MIN ORF SIZE: " + ORFSize);
        System.out.println(" - MAX DB SIZE: " + dBSize);
        System.out.println("Reading DNA from " + FastaFileName);
        String[] Buffers = new String[3];
        int[] Starts = new int[]{0, 1, 2};
        int FileIndex = 0;
        int DataWritten = 0;
        String CurrOutputFileName = String.valueOf(Utils.GetFileNameNoExtension(OutputFastaFile)) + "_" + FileIndex + ".fasta";
        FileWriter CurrOutputWriter = null;
        System.out.println("Writing 6Frame to " + CurrOutputFileName);
        int CurrFrame = 0;
        char[] Codon = new char[3];
        char[] SavedCodon = new char[3];
        int GlobalSeqPos = 0;
        try {
            if (!RunCounter) {
                CurrOutputWriter = new FileWriter(CurrOutputFileName, false);
            }
            ++FileIndex;
        }
        catch (Exception E) {
            System.err.println(E.getLocalizedMessage());
        }
        String Header = null;
        System.out.println("Translating forward frames...");
        System.out.println("File: " + FastaFileName);
        try {
            Reader2 = new BufferedReader(new FileReader(FastaFileName));
            System.out.println("Successfully opened file...");
            Line = Reader2.readLine();
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0) {
                    Line = Reader2.readLine();
                    continue;
                }
                if (DataWritten >= dBSize) {
                    try {
                        if (!RunCounter) {
                            if (PrepAndZipFlag) {
                                SixFrameBuilder.PrepAndShuffleDBPlain(CurrOutputFileName);
                            }
                            CurrOutputFileName = String.valueOf(Utils.GetFileNameNoExtension(OutputFastaFile)) + "_" + FileIndex + ".fasta";
                            System.out.println("**Reached limit, starting new file " + CurrOutputFileName);
                            CurrOutputWriter.close();
                            CurrOutputWriter = new FileWriter(CurrOutputFileName, false);
                        }
                        ++FileIndex;
                    }
                    catch (Exception E) {
                        System.err.println(E.getLocalizedMessage());
                    }
                    DataWritten = 0;
                }
                if (Line.charAt(0) == '>') {
                    if (Header != null) {
                        System.out.println("(" + TotalBACs + ")" + Line);
                        if (Buffers[0].length() >= ORFSize) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 1);
                            ForwardAAs += Buffers[0].length();
                            ++ForwardEntries;
                        }
                        if (Buffers[1].length() >= ORFSize) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 1);
                            ForwardAAs += Buffers[1].length();
                            ++ForwardEntries;
                        }
                        if (Buffers[2].length() >= ORFSize) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 1);
                            ForwardAAs += Buffers[2].length();
                            ++ForwardEntries;
                        }
                    }
                    if (Line.length() > 30) {
                        Line = Line.substring(0, 31);
                    }
                    Header = Line;
                    Buffers[0] = "";
                    Buffers[1] = "";
                    Buffers[2] = "";
                    Starts[0] = 0;
                    Starts[1] = 1;
                    Starts[2] = 2;
                    SavedCodon[0] = 42;
                    SavedCodon[1] = 42;
                    SavedCodon[2] = 42;
                    ++TotalBACs;
                    GlobalSeqPos = 0;
                    CurrFrame = 0;
                } else {
                    int SeqPos = 0;
                    TotalNucs += Line.length();
                    while (SeqPos < Line.length()) {
                        Codon[0] = SavedCodon[1];
                        Codon[1] = SavedCodon[2];
                        Codon[2] = Line.charAt(SeqPos);
                        AA = Utils.translateCodon(Codon, codonTable);
                        if (AA == '\u0000') {
                            System.err.println("ERROR: Invalid nucleotide at position " + TotalNucs);
                            System.exit(-1);
                        }
                        if (AA == Utils.STOP_AA) {
                            if (Buffers[CurrFrame].length() >= ORFSize) {
                                DataWritten += SixFrameBuilder.WriteORF(Buffers[CurrFrame], CurrOutputWriter, Header, Starts[CurrFrame], Starts[CurrFrame] + 3 * Buffers[CurrFrame].length(), 1);
                                if (Debug) {
                                    System.out.println("Encountered stop for frame " + CurrFrame + ", " + Buffers[CurrFrame] + " at " + Starts[CurrFrame]);
                                    Utils.WaitForEnter();
                                }
                                ForwardAAs += Buffers[CurrFrame].length();
                                ++ForwardEntries;
                            }
                            Buffers[CurrFrame] = "";
                            Starts[CurrFrame] = GlobalSeqPos + 1;
                        } else {
                            int n = CurrFrame;
                            Buffers[n] = String.valueOf(Buffers[n]) + AA;
                        }
                        ++SeqPos;
                        if (++GlobalSeqPos % 10000000 == 0) {
                            System.out.println("Pos: " + GlobalSeqPos + ", DataWritten: " + DataWritten);
                        }
                        CurrFrame = (CurrFrame + 1) % 3;
                        if (Debug) {
                            System.out.println("SeqPos: " + SeqPos + ", GlobalPos: " + GlobalSeqPos);
                            System.out.println(String.valueOf(new String(Codon)) + "->" + AA);
                            System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                            System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                            System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
                            Utils.WaitForEnter();
                        }
                        SavedCodon[0] = Codon[0];
                        SavedCodon[1] = Codon[1];
                        SavedCodon[2] = Codon[2];
                    }
                }
                Line = Reader2.readLine();
            }
            if (Buffers[0].length() >= ORFSize) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 1);
                ForwardAAs += Buffers[0].length();
                ++ForwardEntries;
            }
            if (Buffers[1].length() >= ORFSize) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 1);
                ForwardAAs += Buffers[1].length();
                ++ForwardEntries;
            }
            if (Buffers[2].length() >= ORFSize) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 1);
                ForwardAAs += Buffers[2].length();
                ++ForwardEntries;
            }
            if (Debug) {
                System.out.println("Final Seqs: GlobalPos: " + GlobalSeqPos);
                System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
            }
            Reader2.close();
        }
        catch (Exception E) {
            System.err.println(E.getLocalizedMessage());
            E.printStackTrace();
            System.out.println("ERROR: " + E);
            return false;
        }
        Starts[0] = 0;
        Starts[1] = 1;
        Starts[2] = 2;
        CurrFrame = 0;
        SavedCodon[0] = 42;
        SavedCodon[1] = 42;
        SavedCodon[2] = 42;
        Buffers[0] = "";
        Buffers[1] = "";
        Buffers[2] = "";
        GlobalSeqPos = 0;
        System.out.println("Translating reverse frames...");
        try {
            Reader2 = new BufferedReader(new FileReader(FastaFileName));
            Line = Reader2.readLine();
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0) {
                    Line = Reader2.readLine();
                    continue;
                }
                if (DataWritten >= dBSize) {
                    try {
                        if (!RunCounter) {
                            if (PrepAndZipFlag) {
                                SixFrameBuilder.PrepAndShuffleDBPlain(CurrOutputFileName);
                            }
                            CurrOutputWriter.close();
                            CurrOutputFileName = String.valueOf(Utils.GetFileNameNoExtension(OutputFastaFile)) + "_" + FileIndex + ".fasta";
                            System.out.println("**Reached limit, starting new file " + CurrOutputFileName);
                            CurrOutputWriter = new FileWriter(CurrOutputFileName, false);
                        }
                        ++FileIndex;
                    }
                    catch (Exception E) {
                        System.err.println(E.getLocalizedMessage());
                    }
                    DataWritten = 0;
                }
                if (Line.charAt(0) == '>') {
                    if (Header != null) {
                        if (Buffers[0].length() >= ORFSize) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 0);
                            ReverseAAs += Buffers[0].length();
                            ++ReverseEntries;
                        }
                        if (Buffers[1].length() >= ORFSize) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 0);
                            ReverseAAs += Buffers[1].length();
                            ++ReverseEntries;
                        }
                        if (Buffers[2].length() >= ORFSize) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 0);
                            ReverseAAs += Buffers[2].length();
                            ++ReverseEntries;
                        }
                    }
                    if (Line.length() > 30) {
                        Line = Line.substring(0, 31);
                    }
                    Header = Line;
                    Buffers[0] = "";
                    Buffers[1] = "";
                    Buffers[2] = "";
                    Starts[0] = 0;
                    Starts[1] = 1;
                    Starts[2] = 2;
                    SavedCodon[0] = 42;
                    SavedCodon[1] = 42;
                    SavedCodon[2] = 42;
                    CurrFrame = 0;
                    GlobalSeqPos = 0;
                } else {
                    int SeqPos = 0;
                    while (SeqPos < Line.length()) {
                        Codon[0] = Utils.Complement(Line.charAt(SeqPos));
                        Codon[1] = SavedCodon[0];
                        Codon[2] = SavedCodon[1];
                        AA = Utils.translateCodon(Codon, codonTable);
                        if (Debug) {
                            System.out.println("Codon: " + new String(Codon) + "->" + AA);
                        }
                        if (AA == Utils.STOP_AA) {
                            if (Buffers[CurrFrame].length() >= ORFSize) {
                                DataWritten += SixFrameBuilder.WriteORF(Buffers[CurrFrame], CurrOutputWriter, Header, Starts[CurrFrame], Starts[CurrFrame] + 3 * Buffers[CurrFrame].length(), 0);
                                if (Debug) {
                                    System.out.println("Encountered stop for frame " + CurrFrame + ", " + Buffers[CurrFrame] + " at " + Starts[CurrFrame]);
                                }
                                ReverseAAs += Buffers[CurrFrame].length();
                                ++ReverseEntries;
                            }
                            Buffers[CurrFrame] = "";
                            Starts[CurrFrame] = GlobalSeqPos + 1;
                        } else {
                            Buffers[CurrFrame] = String.valueOf(AA) + Buffers[CurrFrame];
                        }
                        ++SeqPos;
                        if (++GlobalSeqPos % 10000000 == 0) {
                            System.out.println("Pos: " + GlobalSeqPos + ", DataWritten: " + DataWritten);
                        }
                        CurrFrame = (CurrFrame + 1) % 3;
                        if (Debug) {
                            System.out.println("SeqPos: " + SeqPos + ", GlobalPos: " + GlobalSeqPos);
                            System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                            System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                            System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
                            Utils.WaitForEnter();
                        }
                        SavedCodon[0] = Codon[0];
                        SavedCodon[1] = Codon[1];
                        SavedCodon[2] = Codon[2];
                    }
                }
                Line = Reader2.readLine();
            }
            if (Buffers[0].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 0);
                ReverseAAs += Buffers[0].length();
                ++ReverseEntries;
            }
            if (Buffers[1].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 0);
                ReverseAAs += Buffers[1].length();
                ++ReverseEntries;
            }
            if (Buffers[2].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 0);
                ReverseAAs += Buffers[2].length();
                ++ReverseEntries;
            }
            if (Debug) {
                System.out.println("Final Seqs: GlobalPos: " + GlobalSeqPos);
                System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
                Utils.WaitForEnter();
            }
            if (!RunCounter) {
                if (PrepAndZipFlag) {
                    SixFrameBuilder.PrepAndShuffleDBPlain(CurrOutputFileName);
                }
                CurrOutputWriter.close();
            }
            Reader2.close();
        }
        catch (Exception E) {
            System.err.println(E.getLocalizedMessage());
            System.err.println("ERROR: " + E);
            return false;
        }
        System.out.println(" Forward: " + ForwardAAs + " AAs in " + ForwardEntries + " Entries");
        System.out.println(" Reverse: " + ReverseAAs + " AAs in " + ReverseEntries + " Entries");
        System.out.println("Loaded " + TotalBACs + " BACs with " + TotalNucs + " nucleotides");
        return true;
    }

    public static boolean BuildSixFrameSmallSeq(String FastaFileName, String OutputFastaFile, int codonTable) {
        char AA;
        int SeqPos;
        String Line;
        BufferedReader Reader2;
        System.out.println("Reading DNA from " + FastaFileName);
        String[] Buffers = new String[3];
        int[] Starts = new int[]{0, 1, 2};
        int DataWritten = 0;
        String CurrOutputFileName = OutputFastaFile;
        FileWriter CurrOutputWriter = null;
        int CurrFrame = 0;
        char[] Codon = new char[3];
        char[] SavedCodon = new char[3];
        int GlobalSeqPos = 0;
        try {
            if (!RunCounter) {
                CurrOutputWriter = new FileWriter(CurrOutputFileName, false);
            }
        }
        catch (Exception E) {
            System.err.println(E.getLocalizedMessage());
        }
        boolean DataWrittenFlag = false;
        String Header = null;
        System.out.println("Translating forward frames...");
        System.out.println("File: " + FastaFileName);
        try {
            Reader2 = new BufferedReader(new FileReader(FastaFileName));
            System.out.println("Successfully opened file...");
            Line = Reader2.readLine();
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0) {
                    Line = Reader2.readLine();
                    continue;
                }
                if (DataWritten >= 100000000 && !DataWrittenFlag) {
                    System.out.println("WARNING: You have exceeded the recommended FASTA file size of 100000000!!!  We'll assume you know best and keep writing...");
                    DataWrittenFlag = true;
                }
                if (Line.charAt(0) == '>') {
                    if (Header != null) {
                        System.out.println("(" + TotalBACs + ")" + Line);
                        if (Buffers[0].length() >= MIN_ORF_LENGTH) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 1);
                            ForwardAAs += Buffers[0].length();
                            ++ForwardEntries;
                        }
                        if (Buffers[1].length() >= MIN_ORF_LENGTH) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 1);
                            ForwardAAs += Buffers[1].length();
                            ++ForwardEntries;
                        }
                        if (Buffers[2].length() >= MIN_ORF_LENGTH) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 1);
                            ForwardAAs += Buffers[2].length();
                            ++ForwardEntries;
                        }
                    }
                    if (Line.length() > 30) {
                        Line = Line.substring(0, 31);
                    }
                    Header = Line;
                    Buffers[0] = "";
                    Buffers[1] = "";
                    Buffers[2] = "";
                    Starts[0] = 0;
                    Starts[1] = 1;
                    Starts[2] = 2;
                    SavedCodon[0] = 42;
                    SavedCodon[1] = 42;
                    SavedCodon[2] = 42;
                    ++TotalBACs;
                    GlobalSeqPos = 0;
                    CurrFrame = 0;
                } else {
                    SeqPos = 0;
                    TotalNucs += Line.length();
                    while (SeqPos < Line.length()) {
                        Codon[0] = SavedCodon[1];
                        Codon[1] = SavedCodon[2];
                        Codon[2] = Line.charAt(SeqPos);
                        AA = Utils.translateCodon(Codon, codonTable);
                        if (AA == Utils.STOP_AA) {
                            if (Buffers[CurrFrame].length() >= MIN_ORF_LENGTH) {
                                DataWritten += SixFrameBuilder.WriteORF(Buffers[CurrFrame], CurrOutputWriter, Header, Starts[CurrFrame], Starts[CurrFrame] + 3 * Buffers[CurrFrame].length(), 1);
                                if (Debug) {
                                    System.out.println("Encountered stop for frame " + CurrFrame + ", " + Buffers[CurrFrame] + " at " + Starts[CurrFrame]);
                                    Utils.WaitForEnter();
                                }
                                ForwardAAs += Buffers[CurrFrame].length();
                                ++ForwardEntries;
                            }
                            Buffers[CurrFrame] = "";
                            Starts[CurrFrame] = GlobalSeqPos + 1;
                        } else {
                            int n = CurrFrame;
                            Buffers[n] = String.valueOf(Buffers[n]) + AA;
                        }
                        ++SeqPos;
                        if (++GlobalSeqPos % 10000000 == 0) {
                            System.out.println("Pos: " + GlobalSeqPos);
                        }
                        CurrFrame = (CurrFrame + 1) % 3;
                        if (Debug) {
                            System.out.println("SeqPos: " + SeqPos + ", GlobalPos: " + GlobalSeqPos);
                            System.out.println(String.valueOf(new String(Codon)) + "->" + AA);
                            System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                            System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                            System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
                            Utils.WaitForEnter();
                        }
                        SavedCodon[0] = Codon[0];
                        SavedCodon[1] = Codon[1];
                        SavedCodon[2] = Codon[2];
                    }
                }
                Line = Reader2.readLine();
            }
            if (Buffers[0].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 1);
                ForwardAAs += Buffers[0].length();
                ++ForwardEntries;
            }
            if (Buffers[1].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 1);
                ForwardAAs += Buffers[1].length();
                ++ForwardEntries;
            }
            if (Buffers[2].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 1);
                ForwardAAs += Buffers[2].length();
                ++ForwardEntries;
            }
            if (Debug) {
                System.out.println("Final Seqs: GlobalPos: " + GlobalSeqPos);
                System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
            }
        }
        catch (Exception E) {
            System.err.println(E.getLocalizedMessage());
            E.printStackTrace();
            System.out.println("ERROR: " + E);
            return false;
        }
        Starts[0] = 0;
        Starts[1] = 1;
        Starts[2] = 2;
        CurrFrame = 0;
        SavedCodon[0] = 42;
        SavedCodon[1] = 42;
        SavedCodon[2] = 42;
        Buffers[0] = "";
        Buffers[1] = "";
        Buffers[2] = "";
        GlobalSeqPos = 0;
        System.out.println("Translating reverse frames...");
        try {
            Reader2 = new BufferedReader(new FileReader(FastaFileName));
            Line = Reader2.readLine();
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0) {
                    Line = Reader2.readLine();
                    continue;
                }
                if (DataWritten >= 100000000 && !DataWrittenFlag) {
                    System.out.println("WARNING: You have exceeded the recommended FASTA file size of 100000000!!!  We'll assume you know best and keep writing...");
                    DataWrittenFlag = true;
                }
                if (Line.charAt(0) == '>') {
                    if (Header != null) {
                        if (Buffers[0].length() >= MIN_ORF_LENGTH) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 0);
                            ReverseAAs += Buffers[0].length();
                            ++ReverseEntries;
                        }
                        if (Buffers[1].length() >= MIN_ORF_LENGTH) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 0);
                            ReverseAAs += Buffers[1].length();
                            ++ReverseEntries;
                        }
                        if (Buffers[2].length() >= MIN_ORF_LENGTH) {
                            DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 0);
                            ReverseAAs += Buffers[2].length();
                            ++ReverseEntries;
                        }
                    }
                    if (Line.length() > 30) {
                        Line = Line.substring(0, 31);
                    }
                    Header = Line;
                    Buffers[0] = "";
                    Buffers[1] = "";
                    Buffers[2] = "";
                    Starts[0] = 0;
                    Starts[1] = 1;
                    Starts[2] = 2;
                    SavedCodon[0] = 42;
                    SavedCodon[1] = 42;
                    SavedCodon[2] = 42;
                    CurrFrame = 0;
                    GlobalSeqPos = 0;
                } else {
                    SeqPos = 0;
                    while (SeqPos < Line.length()) {
                        Codon[0] = Utils.Complement(Line.charAt(SeqPos));
                        Codon[1] = SavedCodon[0];
                        Codon[2] = SavedCodon[1];
                        AA = Utils.translateCodon(Codon, codonTable);
                        if (Debug) {
                            System.out.println("Codon: " + new String(Codon) + "->" + AA);
                        }
                        if (AA == Utils.STOP_AA) {
                            if (Buffers[CurrFrame].length() >= MIN_ORF_LENGTH) {
                                DataWritten += SixFrameBuilder.WriteORF(Buffers[CurrFrame], CurrOutputWriter, Header, Starts[CurrFrame], Starts[CurrFrame] + 3 * Buffers[CurrFrame].length(), 0);
                                if (Debug) {
                                    System.out.println("Encountered stop for frame " + CurrFrame + ", " + Buffers[CurrFrame] + " at " + Starts[CurrFrame]);
                                }
                                ReverseAAs += Buffers[CurrFrame].length();
                                ++ReverseEntries;
                            }
                            Buffers[CurrFrame] = "";
                            Starts[CurrFrame] = GlobalSeqPos + 1;
                        } else {
                            Buffers[CurrFrame] = String.valueOf(AA) + Buffers[CurrFrame];
                        }
                        ++SeqPos;
                        if (++GlobalSeqPos % 10000000 == 0) {
                            System.out.println("Pos: " + GlobalSeqPos);
                        }
                        CurrFrame = (CurrFrame + 1) % 3;
                        if (Debug) {
                            System.out.println("SeqPos: " + SeqPos + ", GlobalPos: " + GlobalSeqPos);
                            System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                            System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                            System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
                            Utils.WaitForEnter();
                        }
                        SavedCodon[0] = Codon[0];
                        SavedCodon[1] = Codon[1];
                        SavedCodon[2] = Codon[2];
                    }
                }
                Line = Reader2.readLine();
            }
            if (Buffers[0].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[0], CurrOutputWriter, Header, Starts[0], Starts[0] + 3 * Buffers[0].length(), 0);
                ReverseAAs += Buffers[0].length();
                ++ReverseEntries;
            }
            if (Buffers[1].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[1], CurrOutputWriter, Header, Starts[1], Starts[1] + 3 * Buffers[1].length(), 0);
                ReverseAAs += Buffers[1].length();
                ++ReverseEntries;
            }
            if (Buffers[2].length() >= MIN_ORF_LENGTH) {
                DataWritten += SixFrameBuilder.WriteORF(Buffers[2], CurrOutputWriter, Header, Starts[2], Starts[2] + 3 * Buffers[2].length(), 0);
                ReverseAAs += Buffers[2].length();
                ++ReverseEntries;
            }
            if (Debug) {
                System.out.println("Final Seqs: GlobalPos: " + GlobalSeqPos);
                System.out.println("(0) - " + Starts[0] + ":" + Buffers[0]);
                System.out.println("(1) - " + Starts[1] + ":" + Buffers[1]);
                System.out.println("(2) - " + Starts[2] + ":" + Buffers[2]);
                Utils.WaitForEnter();
            }
            if (!RunCounter) {
                if (PrepAndZipFlag) {
                    SixFrameBuilder.PrepAndShuffleDBPlain(CurrOutputFileName);
                }
                CurrOutputWriter.close();
            }
        }
        catch (Exception E) {
            System.err.println(E.getLocalizedMessage());
            System.err.println("ERROR: " + E);
            return false;
        }
        System.out.println(" Forward: " + ForwardAAs + " AAs in " + ForwardEntries + " Entries");
        System.out.println(" Reverse: " + ReverseAAs + " AAs in " + ReverseEntries + " Entries");
        System.out.println("Loaded " + TotalBACs + " BACs with " + TotalNucs + " nucleotides");
        return true;
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-d", "-z", "-s", "-t", "-c"};
        boolean[] blArray = new boolean[7];
        blArray[0] = true;
        blArray[1] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: You must specify an input file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        String InputFile = (String)CommandLineArgs.get("-r");
        if (!CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: You must specify an output file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        String OutputFile = (String)CommandLineArgs.get("-w");
        if (CommandLineArgs.containsKey("-d")) {
            Debug = true;
        }
        if (CommandLineArgs.containsKey("-z")) {
            if (RunCounter) {
                System.err.println("WARNING: Cannot run in 'count' mode and prepare and shuffle dbs\n");
            } else {
                PrepAndZipFlag = true;
            }
        }
        int DBSize = 100000000;
        if (CommandLineArgs.containsKey("-s") && (DBSize = Integer.parseInt((String)CommandLineArgs.get("-s"))) < 0) {
            System.err.println("ERROR: Invalid file size '" + DBSize + "'!!");
            System.exit(-1);
        }
        int ORFSize = MIN_ORF_LENGTH;
        if (CommandLineArgs.containsKey("-t") && (ORFSize = Integer.parseInt((String)CommandLineArgs.get("-t"))) < 0) {
            System.err.println("ERROR: Invalid ORF size '" + ORFSize + "'!!");
            System.exit(-1);
        }
        int codonTable = 0;
        if (CommandLineArgs.containsKey("-c") && ((codonTable = Integer.parseInt((String)CommandLineArgs.get("-c"))) < 0 || codonTable >= Utils.dnaCodeNames.length)) {
            System.err.println("ERROR: Invalid codon table selected");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        if (SixFrameBuilder.BuildSixFrameChromosome(InputFile, OutputFile, DBSize, ORFSize, codonTable)) {
            System.out.println("Success!!");
            System.out.println(" Forward: " + ForwardAAs + " AAs in " + ForwardEntries + " Entries");
            System.out.println(" Reverse: " + ReverseAAs + " AAs in " + ReverseEntries + " Entries");
            System.out.println("Loaded " + TotalBACs + " BACs with " + TotalNucs + " nucleotides");
        }
    }
}

