/*
 * Decompiled with CFR 0.152.
 */
package specUtils;

import org.systemsbiology.jrap.stax.Scan;

public class SpectrumWriter {
    public static String WriteScanAsPKL(Scan currScan) {
        String Ret = "";
        Ret = String.valueOf(Ret) + currScan.header.getPrecursorMz() + " " + currScan.header.getPrecursorIntensity() + " " + currScan.header.getPrecursorCharge() + "\n";
        double[][] peakList = currScan.getMassIntensityList();
        int i = 0;
        while (i < peakList[0].length) {
            Ret = String.valueOf(Ret) + peakList[0][i] + " " + peakList[1][i] + "\n";
            ++i;
        }
        Ret = String.valueOf(Ret) + "\n";
        return Ret;
    }

    public static String WriteScanAsMGF(Scan currScan) {
        String Ret = "BEGIN IONS\n";
        if (currScan.header.getPrecursorIntensity() > 0.0f) {
            Ret = String.valueOf(Ret) + "PRECURSOR_INTENSITY=" + currScan.header.getPrecursorIntensity() + "\n";
        }
        if (currScan.header.getPrecursorMz() > 0.0f) {
            Ret = String.valueOf(Ret) + "PEPMASS=" + currScan.header.getPrecursorMz() + "\n";
        }
        if (currScan.header.getPrecursorCharge() > 0) {
            Ret = String.valueOf(Ret) + "CHARGE=" + currScan.header.getPrecursorCharge() + "\n";
        }
        Ret = String.valueOf(Ret) + "SCAN=" + currScan.header.getNum();
        double[][] peakList = currScan.getMassIntensityList();
        int i = 0;
        while (i < peakList[0].length) {
            Ret = String.valueOf(Ret) + peakList[0][i] + " " + peakList[1][i] + "\n";
            ++i;
        }
        Ret = String.valueOf(Ret) + "END IONS\n";
        return Ret;
    }
}

