/*
 * Decompiled with CFR 0.152.
 */
package trieUtils;

import basicUtils.Utils;
import errorUtils.ErrorThrower;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class ProteomeAnalyzer {
    public static String usageInfo = "trieUtils.ProteomeAnalyzer\nComputes basic statistics on the proteome including length\nand distribution of start codons\n[Options]:\n -r [FILE] FASTA or trie file containing the proteome\n";
    private TrieDB seqTrie;

    public ProteomeAnalyzer(String seqFileName) {
        String ext;
        if (!Utils.IsFile(seqFileName)) {
            ErrorThrower.ThrowError(4, seqFileName);
        }
        if ((ext = Utils.GetFileExtension(seqFileName)).equalsIgnoreCase(".trie")) {
            this.seqTrie = new TrieDB(seqFileName);
        } else {
            String[] fileNames = TrieDB.prepDB(seqFileName, null);
            this.seqTrie = new TrieDB(fileNames[0]);
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r"};
        boolean[] values = new boolean[]{true};
        Hashtable commandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!commandLineArgs.containsKey("-r")) {
            System.out.println(usageInfo);
            ErrorThrower.ThrowError(2, "Must specify a sequence file (-r)!");
        }
        String seqFileName = (String)commandLineArgs.get("-r");
        ProteomeAnalyzer p = new ProteomeAnalyzer(seqFileName);
        p.analyze();
    }

    public void analyze() {
        int proteinCount = this.seqTrie.getNumProteins();
        double averageLen = this.seqTrie.getMeanLength(null);
        int[] startCount = this.seqTrie.getStartAACounts(null);
        System.out.println("Total proteins: " + proteinCount);
        System.out.println("Average length: " + averageLen);
        System.out.println("\n---- Start Codons ----");
        int i = 0;
        while (i < startCount.length) {
            System.out.println(String.valueOf((char)(i + 65)) + " " + startCount[i]);
            ++i;
        }
    }
}

