import sys
import os
import getopt


UsageInfo = """ConvertPKL2MGF.py
Converts a file in .pkl format to .mgf format.

PKL Format:

MZ Intensity Z
MZ Intensity
MZ Intensity
...
MZ Intensity

MZ Intensity Z
MZ Intensity
MZ Intensity


MGF Format:

PEPMASS=(MZ/Z) - Z
CHARGE=Z
MZ Intensity
MZ Intensity
...

Options:
-r [FILE] The pkl file to convert
-w [FILE] The mgf file to write.  Default is to use the pkl file but change the extension
"""

class PKL2MGFConverter:

    def __init__(self):
        self.PKLFile = None
        self.MGFFile = None


    def ConvertMZ2Mass(self,MZ,Z):
        return (MZ*Z - Z)

    def ParseCommandLine(self,Arguments):
        (Options,Args) = getopt.getopt(Arguments,"r:w:")
        OptionsSeen = {}
        for (Option,Value) in Options:
            OptionsSeen[Option] = 1
            if Option == "-r":
                if not os.path.exists(Value):
                    print "ERROR: %s is not a valid pkl file name"%Value
                    sys.exit(0)
                self.PKLFile = Value
            elif Option == "-w":
                self.MGFFile = Value

            else:
                print "WARNING: Unexpected argument '%s'"%Option

        if not OptionsSeen.has_key("-r"):
            print "ERROR: Must specify an input pkl file"
            print UsageInfo
            sys.exit(0)

        if self.MGFFile == None:
            (Path,Ext) = os.path.splitext(self.PKLFile)
            self.MGFFile = Path + ".mgf"



    def Main(self):

        OutFile = open(self.MGFFile,'w')
        InFile = open(self.PKLFile,'r')
        SpectraWritten = 0
        for Line in InFile:
            Line = Line.strip()
            if Line == "": 
                continue

            Bits = Line.split(" ")
            if len(Bits) == 3: #a new spectrum
                if(SpectraWritten > 0):
                    OutFile.write("END IONS\n\n")

                OutFile.write("BEGIN IONS\n")
                #OutFile.write("PEPMASS=%s\n"%(self.ConvertMZ2Mass(float(Bits[0]),float(Bits[2]))))
                OutFile.write("PEPMASS=%s\n"%Bits[0])
                OutFile.write("Charge=%s+\n"%Bits[2])
                SpectraWritten += 1
            elif len(Bits) == 2:
                OutFile.write("%s %s\n"%(Bits[0],Bits[1]))
            else:
                print "WARNING: Ill-formed line '%s'"%Line



        if SpectraWritten > 0:
            OutFile.write("END IONS\n")

        OutFile.close()
        print "Wrote %s spectra to %s"%(SpectraWritten,self.MGFFile)

if __name__ == "__main__":
    Dummy = PKL2MGFConverter()
    Dummy.ParseCommandLine(sys.argv[1:])
    Dummy.Main()

